/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.AfterSalesAttachmentEntity;
import com.bringspring.visit.entity.AfterSalesInspectTaskEntity;
import com.bringspring.visit.entity.VisitFollowEvaluateEntity;
import com.bringspring.visit.entity.VisitFollowUpEntity;
import com.bringspring.visit.model.aftersalesattachment.AfterSalesAttachmentModel;
import com.bringspring.visit.model.visitfollowevaluate.VisitFollowEvaluateCrForm;
import com.bringspring.visit.model.visitfollowevaluate.VisitFollowEvaluateInfoVO;
import com.bringspring.visit.model.visitfollowevaluate.VisitFollowEvaluateListVO;
import com.bringspring.visit.model.visitfollowevaluate.VisitFollowEvaluatePagination;
import com.bringspring.visit.model.visitfollowevaluate.VisitFollowEvaluateUpForm;
import com.bringspring.visit.service.AfterSalesAttachmentService;
import com.bringspring.visit.service.AfterSalesInspectTaskService;
import com.bringspring.visit.service.VisitFollowEvaluateService;
import com.bringspring.visit.service.VisitFollowUpService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8bc4\u4ef7"}, value="visit")
@RequestMapping(value={"/api/visit/VisitFollowEvaluate"})
public class VisitFollowEvaluateController {
    private static final Logger log = LoggerFactory.getLogger(VisitFollowEvaluateController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private VisitFollowEvaluateService visitFollowEvaluateService;
    @Autowired
    private VisitFollowUpService visitFollowUpService;
    @Autowired
    private AfterSalesInspectTaskService afterSalesInspectTaskService;
    @Autowired
    private AfterSalesAttachmentService afterSalesAttachmentService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private UserService userService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody VisitFollowEvaluatePagination visitFollowEvaluatePagination) throws IOException {
        List<VisitFollowEvaluateEntity> list = this.visitFollowEvaluateService.getList(visitFollowEvaluatePagination);
        for (VisitFollowEvaluateEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, VisitFollowEvaluateListVO.class);
        for (VisitFollowEvaluateListVO visitFollowEvaluateVO : listVO) {
            CrmCustomerEntity byId;
            if (StrUtil.isNotEmpty((CharSequence)visitFollowEvaluateVO.getEvaluateType())) {
                Object info;
                if (StrUtil.equals((CharSequence)visitFollowEvaluateVO.getEvaluateType(), (CharSequence)"visit") && !ObjectUtil.isEmpty((Object)(info = this.visitFollowUpService.getInfo(visitFollowEvaluateVO.getFollowUpId())))) {
                    visitFollowEvaluateVO.setFollowUpName(((VisitFollowUpEntity)info).getFollowUp());
                }
                if (StrUtil.equals((CharSequence)visitFollowEvaluateVO.getEvaluateType(), (CharSequence)"inspect") && !ObjectUtil.isEmpty((Object)(info = this.afterSalesInspectTaskService.getInfo(visitFollowEvaluateVO.getInspectId())))) {
                    visitFollowEvaluateVO.setInspectName(((AfterSalesInspectTaskEntity)info).getName());
                }
            }
            if (StrUtil.isNotEmpty((CharSequence)visitFollowEvaluateVO.getCustomerId()) && !ObjectUtil.isEmpty((Object)(byId = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)visitFollowEvaluateVO.getCustomerId()))))) {
                visitFollowEvaluateVO.setCustomerName(byId.getName());
            }
            if (!StrUtil.isNotEmpty((CharSequence)visitFollowEvaluateVO.getUserId()) || ObjectUtil.isEmpty((Object)(byId = (UserEntity)this.userService.getById((Serializable)((Object)visitFollowEvaluateVO.getUserId()))))) continue;
            visitFollowEvaluateVO.setUserName(byId.getRealName());
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)visitFollowEvaluatePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @NotCheckLogin
    @PostMapping
    public ActionResult create(@RequestBody @Valid VisitFollowEvaluateCrForm visitFollowEvaluateCrForm) throws DataException {
        this.visitFollowEvaluateService.saveEvaluate(visitFollowEvaluateCrForm);
        return ActionResult.success((String)"\u8bc4\u4ef7\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<VisitFollowEvaluateInfoVO> info(@PathVariable(value="id") String id) {
        VisitFollowEvaluateEntity entity = this.visitFollowEvaluateService.getInfo(id);
        VisitFollowEvaluateInfoVO vo = (VisitFollowEvaluateInfoVO)JsonUtil.getJsonToBean((Object)entity, VisitFollowEvaluateInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @NotCheckLogin
    @GetMapping(value={"/detail/type/{type}/{id}"})
    public ActionResult<VisitFollowEvaluateInfoVO> detailInfoByType(@PathVariable(value="type") String type, @PathVariable(value="id") String id) {
        Object info;
        String evaId = "";
        if (StrUtil.equals((CharSequence)type, (CharSequence)"visit")) {
            info = this.visitFollowUpService.getInfo(id);
            evaId = ((VisitFollowUpEntity)info).getEvaluateId();
        }
        if (StrUtil.equals((CharSequence)type, (CharSequence)"inspect")) {
            info = this.afterSalesInspectTaskService.getInfo(id);
            evaId = ((AfterSalesInspectTaskEntity)info).getEvaluateId();
        }
        if (StrUtil.isNotEmpty((CharSequence)evaId)) {
            VisitFollowEvaluateEntity entity = this.visitFollowEvaluateService.getInfo(evaId);
            VisitFollowEvaluateInfoVO vo = (VisitFollowEvaluateInfoVO)JsonUtil.getJsonToBean((Object)entity, VisitFollowEvaluateInfoVO.class);
            List<AfterSalesAttachmentEntity> attachmentEntities = this.afterSalesAttachmentService.listByEvaluateId(evaId);
            if (CollectionUtil.isNotEmpty(attachmentEntities)) {
                List jsonToList = JsonUtil.getJsonToList(attachmentEntities, AfterSalesAttachmentModel.class);
                vo.setAttachmentList(jsonToList);
            }
            return ActionResult.success((Object)vo);
        }
        return ActionResult.success((Object)new VisitFollowEvaluateInfoVO());
    }

    @NotCheckLogin
    @GetMapping(value={"/detail/{id}"})
    public ActionResult<VisitFollowEvaluateInfoVO> detailInfo(@PathVariable(value="id") String id) {
        VisitFollowEvaluateEntity entity = this.visitFollowEvaluateService.getInfo(id);
        VisitFollowEvaluateInfoVO vo = (VisitFollowEvaluateInfoVO)JsonUtil.getJsonToBean((Object)entity, VisitFollowEvaluateInfoVO.class);
        List<AfterSalesAttachmentEntity> attachmentEntities = this.afterSalesAttachmentService.listByEvaluateId(id);
        if (CollectionUtil.isNotEmpty(attachmentEntities)) {
            List jsonToList = JsonUtil.getJsonToList(attachmentEntities, AfterSalesAttachmentModel.class);
            vo.setAttachmentList(jsonToList);
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid VisitFollowEvaluateUpForm visitFollowEvaluateUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        VisitFollowEvaluateEntity entity = this.visitFollowEvaluateService.getInfo(id);
        if (entity != null) {
            VisitFollowEvaluateEntity subentity = (VisitFollowEvaluateEntity)JsonUtil.getJsonToBean((Object)visitFollowEvaluateUpForm, VisitFollowEvaluateEntity.class);
            this.visitFollowEvaluateService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        VisitFollowEvaluateEntity entity = this.visitFollowEvaluateService.getInfo(id);
        if (entity != null) {
            this.visitFollowEvaluateService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

