/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.VisitFollowReadEntity;
import com.bringspring.visit.model.visitfollowread.VisitFollowReadCrForm;
import com.bringspring.visit.model.visitfollowread.VisitFollowReadInfoVO;
import com.bringspring.visit.model.visitfollowread.VisitFollowReadUpForm;
import com.bringspring.visit.service.VisitFollowReadService;
import io.swagger.annotations.Api;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u62dc\u8bbf\u8bb0\u5f55\u9605\u8bfb\u8868"}, value="visit")
@RequestMapping(value={"/api/visit/VisitFollowRead"})
public class VisitFollowReadController {
    private static final Logger log = LoggerFactory.getLogger(VisitFollowReadController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private VisitFollowReadService visitFollowReadService;

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid VisitFollowReadCrForm visitFollowReadCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        VisitFollowReadEntity entity = (VisitFollowReadEntity)JsonUtil.getJsonToBean((Object)visitFollowReadCrForm, VisitFollowReadEntity.class);
        entity.setId(mainId);
        this.visitFollowReadService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<VisitFollowReadInfoVO> info(@PathVariable(value="id") String id) {
        VisitFollowReadEntity entity = this.visitFollowReadService.getInfo(id);
        VisitFollowReadInfoVO vo = (VisitFollowReadInfoVO)JsonUtil.getJsonToBean((Object)entity, VisitFollowReadInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<VisitFollowReadInfoVO> detailInfo(@PathVariable(value="id") String id) {
        VisitFollowReadEntity entity = this.visitFollowReadService.getInfo(id);
        VisitFollowReadInfoVO vo = (VisitFollowReadInfoVO)JsonUtil.getJsonToBean((Object)entity, VisitFollowReadInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid VisitFollowReadUpForm visitFollowReadUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        VisitFollowReadEntity entity = this.visitFollowReadService.getInfo(id);
        if (entity != null) {
            VisitFollowReadEntity subentity = (VisitFollowReadEntity)JsonUtil.getJsonToBean((Object)visitFollowReadUpForm, VisitFollowReadEntity.class);
            this.visitFollowReadService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        VisitFollowReadEntity entity = this.visitFollowReadService.getInfo(id);
        if (entity != null) {
            this.visitFollowReadService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

