/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.qrcode.QrCodeUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.FilePathUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.constant.CompanyIdEnum;
import com.bringspring.crm.entity.CrmClueInfoEntity;
import com.bringspring.crm.entity.CrmCustomerContactsEntity;
import com.bringspring.crm.entity.CrmCustomerOpportunityEntity;
import com.bringspring.crm.entity.CrmCustomerOpportunityRelationEntity;
import com.bringspring.crm.entity.CrmCustomerOpportunityTrendsEntity;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.model.crmclueinfo.CrmClueInfoInfoVO;
import com.bringspring.crm.model.crmcustomeropportunity.CrmCustomerOpportunityInfoVO;
import com.bringspring.crm.model.crmcustomeropportunitytrends.CrmCustomerOpportunityTrendsInfoVO;
import com.bringspring.crm.service.CrmClueInfoService;
import com.bringspring.crm.service.CrmCustomerContactsService;
import com.bringspring.crm.service.CrmCustomerOpportunityRelationService;
import com.bringspring.crm.service.CrmCustomerOpportunityService;
import com.bringspring.crm.service.CrmCustomerOpportunityTrendsService;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.util.SelectValues;
import com.bringspring.system.base.entity.ProvinceEntity;
import com.bringspring.system.base.model.province.AreaModel;
import com.bringspring.system.base.model.province.ProvinceSelectListVO;
import com.bringspring.system.base.service.ProvinceService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.user.vo.UserBaseVO;
import com.bringspring.system.permission.model.user.vo.UserIdListVo;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.address.AdInfo;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.entity.VisitContactEntity;
import com.bringspring.visit.entity.VisitFollowReadEntity;
import com.bringspring.visit.entity.VisitFollowUpContactsEntity;
import com.bringspring.visit.entity.VisitFollowUpEntity;
import com.bringspring.visit.entity.VisitPhotoEntity;
import com.bringspring.visit.model.aftersalesquestion.AfterSalesQuestionTrendsPagination;
import com.bringspring.visit.model.visitfollowup.VisitFollowUpCrForm;
import com.bringspring.visit.model.visitfollowup.VisitFollowUpInfoVO;
import com.bringspring.visit.model.visitfollowup.VisitFollowUpListVO;
import com.bringspring.visit.model.visitfollowup.VisitFollowUpPagination;
import com.bringspring.visit.model.visitfollowup.VisitFollowUpUpForm;
import com.bringspring.visit.model.visitfollowup.VisitFollowUpUserInfoDTO;
import com.bringspring.visit.model.visitphoto.VisitPhotoListVO;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.visit.service.VisitContactService;
import com.bringspring.visit.service.VisitFollowReadService;
import com.bringspring.visit.service.VisitFollowUpContactsService;
import com.bringspring.visit.service.VisitFollowUpService;
import com.bringspring.visit.service.VisitPhotoService;
import com.bringspring.visit.utils.Constants;
import com.bringspring.visit.utils.DeleteMarkEnum;
import com.bringspring.visit.utils.EnableMarkEnum;
import com.bringspring.visit.utils.FollowUpEnableMarkEnum;
import com.bringspring.visit.utils.JingWeiUtil;
import com.bringspring.visit.utils.RoleVisitUtils;
import com.bringspring.visit.utils.UserRelationUtil;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u62dc\u8bbf\u529f\u80fd\u7684\u62dc\u8bbf\u8ddf\u8fdb\u8bb0\u5f55\u8868"}, value="visit")
@RequestMapping(value={"/api/visit/VisitFollowUp"})
public class VisitFollowUpController {
    private static final Logger log = LoggerFactory.getLogger(VisitFollowUpController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private VisitFollowUpService visitFollowUpService;
    @Autowired
    private VisitContactService visitContactService;
    @Autowired
    private VisitPhotoService visitPhotoService;
    @Autowired
    private VisitFollowReadService visitFollowReadService;
    @Autowired
    private RoleVisitUtils roleVisitUtils;
    @Autowired
    private UserService userService;
    @Autowired
    private VisitFollowUpContactsService visitFollowUpContactsService;
    @Autowired
    private CrmCustomerOpportunityService crmCustomerOpportunityService;
    @Autowired
    private CrmCustomerContactsService crmCustomerContactsService;
    @Autowired
    private SelectValues selectValues;
    @Autowired
    private CrmCustomerOpportunityTrendsService crmCustomerOpportunityTrendsService;
    @Autowired
    private CrmCustomerOpportunityRelationService crmCustomerOpportunityRelationService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserRelationUtil userRelationUtil;
    @Autowired
    private CrmClueInfoService crmClueInfoService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private ServiceAllUtil serviceAllUtil;
    @Autowired
    private ProvinceService provinceService;

    @ApiOperation(value="\u62dc\u8bbf\u5217\u8868")
    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody VisitFollowUpPagination visitFollowUpPagination) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        List userIdList = CollectionUtil.list((boolean)false);
        if (StrUtil.isBlank((CharSequence)visitFollowUpPagination.getUserId())) {
            if (Objects.isNull(visitFollowUpPagination.getDataRange())) {
                if (StrUtil.isNotEmpty((CharSequence)visitFollowUpPagination.getEnabledMark()) && StrUtil.equals((CharSequence)visitFollowUpPagination.getEnabledMark(), (CharSequence)FollowUpEnableMarkEnum.ENABLE_IMPROVED.getEnableMark())) {
                    // empty if block
                }
            } else {
                List<UserEntity> listByDataRange = this.getListByDataRange(visitFollowUpPagination.getDataRange());
                if (CollectionUtil.isNotEmpty(listByDataRange)) {
                    userIdList = listByDataRange.stream().map(UserEntity::getId).collect(Collectors.toList());
                } else {
                    userIdList.add(userInfo.getUserId());
                }
            }
        } else {
            userIdList.add(visitFollowUpPagination.getUserId());
        }
        visitFollowUpPagination.setUserIdList(userIdList);
        if (CollectionUtil.isNotEmpty(visitFollowUpPagination.getVisitDate())) {
            visitFollowUpPagination.setStartDate(visitFollowUpPagination.getVisitDate().get(0));
            visitFollowUpPagination.setEndDate(visitFollowUpPagination.getVisitDate().get(1));
        }
        if (visitFollowUpPagination.getDayType() != null && visitFollowUpPagination.getDayType() == 1) {
            visitFollowUpPagination.setStartDate(DateUtil.getBeginDayOfWeek());
            visitFollowUpPagination.setEndDate(DateUtil.getEndDayOfWeek());
        }
        if (visitFollowUpPagination.getDayType() != null && visitFollowUpPagination.getDayType() == 2) {
            visitFollowUpPagination.setStartDate(DateUtil.getBeginDayOfMonth());
            visitFollowUpPagination.setEndDate(DateUtil.getEndDayOfMonth());
        }
        if (visitFollowUpPagination.getDayType() != null && visitFollowUpPagination.getDayType() == 3) {
            visitFollowUpPagination.setStartDate(DateUtil.getBeginDayOfSeason((Date)DateUtil.getNowDate()));
            visitFollowUpPagination.setEndDate(DateUtil.getEndDayOfSeason((Date)DateUtil.getNowDate()));
        }
        if (visitFollowUpPagination.getMonthType() != null && visitFollowUpPagination.getMonthType() == 2) {
            visitFollowUpPagination.setStartDate(DateUtil.getBeginDayOfMonth());
            visitFollowUpPagination.setEndDate(DateUtil.getEndDayOfMonth());
        }
        if (visitFollowUpPagination.getMonthType() != null && visitFollowUpPagination.getMonthType() == 3) {
            visitFollowUpPagination.setStartDate(DateUtil.getBeginDayOfLastMonth());
            visitFollowUpPagination.setEndDate(DateUtil.getEndDayOfLastMonth());
        }
        List<VisitFollowUpEntity> list = this.visitFollowUpService.getList(visitFollowUpPagination);
        List listVO = JsonUtil.getJsonToList(list, VisitFollowUpListVO.class);
        for (VisitFollowUpListVO visitFollowUpVO : listVO) {
            UserEntity byId = (UserEntity)this.userService.getById((Serializable)((Object)visitFollowUpVO.getCreatorUserId()));
            if (!Objects.isNull(byId)) {
                visitFollowUpVO.setHeadIcon(byId.getHeadIcon());
            }
            OrganizeEntity organizeInfo = this.serviceAllUtil.getOrganizeInfo(byId.getOrganizeId());
            if (StrUtil.equals((CharSequence)visitFollowUpVO.getCompanyId(), (CharSequence)CompanyIdEnum.HNZY.getId())) {
                String cityName = "";
                if (StrUtil.isNotBlank((CharSequence)visitFollowUpVO.getCustomerAddress())) {
                    String[] split = visitFollowUpVO.getCustomerAddress().replace("\"", "").replace("[", "").replace("]", "").split(",");
                    for (int i = 0; i < split.length; ++i) {
                        if (i != 2) continue;
                        cityName = this.baseDataUtil.provinceData(split[2]);
                    }
                }
                if (StrUtil.isEmpty((CharSequence)cityName)) {
                    cityName = visitFollowUpVO.getCityName();
                }
                if (StrUtil.isNotEmpty((CharSequence)cityName)) {
                    visitFollowUpVO.setDepartmentName(organizeInfo.getFullName() + "-" + cityName.replace("\u5e02", ""));
                }
            }
            visitFollowUpVO.setVisitTypeCode(visitFollowUpVO.getVisitType());
            visitFollowUpVO.setVisitType(this.baseDataUtil.getDictName(visitFollowUpVO.getVisitType(), "visitType"));
            visitFollowUpVO.setCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(visitFollowUpVO.getCreatorUserId()));
            visitFollowUpVO.setCompanyName(this.baseDataUtil.comSelectValues(visitFollowUpVO.getCompanyId()));
            visitFollowUpVO.setVisitSaleTypeDesc(this.baseDataUtil.getDictName(visitFollowUpVO.getVisitSaleType(), "visitSaleType"));
            visitFollowUpVO.setEnabledMarkCode(visitFollowUpVO.getEnabledMark());
            visitFollowUpVO.setEnabledMark(this.baseDataUtil.getDictName(visitFollowUpVO.getEnabledMark(), Constants.FOLLOW_UP_ENABLED_MARK_DICT_ID));
            VisitFollowUpContactsEntity byFollowId = this.visitFollowUpContactsService.getByFollowId(visitFollowUpVO.getId());
            if (ObjectUtil.isNotNull((Object)byFollowId)) {
                visitFollowUpVO.setContactId(byFollowId.getName());
                visitFollowUpVO.setContactDepartment(byFollowId.getDepartment());
            }
            visitFollowUpVO.setGoal(this.baseDataUtil.getDictName(visitFollowUpVO.getGoal(), "visitgoal"));
            visitFollowUpVO.setCanLookDetail("1");
            if (StrUtil.equals((CharSequence)visitFollowUpVO.getCreatorUserId(), (CharSequence)userInfo.getUserId())) {
                visitFollowUpVO.setCanLookDetail("2");
                continue;
            }
            HashMap map = this.roleVisitUtils.canSeeUserId(userInfo);
            boolean isAll = (Boolean)map.get("isAll");
            if (isAll) {
                visitFollowUpVO.setCanLookDetail("1");
                continue;
            }
            List canSeeUserIdList = (List)map.get("idList");
            if (!CollectionUtil.isNotEmpty((Collection)canSeeUserIdList) || !canSeeUserIdList.contains(visitFollowUpVO.getCreatorUserId())) continue;
            visitFollowUpVO.setCanLookDetail("1");
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)visitFollowUpPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u552e\u540e\u548c\u9500\u552e\u62dc\u8bbf\u4eba\u5458\uff0c\u5730\u56fe\u7edf\u8ba1\u5206\u6790")
    @PostMapping(value={"/getUserMapData"})
    @NotCheckLogin
    public ActionResult getMapData(@RequestBody AfterSalesQuestionTrendsPagination afterSalesQuestionTrendsPagination) {
        List<VisitFollowUpEntity> visitList = this.visitFollowUpService.getVisitMapData(afterSalesQuestionTrendsPagination);
        List listVO = JsonUtil.getJsonToList(visitList, VisitFollowUpListVO.class);
        if (CollectionUtil.isEmpty((Collection)listVO)) {
            return ActionResult.success((Object)listVO);
        }
        if (ObjectUtil.isNotNull((Object)afterSalesQuestionTrendsPagination.getRadius())) {
            listVO = listVO.stream().filter(t -> ObjectUtil.isNotNull((Object)t.getJuli()) && t.getJuli() <= afterSalesQuestionTrendsPagination.getRadius()).collect(Collectors.toList());
        }
        listVO = listVO.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<VisitFollowUpListVO>(Comparator.comparing(f -> f.getCreatorUserId() + ";" + f.getCreatorUserId()))), ArrayList::new));
        listVO.sort(Comparator.comparing(VisitFollowUpListVO::getJuli, Comparator.nullsLast(Comparator.naturalOrder())));
        for (VisitFollowUpListVO visitFollowUpVO : listVO) {
            UserEntity byId = (UserEntity)this.userService.getById((Serializable)((Object)visitFollowUpVO.getCreatorUserId()));
            if (!Objects.isNull(byId)) {
                visitFollowUpVO.setHeadIcon(byId.getHeadIcon());
                visitFollowUpVO.setGender(byId.getGender() == 1 ? "\u7537" : (byId.getGender() == 2 ? "\u5973" : "\u4fdd\u5bc6"));
            }
            visitFollowUpVO.setVisitTypeName(this.baseDataUtil.getDictName(visitFollowUpVO.getVisitType(), "visitType"));
            visitFollowUpVO.setCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(visitFollowUpVO.getCreatorUserId()));
            visitFollowUpVO.setCompanyName(this.baseDataUtil.comSelectValues(visitFollowUpVO.getCompanyId()));
            visitFollowUpVO.setVisitSaleTypeDesc(this.baseDataUtil.getDictName(visitFollowUpVO.getVisitSaleType(), "visitSaleType"));
            AdInfo addressBak = JingWeiUtil.getAddress_bak(visitFollowUpVO.getAddressLat(), visitFollowUpVO.getAddressLng());
            if (!ObjectUtil.isNotNull((Object)addressBak)) continue;
            visitFollowUpVO.setAddress(addressBak.getAddress());
        }
        return ActionResult.success((Object)listVO);
    }

    @ApiOperation(value="\u9500\u552e\u548c\u552e\u540e\u4eba\u5458\uff0c\u5730\u56fe\u8f68\u8ff9\u5206\u6790\u5c55\u793a")
    @PostMapping(value={"/getTraceData"})
    @NotCheckLogin
    public ActionResult getTraceData(@RequestBody AfterSalesQuestionTrendsPagination afterSalesQuestionTrendsPagination) {
        List<VisitFollowUpEntity> visitList = this.visitFollowUpService.getTraceData(afterSalesQuestionTrendsPagination);
        List listVO = JsonUtil.getJsonToList(visitList, VisitFollowUpListVO.class);
        if (CollectionUtil.isEmpty((Collection)listVO)) {
            return ActionResult.success((Object)listVO);
        }
        for (VisitFollowUpListVO visitFollowUpVO : listVO) {
            UserEntity byId = (UserEntity)this.userService.getById((Serializable)((Object)visitFollowUpVO.getCreatorUserId()));
            if (!Objects.isNull(byId)) {
                visitFollowUpVO.setHeadIcon(byId.getHeadIcon());
                visitFollowUpVO.setGender(byId.getGender() == 1 ? "\u7537" : (byId.getGender() == 2 ? "\u5973" : "\u4fdd\u5bc6"));
            }
            visitFollowUpVO.setVisitTypeName(this.baseDataUtil.getDictName(visitFollowUpVO.getVisitType(), "visitType"));
            visitFollowUpVO.setCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(visitFollowUpVO.getCreatorUserId()));
            visitFollowUpVO.setCompanyName(this.baseDataUtil.comSelectValues(visitFollowUpVO.getCompanyId()));
            visitFollowUpVO.setVisitSaleTypeDesc(this.baseDataUtil.getDictName(visitFollowUpVO.getVisitSaleType(), "visitSaleType"));
            AdInfo addressBak = JingWeiUtil.getAddress_bak(visitFollowUpVO.getAddressLat(), visitFollowUpVO.getAddressLng());
            if (!ObjectUtil.isNotNull((Object)addressBak)) continue;
            visitFollowUpVO.setAddress(addressBak.getAddress());
        }
        return ActionResult.success((Object)listVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u884c\u653f\u533a\u5212\u4e0b\u62c9\u6846\u6570\u636e")
    @GetMapping(value={"/{parentId}/Selector/{ignoreIds}"})
    @NotCheckLogin
    public ActionResult<ListVO<ProvinceSelectListVO>> selectList(@PathVariable(value="parentId") String parentId, @PathVariable(value="ignoreIds") String ignoreIds) {
        List data = this.provinceService.getListByParentId(parentId);
        if (!"0".equals(ignoreIds)) {
            this.filterData(data, new ArrayList<String>(Arrays.asList(ignoreIds)));
        }
        List treeList = JsonUtil.getJsonToList((Object)data, ProvinceSelectListVO.class);
        int i = 0;
        for (ProvinceSelectListVO entity : treeList) {
            ProvinceSelectListVO provinceListVO = (ProvinceSelectListVO)JsonUtil.getJsonToBean((Object)entity, ProvinceSelectListVO.class);
            provinceListVO.setIsLeaf(Boolean.valueOf(false));
            treeList.set(i, provinceListVO);
            ++i;
        }
        ListVO vo = new ListVO();
        vo.setList(treeList);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u884c\u653f\u533a\u5212id\u8f6c\u540d\u79f0")
    @PostMapping(value={"/GetAreaByIds"})
    @NotCheckLogin
    public ActionResult getAreaByIds(@RequestBody AreaModel model) {
        LinkedList list = new LinkedList();
        for (List idList : model.getIdsList()) {
            List proList = this.provinceService.getProList(idList);
            List collect = proList.stream().map(ProvinceEntity::getFullName).collect(Collectors.toList());
            list.add(collect);
        }
        return ActionResult.success(list);
    }

    private void filterData(List<ProvinceEntity> data, List<String> id) {
        List collect = null;
        for (String ids : id) {
            collect = data.stream().filter(t -> ids.equals(t.getParentId())).collect(Collectors.toList());
            data.removeAll(collect);
        }
        if (collect != null && collect.size() > 0) {
            this.filterData(data, collect.stream().map(t -> t.getId()).collect(Collectors.toList()));
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u7684\u6240\u6709\u62dc\u8bbf\u8bb0\u5f55")
    @PostMapping(value={"/listByCustomerId"})
    public ActionResult listByCustomerId(@RequestBody VisitFollowUpPagination visitFollowUpPagination) {
        UserInfo userInfo = this.userProvider.get();
        visitFollowUpPagination.setEnabledMark(EnableMarkEnum.NORMAL.getEnableMark());
        List<VisitFollowUpEntity> list = this.visitFollowUpService.getList(visitFollowUpPagination);
        List listVO = JsonUtil.getJsonToList(list, VisitFollowUpListVO.class);
        for (VisitFollowUpListVO visitFollowUpVO : listVO) {
            UserEntity byId = (UserEntity)this.userService.getById((Serializable)((Object)visitFollowUpVO.getCreatorUserId()));
            if (!Objects.isNull(byId)) {
                visitFollowUpVO.setHeadIcon(byId.getHeadIcon());
            }
            visitFollowUpVO.setCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(visitFollowUpVO.getCreatorUserId()));
            visitFollowUpVO.setEnabledMark(this.baseDataUtil.getDictName(visitFollowUpVO.getEnabledMark(), Constants.FOLLOW_UP_ENABLED_MARK_DICT_ID));
            VisitContactEntity byId1 = (VisitContactEntity)this.visitContactService.getById((Serializable)((Object)visitFollowUpVO.getContactId()));
            String name = ObjectUtil.isNull((Object)byId1) ? "" : byId1.getName();
            visitFollowUpVO.setGoal(this.baseDataUtil.getDictName(visitFollowUpVO.getGoal(), "visitgoal"));
            visitFollowUpVO.setContactId(name);
            visitFollowUpVO.setCanLookDetail("0");
            if (StrUtil.equals((CharSequence)visitFollowUpVO.getCreatorUserId(), (CharSequence)userInfo.getUserId())) {
                visitFollowUpVO.setCanLookDetail("2");
                continue;
            }
            HashMap map = this.roleVisitUtils.canSeeUserId(userInfo);
            boolean isAll = (Boolean)map.get("isAll");
            if (isAll) {
                visitFollowUpVO.setCanLookDetail("1");
                continue;
            }
            List canSeeUserIdList = (List)map.get("idList");
            if (!CollectionUtil.isNotEmpty((Collection)canSeeUserIdList) || !canSeeUserIdList.contains(visitFollowUpVO.getCreatorUserId())) continue;
            visitFollowUpVO.setCanLookDetail("1");
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)visitFollowUpPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @RepeatSubmit
    @ApiOperation(value="\u65b0\u589e\u62dc\u8bbf")
    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid VisitFollowUpCrForm visitFollowUpCrForm) throws DataException {
        HashMap map = this.visitFollowUpService.saveFollowUp(visitFollowUpCrForm);
        if (Objects.isNull(map.get("error"))) {
            return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
        }
        return ActionResult.fail((String)map.get("error").toString());
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<VisitFollowUpInfoVO> info(@PathVariable(value="id") String id) {
        UserInfo userInfo = this.userProvider.get();
        VisitFollowUpEntity entity = this.visitFollowUpService.getInfo(id);
        VisitFollowUpInfoVO vo = (VisitFollowUpInfoVO)JsonUtil.getJsonToBean((Object)entity, VisitFollowUpInfoVO.class);
        if (!StrUtil.equals((CharSequence)userInfo.getUserId(), (CharSequence)entity.getCreatorUserId())) {
            VisitFollowReadEntity readEntity = new VisitFollowReadEntity();
            readEntity.setId(RandomUtil.uuId());
            readEntity.setFollowUpId(id);
            this.visitFollowReadService.save(readEntity);
            if (Objects.isNull(entity.getIsRead()) || entity.getIsRead() == 0) {
                entity.setIsRead(1);
                this.visitFollowUpService.update(id, entity);
            }
        }
        vo.setVisitSaleTypeDesc(this.baseDataUtil.getDictName(vo.getVisitSaleType(), "visitSaleType"));
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/detail/{id}"})
    public ActionResult<VisitFollowUpInfoVO> detailInfo(@PathVariable(value="id") String id) {
        RkProjectReportingEntity infoReport;
        Object byId;
        VisitContactEntity byId1;
        UserInfo userInfo = this.userProvider.get();
        VisitFollowUpEntity entity = this.visitFollowUpService.getInfo(id);
        VisitFollowUpInfoVO vo = (VisitFollowUpInfoVO)JsonUtil.getJsonToBean((Object)entity, VisitFollowUpInfoVO.class);
        vo.setCreatorTimeStr(DateUtil.dateFormat((Date)entity.getCreatorTime()));
        vo.setGoalName(this.baseDataUtil.getDictName(vo.getGoal(), "visitgoal"));
        VisitFollowUpContactsEntity byFollowId = this.visitFollowUpContactsService.getByFollowId(vo.getId());
        if (ObjectUtil.isNotNull((Object)byFollowId)) {
            vo.setContactName(byFollowId.getName());
            vo.setContactDepartment(byFollowId.getDepartment());
        }
        List<VisitPhotoEntity> visitPhotoEntities = this.visitPhotoService.listByFollowUpId(id);
        List jsonToList = JsonUtil.getJsonToList(visitPhotoEntities, VisitPhotoListVO.class);
        vo.setPhotoListVOList(jsonToList);
        if (!StrUtil.equals((CharSequence)userInfo.getUserId(), (CharSequence)entity.getCreatorUserId())) {
            VisitFollowReadEntity readEntity = new VisitFollowReadEntity();
            readEntity.setId(RandomUtil.uuId());
            readEntity.setFollowUpId(id);
            this.visitFollowReadService.save(readEntity);
            if (Objects.isNull(entity.getIsRead()) || entity.getIsRead() == 0) {
                entity.setIsRead(1);
                this.visitFollowUpService.update(id, entity);
            }
        }
        vo.setPhone("");
        String contactId = entity.getContactId();
        if (StrUtil.isNotEmpty((CharSequence)contactId) && !ObjectUtil.isEmpty((Object)(byId1 = (VisitContactEntity)this.visitContactService.getById((Serializable)((Object)contactId))))) {
            vo.setPhone(byId1.getPhone());
        }
        if (StringUtil.isNotEmpty((String)vo.getOppId())) {
            byId = (CrmCustomerOpportunityEntity)this.crmCustomerOpportunityService.getById((Serializable)((Object)vo.getOppId()));
            CrmCustomerOpportunityInfoVO jsonToBean = (CrmCustomerOpportunityInfoVO)JsonUtil.getJsonToBean((Object)byId, CrmCustomerOpportunityInfoVO.class);
            this.selectValues(jsonToBean);
            vo.setOpportunity(jsonToBean);
        }
        if (!ObjectUtil.isEmpty((Object)vo.getReportId()) && !ObjectUtil.isEmpty((Object)(infoReport = this.rkProjectReportingService.getInfo(vo.getReportId())))) {
            vo.setReportName(infoReport.getReportingProject());
        }
        if (StrUtil.isNotEmpty((CharSequence)vo.getClueId())) {
            byId = (CrmClueInfoEntity)this.crmClueInfoService.getById((Serializable)((Object)vo.getClueId()));
            vo.setCrmClueInfoInfoVO((CrmClueInfoInfoVO)JsonUtil.getJsonToBean((Object)byId, CrmClueInfoInfoVO.class));
        }
        vo.setVisitSaleTypeDesc(this.baseDataUtil.getDictName(vo.getVisitSaleType(), "visitSaleType"));
        return ActionResult.success((Object)vo);
    }

    private void selectValues(CrmCustomerOpportunityInfoVO item) {
        UserEntity info1;
        if (Objects.isNull(item)) {
            return;
        }
        CrmCustomerOpportunityTrendsInfoVO inputVo = new CrmCustomerOpportunityTrendsInfoVO();
        inputVo.setCustomerOpportunityId(item.getId());
        inputVo.setType("create");
        List<CrmCustomerOpportunityTrendsEntity> info = this.crmCustomerOpportunityTrendsService.getInfo(inputVo);
        if (!Objects.isNull(info)) {
            item.setGrade(info.get(0).getGrade());
        }
        item.setCustomerName(this.selectValues.cusSelectValues(item.getCustomerId()));
        UserEntity info2 = this.userService.getInfo(item.getCreatorUserId());
        if (!Objects.isNull(info2)) {
            item.setCreatorUserName(info2.getRealName());
        }
        if (!Objects.isNull(info1 = this.userService.getInfo(item.getAffiliatedUserId()))) {
            item.setAffiliatedUserName(Objects.isNull(item.getAffiliatedUserId()) ? null : this.baseDataUtil.userSelectValueNoAccount(item.getAffiliatedUserId()));
        }
        item.setCreatorTimeFormat(Objects.isNull(item.getCreatorTime()) ? null : DateUtil.daFormat((Long)item.getCreatorTime()));
        item.setLastModifyUserName(Objects.isNull(item.getLastModifyUserId()) ? null : this.baseDataUtil.userSelectValueNoAccount(item.getLastModifyUserId()));
        item.setLastModifyTimeFormat(Objects.isNull(item.getLastModifyTime()) ? null : DateUtil.daFormat((Long)item.getLastModifyTime()));
        item.setHelpName(Objects.isNull(item.getHelp()) ? null : this.baseDataUtil.getDictName(item.getHelp(), "whether"));
        item.setHelpScoptName(Objects.isNull(item.getHelpScopt()) ? null : this.baseDataUtil.getDictName(item.getHelpScopt(), "AssistPublicity"));
        item.setEnabledMarkName(Objects.isNull(item.getEnabledMark()) ? null : this.baseDataUtil.getDictName(item.getEnabledMark(), "OpportunityStatus"));
        List<CrmCustomerOpportunityRelationEntity> listByOppoId = this.crmCustomerOpportunityRelationService.getListByOppoId(item.getId());
        if (!Objects.isNull(listByOppoId)) {
            String productName = "";
            ArrayList<String> productId = new ArrayList<String>();
            for (CrmCustomerOpportunityRelationEntity listByOppoIdItem : listByOppoId) {
                CrmProductCategoryEntity productCategoryInfo = this.crmProductCategoryService.getInfo(listByOppoIdItem.getProductCategoryId());
                if (!Objects.isNull(productCategoryInfo)) {
                    productName = productName + productCategoryInfo.getName() + "\uff0c";
                    productId.add(productCategoryInfo.getId());
                }
                if (!Objects.isNull(productName)) {
                    item.setProductCategoryName(productName.substring(0, productName.length() - 1));
                }
                item.setProductCategoryId(productId);
            }
        }
    }

    @RepeatSubmit
    @ApiOperation(value="\u66f4\u65b0\u62dc\u8bbf\u8bb0\u5f55")
    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid VisitFollowUpUpForm visitFollowUpUpForm) throws DataException {
        HashMap map = this.visitFollowUpService.updateFollowUp(id, visitFollowUpUpForm);
        if (Objects.isNull(map.get("error"))) {
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)((String)map.get("error")));
    }

    @ApiOperation(value="\u5220\u9664\u62dc\u8bbf\u8bb0\u5f55")
    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        UserInfo userInfo = this.userProvider.get();
        VisitFollowUpEntity entity = this.visitFollowUpService.getInfo(id);
        if (entity != null) {
            if (StrUtil.isEmpty((CharSequence)entity.getCreatorUserId()) || !StrUtil.equals((CharSequence)userInfo.getUserId(), (CharSequence)entity.getCreatorUserId())) {
                return ActionResult.fail((String)"\u53ea\u80fd\u5220\u9664\u81ea\u5df1\u65b0\u589e\u7684\u62dc\u8bbf\u8bb0\u5f55");
            }
            entity.setDeleteMark(DeleteMarkEnum.DELETE.getDeleteMark());
            entity.setDeleteTime(DateUtil.getNowDate());
            entity.setDeleteUserId(userInfo.getUserId());
            this.visitFollowUpService.update(id, entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u7edf\u8ba1")
    @GetMapping(value={"/count/{type}"})
    public ActionResult countFollowUp(@PathVariable(value="type") String type) {
        long l = this.visitFollowUpService.countByType(type);
        return ActionResult.success((Object)l);
    }

    @ApiOperation(value="\u6700\u8fd16\u4e2a\u6708\u8bbf\u95ee\u91cf\u7edf\u8ba1")
    @GetMapping(value={"lastSixMonth"})
    public ActionResult lastSixMonth() {
        List list = this.visitFollowUpService.lastSixMonth();
        return ActionResult.success((Object)list);
    }

    @ApiOperation(value="\u6839\u636e\u7ecf\u7eac\u5ea6\u83b7\u53d6\u5730\u5740")
    @GetMapping(value={"getAddressByLatLng"})
    public ActionResult getAddressByLatLng(String lat, String lng) {
        AdInfo address = JingWeiUtil.getAddress(lat, lng);
        return ActionResult.success((Object)address);
    }

    @ApiOperation(value="\u67e5\u770b\u8d1f\u8d23\u4eba")
    @GetMapping(value={"/getUserInfoByDataRange/{dataRange}"})
    public ActionResult getUserInfoByDataRange(@PathVariable(value="dataRange") Integer dataRange) {
        UserInfo userInfo = this.userProvider.get();
        List<Object> userEntities = CollectionUtil.list((boolean)false);
        if (dataRange == -1) {
            List<UserEntity> userEntities1 = this.getListByDataRange(1);
            List<UserEntity> userEntities2 = this.getListByDataRange(2);
            userEntities.addAll(userEntities1);
            userEntities.addAll(userEntities2);
        } else {
            userEntities = this.getListByDataRange(dataRange);
        }
        if (CollectionUtil.isEmpty(userEntities)) {
            return ActionResult.success((Object)CollectionUtil.list((boolean)false));
        }
        userEntities = userEntities.stream().distinct().collect(Collectors.toList());
        List collect = userEntities.stream().map(user -> new VisitFollowUpUserInfoDTO(user.getId(), user.getRealName())).collect(Collectors.toList());
        collect = collect.stream().distinct().collect(Collectors.toList());
        return ActionResult.success(collect);
    }

    private List<UserEntity> getListByDataRange(Integer dataRange) {
        UserInfo userInfo = this.userProvider.get();
        List userIdList = CollectionUtil.list((boolean)false);
        List<String> strings = this.visitFollowUpService.listUserIdByCompany(userInfo.getOrganizeId());
        if (dataRange == 1) {
            HashMap map = this.roleVisitUtils.canSeeUserId(userInfo);
            boolean isAll = (Boolean)map.get("isAll");
            if (!isAll) {
                List list = (List)map.get("idList");
                List collect = list.stream().filter(strings::contains).collect(Collectors.toList());
                userIdList.addAll(collect);
            } else {
                userIdList.addAll(strings);
            }
        }
        if (dataRange == 2) {
            List listByManagerId = this.userService.getListByManagerId(userInfo.getUserId(), "");
            UserIdListVo userIdListVo = new UserIdListVo();
            userIdListVo.setId(userInfo.getUserId());
            listByManagerId.add(userIdListVo);
            if (CollectionUtil.isNotEmpty((Collection)listByManagerId)) {
                List collect = listByManagerId.stream().filter(x -> strings.contains(x.getId())).collect(Collectors.toList());
                List collect1 = collect.stream().map(UserBaseVO::getId).collect(Collectors.toList());
                userIdList.addAll(collect1);
            } else {
                userIdList.add(userInfo.getUserId());
            }
        }
        if (dataRange == 3) {
            userIdList.add(userInfo.getUserId());
        }
        if (CollectionUtil.isEmpty((Collection)userIdList)) {
            return CollectionUtil.list((boolean)false);
        }
        List userEntities = this.userService.listByIds((Collection)userIdList);
        return userEntities;
    }

    public static void main(String[] args) {
        Date beginDayOfWeek = DateUtil.getBeginDayOfWeek();
        Date endDayOfWeek = DateUtil.getEndDayOfWeek();
        Date beginDayOfMonth = DateUtil.getBeginDayOfMonth();
        Date endDayOfWeek1 = DateUtil.getEndDayOfMonth();
        Date seasonStartDate = DateUtil.getBeginDayOfSeason((Date)DateUtil.getNowDate());
        Date seasonEndDate = DateUtil.getEndDayOfSeason((Date)DateUtil.getNowDate());
        System.out.println("ddd");
        QrCodeUtil.generate((String)"https://hutool.cn/", (int)300, (int)300, (File)FileUtil.file((String)"d:/qrcode.jpg"));
    }

    @PostMapping(value={"/Actions/Export"})
    public ActionResult Export(@RequestBody VisitFollowUpPagination visitFollowUpPagination) {
        UserInfo userInfo = this.userProvider.get();
        List userIdList = CollectionUtil.list((boolean)false);
        if (StrUtil.isBlank((CharSequence)visitFollowUpPagination.getUserId())) {
            if (Objects.isNull(visitFollowUpPagination.getDataRange())) {
                if (!StrUtil.isNotEmpty((CharSequence)visitFollowUpPagination.getEnabledMark()) || !StrUtil.equals((CharSequence)visitFollowUpPagination.getEnabledMark(), (CharSequence)FollowUpEnableMarkEnum.ENABLE_IMPROVED.getEnableMark())) {
                    userIdList.add(userInfo.getUserId());
                }
            } else {
                List<UserEntity> listByDataRange = this.getListByDataRange(visitFollowUpPagination.getDataRange());
                if (CollectionUtil.isNotEmpty(listByDataRange)) {
                    userIdList = listByDataRange.stream().map(UserEntity::getId).collect(Collectors.toList());
                } else {
                    userIdList.add(userInfo.getUserId());
                }
            }
        } else {
            userIdList.add(visitFollowUpPagination.getUserId());
        }
        visitFollowUpPagination.setUserIdList(userIdList);
        if (CollectionUtil.isNotEmpty(visitFollowUpPagination.getVisitDate())) {
            visitFollowUpPagination.setStartDate(visitFollowUpPagination.getVisitDate().get(0));
            visitFollowUpPagination.setEndDate(visitFollowUpPagination.getVisitDate().get(1));
        }
        if (visitFollowUpPagination.getDayType() != null && visitFollowUpPagination.getDayType() == 1) {
            visitFollowUpPagination.setStartDate(DateUtil.getBeginDayOfWeek());
            visitFollowUpPagination.setEndDate(DateUtil.getEndDayOfWeek());
        }
        if (visitFollowUpPagination.getDayType() != null && visitFollowUpPagination.getDayType() == 2) {
            visitFollowUpPagination.setStartDate(DateUtil.getBeginDayOfMonth());
            visitFollowUpPagination.setEndDate(DateUtil.getEndDayOfMonth());
        }
        if (visitFollowUpPagination.getDayType() != null && visitFollowUpPagination.getDayType() == 3) {
            visitFollowUpPagination.setStartDate(DateUtil.getBeginDayOfSeason((Date)DateUtil.getNowDate()));
            visitFollowUpPagination.setEndDate(DateUtil.getEndDayOfSeason((Date)DateUtil.getNowDate()));
        }
        if (visitFollowUpPagination.getMonthType() != null && visitFollowUpPagination.getMonthType() == 2) {
            visitFollowUpPagination.setStartDate(DateUtil.getBeginDayOfMonth());
            visitFollowUpPagination.setEndDate(DateUtil.getEndDayOfMonth());
        }
        if (visitFollowUpPagination.getMonthType() != null && visitFollowUpPagination.getMonthType() == 3) {
            visitFollowUpPagination.setStartDate(DateUtil.getBeginDayOfLastMonth());
            visitFollowUpPagination.setEndDate(DateUtil.getEndDayOfLastMonth());
        }
        List<VisitFollowUpEntity> list = this.visitFollowUpService.getTypeList(visitFollowUpPagination, visitFollowUpPagination.getDataType());
        List listVO = JsonUtil.getJsonToList(list, VisitFollowUpListVO.class);
        for (VisitFollowUpListVO visitFollowUpVO : listVO) {
            UserEntity byId = (UserEntity)this.userService.getById((Serializable)((Object)visitFollowUpVO.getCreatorUserId()));
            if (!Objects.isNull(byId)) {
                visitFollowUpVO.setHeadIcon(byId.getHeadIcon());
            }
            visitFollowUpVO.setCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(visitFollowUpVO.getCreatorUserId()));
            CrmCustomerContactsEntity byId1 = (CrmCustomerContactsEntity)this.crmCustomerContactsService.getById((Serializable)((Object)visitFollowUpVO.getContactId()));
            if (ObjectUtil.isNotEmpty((Object)byId1)) {
                visitFollowUpVO.setContactDepartment(byId1.getDepartment());
                String name = ObjectUtil.isNull((Object)byId1) ? "" : byId1.getName();
                visitFollowUpVO.setContactId(name);
            }
            visitFollowUpVO.setGoal(this.baseDataUtil.getDictName(visitFollowUpVO.getGoal(), "visitgoal"));
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)visitFollowUpPagination.getSelectKey()) ? visitFollowUpPagination.getSelectKey().split(",") : new String[]{};
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    @NotCheckLogin
    @GetMapping(value={"/Actions/Export/app"})
    public void ExportApp(VisitFollowUpPagination visitFollowUpPagination) {
        UserInfo userInfo = new UserInfo();
        UserEntity byId2 = (UserEntity)this.userService.getById((Serializable)((Object)"410818926520309637"));
        visitFollowUpPagination.setDataType("1");
        visitFollowUpPagination.setEnabledMark("valid");
        visitFollowUpPagination.setSelectKey("customerName,contactId,creatorUserName,creatorTime,goal,followUp,locationAddress");
        userInfo.setUserId(byId2.getId());
        userInfo.setOrganizeId("2");
        List userIdList = CollectionUtil.list((boolean)false);
        if (Objects.isNull(visitFollowUpPagination.getUserId())) {
            if (Objects.isNull(visitFollowUpPagination.getDataRange())) {
                if (StrUtil.isNotEmpty((CharSequence)visitFollowUpPagination.getEnabledMark()) && StrUtil.equals((CharSequence)visitFollowUpPagination.getEnabledMark(), (CharSequence)FollowUpEnableMarkEnum.ENABLE_IMPROVED.getEnableMark())) {
                    HashMap map = this.roleVisitUtils.canSeeUserId(userInfo);
                    boolean isAll = (Boolean)map.get("isAll");
                    if (!isAll) {
                        userIdList.add(userInfo.getUserId());
                        List list = (List)map.get("idList");
                        userIdList.addAll(list);
                    }
                } else {
                    userIdList.add(userInfo.getUserId());
                }
            } else {
                List<UserEntity> listByDataRange = this.getListByDataRange(visitFollowUpPagination.getDataRange());
                if (CollectionUtil.isNotEmpty(listByDataRange)) {
                    userIdList = listByDataRange.stream().map(UserEntity::getId).collect(Collectors.toList());
                } else {
                    userIdList.add(userInfo.getUserId());
                }
            }
        } else {
            userIdList.add(visitFollowUpPagination.getUserId());
        }
        visitFollowUpPagination.setUserIdList(userIdList);
        visitFollowUpPagination.setCompanyId(userInfo.getOrganizeId());
        if (CollectionUtil.isNotEmpty(visitFollowUpPagination.getVisitDate())) {
            visitFollowUpPagination.setStartDate(visitFollowUpPagination.getVisitDate().get(0));
            visitFollowUpPagination.setEndDate(visitFollowUpPagination.getVisitDate().get(1));
        }
        if (visitFollowUpPagination.getDayType() != null && visitFollowUpPagination.getDayType() == 1) {
            visitFollowUpPagination.setStartDate(DateUtil.getBeginDayOfWeek());
            visitFollowUpPagination.setEndDate(DateUtil.getEndDayOfWeek());
        }
        if (visitFollowUpPagination.getDayType() != null && visitFollowUpPagination.getDayType() == 2) {
            visitFollowUpPagination.setStartDate(DateUtil.getBeginDayOfMonth());
            visitFollowUpPagination.setEndDate(DateUtil.getEndDayOfMonth());
        }
        if (visitFollowUpPagination.getDayType() != null && visitFollowUpPagination.getDayType() == 3) {
            visitFollowUpPagination.setStartDate(DateUtil.getBeginDayOfSeason((Date)DateUtil.getNowDate()));
            visitFollowUpPagination.setEndDate(DateUtil.getEndDayOfSeason((Date)DateUtil.getNowDate()));
        }
        if (visitFollowUpPagination.getMonthType() != null && visitFollowUpPagination.getMonthType() == 2) {
            visitFollowUpPagination.setStartDate(DateUtil.getBeginDayOfMonth());
            visitFollowUpPagination.setEndDate(DateUtil.getEndDayOfMonth());
        }
        if (visitFollowUpPagination.getMonthType() != null && visitFollowUpPagination.getMonthType() == 3) {
            visitFollowUpPagination.setStartDate(DateUtil.getBeginDayOfLastMonth());
            visitFollowUpPagination.setEndDate(DateUtil.getEndDayOfLastMonth());
        }
        List<VisitFollowUpEntity> list = this.visitFollowUpService.getTypeList(visitFollowUpPagination, visitFollowUpPagination.getDataType());
        List listVO = JsonUtil.getJsonToList(list, VisitFollowUpListVO.class);
        for (VisitFollowUpListVO visitFollowUpVO : listVO) {
            UserEntity byId = (UserEntity)this.userService.getById((Serializable)((Object)visitFollowUpVO.getCreatorUserId()));
            if (!Objects.isNull(byId)) {
                visitFollowUpVO.setHeadIcon(byId.getHeadIcon());
            }
            visitFollowUpVO.setCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(visitFollowUpVO.getCreatorUserId()));
            visitFollowUpVO.setEnabledMark(this.baseDataUtil.getDictName(visitFollowUpVO.getEnabledMark(), Constants.FOLLOW_UP_ENABLED_MARK_DICT_ID));
            CrmCustomerContactsEntity byId1 = (CrmCustomerContactsEntity)this.crmCustomerContactsService.getById((Serializable)((Object)visitFollowUpVO.getContactId()));
            if (ObjectUtil.isNotEmpty((Object)byId1)) {
                visitFollowUpVO.setContactDepartment(byId1.getDepartment());
                String name = ObjectUtil.isNull((Object)byId1) ? "" : byId1.getName();
                visitFollowUpVO.setContactId(name);
            }
            visitFollowUpVO.setGoal(this.baseDataUtil.getDictName(visitFollowUpVO.getGoal(), "visitgoal"));
            visitFollowUpVO.setCanLookDetail("0");
            if (StrUtil.equals((CharSequence)visitFollowUpVO.getCreatorUserId(), (CharSequence)userInfo.getUserId())) {
                visitFollowUpVO.setCanLookDetail("2");
                continue;
            }
            HashMap map = this.roleVisitUtils.canSeeUserId(userInfo);
            boolean isAll = (Boolean)map.get("isAll");
            if (isAll) {
                visitFollowUpVO.setCanLookDetail("1");
                continue;
            }
            List canSeeUserIdList = (List)map.get("idList");
            if (!CollectionUtil.isNotEmpty((Collection)canSeeUserIdList) || !canSeeUserIdList.contains(visitFollowUpVO.getCreatorUserId())) continue;
            visitFollowUpVO.setCanLookDetail("1");
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)visitFollowUpPagination.getSelectKey()) ? visitFollowUpPagination.getSelectKey().split(",") : new String[]{};
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        String filePath = FilePathUtil.getFilePath((String)"Temporary".toLowerCase());
        UploadUtil.downFile((String)this.configValueUtil.getFileType(), (String)vo.getName(), (String)"Temporary", (String)filePath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block68: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "customerName": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u540d\u79f0", (Object)"customerName"));
                        continue block68;
                    }
                    case "contactId": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba", (Object)"contactId"));
                        continue block68;
                    }
                    case "contactDepartment": {
                        entitys.add(new ExcelExportEntity("\u8054\u7cfb\u4eba\u79d1\u5ba4", (Object)"contactDepartment"));
                        continue block68;
                    }
                    case "creatorUserName": {
                        entitys.add(new ExcelExportEntity("\u62dc\u8bbf\u4eba", (Object)"creatorUserName"));
                        continue block68;
                    }
                    case "departmentName": {
                        entitys.add(new ExcelExportEntity("\u90e8\u95e8\u540d\u79f0", (Object)"departmentName"));
                        continue block68;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u62dc\u8bbf\u65f6\u95f4", (Object)"creatorTime"));
                        continue block68;
                    }
                    case "goal": {
                        entitys.add(new ExcelExportEntity("\u62dc\u8bbf\u76ee\u7684", (Object)"goal"));
                        continue block68;
                    }
                    case "followUp": {
                        ExcelExportEntity contractAmount = new ExcelExportEntity("\u62dc\u8bbf\u8ddf\u8fdb", (Object)"followUp");
                        entitys.add(contractAmount);
                        continue block68;
                    }
                    case "locationAddress": {
                        entitys.add(new ExcelExportEntity("\u5ba2\u6237\u5730\u5740", (Object)"locationAddress"));
                        continue block68;
                    }
                    case "oppStatus": {
                        entitys.add(new ExcelExportEntity("\u5546\u673a\u72b6\u6001", (Object)"oppStatus"));
                        continue block68;
                    }
                    case "isMilestone": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u9879\u76ee\u91cc\u7a0b\u7891", (Object)"isMilestone"));
                        continue block68;
                    }
                    case "milestoneDesc": {
                        entitys.add(new ExcelExportEntity("\u91cc\u7a0b\u7891\u5185\u5bb9", (Object)"milestoneDesc"));
                        continue block68;
                    }
                    case "oppCreatorTimeStr": {
                        entitys.add(new ExcelExportEntity("\u5546\u673a\u521b\u5efa\u65f6\u95f4", (Object)"oppCreatorTimeStr"));
                        continue block68;
                    }
                    case "creatorName": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u4eba", (Object)"creatorName"));
                        continue block68;
                    }
                    case "isCrossCompany": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u534f\u540c\u5546\u673a", (Object)"isCrossCompany"));
                        continue block68;
                    }
                    case "customerRegion": {
                        entitys.add(new ExcelExportEntity("\u9879\u76ee\u533a\u57df(\u6700\u7ec8\u7528\u6237\u6240\u5728\u533a\u57df)", (Object)"customerRegion"));
                        continue block68;
                    }
                    case "incomeType": {
                        entitys.add(new ExcelExportEntity("\u4ea7\u54c1\u5927\u7c7b", (Object)"incomeType"));
                        continue block68;
                    }
                    case "industryType": {
                        entitys.add(new ExcelExportEntity("\u884c\u4e1a\u7c7b\u578b", (Object)"industryType"));
                        continue block68;
                    }
                    case "profit": {
                        ExcelExportEntity profit = new ExcelExportEntity("\u6bdb\u5229\u6da6(\u5143)", (Object)"profit");
                        profit.setType(10);
                        entitys.add(profit);
                        continue block68;
                    }
                    case "isAgent": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u4ee3\u7406\u5408\u540c", (Object)"isAgent"));
                        continue block68;
                    }
                    case "agentType": {
                        entitys.add(new ExcelExportEntity("\u5408\u540c\u5bf9\u8c61\u7c7b\u578b", (Object)"agentType"));
                        continue block68;
                    }
                    case "returnAmount": {
                        ExcelExportEntity returnAmount = new ExcelExportEntity("\u5df2\u56de\u6b3e\u91d1\u989d(\u5143)", (Object)"returnAmount");
                        returnAmount.setType(10);
                        entitys.add(returnAmount);
                        continue block68;
                    }
                    case "returnRatio": {
                        entitys.add(new ExcelExportEntity("\u5df2\u56de\u6b3e\u6bd4\u4f8b(%)", (Object)"returnRatio"));
                        continue block68;
                    }
                    case "warranty": {
                        entitys.add(new ExcelExportEntity("\u8d28\u4fdd\u671f\u9650(\u6708)", (Object)"warranty"));
                        continue block68;
                    }
                    case "arrearsAmount": {
                        ExcelExportEntity arrearsAmount = new ExcelExportEntity("\u6536\u6b3e\u903e\u671f\u56de\u6b3e(\u5143)", (Object)"arrearsAmount");
                        arrearsAmount.setType(10);
                        entitys.add(arrearsAmount);
                        continue block68;
                    }
                    case "paymentMethod": {
                        entitys.add(new ExcelExportEntity("\u4ed8\u6b3e\u65b9\u5f0f", (Object)"paymentMethod"));
                        continue block68;
                    }
                    case "isHaveAttachment": {
                        entitys.add(new ExcelExportEntity("\u662f\u5426\u5df2\u4e0a\u4f20\u9644\u4ef6", (Object)"isHaveAttachment"));
                        continue block68;
                    }
                    case "expectedReturnTime": {
                        entitys.add(new ExcelExportEntity("\u9884\u8ba1\u8fd4\u56de\u65e5\u671f", (Object)"expectedReturnTime"));
                        continue block68;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u62dc\u8bbf\u8bb0\u5f55" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

