/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.VisitPhotoEntity;
import com.bringspring.visit.model.visitphoto.VisitPhotoCrForm;
import com.bringspring.visit.model.visitphoto.VisitPhotoInfoVO;
import com.bringspring.visit.model.visitphoto.VisitPhotoUpForm;
import com.bringspring.visit.service.VisitPhotoService;
import io.swagger.annotations.Api;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u62dc\u8bbf\u529f\u80fd\u7684\u62dc\u8bbf\u56fe\u7247\u8868"}, value="visit")
@RequestMapping(value={"/api/visit/VisitPhoto"})
public class VisitPhotoController {
    private static final Logger log = LoggerFactory.getLogger(VisitPhotoController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private VisitPhotoService visitPhotoService;

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid VisitPhotoCrForm visitPhotoCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        VisitPhotoEntity entity = (VisitPhotoEntity)JsonUtil.getJsonToBean((Object)visitPhotoCrForm, VisitPhotoEntity.class);
        entity.setId(mainId);
        this.visitPhotoService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<VisitPhotoInfoVO> info(@PathVariable(value="id") String id) {
        VisitPhotoEntity entity = this.visitPhotoService.getInfo(id);
        VisitPhotoInfoVO vo = (VisitPhotoInfoVO)JsonUtil.getJsonToBean((Object)entity, VisitPhotoInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<VisitPhotoInfoVO> detailInfo(@PathVariable(value="id") String id) {
        VisitPhotoEntity entity = this.visitPhotoService.getInfo(id);
        VisitPhotoInfoVO vo = (VisitPhotoInfoVO)JsonUtil.getJsonToBean((Object)entity, VisitPhotoInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid VisitPhotoUpForm visitPhotoUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        VisitPhotoEntity entity = this.visitPhotoService.getInfo(id);
        if (entity != null) {
            VisitPhotoEntity subentity = (VisitPhotoEntity)JsonUtil.getJsonToBean((Object)visitPhotoUpForm, VisitPhotoEntity.class);
            this.visitPhotoService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        VisitPhotoEntity entity = this.visitPhotoService.getInfo(id);
        if (entity != null) {
            this.visitPhotoService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

