/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.constant.UserRelationObjectTypeEnum;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.AfterInspectEnum;
import com.bringspring.visit.entity.AfterInspectTaskEntity;
import com.bringspring.visit.mapper.AfterInspectTaskMapper;
import com.bringspring.visit.model.after_inspecttask.AfterInspectTaskListVO;
import com.bringspring.visit.model.after_inspecttask.AfterInspectTaskPagination;
import com.bringspring.visit.model.after_inspecttask.AfterInspectTaskUpForm;
import com.bringspring.visit.service.AfterInspectTaskService;
import com.bringspring.visit.service.AfterInspectTaskTrendsService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AfterInspectTaskServiceImpl
extends ServiceImpl<AfterInspectTaskMapper, AfterInspectTaskEntity>
implements AfterInspectTaskService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private AfterInspectTaskTrendsService afterInspectTaskTrendsService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private BaseDataUtil baseDataUtil;

    @Override
    public List<AfterInspectTaskEntity> getList(AfterInspectTaskPagination afterInspectTaskPagination) {
        Object afterSalesTelephoneTaskObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int afterInspectTaskNum = 0;
        QueryWrapper afterInspectTaskQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            afterSalesTelephoneTaskObj = this.authorizeService.getCondition(new AuthorizeConditionModel(afterInspectTaskQueryWrapper, afterInspectTaskPagination.getMenuId(), "after_inspect_task"));
            if (ObjectUtil.isEmpty((Object)afterSalesTelephoneTaskObj)) {
                return new ArrayList<AfterInspectTaskEntity>();
            }
            afterInspectTaskQueryWrapper = (QueryWrapper)afterSalesTelephoneTaskObj;
            ++afterInspectTaskNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            afterSalesTelephoneTaskObj = this.authorizeService.getCondition(new AuthorizeConditionModel(afterInspectTaskQueryWrapper, afterInspectTaskPagination.getMenuId(), "after_inspect_task"));
            if (ObjectUtil.isEmpty((Object)afterSalesTelephoneTaskObj)) {
                return new ArrayList<AfterInspectTaskEntity>();
            }
            afterInspectTaskQueryWrapper = (QueryWrapper)afterSalesTelephoneTaskObj;
            ++afterInspectTaskNum;
        }
        if (StringUtils.isNotEmpty((String)afterInspectTaskPagination.getProjectName())) {
            ++afterInspectTaskNum;
            afterInspectTaskQueryWrapper.lambda().like(AfterInspectTaskEntity::getProjectName, (Object)afterInspectTaskPagination.getProjectName());
        }
        if (StringUtils.isNotEmpty((String)afterInspectTaskPagination.getProjectCode())) {
            ++afterInspectTaskNum;
            afterInspectTaskQueryWrapper.lambda().like(AfterInspectTaskEntity::getProjectCode, (Object)afterInspectTaskPagination.getProjectCode());
        }
        if (StringUtils.isNotEmpty((String)afterInspectTaskPagination.getEnabledMark())) {
            ++afterInspectTaskNum;
            afterInspectTaskQueryWrapper.lambda().like(AfterInspectTaskEntity::getEnabledMark, (Object)afterInspectTaskPagination.getEnabledMark());
        }
        if (StringUtils.isNotEmpty((String)afterInspectTaskPagination.getCustomerId())) {
            ++afterInspectTaskNum;
            afterInspectTaskQueryWrapper.lambda().eq(AfterInspectTaskEntity::getCustomerId, (Object)afterInspectTaskPagination.getCustomerId());
        }
        if (StringUtils.isNotEmpty((String)afterInspectTaskPagination.getInspectUserId())) {
            ++afterInspectTaskNum;
            afterInspectTaskQueryWrapper.lambda().eq(AfterInspectTaskEntity::getInspectUserId, (Object)afterInspectTaskPagination.getInspectUserId());
        }
        if (StringUtils.isNotEmpty((String)afterInspectTaskPagination.getCompanyId())) {
            ++afterInspectTaskNum;
            afterInspectTaskQueryWrapper.lambda().eq(AfterInspectTaskEntity::getCompanyId, (Object)afterInspectTaskPagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty(afterInspectTaskPagination.getDepartmentList())) {
            ++afterInspectTaskNum;
            String dept = afterInspectTaskPagination.getDepartmentList().get(afterInspectTaskPagination.getDepartmentList().size() - 1);
            afterInspectTaskQueryWrapper.lambda().eq(AfterInspectTaskEntity::getUserDept, (Object)dept);
        }
        if (StringUtils.isNotEmpty(afterInspectTaskPagination.getExecutionStartTime())) {
            ++afterInspectTaskNum;
            List<Long> ExecutionStartTimeList = afterInspectTaskPagination.getExecutionStartTime();
            Date startDate = DateUtil.daFormatDate((Long)ExecutionStartTimeList.get(0));
            Date endDate = DateUtil.dateAddDays((Date)DateUtil.daFormatDate((Long)ExecutionStartTimeList.get(1)), (int)1);
            afterInspectTaskQueryWrapper.lambda().between(AfterInspectTaskEntity::getCreatorTime, (Object)startDate, (Object)endDate);
        }
        if (AllIdList.size() > 0) {
            afterInspectTaskQueryWrapper.lambda().in(AfterInspectTaskEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)afterInspectTaskPagination.getSidx())) {
            afterInspectTaskQueryWrapper.lambda().orderByDesc(AfterInspectTaskEntity::getCreatorTime);
        } else {
            try {
                String sidx = afterInspectTaskPagination.getSidx();
                AfterInspectTaskEntity afterInspectTaskEntity = new AfterInspectTaskEntity();
                Field declaredField = afterInspectTaskEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                afterInspectTaskQueryWrapper = "asc".equals(afterInspectTaskPagination.getSort().toLowerCase()) ? (QueryWrapper)afterInspectTaskQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)afterInspectTaskQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(afterInspectTaskPagination.getCurrentPage(), afterInspectTaskPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)afterInspectTaskQueryWrapper);
            return afterInspectTaskPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return afterInspectTaskPagination.setData(list, list.size());
    }

    @Override
    public List<AfterInspectTaskEntity> getTypeList(AfterInspectTaskPagination afterInspectTaskPagination, String dataType) {
        Object afterSalesTelephoneTaskObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int afterInspectTaskNum = 0;
        QueryWrapper afterInspectTaskQueryWrapper = new QueryWrapper();
        boolean afterInspectTaskTrendsNum = false;
        QueryWrapper afterInspectTaskTrendsQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            afterSalesTelephoneTaskObj = this.authorizeService.getCondition(new AuthorizeConditionModel(afterInspectTaskQueryWrapper, afterInspectTaskPagination.getMenuId(), "after_inspect_task"));
            if (ObjectUtil.isEmpty((Object)afterSalesTelephoneTaskObj)) {
                return new ArrayList<AfterInspectTaskEntity>();
            }
            afterInspectTaskQueryWrapper = (QueryWrapper)afterSalesTelephoneTaskObj;
            ++afterInspectTaskNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            afterSalesTelephoneTaskObj = this.authorizeService.getCondition(new AuthorizeConditionModel(afterInspectTaskQueryWrapper, afterInspectTaskPagination.getMenuId(), "after_inspect_task"));
            if (ObjectUtil.isEmpty((Object)afterSalesTelephoneTaskObj)) {
                return new ArrayList<AfterInspectTaskEntity>();
            }
            afterInspectTaskQueryWrapper = (QueryWrapper)afterSalesTelephoneTaskObj;
            ++afterInspectTaskNum;
        }
        if (StringUtils.isNotEmpty((String)afterInspectTaskPagination.getProjectName())) {
            ++afterInspectTaskNum;
            afterInspectTaskQueryWrapper.lambda().like(AfterInspectTaskEntity::getProjectName, (Object)afterInspectTaskPagination.getProjectName());
        }
        if (StringUtils.isNotEmpty((String)afterInspectTaskPagination.getProjectCode())) {
            ++afterInspectTaskNum;
            afterInspectTaskQueryWrapper.lambda().like(AfterInspectTaskEntity::getProjectCode, (Object)afterInspectTaskPagination.getProjectCode());
        }
        if (StringUtils.isNotEmpty((String)afterInspectTaskPagination.getEnabledMark())) {
            ++afterInspectTaskNum;
            afterInspectTaskQueryWrapper.lambda().like(AfterInspectTaskEntity::getEnabledMark, (Object)afterInspectTaskPagination.getEnabledMark());
        }
        if (StringUtils.isNotEmpty((String)afterInspectTaskPagination.getInspectUserId())) {
            ++afterInspectTaskNum;
            afterInspectTaskQueryWrapper.lambda().like(AfterInspectTaskEntity::getInspectUserId, (Object)afterInspectTaskPagination.getInspectUserId());
        }
        if (StringUtils.isNotEmpty(afterInspectTaskPagination.getExecutionStartTime())) {
            ++afterInspectTaskNum;
            List<Long> ExecutionStartTimeList = afterInspectTaskPagination.getExecutionStartTime();
            Date startDate = DateUtil.daFormatDate((Long)ExecutionStartTimeList.get(0));
            Date endDate = DateUtil.dateAddDays((Date)DateUtil.daFormatDate((Long)ExecutionStartTimeList.get(1)), (int)1);
            afterInspectTaskQueryWrapper.lambda().between(AfterInspectTaskEntity::getCreatorTime, (Object)startDate, (Object)endDate);
        }
        if (AllIdList.size() > 0) {
            afterInspectTaskQueryWrapper.lambda().in(AfterInspectTaskEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)afterInspectTaskPagination.getSidx())) {
            afterInspectTaskQueryWrapper.lambda().orderByDesc(AfterInspectTaskEntity::getCreatorTime);
        } else {
            try {
                String sidx = afterInspectTaskPagination.getSidx();
                AfterInspectTaskEntity afterInspectTaskEntity = new AfterInspectTaskEntity();
                Field declaredField = afterInspectTaskEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                afterInspectTaskQueryWrapper = "asc".equals(afterInspectTaskPagination.getSort().toLowerCase()) ? (QueryWrapper)afterInspectTaskQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)afterInspectTaskQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(afterInspectTaskPagination.getCurrentPage(), afterInspectTaskPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)afterInspectTaskQueryWrapper);
                return afterInspectTaskPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return afterInspectTaskPagination.setData(list, list.size());
        }
        return this.list((Wrapper)afterInspectTaskQueryWrapper);
    }

    @Override
    public AfterInspectTaskEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AfterInspectTaskEntity::getId, (Object)id);
        return (AfterInspectTaskEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(AfterInspectTaskEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, AfterInspectTaskEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public boolean updateInspectTask(AfterInspectTaskUpForm afterInspectTaskUpForm) {
        UserInfo userInfo = this.userProvider.get();
        AfterInspectTaskEntity subentity = (AfterInspectTaskEntity)JsonUtil.getJsonToBean((Object)afterInspectTaskUpForm, AfterInspectTaskEntity.class);
        String state = afterInspectTaskUpForm.getEnabledMark();
        if (StringUtils.isNotEmpty((String)state)) {
            if ("20".equals(state)) {
                subentity.setExecutionStartTime(new Date());
            }
            if ("25".equals(state)) {
                subentity.setExecutionEndTime(new Date());
                List result = this.userRelationService.getListByUserIdAndObjType(userInfo.getUserId(), UserRelationObjectTypeEnum.AFTER_AREA_MANAGER.getObjectType());
                if (ObjectUtil.isNotEmpty((Object)result)) {
                    subentity.setEnabledMark(AfterInspectEnum.AFTER_INSPECT_PREFORM.getType());
                } else {
                    subentity.setEnabledMark(AfterInspectEnum.AFTER_INSPECT_AUDIT.getType());
                }
            }
        }
        subentity.setAttachmentList(null);
        this.update(afterInspectTaskUpForm.getId(), subentity);
        if (!"10".equals(state)) {
            this.afterInspectTaskTrendsService.createInspectTaskTrends(subentity);
        }
        if (CollectionUtil.isNotEmpty(afterInspectTaskUpForm.getAttachmentList())) {
            List attachmentEntityList = JsonUtil.getJsonToList(afterInspectTaskUpForm.getAttachmentList(), RkAttachmentEntity.class);
            for (RkAttachmentEntity entitys : attachmentEntityList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setObjId(afterInspectTaskUpForm.getId());
                entitys.setFileType(AttachmentTypeEnum.AFTER_INSPECT_TYPE.getType());
                entitys.setCreatorTime(new Date());
                entitys.setCreatorUserId(userInfo.getUserId());
                this.rkAttachmentService.save(entitys);
            }
        }
        return true;
    }

    @Override
    public long getAfterInspectCountByProjectId(String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AfterInspectTaskEntity::getProjectId, (Object)projectId);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public List<AfterInspectTaskListVO> getListByProjectId(String projectId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(AfterInspectTaskEntity::getProjectId, (Object)projectId);
        List list = this.list((Wrapper)queryWrapper);
        List authorizationList = JsonUtil.getJsonToList((Object)list, AfterInspectTaskListVO.class);
        List allCompanyList = this.organizeService.getAllCompanyList("");
        block0: for (AfterInspectTaskListVO auth : authorizationList) {
            auth.setInspectUserName(this.baseDataUtil.userSelectValue(auth.getInspectUserId()));
            for (OrganizeEntity company : allCompanyList) {
                if (!StringUtils.isNotEmpty((String)auth.getCompanyId()) || !company.getId().equals(auth.getCompanyId())) continue;
                auth.setCompanyName(company.getFullName());
                continue block0;
            }
        }
        return authorizationList;
    }

    @Override
    public void delete(AfterInspectTaskEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

