/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.visit.entity.AfterInspectTaskEntity;
import com.bringspring.visit.entity.AfterInspectTaskTrendsEntity;
import com.bringspring.visit.mapper.AfterInspectTaskTrendsMapper;
import com.bringspring.visit.service.AfterInspectTaskTrendsService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AfterInspectTaskTrendsServiceImpl
extends ServiceImpl<AfterInspectTaskTrendsMapper, AfterInspectTaskTrendsEntity>
implements AfterInspectTaskTrendsService {
    @Autowired
    private UserProvider userProvider;

    @Override
    public List<AfterInspectTaskTrendsEntity> getInspectTrendsListByInspectId(String inspectId) {
        QueryWrapper afterInspectTaskTrendsQueryWrapper = new QueryWrapper();
        afterInspectTaskTrendsQueryWrapper.lambda().eq(AfterInspectTaskTrendsEntity::getInspectId, (Object)inspectId);
        afterInspectTaskTrendsQueryWrapper.lambda().orderByDesc(AfterInspectTaskTrendsEntity::getCreatorTime);
        List list = this.list((Wrapper)afterInspectTaskTrendsQueryWrapper);
        return list;
    }

    @Override
    public void createInspectTaskTrends(AfterInspectTaskEntity entity) {
        AfterInspectTaskTrendsEntity trendsEntity = new AfterInspectTaskTrendsEntity();
        UserInfo userInfo = this.userProvider.get();
        trendsEntity.setId(RandomUtil.uuId());
        trendsEntity.setCreatorTime(new Date());
        trendsEntity.setInspectId(entity.getId());
        trendsEntity.setNodeType(entity.getEnabledMark());
        trendsEntity.setCompanyId(userInfo.getOrganizeId());
        trendsEntity.setCreatorUserId(userInfo.getUserId());
        trendsEntity.setUserName(userInfo.getUserName());
        trendsEntity.setUserId(userInfo.getUserId());
        trendsEntity.setExecDate(new Date());
        trendsEntity.setDescription(entity.getDescription());
        this.save(trendsEntity);
    }
}

