/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.utils.AllMaintenanceTypeEnum;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.visit.entity.AfterSalesCommunicationRecordEntity;
import com.bringspring.visit.entity.AfterSalesMaintenanceEntity;
import com.bringspring.visit.mapper.AfterSalesCommunicationRecordMapper;
import com.bringspring.visit.model.aftersalescommunicationrecord.AfterSalesCommunicationRecordCrForm;
import com.bringspring.visit.model.aftersalescommunicationrecord.AfterSalesCommunicationRecordPagination;
import com.bringspring.visit.model.aftersalescommunicationrecord.AfterSalesCommunicationRecordUpForm;
import com.bringspring.visit.service.AfterSalesCommunicationRecordService;
import com.bringspring.visit.service.AfterSalesMaintenanceService;
import com.bringspring.visit.utils.HolidayUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AfterSalesCommunicationRecordServiceImpl
extends ServiceImpl<AfterSalesCommunicationRecordMapper, AfterSalesCommunicationRecordEntity>
implements AfterSalesCommunicationRecordService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private AfterSalesMaintenanceService afterSalesMaintenanceService;

    @Override
    public List<AfterSalesCommunicationRecordEntity> getList(AfterSalesCommunicationRecordPagination afterSalesCommunicationRecordPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int afterSalesCommunicationRecordNum = 0;
        QueryWrapper afterSalesCommunicationRecordQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)afterSalesCommunicationRecordPagination.getMaintenanceId())) {
            ++afterSalesCommunicationRecordNum;
            afterSalesCommunicationRecordQueryWrapper.lambda().like(AfterSalesCommunicationRecordEntity::getMaintenanceId, (Object)afterSalesCommunicationRecordPagination.getMaintenanceId());
        }
        if (StringUtils.isNotEmpty((String)afterSalesCommunicationRecordPagination.getContactsId())) {
            ++afterSalesCommunicationRecordNum;
            afterSalesCommunicationRecordQueryWrapper.lambda().like(AfterSalesCommunicationRecordEntity::getContactsId, (Object)afterSalesCommunicationRecordPagination.getContactsId());
        }
        if (AllIdList.size() > 0) {
            afterSalesCommunicationRecordQueryWrapper.lambda().in(AfterSalesCommunicationRecordEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)afterSalesCommunicationRecordPagination.getSidx())) {
            afterSalesCommunicationRecordQueryWrapper.lambda().orderByDesc(AfterSalesCommunicationRecordEntity::getId);
        } else {
            try {
                String sidx = afterSalesCommunicationRecordPagination.getSidx();
                AfterSalesCommunicationRecordEntity afterSalesCommunicationRecordEntity = new AfterSalesCommunicationRecordEntity();
                Field declaredField = afterSalesCommunicationRecordEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                afterSalesCommunicationRecordQueryWrapper = "asc".equals(afterSalesCommunicationRecordPagination.getSort().toLowerCase()) ? (QueryWrapper)afterSalesCommunicationRecordQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)afterSalesCommunicationRecordQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(afterSalesCommunicationRecordPagination.getCurrentPage(), afterSalesCommunicationRecordPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)afterSalesCommunicationRecordQueryWrapper);
            return afterSalesCommunicationRecordPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return afterSalesCommunicationRecordPagination.setData(list, list.size());
    }

    @Override
    public List<AfterSalesCommunicationRecordEntity> getTypeList(AfterSalesCommunicationRecordPagination afterSalesCommunicationRecordPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int afterSalesCommunicationRecordNum = 0;
        QueryWrapper afterSalesCommunicationRecordQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)afterSalesCommunicationRecordPagination.getContactsId())) {
            ++afterSalesCommunicationRecordNum;
            afterSalesCommunicationRecordQueryWrapper.lambda().like(AfterSalesCommunicationRecordEntity::getContactsId, (Object)afterSalesCommunicationRecordPagination.getContactsId());
        }
        if (AllIdList.size() > 0) {
            afterSalesCommunicationRecordQueryWrapper.lambda().in(AfterSalesCommunicationRecordEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)afterSalesCommunicationRecordPagination.getSidx())) {
            afterSalesCommunicationRecordQueryWrapper.lambda().orderByDesc(AfterSalesCommunicationRecordEntity::getId);
        } else {
            try {
                String sidx = afterSalesCommunicationRecordPagination.getSidx();
                AfterSalesCommunicationRecordEntity afterSalesCommunicationRecordEntity = new AfterSalesCommunicationRecordEntity();
                Field declaredField = afterSalesCommunicationRecordEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                afterSalesCommunicationRecordQueryWrapper = "asc".equals(afterSalesCommunicationRecordPagination.getSort().toLowerCase()) ? (QueryWrapper)afterSalesCommunicationRecordQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)afterSalesCommunicationRecordQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(afterSalesCommunicationRecordPagination.getCurrentPage(), afterSalesCommunicationRecordPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)afterSalesCommunicationRecordQueryWrapper);
                return afterSalesCommunicationRecordPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return afterSalesCommunicationRecordPagination.setData(list, list.size());
        }
        return this.list((Wrapper)afterSalesCommunicationRecordQueryWrapper);
    }

    @Override
    public AfterSalesCommunicationRecordEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AfterSalesCommunicationRecordEntity::getId, (Object)id);
        return (AfterSalesCommunicationRecordEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(AfterSalesCommunicationRecordCrForm afterSalesCommunicationRecordCrForm) throws ParseException {
        UserInfo userInfo = this.userProvider.get();
        String mainId = RandomUtil.uuId();
        AfterSalesCommunicationRecordEntity entity = (AfterSalesCommunicationRecordEntity)JsonUtil.getJsonToBean((Object)afterSalesCommunicationRecordCrForm, AfterSalesCommunicationRecordEntity.class);
        entity.setId(mainId);
        AfterSalesMaintenanceEntity info = this.afterSalesMaintenanceService.getInfo(afterSalesCommunicationRecordCrForm.getMaintenanceId());
        if (ObjectUtil.isNotEmpty((Object)info)) {
            info.setLatestCommunicator(userInfo.getUserId());
            info.setLatestCommunicationTime(HolidayUtil.getNowFormat());
            info.setLatestCommunicationContent(entity.getCommunicationContent());
            info.setNextCommunicationDate(entity.getRecommunicationDate());
            info.setFollowStatus(AllMaintenanceTypeEnum.NORMALFOLLOW.getType());
            info.setWarrantyState(afterSalesCommunicationRecordCrForm.getWarrantyState());
            info.setFollowRemark(afterSalesCommunicationRecordCrForm.getFollowRemark());
            this.afterSalesMaintenanceService.update(info.getId(), info);
        }
        this.save(entity);
    }

    @Override
    @DSTransactional
    public void update(String id, AfterSalesCommunicationRecordUpForm afterSalesCommunicationRecordUpForm) {
        UserInfo userInfo = this.userProvider.get();
        AfterSalesCommunicationRecordEntity entity = this.getInfo(id);
        if (entity != null) {
            AfterSalesCommunicationRecordEntity subentity = (AfterSalesCommunicationRecordEntity)JsonUtil.getJsonToBean((Object)afterSalesCommunicationRecordUpForm, AfterSalesCommunicationRecordEntity.class);
            this.updateById(subentity);
        }
    }

    @Override
    public List<AfterSalesCommunicationRecordEntity> byMaintenanceIdList(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AfterSalesCommunicationRecordEntity::getMaintenanceId, (Object)id);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<String> getSupertimeList() {
        LocalDateTime threeHundredSixtyFiveDaysAgo = LocalDateTime.now().minus(365L, ChronoUnit.DAYS);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().lt(AfterSalesCommunicationRecordEntity::getCreatorTime, (Object)threeHundredSixtyFiveDaysAgo);
        List list = this.list((Wrapper)queryWrapper);
        List<String> maintenanceIdList = list.stream().map(AfterSalesCommunicationRecordEntity::getMaintenanceId).collect(Collectors.toList());
        return maintenanceIdList;
    }

    @Override
    public long getMainCount(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AfterSalesCommunicationRecordEntity::getMaintenanceId, (Object)id);
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void delete(AfterSalesCommunicationRecordEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

