/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.contract.model.RkProjectTaskDetailPagination;
import com.bringspring.visit.entity.AfterSalesQuestionTrendsEntity;
import com.bringspring.visit.mapper.AfterSalesQuestionTrendsMapper;
import com.bringspring.visit.service.AfterSalesQuestionTrendsService;
import com.bringspring.visit.utils.DateUtil;
import com.bringspring.visit.utils.HolidayUtil;
import com.bringspring.visit.utils.QuestionTrendsTypeEnum;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class AfterSalesQuestionTrendsServiceImpl
extends ServiceImpl<AfterSalesQuestionTrendsMapper, AfterSalesQuestionTrendsEntity>
implements AfterSalesQuestionTrendsService {
    @Override
    public void create(AfterSalesQuestionTrendsEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, AfterSalesQuestionTrendsEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(AfterSalesQuestionTrendsEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public void createTrends(String questionId, String type, String description, String nextProcessedUser, Date time) {
        AfterSalesQuestionTrendsEntity trendsEntity = new AfterSalesQuestionTrendsEntity();
        trendsEntity.setQuestionId(questionId);
        trendsEntity.setId(RandomUtil.uuId());
        trendsEntity.setType(type);
        trendsEntity.setDescription(description);
        trendsEntity.setNextProcessedUser(nextProcessedUser);
        trendsEntity.setLastModifyTime(time);
        if ("admin".equals(nextProcessedUser)) {
            trendsEntity.setCreatorUserId("admin");
        }
        this.save(trendsEntity);
    }

    @Override
    public List<AfterSalesQuestionTrendsEntity> getListByQuestionId(String questionId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AfterSalesQuestionTrendsEntity::getQuestionId, (Object)questionId);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByDesc(AfterSalesQuestionTrendsEntity::getCreatorTime)).orderByDesc(AfterSalesQuestionTrendsEntity::getId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<AfterSalesQuestionTrendsEntity> getByAssignRemark(String assignRemark) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().and(a -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)a.like(AfterSalesQuestionTrendsEntity::getDescription, (Object)assignRemark)).eq(AfterSalesQuestionTrendsEntity::getType, (Object)QuestionTrendsTypeEnum.ASSIGN_TYPE.getType());
        });
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<AfterSalesQuestionTrendsEntity> getByDailyPaperDateList(RkProjectTaskDetailPagination rkProjectTaskDetailPagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AfterSalesQuestionTrendsEntity::getCreatorUserId, (Object)rkProjectTaskDetailPagination.getUserId());
        queryWrapper.lambda().between(AfterSalesQuestionTrendsEntity::getCreatorTime, (Object)HolidayUtil.getBeginDayOfWeek(DateUtil.daFormat(rkProjectTaskDetailPagination.getDailyPaperDate())), (Object)HolidayUtil.getEndDayOfWeek(DateUtil.daFormat(rkProjectTaskDetailPagination.getDailyPaperDate())));
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<AfterSalesQuestionTrendsEntity> getListByQuestionIdOrState(String id, String enabledMark) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(AfterSalesQuestionTrendsEntity::getQuestionId, (Object)id)).eq(AfterSalesQuestionTrendsEntity::getType, (Object)enabledMark);
        ((QueryWrapper)queryWrapper.orderByDesc((Object)"creator_time")).last("LIMIT 1");
        return this.list((Wrapper)queryWrapper);
    }
}

