/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.RkAttachmentEntity;
import com.bringspring.contract.service.RkAttachmentService;
import com.bringspring.contract.utils.AttachmentTypeEnum;
import com.bringspring.utils.AfterInspectEnum;
import com.bringspring.visit.entity.AfterInspectTaskEntity;
import com.bringspring.visit.entity.AfterSalesTaskInspectionTopicEntity;
import com.bringspring.visit.entity.AfterSalesTelephoneTemplateEntity;
import com.bringspring.visit.entity.AfterSalesTelephoneTopicOptionEntity;
import com.bringspring.visit.mapper.AfterSalesTaskInspectionTopicMapper;
import com.bringspring.visit.model.after_inspecttask.AfterInspectTaskForm;
import com.bringspring.visit.model.after_sales_telephone_template.AfterSalesTelephoneTopicOptionModel;
import com.bringspring.visit.model.aftersalestelephonetaskresult.AfterSalesTelephoneTaskTopicListVO;
import com.bringspring.visit.service.AfterInspectTaskService;
import com.bringspring.visit.service.AfterSalesTaskInspectionTopicService;
import com.bringspring.visit.service.AfterSalesTelephoneTemplateService;
import com.bringspring.visit.service.AfterSalesTelephoneTopicOptionService;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AfterSalesTaskInspectionTopicServiceImpl
extends ServiceImpl<AfterSalesTaskInspectionTopicMapper, AfterSalesTaskInspectionTopicEntity>
implements AfterSalesTaskInspectionTopicService {
    @Autowired
    private AfterSalesTelephoneTemplateService afterSalesTelephoneTemplateService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AfterInspectTaskService afterInspectTaskService;
    @Autowired
    private RkAttachmentService rkAttachmentService;
    @Autowired
    private AfterSalesTelephoneTopicOptionService afterSalesTelephoneTopicOptionService;
    @Autowired
    private AfterSalesTaskInspectionTopicService afterSalesTaskInspectionTopicService;

    @Override
    public void create(AfterInspectTaskForm form) {
        UserInfo userInfo = this.userProvider.get();
        AfterSalesTelephoneTemplateEntity info = this.afterSalesTelephoneTemplateService.getInfo(form.getTemplateId());
        for (AfterSalesTelephoneTaskTopicListVO vo : form.getTopicList()) {
            AfterSalesTaskInspectionTopicEntity entity = (AfterSalesTaskInspectionTopicEntity)JsonUtil.getJsonToBean((Object)vo, AfterSalesTaskInspectionTopicEntity.class);
            entity.setId(RandomUtil.uuId());
            entity.setInspectionId(form.getId());
            entity.setCompanyId(userInfo.getOrganizeId());
            entity.setTemplateId(form.getTemplateId());
            entity.setTemplateName(info.getName());
            entity.setTemplateTopicId(vo.getId());
            entity.setTopicType(vo.getTopicType());
            this.save(entity);
        }
        AfterInspectTaskEntity taskEntity = this.afterInspectTaskService.getInfo(form.getId());
        taskEntity.setUserAddress(form.getUserAddress());
        taskEntity.setBusinesstripType(form.getBusinesstripType());
        taskEntity.setSystem(form.getSystem());
        taskEntity.setTerminalQuantityType(form.getTerminalQuantityType());
        taskEntity.setVersionType(form.getVersionType());
        taskEntity.setServerIp(form.getServerIp());
        taskEntity.setWarrantyExpirationTime(form.getWarrantyExpirationTime());
        taskEntity.setDescription(form.getDescription());
        taskEntity.setLinkmanName(form.getLinkmanName());
        taskEntity.setLinkmanPhone(form.getLinkmanPhone());
        taskEntity.setInspectionDate(form.getInspectionDate());
        taskEntity.setEnabledMark(AfterInspectEnum.AFTER_INSPECT_PREFORM.getType());
        this.afterInspectTaskService.update(taskEntity.getId(), taskEntity);
        if (CollectionUtil.isNotEmpty(form.getAttachmentList())) {
            this.rkAttachmentService.deleteByObjId(form.getId());
            List attachmentEntityList = JsonUtil.getJsonToList(form.getAttachmentList(), RkAttachmentEntity.class);
            for (RkAttachmentEntity entitys : attachmentEntityList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setObjId(form.getId());
                entitys.setFileType(AttachmentTypeEnum.AFTER_INSPECT_TYPE.getType());
                entitys.setCreatorTime(new Date());
                entitys.setCreatorUserId(userInfo.getUserId());
                this.rkAttachmentService.save(entitys);
            }
        }
    }

    @Override
    public void delete(List<String> id) {
        this.removeBatchByIds(id);
    }

    @Override
    public LinkedHashMap<String, List<AfterSalesTaskInspectionTopicEntity>> getByInspectionId(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AfterSalesTaskInspectionTopicEntity::getInspectionId, (Object)id);
        List list = this.list((Wrapper)queryWrapper);
        for (AfterSalesTaskInspectionTopicEntity topicEntity : list) {
            List<AfterSalesTelephoneTopicOptionEntity> optionEntityList = this.afterSalesTelephoneTopicOptionService.listByTopicId(topicEntity.getTemplateTopicId());
            topicEntity.setOptionList(JsonUtil.getJsonToList(optionEntityList, AfterSalesTelephoneTopicOptionModel.class));
            if (!StringUtils.isNotEmpty((String)topicEntity.getTemplateTopicId())) continue;
            topicEntity.setId(topicEntity.getTemplateTopicId());
        }
        LinkedHashMap<String, List<AfterSalesTaskInspectionTopicEntity>> stringListHashMap = new LinkedHashMap<String, List<AfterSalesTaskInspectionTopicEntity>>();
        stringListHashMap.put("service", list.stream().filter(a -> StrUtil.equals((CharSequence)a.getType(), (CharSequence)"\u670d\u52a1\u5668")).collect(Collectors.toList()));
        stringListHashMap.put("network", list.stream().filter(a -> StrUtil.equals((CharSequence)a.getType(), (CharSequence)"\u7f51\u7edc")).collect(Collectors.toList()));
        stringListHashMap.put("software", list.stream().filter(a -> StrUtil.equals((CharSequence)a.getType(), (CharSequence)"\u670d\u52a1\u5668\u540e\u53f0\u8f6f\u4ef6:(\u65e0\u76f8\u5173\u8f6f\u4ef6\u53ef\u5ffd\u7565)")).collect(Collectors.toList()));
        stringListHashMap.put("hardware", list.stream().filter(a -> StrUtil.equals((CharSequence)a.getType(), (CharSequence)"\u786c\u4ef6")).collect(Collectors.toList()));
        stringListHashMap.put("answerQuestion", list.stream().filter(a -> StrUtil.equals((CharSequence)a.getTopicType(), (CharSequence)"essayQuestion")).collect(Collectors.toList()));
        return stringListHashMap;
    }

    @Override
    public Boolean telephoneUpdate(String id, AfterInspectTaskForm afterInspectTaskForm) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AfterSalesTaskInspectionTopicEntity::getInspectionId, (Object)id);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return false;
        }
        this.afterSalesTaskInspectionTopicService.delete(list.stream().map(AfterSalesTaskInspectionTopicEntity::getId).collect(Collectors.toList()));
        UserInfo userInfo = this.userProvider.get();
        AfterSalesTelephoneTemplateEntity info = this.afterSalesTelephoneTemplateService.getInfo(afterInspectTaskForm.getTemplateId());
        for (AfterSalesTelephoneTaskTopicListVO vo : afterInspectTaskForm.getTopicList()) {
            AfterSalesTaskInspectionTopicEntity entity = (AfterSalesTaskInspectionTopicEntity)JsonUtil.getJsonToBean((Object)vo, AfterSalesTaskInspectionTopicEntity.class);
            entity.setId(RandomUtil.uuId());
            entity.setInspectionId(afterInspectTaskForm.getId());
            entity.setCompanyId(userInfo.getOrganizeId());
            entity.setTemplateId(afterInspectTaskForm.getTemplateId());
            entity.setTemplateName(info.getName());
            entity.setTemplateTopicId(vo.getId());
            entity.setTopicType(vo.getTopicType());
            this.save(entity);
        }
        AfterInspectTaskEntity taskEntity = this.afterInspectTaskService.getInfo(afterInspectTaskForm.getId());
        taskEntity.setUserAddress(afterInspectTaskForm.getUserAddress());
        taskEntity.setBusinesstripType(afterInspectTaskForm.getBusinesstripType());
        taskEntity.setSystem(afterInspectTaskForm.getSystem());
        taskEntity.setTerminalQuantityType(afterInspectTaskForm.getTerminalQuantityType());
        taskEntity.setVersionType(afterInspectTaskForm.getVersionType());
        taskEntity.setServerIp(afterInspectTaskForm.getServerIp());
        taskEntity.setWarrantyExpirationTime(afterInspectTaskForm.getWarrantyExpirationTime());
        taskEntity.setDescription(afterInspectTaskForm.getDescription());
        taskEntity.setLinkmanName(afterInspectTaskForm.getLinkmanName());
        taskEntity.setLinkmanPhone(afterInspectTaskForm.getLinkmanPhone());
        taskEntity.setInspectionDate(afterInspectTaskForm.getInspectionDate());
        taskEntity.setAttachmentList(null);
        this.afterInspectTaskService.update(taskEntity.getId(), taskEntity);
        if (CollectionUtil.isNotEmpty(afterInspectTaskForm.getAttachmentList())) {
            this.rkAttachmentService.deleteByObjId(afterInspectTaskForm.getId());
            List attachmentEntityList = JsonUtil.getJsonToList(afterInspectTaskForm.getAttachmentList(), RkAttachmentEntity.class);
            for (RkAttachmentEntity entitys : attachmentEntityList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setObjId(afterInspectTaskForm.getId());
                entitys.setFileType(AttachmentTypeEnum.AFTER_INSPECT_TYPE.getType());
                entitys.setCreatorTime(new Date());
                entitys.setCreatorUserId(userInfo.getUserId());
                this.rkAttachmentService.save(entitys);
            }
        }
        return true;
    }

    @Override
    public AfterSalesTelephoneTemplateEntity getTemplateId(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AfterSalesTaskInspectionTopicEntity::getInspectionId, (Object)id);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            AfterSalesTelephoneTemplateEntity info = this.afterSalesTelephoneTemplateService.getInfo(((AfterSalesTaskInspectionTopicEntity)list.get(0)).getTemplateId());
            return info;
        }
        return null;
    }
}

