/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.BeforeSaleSupportListUserEntity;
import com.bringspring.visit.mapper.BeforeSaleSupportListUserMapper;
import com.bringspring.visit.service.BeforeSaleSupportListUserService;
import com.bringspring.visit.utils.BeforeSupportEnableEnableEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BeforeSaleSupportListUserServiceImpl
extends ServiceImpl<BeforeSaleSupportListUserMapper, BeforeSaleSupportListUserEntity>
implements BeforeSaleSupportListUserService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserService userService;

    @Override
    public List<BeforeSaleSupportListUserEntity> getListByParentId(String parentId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BeforeSaleSupportListUserEntity::getBeforeSaleId, (Object)parentId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<BeforeSaleSupportListUserEntity> getListBySupportUserId(String supportUserId, String parentId, String inEnabledMark, String inSupportUserId, String noSupportUserId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StrUtil.isNotEmpty((CharSequence)supportUserId)) {
            queryWrapper.lambda().eq(BeforeSaleSupportListUserEntity::getSupportUserId, (Object)supportUserId);
        }
        queryWrapper.lambda().eq(BeforeSaleSupportListUserEntity::getBeforeSaleId, (Object)parentId);
        if (StrUtil.isNotEmpty((CharSequence)inEnabledMark)) {
            List enabledMark = JsonUtil.getJsonToList(Arrays.asList(inEnabledMark.split(",")), String.class);
            queryWrapper.lambda().in(BeforeSaleSupportListUserEntity::getEnabledMark, (Collection)enabledMark);
        }
        if (StrUtil.isNotEmpty((CharSequence)inSupportUserId)) {
            List inSupportUserList = JsonUtil.getJsonToList(Arrays.asList(inSupportUserId.split(",")), String.class);
            queryWrapper.lambda().in(BeforeSaleSupportListUserEntity::getSupportUserId, (Collection)inSupportUserList);
        }
        if (StrUtil.isNotEmpty((CharSequence)noSupportUserId)) {
            List noSupportUserList = JsonUtil.getJsonToList(Arrays.asList(noSupportUserId.split(",")), String.class);
            queryWrapper.lambda().notIn(BeforeSaleSupportListUserEntity::getSupportUserId, (Collection)noSupportUserList);
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void insertByCreate(String beforeSaleManager, String mainId, Long startTime, Long endTime) {
        UserInfo userInfo = this.userProvider.get();
        List<String> ids = Arrays.asList(beforeSaleManager.split(","));
        ArrayList<BeforeSaleSupportListUserEntity> resList = new ArrayList<BeforeSaleSupportListUserEntity>();
        for (String userId : ids) {
            BeforeSaleSupportListUserEntity entity = new BeforeSaleSupportListUserEntity();
            entity.setBeforeSaleId(mainId);
            entity.setCreatorUserId(userInfo.getUserId());
            entity.setEnabledMark(BeforeSupportEnableEnableEnum.IN_EXECUTION.getType());
            entity.setSupportUserId(userId);
            entity.setCompanyId(this.userService.getUserCompany(userId));
            entity.setSupportUserIdName(this.baseDataUtil.userSelectValue(userId));
            entity.setId(RandomUtil.uuId());
            entity.setStartTime((Date)DateUtil.date((long)startTime));
            entity.setEndTime((Date)DateUtil.date((long)endTime));
            resList.add(entity);
        }
        this.saveBatch(resList);
    }

    @Override
    public void insertByUpdate(String beforeSaleManager, String mainId, Date startTime, Date endTime) {
        UserInfo userInfo = this.userProvider.get();
        List<String> ids = Arrays.asList(beforeSaleManager.split(","));
        ArrayList<BeforeSaleSupportListUserEntity> resList = new ArrayList<BeforeSaleSupportListUserEntity>();
        List<BeforeSaleSupportListUserEntity> oldList = this.getListByParentId(mainId);
        for (String userId : ids) {
            BeforeSaleSupportListUserEntity entity = this.getSupportUserOne(mainId, userId);
            if (ObjectUtil.isNull((Object)entity)) {
                entity = new BeforeSaleSupportListUserEntity();
                entity.setId(RandomUtil.uuId());
                entity.setBeforeSaleId(mainId);
                entity.setCreatorUserId(userInfo.getUserId());
                entity.setEnabledMark(BeforeSupportEnableEnableEnum.IN_EXECUTION.getType());
                entity.setSupportUserId(userId);
                entity.setCompanyId(this.userService.getUserCompany(userId));
                entity.setSupportUserIdName(this.baseDataUtil.userSelectValue(userId));
                entity.setStartTime(startTime);
                entity.setEndTime(endTime);
            }
            resList.add(entity);
            oldList.removeIf(a -> a.getSupportUserId().equals(userId));
        }
        if (CollectionUtil.isNotEmpty(oldList)) {
            this.removeBatchByIds(oldList);
        }
        this.saveOrUpdateBatch(resList);
    }

    @Override
    public BeforeSaleSupportListUserEntity getSupportUserOne(String parentId, String supportUserId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BeforeSaleSupportListUserEntity::getSupportUserId, (Object)supportUserId);
        queryWrapper.lambda().eq(BeforeSaleSupportListUserEntity::getBeforeSaleId, (Object)parentId);
        return (BeforeSaleSupportListUserEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public boolean removeByParentId(String parentId) {
        List<BeforeSaleSupportListUserEntity> list = this.getListByParentId(parentId);
        return this.removeByIds(list);
    }
}

