/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.AfterSalesProjectsEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.service.AfterSalesProjectsService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.visit.entity.RkMarketLogEntity;
import com.bringspring.visit.entity.RkMarketLogProjectDataEntity;
import com.bringspring.visit.mapper.RkMarketLogMapper;
import com.bringspring.visit.mapper.RkMarketLogProjectDataMapper;
import com.bringspring.visit.model.rkMarketLog.RkMarketLogCrForm;
import com.bringspring.visit.model.rkMarketLog.RkMarketLogPagination;
import com.bringspring.visit.model.rkMarketLog.RkMrketLogProjectListVO;
import com.bringspring.visit.model.rkmarketlogprojectdata.RkMarketLogProjectDataCrForm;
import com.bringspring.visit.model.rkmarketlogprojectdata.RkMarketLogProjectDataUpForm;
import com.bringspring.visit.service.RkMarketLogProjectDataService;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkMarketLogProjectDataServiceImpl
extends ServiceImpl<RkMarketLogProjectDataMapper, RkMarketLogProjectDataEntity>
implements RkMarketLogProjectDataService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkMarketLogProjectDataService rkMarketLogProjectDataService;
    @Autowired
    private AfterSalesProjectsService afterSalesProjectsService;
    @Autowired
    private RkMarketLogProjectDataMapper rkMarketLogProjectDataMapper;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private RkMarketLogMapper rkMarketLogMapper;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public List<RkMarketLogProjectDataEntity> getList(RkMarketLogPagination rkMarketLogPagination) {
        Object rkMarketLogObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkMarketLogNum = 0;
        QueryWrapper rkMarketLogQueryWrapper = new QueryWrapper();
        rkMarketLogQueryWrapper.select(new String[]{"sum(man_hour) as manHour,project_code as projectCode", "creator_user_id as creatorUserId,type"});
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkMarketLogObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkMarketLogQueryWrapper, rkMarketLogPagination.getMenuId(), "rk_market_log_project_data"));
            if (ObjectUtil.isEmpty((Object)rkMarketLogObj)) {
                return new ArrayList<RkMarketLogProjectDataEntity>();
            }
            rkMarketLogQueryWrapper = (QueryWrapper)rkMarketLogObj;
            ++rkMarketLogNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkMarketLogObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkMarketLogQueryWrapper, rkMarketLogPagination.getMenuId(), "rk_market_log"));
            if (ObjectUtil.isEmpty((Object)rkMarketLogObj)) {
                return new ArrayList<RkMarketLogProjectDataEntity>();
            }
            rkMarketLogQueryWrapper = (QueryWrapper)rkMarketLogObj;
            ++rkMarketLogNum;
        }
        if (StringUtils.isNotEmpty((String)rkMarketLogPagination.getState())) {
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogProjectDataEntity::getState, (Object)rkMarketLogPagination.getState());
        }
        if (CollectionUtil.isNotEmpty(rkMarketLogPagination.getStateList())) {
            rkMarketLogQueryWrapper.lambda().in(RkMarketLogProjectDataEntity::getState, rkMarketLogPagination.getStateList());
        }
        if (StringUtils.isNotEmpty((String)rkMarketLogPagination.getType())) {
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogProjectDataEntity::getType, (Object)rkMarketLogPagination.getType());
        }
        if (StringUtils.isNotEmpty((String)rkMarketLogPagination.getCompanyId())) {
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogProjectDataEntity::getOrganizeId, (Object)rkMarketLogPagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)rkMarketLogPagination.getDepartment())) {
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogProjectDataEntity::getDepartmentId, (Object)rkMarketLogPagination.getDepartment());
        }
        if (!Strings.isBlank((String)rkMarketLogPagination.getCreatorUserId())) {
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogProjectDataEntity::getCreatorUserId, (Object)rkMarketLogPagination.getCreatorUserId());
        }
        if (rkMarketLogPagination.getStartTime() != null && rkMarketLogPagination.getStartTime().size() > 0) {
            rkMarketLogPagination.setStartTimes(new SimpleDateFormat("yyyy-MM-dd").format(new Date(rkMarketLogPagination.getStartTime().get(0))));
            rkMarketLogPagination.setEndTime(new SimpleDateFormat("yyyy-MM-dd").format(new Date(rkMarketLogPagination.getStartTime().get(1))));
            rkMarketLogQueryWrapper.lambda().between(RkMarketLogProjectDataEntity::getCreatorTime, (Object)rkMarketLogPagination.getStartTimes(), (Object)rkMarketLogPagination.getEndTime());
        }
        if (rkMarketLogPagination.getOptionDateSum() != null && rkMarketLogPagination.getOptionDateSum().size() > 0) {
            rkMarketLogPagination.setStartTimes2(new SimpleDateFormat("yyyy-MM-dd").format(new Date(rkMarketLogPagination.getOptionDateSum().get(0))));
            rkMarketLogPagination.setEndTime2(new SimpleDateFormat("yyyy-MM-dd").format(new Date(rkMarketLogPagination.getOptionDateSum().get(1))));
            rkMarketLogQueryWrapper.lambda().between(RkMarketLogProjectDataEntity::getOptionDate, (Object)rkMarketLogPagination.getStartTimes2(), (Object)rkMarketLogPagination.getEndTime2());
        }
        if (StringUtil.isNotEmpty((String)rkMarketLogPagination.getKeyword())) {
            ++rkMarketLogNum;
            rkMarketLogQueryWrapper.lambda().and(s -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)s.like(RkMarketLogProjectDataEntity::getProjectNameAll, (Object)rkMarketLogPagination.getKeyword())).or()).like(RkMarketLogProjectDataEntity::getProjectCode, (Object)rkMarketLogPagination.getKeyword());
            });
        }
        if (StringUtil.isNotEmpty((String)rkMarketLogPagination.getStartTimes()) && StringUtil.isNotEmpty((String)rkMarketLogPagination.getEndTime())) {
            ++rkMarketLogNum;
            rkMarketLogQueryWrapper.lambda().between(RkMarketLogProjectDataEntity::getCreatorTime, (Object)rkMarketLogPagination.getStartTimes(), (Object)rkMarketLogPagination.getEndTime());
        }
        if (AllIdList.size() > 0) {
            rkMarketLogQueryWrapper.lambda().in(RkMarketLogProjectDataEntity::getId, AllIdList);
        }
        rkMarketLogQueryWrapper.lambda().eq(RkMarketLogProjectDataEntity::getMarketType, (Object)0);
        rkMarketLogQueryWrapper.lambda().groupBy(RkMarketLogProjectDataEntity::getProjectCode, (Object[])new SFunction[]{RkMarketLogProjectDataEntity::getCreatorUserId, RkMarketLogProjectDataEntity::getType});
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkMarketLogPagination.getCurrentPage(), rkMarketLogPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkMarketLogQueryWrapper);
            return rkMarketLogPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkMarketLogPagination.setData(list, list.size());
    }

    @Override
    public List<RkMarketLogProjectDataEntity> getTypeList(RkMarketLogPagination rkMarketLogPagination, String dataType) {
        Object rkMarketLogObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkMarketLogNum = 0;
        QueryWrapper rkMarketLogQueryWrapper = new QueryWrapper();
        rkMarketLogQueryWrapper.select(new String[]{"sum(man_hour) as manHour,project_code as projectCode", "creator_user_id as creatorUserId,type"});
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkMarketLogObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkMarketLogQueryWrapper, rkMarketLogPagination.getMenuId(), "rk_market_log_project_data"));
            if (ObjectUtil.isEmpty((Object)rkMarketLogObj)) {
                return new ArrayList<RkMarketLogProjectDataEntity>();
            }
            rkMarketLogQueryWrapper = (QueryWrapper)rkMarketLogObj;
            ++rkMarketLogNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkMarketLogObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkMarketLogQueryWrapper, rkMarketLogPagination.getMenuId(), "rk_market_log"));
            if (ObjectUtil.isEmpty((Object)rkMarketLogObj)) {
                return new ArrayList<RkMarketLogProjectDataEntity>();
            }
            rkMarketLogQueryWrapper = (QueryWrapper)rkMarketLogObj;
            ++rkMarketLogNum;
        }
        if (StringUtils.isNotEmpty((String)rkMarketLogPagination.getState())) {
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogProjectDataEntity::getState, (Object)rkMarketLogPagination.getState());
        }
        if (CollectionUtil.isNotEmpty(rkMarketLogPagination.getStateList())) {
            rkMarketLogQueryWrapper.lambda().in(RkMarketLogProjectDataEntity::getState, rkMarketLogPagination.getStateList());
        }
        if (StringUtils.isNotEmpty((String)rkMarketLogPagination.getType())) {
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogProjectDataEntity::getType, (Object)rkMarketLogPagination.getType());
        }
        if (StringUtils.isNotEmpty((String)rkMarketLogPagination.getCompanyId())) {
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogProjectDataEntity::getOrganizeId, (Object)rkMarketLogPagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty((String)rkMarketLogPagination.getDepartment())) {
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogProjectDataEntity::getDepartmentId, (Object)rkMarketLogPagination.getDepartment());
        }
        if (!Strings.isBlank((String)rkMarketLogPagination.getCreatorUserId())) {
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogProjectDataEntity::getCreatorUserId, (Object)rkMarketLogPagination.getCreatorUserId());
        }
        if (rkMarketLogPagination.getStartTime() != null && rkMarketLogPagination.getStartTime().size() > 0) {
            rkMarketLogPagination.setStartTimes(new SimpleDateFormat("yyyy-MM-dd").format(new Date(rkMarketLogPagination.getStartTime().get(0))));
            rkMarketLogPagination.setEndTime(new SimpleDateFormat("yyyy-MM-dd").format(new Date(rkMarketLogPagination.getStartTime().get(1))));
            rkMarketLogQueryWrapper.lambda().between(RkMarketLogProjectDataEntity::getCreatorTime, (Object)rkMarketLogPagination.getStartTimes(), (Object)rkMarketLogPagination.getEndTime());
        }
        if (rkMarketLogPagination.getOptionDateSum() != null && rkMarketLogPagination.getOptionDateSum().size() > 0) {
            rkMarketLogPagination.setStartTimes2(new SimpleDateFormat("yyyy-MM-dd").format(new Date(rkMarketLogPagination.getOptionDateSum().get(0))));
            rkMarketLogPagination.setEndTime2(new SimpleDateFormat("yyyy-MM-dd").format(new Date(rkMarketLogPagination.getOptionDateSum().get(1))));
            rkMarketLogQueryWrapper.lambda().between(RkMarketLogProjectDataEntity::getOptionDate, (Object)rkMarketLogPagination.getStartTimes2(), (Object)rkMarketLogPagination.getEndTime2());
        }
        if (StringUtil.isNotEmpty((String)rkMarketLogPagination.getKeyword())) {
            ++rkMarketLogNum;
            rkMarketLogQueryWrapper.lambda().and(s -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)s.like(RkMarketLogProjectDataEntity::getProjectNameAll, (Object)rkMarketLogPagination.getKeyword())).or()).like(RkMarketLogProjectDataEntity::getProjectCode, (Object)rkMarketLogPagination.getKeyword());
            });
        }
        if (StringUtil.isNotEmpty((String)rkMarketLogPagination.getStartTimes()) && StringUtil.isNotEmpty((String)rkMarketLogPagination.getEndTime())) {
            ++rkMarketLogNum;
            rkMarketLogQueryWrapper.lambda().between(RkMarketLogProjectDataEntity::getCreatorTime, (Object)rkMarketLogPagination.getStartTimes(), (Object)rkMarketLogPagination.getEndTime());
        }
        if (AllIdList.size() > 0) {
            rkMarketLogQueryWrapper.lambda().in(RkMarketLogProjectDataEntity::getId, AllIdList);
        }
        rkMarketLogQueryWrapper.lambda().groupBy(RkMarketLogProjectDataEntity::getProjectCode, (Object[])new SFunction[]{RkMarketLogProjectDataEntity::getCreatorUserId, RkMarketLogProjectDataEntity::getType});
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkMarketLogPagination.getCurrentPage(), rkMarketLogPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkMarketLogQueryWrapper);
                return rkMarketLogPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkMarketLogPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkMarketLogQueryWrapper);
    }

    @Override
    public RkMarketLogProjectDataEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkMarketLogProjectDataEntity::getId, (Object)id);
        return (RkMarketLogProjectDataEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(String marketId, RkMarketLogCrForm rkMarketLogCrForm) {
        UserInfo userInfo = this.userProvider.get();
        if (CollectionUtil.isNotEmpty(rkMarketLogCrForm.getProjectLogDetaList())) {
            for (RkMrketLogProjectListVO vo : rkMarketLogCrForm.getProjectLogDetaList()) {
                String mainId = RandomUtil.uuId();
                RkMarketLogProjectDataCrForm form = new RkMarketLogProjectDataCrForm();
                form.setOptionDate(rkMarketLogCrForm.getOptionDate());
                form.setMarketLogId(marketId);
                form.setCustomerId(vo.getCustomerId());
                form.setCustomerName(vo.getCustomerName());
                form.setProjectId(vo.getRkContractProjectId());
                AfterSalesProjectsEntity info = this.afterSalesProjectsService.byProjectId(vo.getRkContractProjectId());
                if (ObjectUtil.isNotEmpty((Object)info)) {
                    form.setType(info.getWarrantyState());
                } else {
                    form.setType("inOperation");
                }
                RkContractProjectEntity projectEntity = this.rkContractProjectService.getInfo(vo.getRkContractProjectId());
                if (ObjectUtil.isNotEmpty((Object)projectEntity)) {
                    form.setProjectNameAll(projectEntity.getProjectName());
                    form.setProjectCode(projectEntity.getProjectCode());
                }
                form.setProjectName(vo.getRkContractProjectName());
                form.setManHour(vo.getManHour());
                form.setHumanDay(String.valueOf(vo.getWorkDay()));
                form.setOrganizeId(userInfo.getOrganizeId());
                form.setDepartmentId(userInfo.getDepartmentId());
                RkMarketLogProjectDataEntity entity = (RkMarketLogProjectDataEntity)JsonUtil.getJsonToBean((Object)form, RkMarketLogProjectDataEntity.class);
                entity.setContent(vo.getContent());
                entity.setWorkDay(vo.getWorkDay());
                entity.setState(rkMarketLogCrForm.getState());
                entity.setId(mainId);
                if (StrUtil.equals((CharSequence)rkMarketLogCrForm.getMarketType(), (CharSequence)"afterSale")) {
                    entity.setMarketType(0);
                } else {
                    entity.setMarketType(1);
                }
                this.save(entity);
            }
        }
    }

    @Override
    public void createAll() {
        LocalDateTime specifiedTime = LocalDateTime.of(2024, 10, 24, 22, 2);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().lt(RkMarketLogEntity::getCreatorTime, (Object)specifiedTime);
        queryWrapper.lambda().eq(RkMarketLogEntity::getMarketType, (Object)"afterSale");
        queryWrapper.lambda().eq(RkMarketLogEntity::getState, (Object)"1");
        queryWrapper.lambda().isNotNull(RkMarketLogEntity::getManHour);
        queryWrapper.lambda().isNull(RkMarketLogEntity::getNewProductId);
        List rkMarketLogEntities = this.rkMarketLogMapper.selectList((Wrapper)queryWrapper);
        for (RkMarketLogEntity vo : rkMarketLogEntities) {
            String mainId = RandomUtil.uuId();
            RkMarketLogProjectDataCrForm form = new RkMarketLogProjectDataCrForm();
            form.setMarketLogId(vo.getId());
            form.setCustomerId(vo.getCustomerId());
            CrmCustomerEntity customerEntity = this.crmCustomerService.getInfo(vo.getCustomerId());
            if (ObjectUtil.isNotEmpty((Object)customerEntity)) {
                form.setCustomerName(customerEntity.getName());
            }
            form.setProjectId(vo.getRkContractProjectId());
            AfterSalesProjectsEntity info = this.afterSalesProjectsService.byProjectId(vo.getRkContractProjectId());
            if (ObjectUtil.isNotEmpty((Object)info)) {
                form.setType(info.getWarrantyState());
            } else {
                form.setType("inOperation");
            }
            RkContractProjectEntity projectEntity = this.rkContractProjectService.getInfo(vo.getRkContractProjectId());
            if (ObjectUtil.isNotEmpty((Object)projectEntity)) {
                form.setProjectNameAll(projectEntity.getProjectName());
                form.setProjectCode(projectEntity.getProjectCode());
            } else {
                form.setProjectNameAll("\u5185\u90e8\u9879\u76ee");
            }
            form.setManHour(String.valueOf(vo.getManHour()));
            form.setOrganizeId(vo.getOrganizeId());
            form.setDepartmentId(vo.getDepartmentId());
            RkMarketLogProjectDataEntity entity = (RkMarketLogProjectDataEntity)JsonUtil.getJsonToBean((Object)form, RkMarketLogProjectDataEntity.class);
            entity.setCreatorTime(vo.getCreatorTime());
            entity.setCreatorUserId(vo.getCreatorUserId());
            entity.setLastModifyTime(vo.getLastModifyTime());
            entity.setLastModifyUserId(vo.getLastModifyUserId());
            entity.setId(mainId);
            entity.setMarketType(0);
            this.save(entity);
        }
    }

    @Override
    public void edit(String id, RkMarketLogProjectDataUpForm rkMarketLogProjectDataUpForm) {
        UserInfo userInfo = this.userProvider.get();
        RkMarketLogProjectDataEntity entity = this.rkMarketLogProjectDataService.getInfo(id);
        if (entity != null) {
            RkMarketLogProjectDataEntity subentity = (RkMarketLogProjectDataEntity)JsonUtil.getJsonToBean((Object)rkMarketLogProjectDataUpForm, RkMarketLogProjectDataEntity.class);
            this.updateById(subentity);
        }
    }

    @Override
    public void deleteBatchIds(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkMarketLogProjectDataEntity::getMarketLogId, (Object)id);
        List rkMrketLogRelevanceEntities = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)rkMrketLogRelevanceEntities)) {
            this.rkMarketLogProjectDataMapper.deleteBatchIds(rkMrketLogRelevanceEntities);
        }
    }

    @Override
    public void delete(RkMarketLogProjectDataEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public void deleteAll(String marketId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkMarketLogProjectDataEntity::getMarketLogId, (Object)marketId);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            this.rkMarketLogProjectDataMapper.deleteBatchIds(list);
        }
    }

    @Override
    public List<RkMarketLogProjectDataEntity> queryByMarketLogId(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkMarketLogProjectDataEntity::getMarketLogId, (Object)id);
        return this.list((Wrapper)queryWrapper);
    }
}

