/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.service.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.constant.MarketLogStateEnum;
import com.bringspring.contract.entity.AfterSalesProjectsEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkContractReturnPlanEntity;
import com.bringspring.contract.entity.RkReturnPlanFollowEntity;
import com.bringspring.contract.service.AfterSalesProjectsService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractReturnPlanService;
import com.bringspring.contract.service.RkReturnPlanFollowService;
import com.bringspring.crm.entity.CrmClueInfoEntity;
import com.bringspring.crm.entity.CrmClueTrendsEntity;
import com.bringspring.crm.entity.CrmProductRelationEntity;
import com.bringspring.crm.mapper.CrmProductRelationMapper;
import com.bringspring.crm.service.CrmClueInfoService;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.CustomizeSortWrapper;
import com.bringspring.visit.entity.RkMarketLogEntity;
import com.bringspring.visit.entity.RkMarketLogProjectDataEntity;
import com.bringspring.visit.entity.RkMrketLogRelevanceEntity;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.entity.RkProjectReportingStageTrendsEntity;
import com.bringspring.visit.entity.VisitFollowUpEntity;
import com.bringspring.visit.mapper.RkMarketLogMapper;
import com.bringspring.visit.mapper.VisitFollowUpMapper;
import com.bringspring.visit.model.RkMrketLogDetailCrForm;
import com.bringspring.visit.model.RkMrketLogDetailUpForm;
import com.bringspring.visit.model.RkMrketLogRelevanceListInfo;
import com.bringspring.visit.model.rkMarketLog.RkMarketLogCrForm;
import com.bringspring.visit.model.rkMarketLog.RkMarketLogListVO;
import com.bringspring.visit.model.rkMarketLog.RkMarketLogPagination;
import com.bringspring.visit.model.rkMarketLog.RkMarketLogUpForm;
import com.bringspring.visit.model.rkMarketLog.RkMrketLogProjectListVO;
import com.bringspring.visit.model.rkMarketLog.RkMrketLogRelevanceListVO;
import com.bringspring.visit.model.rkMarketLog.RkProjectHourStatisticsInfoVO;
import com.bringspring.visit.model.rkMarketLog.VisitFollowUpForm;
import com.bringspring.visit.service.RkMarketLogProjectDataService;
import com.bringspring.visit.service.RkMarketLogService;
import com.bringspring.visit.service.RkMrketLogDetailService;
import com.bringspring.visit.service.RkMrketLogRelevanceService;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.visit.utils.HolidayUtil;
import com.github.pagehelper.util.StringUtil;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Strings;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkMarketLogServiceImpl
extends ServiceImpl<RkMarketLogMapper, RkMarketLogEntity>
implements RkMarketLogService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private VisitFollowUpMapper visitFollowUpMapper;
    @Autowired
    private CrmProductRelationMapper crmProductRelationMapper;
    @Autowired
    private RkMarketLogService rkMarketLogService;
    @Autowired
    private RkMrketLogDetailService rkMrketLogDetailService;
    @Autowired
    private RkMrketLogRelevanceService rkMrketLogRelevanceService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private RkMarketLogMapper rkMarketLogMapper;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private CrmClueInfoService crmClueInfoService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private RkMarketLogProjectDataService rkMarketLogProjectDataService;
    @Autowired
    private AfterSalesProjectsService afterSalesProjectsService;
    @Autowired
    private RkReturnPlanFollowService rkReturnPlanFollowService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private RkContractReturnPlanService rkContractReturnPlanService;

    @Override
    public List<RkMarketLogEntity> getList(RkMarketLogPagination rkMarketLogPagination) {
        AfterSalesProjectsEntity info;
        Object rkMarketLogObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkMarketLogNum = 0;
        QueryWrapper rkMarketLogQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkMarketLogObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkMarketLogQueryWrapper, rkMarketLogPagination.getMenuId(), "rk_market_log"));
            if (ObjectUtil.isEmpty((Object)rkMarketLogObj)) {
                return new ArrayList<RkMarketLogEntity>();
            }
            rkMarketLogQueryWrapper = (QueryWrapper)rkMarketLogObj;
            ++rkMarketLogNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkMarketLogObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkMarketLogQueryWrapper, rkMarketLogPagination.getMenuId(), "rk_market_log"));
            if (ObjectUtil.isEmpty((Object)rkMarketLogObj)) {
                return new ArrayList<RkMarketLogEntity>();
            }
            rkMarketLogQueryWrapper = (QueryWrapper)rkMarketLogObj;
            ++rkMarketLogNum;
        }
        if (ObjectUtil.isNotEmpty((Object)(info = this.afterSalesProjectsService.getInfo(rkMarketLogPagination.getAfterSaleProjectId())))) {
            rkMarketLogPagination.setRkContractProjectId(info.getProjectId());
        }
        if (StringUtil.isNotEmpty((String)rkMarketLogPagination.getRkContractProjectId())) {
            ++rkMarketLogNum;
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogEntity::getRkContractProjectId, (Object)rkMarketLogPagination.getRkContractProjectId());
            rkMarketLogPagination.setMenuId("515156844830789317");
        }
        if (StringUtils.isNotEmpty((String)rkMarketLogPagination.getCompanyId())) {
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogEntity::getOrganizeId, (Object)rkMarketLogPagination.getCompanyId());
        }
        if (StringUtils.isNotEmpty(rkMarketLogPagination.getCreatorTime())) {
            List<String> CreatorTimeList = rkMarketLogPagination.getCreatorTime();
            Long fir = Long.valueOf(CreatorTimeList.get(0));
            Long sec = Long.valueOf(CreatorTimeList.get(1));
            ((LambdaQueryWrapper)rkMarketLogQueryWrapper.lambda().ge(RkMarketLogEntity::getOptionDate, (Object)new Date(fir))).le(RkMarketLogEntity::getOptionDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty((String)rkMarketLogPagination.getDepartment())) {
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogEntity::getDepartmentId, (Object)rkMarketLogPagination.getDepartment());
        }
        if (CollectionUtil.isNotEmpty(rkMarketLogPagination.getCompanyIdList())) {
            rkMarketLogQueryWrapper.lambda().in(RkMarketLogEntity::getOrganizeId, rkMarketLogPagination.getCompanyIdList());
        }
        if (StringUtils.isNotEmpty((String)rkMarketLogPagination.getIsAutomatic())) {
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogEntity::getIsAutomatic, (Object)rkMarketLogPagination.getIsAutomatic());
        }
        rkMarketLogQueryWrapper.lambda().eq(RkMarketLogEntity::getMarketType, (Object)rkMarketLogPagination.getMarketType());
        if (!Strings.isBlank((String)rkMarketLogPagination.getIsDraft())) {
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogEntity::getState, (Object)rkMarketLogPagination.getIsDraft());
        }
        if (!Strings.isBlank((String)rkMarketLogPagination.getCreatorUserId())) {
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogEntity::getCreatorUserId, (Object)rkMarketLogPagination.getCreatorUserId());
        }
        if (rkMarketLogPagination.getStartTime() != null && rkMarketLogPagination.getStartTime().size() > 0) {
            rkMarketLogPagination.setStartTimes(new SimpleDateFormat("yyyy-MM-dd").format(new Date(rkMarketLogPagination.getStartTime().get(0))));
            rkMarketLogPagination.setEndTime(new SimpleDateFormat("yyyy-MM-dd").format(new Date(rkMarketLogPagination.getStartTime().get(1))));
            rkMarketLogQueryWrapper.lambda().between(RkMarketLogEntity::getCreatorTime, (Object)rkMarketLogPagination.getStartTimes(), (Object)rkMarketLogPagination.getEndTime());
        }
        if (rkMarketLogPagination.getOptionDateSum() != null && rkMarketLogPagination.getOptionDateSum().size() > 0) {
            rkMarketLogPagination.setStartTimesOption(new SimpleDateFormat("yyyy-MM-dd").format(new Date(rkMarketLogPagination.getOptionDateSum().get(0))));
            rkMarketLogPagination.setEndTimeOption(new SimpleDateFormat("yyyy-MM-dd").format(new Date(rkMarketLogPagination.getOptionDateSum().get(1))));
            rkMarketLogQueryWrapper.lambda().between(RkMarketLogEntity::getOptionDate, (Object)rkMarketLogPagination.getStartTimesOption(), (Object)rkMarketLogPagination.getEndTimeOption());
        }
        if (StringUtil.isNotEmpty((String)rkMarketLogPagination.getCustomerId())) {
            ++rkMarketLogNum;
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogEntity::getCustomerId, (Object)rkMarketLogPagination.getCustomerId());
        }
        if (StringUtil.isNotEmpty((String)rkMarketLogPagination.getProjectCode())) {
            ++rkMarketLogNum;
            QueryWrapper projectDataQuery = new QueryWrapper();
            projectDataQuery.lambda().like(RkMarketLogProjectDataEntity::getProjectCode, (Object)rkMarketLogPagination.getProjectCode().replaceAll("\\s", ""));
            List list = this.rkMarketLogProjectDataService.list((Wrapper)projectDataQuery);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                List collect = list.stream().map(RkMarketLogProjectDataEntity::getMarketLogId).collect(Collectors.toList());
                rkMarketLogQueryWrapper.lambda().in(RkMarketLogEntity::getId, collect);
            } else {
                rkMarketLogQueryWrapper.lambda().in(RkMarketLogEntity::getId, new Object[]{""});
            }
        }
        if (ObjectUtil.isNotEmpty((Object)rkMarketLogPagination.getOptionDate())) {
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogEntity::getOptionDate, (Object)new SimpleDateFormat("yyyy-MM-dd").format(new Date(rkMarketLogPagination.getOptionDate())));
        }
        if (StringUtil.isNotEmpty((String)rkMarketLogPagination.getTitle())) {
            ++rkMarketLogNum;
            rkMarketLogQueryWrapper.lambda().like(RkMarketLogEntity::getTitle, (Object)rkMarketLogPagination.getTitle().replaceAll("\\s", ""));
        }
        if (StringUtil.isNotEmpty((String)rkMarketLogPagination.getStartTimes()) && StringUtil.isNotEmpty((String)rkMarketLogPagination.getEndTime())) {
            ++rkMarketLogNum;
            rkMarketLogQueryWrapper.lambda().between(RkMarketLogEntity::getCreatorTime, (Object)rkMarketLogPagination.getStartTimes(), (Object)rkMarketLogPagination.getEndTime());
        }
        if (StringUtil.isNotEmpty((String)rkMarketLogPagination.getType())) {
            ++rkMarketLogNum;
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogEntity::getLogType, (Object)rkMarketLogPagination.getType());
        }
        if (StringUtil.isNotEmpty((String)rkMarketLogPagination.getState())) {
            ++rkMarketLogNum;
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogEntity::getState, (Object)rkMarketLogPagination.getState());
        }
        if (AllIdList.size() > 0) {
            rkMarketLogQueryWrapper.lambda().in(RkMarketLogEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)rkMarketLogPagination.getSidx())) {
            rkMarketLogQueryWrapper.lambda().orderByDesc(RkMarketLogEntity::getId);
        } else {
            try {
                QueryWrapper customSortWrapper = CustomizeSortWrapper.appendWrapper(rkMarketLogPagination, new RkMarketLogListVO(), rkMarketLogQueryWrapper);
                if (ObjectUtil.isNull((Object)customSortWrapper)) {
                    String sidx = rkMarketLogPagination.getSidx();
                    RkMarketLogEntity rkMarketLogEntity = new RkMarketLogEntity();
                    Field declaredField = rkMarketLogEntity.getClass().getDeclaredField(sidx);
                    declaredField.setAccessible(true);
                    String value = declaredField.getAnnotation(TableField.class).value();
                    rkMarketLogQueryWrapper = "asc".equals(rkMarketLogPagination.getSort().toLowerCase()) ? (QueryWrapper)rkMarketLogQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkMarketLogQueryWrapper.orderByDesc((Object)value);
                } else {
                    rkMarketLogQueryWrapper = customSortWrapper;
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkMarketLogPagination.getCurrentPage(), rkMarketLogPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkMarketLogQueryWrapper);
            return rkMarketLogPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkMarketLogPagination.setData(list, list.size());
    }

    @Override
    public List<RkMarketLogEntity> getTypeList(RkMarketLogPagination rkMarketLogPagination, String dataType) {
        Object rkMarketLogObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkMarketLogNum = 0;
        QueryWrapper rkMarketLogQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkMarketLogObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkMarketLogQueryWrapper, rkMarketLogPagination.getMenuId(), "rkMarketLog"));
            if (ObjectUtil.isEmpty((Object)rkMarketLogObj)) {
                return new ArrayList<RkMarketLogEntity>();
            }
            rkMarketLogQueryWrapper = (QueryWrapper)rkMarketLogObj;
            ++rkMarketLogNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkMarketLogObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkMarketLogQueryWrapper, rkMarketLogPagination.getMenuId(), "rkMarketLog"));
            if (ObjectUtil.isEmpty((Object)rkMarketLogObj)) {
                return new ArrayList<RkMarketLogEntity>();
            }
            rkMarketLogQueryWrapper = (QueryWrapper)rkMarketLogObj;
            ++rkMarketLogNum;
        }
        if (StringUtils.isNotEmpty((String)rkMarketLogPagination.getCompanyId())) {
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogEntity::getOrganizeId, (Object)rkMarketLogPagination.getCompanyId());
        }
        rkMarketLogQueryWrapper.lambda().eq(RkMarketLogEntity::getMarketType, (Object)rkMarketLogPagination.getMarketType());
        if (!Strings.isBlank((String)rkMarketLogPagination.getIsDraft())) {
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogEntity::getState, (Object)rkMarketLogPagination.getIsDraft());
        }
        if (!Strings.isBlank((String)rkMarketLogPagination.getCreatorUserId())) {
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogEntity::getCreatorUserId, (Object)rkMarketLogPagination.getCreatorUserId());
        }
        if (rkMarketLogPagination.getStartTime() != null && rkMarketLogPagination.getStartTime().size() > 0) {
            rkMarketLogPagination.setStartTimes(new SimpleDateFormat("yyyy-MM-dd").format(new Date(rkMarketLogPagination.getStartTime().get(0))));
            rkMarketLogPagination.setEndTime(new SimpleDateFormat("yyyy-MM-dd").format(new Date(rkMarketLogPagination.getStartTime().get(1))));
            rkMarketLogQueryWrapper.lambda().between(RkMarketLogEntity::getCreatorTime, (Object)rkMarketLogPagination.getStartTimes(), (Object)rkMarketLogPagination.getEndTime());
        }
        if (rkMarketLogPagination.getOptionDateSum() != null && rkMarketLogPagination.getOptionDateSum().size() > 0) {
            rkMarketLogPagination.setStartTimesOption(new SimpleDateFormat("yyyy-MM-dd").format(new Date(rkMarketLogPagination.getOptionDateSum().get(0))));
            rkMarketLogPagination.setEndTimeOption(new SimpleDateFormat("yyyy-MM-dd").format(new Date(rkMarketLogPagination.getOptionDateSum().get(1))));
            rkMarketLogQueryWrapper.lambda().between(RkMarketLogEntity::getOptionDate, (Object)rkMarketLogPagination.getStartTimesOption(), (Object)rkMarketLogPagination.getEndTimeOption());
        }
        if (StringUtil.isNotEmpty((String)rkMarketLogPagination.getCustomerId())) {
            ++rkMarketLogNum;
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogEntity::getCustomerId, (Object)rkMarketLogPagination.getCustomerId());
        }
        if (StringUtil.isNotEmpty((String)rkMarketLogPagination.getProjectCode())) {
            ++rkMarketLogNum;
            QueryWrapper projectDataQuery = new QueryWrapper();
            projectDataQuery.lambda().like(RkMarketLogProjectDataEntity::getProjectCode, (Object)rkMarketLogPagination.getProjectCode());
            List list = this.rkMarketLogProjectDataService.list((Wrapper)projectDataQuery);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                List collect = list.stream().map(RkMarketLogProjectDataEntity::getMarketLogId).collect(Collectors.toList());
                rkMarketLogQueryWrapper.lambda().in(RkMarketLogEntity::getId, collect);
            } else {
                rkMarketLogQueryWrapper.lambda().in(RkMarketLogEntity::getId, new Object[]{""});
            }
        }
        if (StringUtil.isNotEmpty((String)rkMarketLogPagination.getTitle())) {
            ++rkMarketLogNum;
            rkMarketLogQueryWrapper.lambda().like(RkMarketLogEntity::getTitle, (Object)rkMarketLogPagination.getTitle());
        }
        if (StringUtil.isNotEmpty((String)rkMarketLogPagination.getType())) {
            ++rkMarketLogNum;
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogEntity::getLogType, (Object)rkMarketLogPagination.getType());
        }
        if (AllIdList.size() > 0) {
            rkMarketLogQueryWrapper.lambda().in(RkMarketLogEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)rkMarketLogPagination.getSidx())) {
            rkMarketLogQueryWrapper.lambda().orderByDesc(RkMarketLogEntity::getId);
        } else {
            try {
                String sidx = rkMarketLogPagination.getSidx();
                RkMarketLogEntity rkMarketLogEntity = new RkMarketLogEntity();
                Field declaredField = rkMarketLogEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkMarketLogQueryWrapper = "asc".equals(rkMarketLogPagination.getSort().toLowerCase()) ? (QueryWrapper)rkMarketLogQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkMarketLogQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkMarketLogPagination.getCurrentPage(), rkMarketLogPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkMarketLogQueryWrapper);
                return rkMarketLogPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkMarketLogPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkMarketLogQueryWrapper);
    }

    @Override
    public List<RkMarketLogEntity> getDateTime() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkMarketLogEntity::getMarketType, (Object)"afterSale");
        queryWrapper.lambda().between(RkMarketLogEntity::getCreatorTime, (Object)HolidayUtil.getDayBegin(), (Object)HolidayUtil.getDayEnd());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public RkMarketLogEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkMarketLogEntity::getId, (Object)id);
        return (RkMarketLogEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkMarketLogEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, RkMarketLogEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public List<VisitFollowUpEntity> getVisitInfo(VisitFollowUpForm visitFollowUpForm) {
        QueryWrapper visitFollowUpQueryWrapper = new QueryWrapper();
        if (Objects.nonNull(visitFollowUpForm.getProductName())) {
            visitFollowUpQueryWrapper.lambda().like(VisitFollowUpEntity::getCustomerName, (Object)visitFollowUpForm.getProductName());
        }
        visitFollowUpQueryWrapper.lambda().eq(VisitFollowUpEntity::getCreatorUserId, (Object)visitFollowUpForm.getId());
        LocalDate now = LocalDate.now();
        LocalDate thirtyDaysAgo = now.minus(30L, ChronoUnit.DAYS);
        visitFollowUpQueryWrapper.lambda().ge(VisitFollowUpEntity::getCreatorTime, (Object)thirtyDaysAgo.atStartOfDay());
        visitFollowUpQueryWrapper.lambda().lt(VisitFollowUpEntity::getCreatorTime, (Object)now.atStartOfDay());
        visitFollowUpQueryWrapper.lambda().orderByDesc(VisitFollowUpEntity::getCreatorTime);
        Page page = new Page(visitFollowUpForm.getCurrentPage(), visitFollowUpForm.getPageSize());
        IPage iPage = this.visitFollowUpMapper.selectPage((IPage)page, (Wrapper)visitFollowUpQueryWrapper);
        return visitFollowUpForm.setData(iPage.getRecords(), iPage.getTotal());
    }

    @Override
    public List<CrmProductRelationEntity> getProjectInfo(String id) {
        UserInfo userInfo = this.userProvider.get();
        return this.crmProductRelationMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(CrmProductRelationEntity::getCustomerId, (Object)id));
    }

    @Override
    public Boolean insert(RkMarketLogCrForm rkMarketLogCrForm) throws Exception {
        RkContractProjectEntity info;
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        RkMarketLogEntity entity = (RkMarketLogEntity)JsonUtil.getJsonToBean((Object)rkMarketLogCrForm, RkMarketLogEntity.class);
        entity.setId(mainId);
        entity.setLogUserId(userInfo.getUserId());
        entity.setOrganizeId(userInfo.getOrganizeId());
        entity.setDepartmentId(userInfo.getDepartmentId());
        entity.setCreatorUserName(userInfo.getUserName());
        if (StrUtil.isNotBlank((CharSequence)entity.getRkContractProjectId()) && ObjectUtil.isNotNull((Object)(info = this.rkContractProjectService.getInfo(entity.getRkContractProjectId())))) {
            entity.setRegionalHead(info.getRegionalHead());
            entity.setProjectHeader(info.getProjectHeader());
        }
        if (CollectionUtil.isNotEmpty(rkMarketLogCrForm.getStartAllTime())) {
            entity.setStartTime(new Date(rkMarketLogCrForm.getStartAllTime().get(0)));
            entity.setEndTime(new Date(rkMarketLogCrForm.getStartAllTime().get(1)));
        }
        if (rkMarketLogCrForm.getMarketType().equals("afterSale") || rkMarketLogCrForm.getMarketType().equals("newAfterSale")) {
            this.rkMarketLogProjectDataService.create(mainId, rkMarketLogCrForm);
            if (CollectionUtil.isNotEmpty(rkMarketLogCrForm.getProjectLogDetaList())) {
                entity.setCustomerId(String.join((CharSequence)",", rkMarketLogCrForm.getProjectLogDetaList().stream().filter(s -> s.getCustomerId() != null).map(RkMrketLogProjectListVO::getCustomerId).collect(Collectors.toList())));
                List projectIds = rkMarketLogCrForm.getProjectLogDetaList().stream().map(RkMrketLogProjectListVO::getRkContractProjectId).collect(Collectors.toList());
                entity.setManHourMore(String.join((CharSequence)",", rkMarketLogCrForm.getProjectLogDetaList().stream().map(RkMrketLogProjectListVO::getManHour).collect(Collectors.toList())));
                entity.setRkContractProjectId(String.join((CharSequence)",", projectIds));
                if (!StrUtil.equals((CharSequence)rkMarketLogCrForm.getRkContractProjectId(), (CharSequence)"\u5185\u90e8\u9879\u76ee")) {
                    ArrayList<String> regionalHeadList = new ArrayList<String>();
                    ArrayList<String> projectHeaderList = new ArrayList<String>();
                    for (String id : projectIds) {
                        RkContractProjectEntity info2 = this.rkContractProjectService.getInfo(id);
                        if (StringUtils.isNotEmpty((String)info2.getRegionalHead())) {
                            regionalHeadList.add(info2.getRegionalHead());
                        }
                        if (!StringUtils.isNotEmpty((String)info2.getProjectHeader())) continue;
                        projectHeaderList.add(info2.getProjectHeader());
                    }
                    entity.setRegionalHead(String.join((CharSequence)",", regionalHeadList.stream().distinct().collect(Collectors.toList())));
                    entity.setProjectHeader(String.join((CharSequence)",", projectHeaderList.stream().distinct().collect(Collectors.toList())));
                }
            }
        }
        boolean save = this.rkMarketLogService.save(entity);
        if (rkMarketLogCrForm.getMarketType().equals("sale") || rkMarketLogCrForm.getMarketType().equals("mjWorkerLog")) {
            if (CollectionUtil.isNotEmpty(rkMarketLogCrForm.getMrketLogDetailList())) {
                for (RkMrketLogDetailCrForm form : rkMarketLogCrForm.getMrketLogDetailList()) {
                    form.setMarketId(mainId);
                    this.rkMrketLogDetailService.create(form);
                }
            }
            if (CollectionUtil.isNotEmpty(rkMarketLogCrForm.getRelevanceListInfo())) {
                for (RkMrketLogRelevanceListVO vo : rkMarketLogCrForm.getRelevanceListInfo()) {
                    RkMrketLogRelevanceEntity jsonToBean = (RkMrketLogRelevanceEntity)JsonUtil.getJsonToBean((Object)vo, RkMrketLogRelevanceEntity.class);
                    jsonToBean.setMarketId(mainId);
                    this.rkMrketLogRelevanceService.create(jsonToBean);
                }
            }
        }
        return save;
    }

    @Override
    public Boolean updateMarket(String id, RkMarketLogUpForm rkMarketLogUpForm) {
        UserInfo userInfo = this.userProvider.get();
        RkMarketLogEntity entity = this.rkMarketLogService.getInfo(id);
        String type = "";
        type = entity.getMarketType().equals("sale") ? this.baseDataUtil.getDictName(entity.getLogType(), "marketLogType") : this.baseDataUtil.getDictName(entity.getLogType(), "deliveryLogType");
        if (entity != null) {
            RkMarketLogEntity subentity = (RkMarketLogEntity)JsonUtil.getJsonToBean((Object)rkMarketLogUpForm, RkMarketLogEntity.class);
            RkContractProjectEntity info = this.rkContractProjectService.getInfo(subentity.getRkContractProjectId());
            if (ObjectUtil.isNotEmpty((Object)info)) {
                subentity.setRegionalHead(info.getRegionalHead());
                subentity.setProjectHeader(info.getProjectHeader());
            }
            if (CollectionUtil.isNotEmpty(rkMarketLogUpForm.getStartAllTime())) {
                subentity.setStartTime(new Date(rkMarketLogUpForm.getStartAllTime().get(0)));
                subentity.setEndTime(new Date(rkMarketLogUpForm.getStartAllTime().get(1)));
            }
            if (rkMarketLogUpForm.getMarketType().equals("afterSale") || rkMarketLogUpForm.getMarketType().equals("newAfterSale")) {
                this.rkMarketLogProjectDataService.deleteAll(id);
                RkMarketLogCrForm crForm = (RkMarketLogCrForm)JsonUtil.getJsonToBean((Object)rkMarketLogUpForm, RkMarketLogCrForm.class);
                this.rkMarketLogProjectDataService.create(id, crForm);
                if (CollectionUtil.isNotEmpty(rkMarketLogUpForm.getProjectLogDetaList())) {
                    subentity.setCustomerId(String.join((CharSequence)",", rkMarketLogUpForm.getProjectLogDetaList().stream().filter(s -> s.getCustomerId() != null).map(RkMrketLogProjectListVO::getCustomerId).collect(Collectors.toList())));
                    List projectIds = rkMarketLogUpForm.getProjectLogDetaList().stream().map(RkMrketLogProjectListVO::getRkContractProjectId).collect(Collectors.toList());
                    subentity.setRkContractProjectId(String.join((CharSequence)",", projectIds));
                    subentity.setManHourMore(String.join((CharSequence)",", rkMarketLogUpForm.getProjectLogDetaList().stream().map(RkMrketLogProjectListVO::getManHour).collect(Collectors.toList())));
                    if (!StrUtil.equals((CharSequence)rkMarketLogUpForm.getRkContractProjectId(), (CharSequence)"\u5185\u90e8\u9879\u76ee")) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        ArrayList<String> projectHeaderList = new ArrayList<String>();
                        for (String projectId : projectIds) {
                            RkContractProjectEntity projectEntity = this.rkContractProjectService.getInfo(projectId);
                            if (StringUtils.isNotEmpty((String)projectEntity.getRegionalHead())) {
                                arrayList.add(projectEntity.getRegionalHead());
                            }
                            if (!StringUtils.isNotEmpty((String)projectEntity.getProjectHeader())) continue;
                            projectHeaderList.add(projectEntity.getProjectHeader());
                        }
                        subentity.setRegionalHead(String.join((CharSequence)",", arrayList.stream().distinct().collect(Collectors.toList())));
                        subentity.setProjectHeader(String.join((CharSequence)",", projectHeaderList.stream().distinct().collect(Collectors.toList())));
                    }
                }
            }
            boolean update = this.rkMarketLogService.update(id, subentity);
            if (entity.getMarketType().equals("mjWorkerLog") && CollectionUtil.isNotEmpty(rkMarketLogUpForm.getMrketLogDetailList())) {
                for (RkMrketLogDetailUpForm rkMrketLogDetailUpForm : rkMarketLogUpForm.getMrketLogDetailList()) {
                    this.rkMrketLogDetailService.update(rkMrketLogDetailUpForm.getId(), rkMrketLogDetailUpForm, id);
                }
            }
            if (entity.getMarketType().equals("sale")) {
                if (CollectionUtil.isNotEmpty(rkMarketLogUpForm.getMrketLogDetailList())) {
                    for (RkMrketLogDetailUpForm rkMrketLogDetailUpForm : rkMarketLogUpForm.getMrketLogDetailList()) {
                        this.rkMrketLogDetailService.update(rkMrketLogDetailUpForm.getId(), rkMrketLogDetailUpForm, id);
                    }
                }
                if (CollectionUtil.isNotEmpty(rkMarketLogUpForm.getRelevanceListInfo())) {
                    this.rkMrketLogRelevanceService.deleteBatchIds(id);
                    for (RkMrketLogRelevanceListVO rkMrketLogRelevanceListVO : rkMarketLogUpForm.getRelevanceListInfo()) {
                        RkMrketLogRelevanceEntity jsonToBean = (RkMrketLogRelevanceEntity)JsonUtil.getJsonToBean((Object)rkMrketLogRelevanceListVO, RkMrketLogRelevanceEntity.class);
                        jsonToBean.setMarketId(id);
                        this.rkMrketLogRelevanceService.create(jsonToBean);
                    }
                } else {
                    this.rkMrketLogRelevanceService.deleteBatchIds(id);
                }
            }
            return update;
        }
        return null;
    }

    @Override
    public List<RkProjectHourStatisticsInfoVO> selectProjectHourStatisticsList(RkMarketLogPagination rkMarketLogPagination) {
        boolean total = false;
        String yearMonth = rkMarketLogPagination.getYearMonth();
        if (StringUtil.isNotEmpty((String)yearMonth)) {
            rkMarketLogPagination.setYearMonth(yearMonth.substring(0, 7));
        } else {
            rkMarketLogPagination.setYearMonth(DateUtil.getNow().substring(0, 7));
        }
        UserInfo userInfo = this.userProvider.get();
        List<RkProjectHourStatisticsInfoVO> selfList = this.rkMarketLogMapper.selectProjectHourSelfAggregateList(rkMarketLogPagination);
        List<RkProjectHourStatisticsInfoVO> selfDetaliList = this.rkMarketLogMapper.selectProjectHourDetailStatisticsList(rkMarketLogPagination);
        for (RkProjectHourStatisticsInfoVO vo : selfList) {
            vo.setId(RandomUtil.uuId());
            ArrayList<RkProjectHourStatisticsInfoVO> addDetail = new ArrayList<RkProjectHourStatisticsInfoVO>();
            for (RkProjectHourStatisticsInfoVO detail : selfDetaliList) {
                detail.setId(RandomUtil.uuId());
                if (!vo.getUserName().equals(detail.getUserName())) continue;
                addDetail.add(detail);
            }
            vo.setChildren(addDetail);
        }
        List<RkProjectHourStatisticsInfoVO> listSum = this.rkMarketLogMapper.selectProjectHourStatisticsAggregateList(rkMarketLogPagination);
        selfList.addAll(listSum);
        return selfList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadVO exportProjectHourStatistics(RkMarketLogPagination rkMarketLogPagination) {
        String yearMonth = rkMarketLogPagination.getYearMonth();
        if (StringUtil.isNotEmpty((String)yearMonth)) {
            rkMarketLogPagination.setYearMonth(yearMonth.substring(0, 7));
        } else {
            rkMarketLogPagination.setYearMonth(DateUtil.getNow().substring(0, 7));
        }
        List<RkProjectHourStatisticsInfoVO> selfList = this.rkMarketLogMapper.selectProjectHourSelfAggregateList(rkMarketLogPagination);
        List<RkProjectHourStatisticsInfoVO> selfDetaliList = this.rkMarketLogMapper.selectProjectHourDetailStatisticsList(rkMarketLogPagination);
        selfList.addAll(selfDetaliList);
        selfList = selfList.stream().sorted(Comparator.comparing(RkProjectHourStatisticsInfoVO::getUserName).thenComparing(RkProjectHourStatisticsInfoVO::getOrderNum)).collect(Collectors.toList());
        List<RkProjectHourStatisticsInfoVO> listSum = this.rkMarketLogMapper.selectProjectHourStatisticsAggregateList(rkMarketLogPagination);
        selfList.addAll(listSum);
        String tableName = "\u552e\u540e\u4eba\u5458\u5de5\u65f6\u660e\u7ec6_";
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        entitys.add(new ExcelExportEntity("\u516c\u53f8", (Object)"companyName"));
        entitys.add(new ExcelExportEntity("\u90e8\u95e8", (Object)"deptName"));
        entitys.add(new ExcelExportEntity("\u59d3\u540d", (Object)"userName"));
        entitys.add(new ExcelExportEntity("\u7c7b\u578b", (Object)"logType"));
        entitys.add(new ExcelExportEntity("01", (Object)"day1"));
        entitys.add(new ExcelExportEntity("02", (Object)"day2"));
        entitys.add(new ExcelExportEntity("03", (Object)"day3"));
        entitys.add(new ExcelExportEntity("04", (Object)"day4"));
        entitys.add(new ExcelExportEntity("05", (Object)"day5"));
        entitys.add(new ExcelExportEntity("06", (Object)"day6"));
        entitys.add(new ExcelExportEntity("07", (Object)"day7"));
        entitys.add(new ExcelExportEntity("08", (Object)"day8"));
        entitys.add(new ExcelExportEntity("09", (Object)"day9"));
        entitys.add(new ExcelExportEntity("10", (Object)"day10"));
        entitys.add(new ExcelExportEntity("11", (Object)"day11"));
        entitys.add(new ExcelExportEntity("12", (Object)"day12"));
        entitys.add(new ExcelExportEntity("13", (Object)"day13"));
        entitys.add(new ExcelExportEntity("14", (Object)"day14"));
        entitys.add(new ExcelExportEntity("15", (Object)"day15"));
        entitys.add(new ExcelExportEntity("16", (Object)"day16"));
        entitys.add(new ExcelExportEntity("17", (Object)"day17"));
        entitys.add(new ExcelExportEntity("18", (Object)"day18"));
        entitys.add(new ExcelExportEntity("19", (Object)"day19"));
        entitys.add(new ExcelExportEntity("20", (Object)"day20"));
        entitys.add(new ExcelExportEntity("21", (Object)"day21"));
        entitys.add(new ExcelExportEntity("22", (Object)"day22"));
        entitys.add(new ExcelExportEntity("23", (Object)"day23"));
        entitys.add(new ExcelExportEntity("24", (Object)"day24"));
        entitys.add(new ExcelExportEntity("25", (Object)"day25"));
        entitys.add(new ExcelExportEntity("26", (Object)"day26"));
        entitys.add(new ExcelExportEntity("27", (Object)"day27"));
        entitys.add(new ExcelExportEntity("28", (Object)"day28"));
        entitys.add(new ExcelExportEntity("29", (Object)"day29"));
        entitys.add(new ExcelExportEntity("30", (Object)"day30"));
        entitys.add(new ExcelExportEntity("31", (Object)"day31"));
        entitys.add(new ExcelExportEntity("\u603b\u5de5\u65f6(\u5c0f\u65f6)", (Object)"aggregate"));
        List list = JsonUtil.listToJsonField((List)JsonUtil.getJsonToList(selfList, RkProjectHourStatisticsInfoVO.class));
        DownloadVO vo = DownloadVO.builder().build();
        ExportParams exportParams = new ExportParams(null, tableName);
        exportParams.setType(ExcelType.XSSF);
        try {
            UserInfo userInfo = this.userProvider.get();
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, (Collection)list);
                }
                String name = tableName + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u552e\u540e\u5de5\u65f6\u660e\u7ec6\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}" + e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @Override
    public long countByProjectId(String projectId) {
        Object rkMarketLogObj;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!this.userProvider.get().getIsAdministrator().booleanValue() && ObjectUtil.isNotEmpty((Object)(rkMarketLogObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, "515156844830789317", "rk_market_log"))))) {
            queryWrapper = (QueryWrapper)rkMarketLogObj;
        }
        queryWrapper.lambda().eq(RkMarketLogEntity::getRkContractProjectId, (Object)projectId);
        queryWrapper.lambda().eq(RkMarketLogEntity::getState, (Object)"1");
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public List<VisitFollowUpEntity> getVisitDateInfo(VisitFollowUpForm visitFollowUpForm) {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper visitFollowUpQueryWrapper = new QueryWrapper();
        if (Objects.nonNull(visitFollowUpForm.getId())) {
            visitFollowUpQueryWrapper.lambda().eq(VisitFollowUpEntity::getCreatorUserId, (Object)visitFollowUpForm.getId());
        } else {
            visitFollowUpQueryWrapper.lambda().eq(VisitFollowUpEntity::getCreatorUserId, (Object)userInfo.getUserId());
        }
        if (visitFollowUpForm.getLogType().equals("519482164182535109")) {
            visitFollowUpQueryWrapper.lambda().between(VisitFollowUpEntity::getCreatorTime, (Object)HolidayUtil.getBeginDayOfWeek(visitFollowUpForm.getOptionDate()), (Object)HolidayUtil.getEndDayOfWeek(visitFollowUpForm.getOptionDate()));
        } else if (visitFollowUpForm.getStartTime() != null && visitFollowUpForm.getStartTime().size() > 0) {
            visitFollowUpForm.setStartTimes(new SimpleDateFormat("yyyy-MM-dd").format(new Date(visitFollowUpForm.getStartTime().get(0))));
            visitFollowUpForm.setEndTime(new SimpleDateFormat("yyyy-MM-dd").format(new Date(visitFollowUpForm.getStartTime().get(1) + 86400000L)));
            visitFollowUpQueryWrapper.lambda().between(VisitFollowUpEntity::getCreatorTime, (Object)visitFollowUpForm.getStartTimes(), (Object)visitFollowUpForm.getEndTime());
        } else {
            visitFollowUpQueryWrapper.lambda().in(VisitFollowUpEntity::getId, new Object[]{""});
        }
        List visitFollowUpEntities = this.visitFollowUpMapper.selectList((Wrapper)visitFollowUpQueryWrapper);
        return visitFollowUpEntities;
    }

    @Override
    public RkMrketLogRelevanceListInfo getRelevanceData(List<VisitFollowUpEntity> entity, List<CrmClueTrendsEntity> crmClue, List<RkProjectReportingStageTrendsEntity> stageTrendsList, List<RkReturnPlanFollowEntity> returnPlanList) {
        RkMrketLogRelevanceListInfo visitFollowVo = new RkMrketLogRelevanceListInfo();
        ArrayList<RkMrketLogRelevanceListVO> visitList = new ArrayList<RkMrketLogRelevanceListVO>();
        if (CollectionUtil.isNotEmpty(entity)) {
            for (VisitFollowUpEntity visitFollowUpEntity : entity) {
                if (visitFollowUpEntity.getIsDaily() == 0) {
                    RkMrketLogRelevanceListVO rkMrketLogRelevanceListVO = RkMrketLogRelevanceListVO.builder().mainTypeName(this.baseDataUtil.getDictName("forVisit", "dailyType")).mainType("forVisit").nextType("client").nextTypeName(this.baseDataUtil.getDictName("client", "dailyType")).customerId(visitFollowUpEntity.getCustomerId()).customerName(visitFollowUpEntity.getCustomerName()).creatorTime(visitFollowUpEntity.getCreatorTime()).build();
                    visitList.add(rkMrketLogRelevanceListVO);
                    continue;
                }
                RkMrketLogRelevanceListVO rkMrketLogRelevanceListVO = RkMrketLogRelevanceListVO.builder().mainTypeName(this.baseDataUtil.getDictName("forVisit", "dailyType")).mainType("forVisit").nextType("everyday").nextTypeName(this.baseDataUtil.getDictName("everyday", "dailyType")).creatorTime(visitFollowUpEntity.getCreatorTime()).build();
                visitList.add(rkMrketLogRelevanceListVO);
            }
        }
        visitFollowVo.setVisitFollowList(visitList);
        ArrayList<RkMrketLogRelevanceListVO> visitList2 = new ArrayList<RkMrketLogRelevanceListVO>();
        if (CollectionUtil.isNotEmpty(crmClue)) {
            for (CrmClueTrendsEntity crmClueTrendsEntity : crmClue) {
                RkMrketLogRelevanceListVO build;
                CrmClueInfoEntity byId;
                if (crmClueTrendsEntity.getType().equals("create") && ObjectUtil.isNotEmpty((Object)(byId = (CrmClueInfoEntity)this.crmClueInfoService.getById((Serializable)((Object)crmClueTrendsEntity.getClueId()))))) {
                    build = RkMrketLogRelevanceListVO.builder().mainTypeName(this.baseDataUtil.getDictName("FollowLeads", "dailyType")).mainType("FollowLeads").nextType("addFollowLeads").nextTypeName(this.baseDataUtil.getDictName("addFollowLeads", "dailyType")).customerId(byId.getCustomerId()).customerName(byId.getCustomerName()).clue(byId.getName()).creatorTime(crmClueTrendsEntity.getCreatorTime()).build();
                    visitList2.add(build);
                }
                if (!crmClueTrendsEntity.getType().equals("follow") || !ObjectUtil.isNotEmpty((Object)(byId = (CrmClueInfoEntity)this.crmClueInfoService.getById((Serializable)((Object)crmClueTrendsEntity.getClueId()))))) continue;
                build = RkMrketLogRelevanceListVO.builder().mainTypeName(this.baseDataUtil.getDictName("FollowLeads", "dailyType")).mainType("FollowLeads").nextType("ciFollowLeads").nextTypeName(this.baseDataUtil.getDictName("ciFollowLeads", "dailyType")).customerId(byId.getCustomerId()).customerName(byId.getCustomerName()).clue(byId.getName()).creatorTime(crmClueTrendsEntity.getCreatorTime()).build();
                visitList2.add(build);
            }
        }
        visitFollowVo.setCrmClueList(visitList2);
        ArrayList<RkMrketLogRelevanceListVO> arrayList = new ArrayList<RkMrketLogRelevanceListVO>();
        if (CollectionUtil.isNotEmpty(stageTrendsList)) {
            for (RkProjectReportingStageTrendsEntity trendsEntity : stageTrendsList) {
                RkProjectReportingEntity byId = (RkProjectReportingEntity)this.rkProjectReportingService.getById((Serializable)((Object)trendsEntity.getReportingId()));
                if (!ObjectUtil.isNotEmpty((Object)byId)) continue;
                RkMrketLogRelevanceListVO build = RkMrketLogRelevanceListVO.builder().mainTypeName(this.baseDataUtil.getDictName("business", "dailyType")).mainType("business").nextType("followBusiness").nextTypeName(this.baseDataUtil.getDictName("followBusiness", "dailyType")).customerId(byId.getCustomerId()).customerName(byId.getCustomerName()).business(byId.getReportingProject()).followMethodName(this.baseDataUtil.getDictName(trendsEntity.getFollowMethod(), "followMethod")).creatorTime(trendsEntity.getCreatorTime()).build();
                arrayList.add(build);
            }
        }
        visitFollowVo.setTrendsList(arrayList);
        ArrayList<RkMrketLogRelevanceListVO> arrayList2 = new ArrayList<RkMrketLogRelevanceListVO>();
        if (CollectionUtil.isNotEmpty(returnPlanList)) {
            for (RkReturnPlanFollowEntity rkReturnPlanFollowEntity : returnPlanList) {
                RkReturnPlanFollowEntity byId = (RkReturnPlanFollowEntity)this.rkReturnPlanFollowService.getById((Serializable)((Object)rkReturnPlanFollowEntity.getId()));
                RkContractReturnPlanEntity returnPlanEntity = (RkContractReturnPlanEntity)this.rkContractReturnPlanService.getById((Serializable)((Object)byId.getPlanId()));
                if (!ObjectUtil.isNotEmpty((Object)byId)) continue;
                RkMrketLogRelevanceListVO build = RkMrketLogRelevanceListVO.builder().mainTypeName(this.baseDataUtil.getDictName("returnPlan", "dailyType")).mainType("returnPlan").nextType("followReturnPlan").nextTypeName(this.baseDataUtil.getDictName("followReturnPlan", "dailyType")).customerId(returnPlanEntity.getCustomerId()).customerName(this.crmCustomerService.getInfo(returnPlanEntity.getCustomerId()).getName()).paymentType(this.baseDataUtil.getDictName(returnPlanEntity.getPaymentType(), "paymentType")).contactsName(byId.getContactsName()).creatorTime(rkReturnPlanFollowEntity.getCreatorTime()).build();
                arrayList2.add(build);
            }
        }
        visitFollowVo.setReturnPlanList(arrayList2);
        if (CollectionUtil.isNotEmpty(visitFollowVo.getVisitFollowList())) {
            visitFollowVo.setClientCount(visitFollowVo.getVisitFollowList().stream().filter(s -> s.getNextType().equals("client")).count());
            visitFollowVo.setEverydayCount(visitFollowVo.getVisitFollowList().stream().filter(s -> s.getNextType().equals("everyday")).count());
        }
        if (CollectionUtil.isNotEmpty(visitFollowVo.getCrmClueList())) {
            visitFollowVo.setAddFollowLeadsCount(visitFollowVo.getCrmClueList().stream().filter(s -> s.getNextType().equals("addFollowLeads")).count());
            visitFollowVo.setCiFollowLeadsCount(visitFollowVo.getCrmClueList().stream().filter(s -> s.getNextType().equals("ciFollowLeads")).count());
        }
        if (CollectionUtil.isNotEmpty(visitFollowVo.getTrendsList())) {
            visitFollowVo.setFollowBusinessCount(visitFollowVo.getTrendsList().stream().filter(s -> s.getNextType().equals("followBusiness")).count());
        }
        if (CollectionUtil.isNotEmpty(visitFollowVo.getReturnPlanList())) {
            visitFollowVo.setFollowReturnPlanCount(visitFollowVo.getReturnPlanList().stream().filter(s -> s.getNextType().equals("followReturnPlan")).count());
        }
        return visitFollowVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadVO exportProjectHourStatisticsDetail(RkMarketLogPagination rkMarketLogPagination) {
        String yearMonth = rkMarketLogPagination.getYearMonth();
        if (StringUtil.isNotEmpty((String)yearMonth)) {
            rkMarketLogPagination.setYearMonth(yearMonth.substring(0, 7));
        } else {
            rkMarketLogPagination.setYearMonth(DateUtil.getNow().substring(0, 7));
        }
        List<RkProjectHourStatisticsInfoVO> selfList = this.rkMarketLogMapper.selectProjectHourSelfAggregateList(rkMarketLogPagination);
        List<RkProjectHourStatisticsInfoVO> selfDetaliList = this.rkMarketLogMapper.selectProjectHourDetailStatisticsList(rkMarketLogPagination);
        List selfDetaliListAll = selfDetaliList.stream().filter(a -> !a.getLogType().equals("\u9879\u76ee\u5de5\u65f6")).collect(Collectors.toList());
        List<RkProjectHourStatisticsInfoVO> rkMarketLogEntitieList = this.rkMarketLogMapper.selectProjectData(rkMarketLogPagination);
        selfList.addAll(selfDetaliListAll);
        selfList.addAll(rkMarketLogEntitieList);
        selfList = selfList.stream().sorted(Comparator.comparing(RkProjectHourStatisticsInfoVO::getUserName).thenComparing(RkProjectHourStatisticsInfoVO::getOrderNum)).collect(Collectors.toList());
        List<RkProjectHourStatisticsInfoVO> listSum = this.rkMarketLogMapper.selectProjectHourStatisticsAggregateList(rkMarketLogPagination);
        selfList.addAll(listSum);
        String tableName = "\u552e\u540e\u4eba\u5458\u5de5\u65f6\u660e\u7ec6_";
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        entitys.add(new ExcelExportEntity("\u516c\u53f8", (Object)"companyName"));
        entitys.add(new ExcelExportEntity("\u90e8\u95e8", (Object)"deptName"));
        entitys.add(new ExcelExportEntity("\u59d3\u540d", (Object)"userName"));
        entitys.add(new ExcelExportEntity("\u7c7b\u578b", (Object)"logType"));
        entitys.add(new ExcelExportEntity("\u9879\u76ee\u540d\u79f0", (Object)"projectName"));
        entitys.add(new ExcelExportEntity("01", (Object)"day1"));
        entitys.add(new ExcelExportEntity("02", (Object)"day2"));
        entitys.add(new ExcelExportEntity("03", (Object)"day3"));
        entitys.add(new ExcelExportEntity("04", (Object)"day4"));
        entitys.add(new ExcelExportEntity("05", (Object)"day5"));
        entitys.add(new ExcelExportEntity("06", (Object)"day6"));
        entitys.add(new ExcelExportEntity("07", (Object)"day7"));
        entitys.add(new ExcelExportEntity("08", (Object)"day8"));
        entitys.add(new ExcelExportEntity("09", (Object)"day9"));
        entitys.add(new ExcelExportEntity("10", (Object)"day10"));
        entitys.add(new ExcelExportEntity("11", (Object)"day11"));
        entitys.add(new ExcelExportEntity("12", (Object)"day12"));
        entitys.add(new ExcelExportEntity("13", (Object)"day13"));
        entitys.add(new ExcelExportEntity("14", (Object)"day14"));
        entitys.add(new ExcelExportEntity("15", (Object)"day15"));
        entitys.add(new ExcelExportEntity("16", (Object)"day16"));
        entitys.add(new ExcelExportEntity("17", (Object)"day17"));
        entitys.add(new ExcelExportEntity("18", (Object)"day18"));
        entitys.add(new ExcelExportEntity("19", (Object)"day19"));
        entitys.add(new ExcelExportEntity("20", (Object)"day20"));
        entitys.add(new ExcelExportEntity("21", (Object)"day21"));
        entitys.add(new ExcelExportEntity("22", (Object)"day22"));
        entitys.add(new ExcelExportEntity("23", (Object)"day23"));
        entitys.add(new ExcelExportEntity("24", (Object)"day24"));
        entitys.add(new ExcelExportEntity("25", (Object)"day25"));
        entitys.add(new ExcelExportEntity("26", (Object)"day26"));
        entitys.add(new ExcelExportEntity("27", (Object)"day27"));
        entitys.add(new ExcelExportEntity("28", (Object)"day28"));
        entitys.add(new ExcelExportEntity("29", (Object)"day29"));
        entitys.add(new ExcelExportEntity("30", (Object)"day30"));
        entitys.add(new ExcelExportEntity("31", (Object)"day31"));
        entitys.add(new ExcelExportEntity("\u603b\u5de5\u65f6(\u5c0f\u65f6)", (Object)"aggregate"));
        List list = JsonUtil.listToJsonField((List)JsonUtil.getJsonToList(selfList, RkProjectHourStatisticsInfoVO.class));
        DownloadVO vo = DownloadVO.builder().build();
        ExportParams exportParams = new ExportParams(null, tableName);
        exportParams.setType(ExcelType.XSSF);
        try {
            UserInfo userInfo = this.userProvider.get();
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, (Collection)list);
                }
                String name = tableName + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u552e\u540e\u5de5\u65f6\u660e\u7ec6\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}" + e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @Override
    public RkMarketLogListVO detailInfo(RkMarketLogEntity entity) {
        RkMarketLogListVO vo = (RkMarketLogListVO)JsonUtil.getJsonToBean((Object)entity, RkMarketLogListVO.class);
        if (vo.getMarketType().equals("afterSale") || vo.getMarketType().equals("newAfterSale")) {
            ArrayList<RkMrketLogProjectListVO> projectLogDetaList = new ArrayList<RkMrketLogProjectListVO>();
            RkMrketLogProjectListVO rkMrketLogProjectListVO = new RkMrketLogProjectListVO();
            String[] customerIds = new String[13];
            if (StringUtils.isNotEmpty((String)vo.getCustomerId()) && vo.getCustomerId().contains(",")) {
                customerIds = vo.getCustomerId().split(",");
            }
            String[] projectIds = new String[13];
            if (StringUtils.isNotEmpty((String)vo.getRkContractProjectId()) && vo.getCustomerId().contains(",")) {
                projectIds = vo.getRkContractProjectId().split(",");
            }
            List<RkMarketLogProjectDataEntity> logList = this.rkMarketLogProjectDataService.queryByMarketLogId(entity.getId());
            if (customerIds != null && vo.getCustomerId().contains(",")) {
                for (int i = 0; i < customerIds.length; ++i) {
                    RkMrketLogProjectListVO rkMrketLogProjectListVO2 = new RkMrketLogProjectListVO();
                    if (ObjectUtil.isNotEmpty((Object)this.crmCustomerService.getInfo(customerIds[i]))) {
                        rkMrketLogProjectListVO2.setCustomerName(this.crmCustomerService.getInfo(customerIds[i]).getName());
                    }
                    rkMrketLogProjectListVO2.setRkContractProjectId(projectIds[i]);
                    rkMrketLogProjectListVO2.setCustomerId(customerIds[i]);
                    RkContractProjectEntity info = this.rkContractProjectService.getInfo(projectIds[i]);
                    rkMrketLogProjectListVO2.setRkContractProjectName(ObjectUtil.isNotEmpty((Object)info) ? info.getProjectName() : "");
                    if (CollectionUtil.isNotEmpty(logList) && logList.size() > i) {
                        rkMrketLogProjectListVO2.setManHour(logList.get(i).getManHour());
                        rkMrketLogProjectListVO2.setWorkDay(logList.get(i).getWorkDay());
                        rkMrketLogProjectListVO2.setContent(logList.get(i).getContent());
                    }
                    projectLogDetaList.add(rkMrketLogProjectListVO2);
                }
            } else if (StringUtils.isNotEmpty((String)vo.getCustomerId())) {
                rkMrketLogProjectListVO.setCustomerId(vo.getCustomerId());
                if (StrUtil.equals((CharSequence)vo.getCustomerId(), (CharSequence)"-1") || StrUtil.equals((CharSequence)vo.getCustomerId(), (CharSequence)"z")) {
                    rkMrketLogProjectListVO.setCustomerName("");
                } else {
                    rkMrketLogProjectListVO.setCustomerName(this.crmCustomerService.getInfo(vo.getCustomerId()).getName());
                }
                rkMrketLogProjectListVO.setRkContractProjectId(vo.getRkContractProjectId());
                RkContractProjectEntity info = this.rkContractProjectService.getInfo(vo.getRkContractProjectId());
                rkMrketLogProjectListVO.setRkContractProjectName(ObjectUtil.isNotEmpty((Object)info) ? info.getProjectName() : "");
                if (CollectionUtil.isNotEmpty(logList)) {
                    rkMrketLogProjectListVO.setManHour(logList.get(0).getManHour());
                    rkMrketLogProjectListVO.setWorkDay(logList.get(0).getWorkDay());
                    rkMrketLogProjectListVO.setContent(logList.get(0).getContent());
                }
                projectLogDetaList.add(rkMrketLogProjectListVO);
            } else {
                rkMrketLogProjectListVO.setRkContractProjectId("\u5185\u90e8\u9879\u76ee");
                rkMrketLogProjectListVO.setRkContractProjectName("\u5185\u90e8\u9879\u76ee");
                if (CollectionUtil.isNotEmpty(logList)) {
                    rkMrketLogProjectListVO.setManHour(logList.get(0).getManHour());
                    rkMrketLogProjectListVO.setWorkDay(logList.get(0).getWorkDay());
                    rkMrketLogProjectListVO.setContent(logList.get(0).getContent());
                }
                projectLogDetaList.add(rkMrketLogProjectListVO);
            }
            vo.setProjectLogDetaList(projectLogDetaList);
        }
        return vo;
    }

    @Override
    public boolean everydayTotal(Date optionDate) {
        UserInfo userInfo = this.userProvider.get();
        boolean isEqual = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkMarketLogEntity::getCreatorUserId, (Object)userInfo.getUserId());
        queryWrapper.lambda().and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(RkMarketLogEntity::getState, (Object)MarketLogStateEnum.SUBMIT.getEnableMark())).or()).eq(RkMarketLogEntity::getState, (Object)MarketLogStateEnum.CONFIRM.getEnableMark()));
        queryWrapper.lambda().isNotNull(RkMarketLogEntity::getOptionDate);
        queryWrapper.lambda().eq(RkMarketLogEntity::getOptionDate, (Object)optionDate);
        List list = this.list((Wrapper)queryWrapper);
        List dates = list.stream().map(RkMarketLogEntity::getOptionDate).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(dates)) {
            List localDates = dates.stream().map(date -> date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate()).collect(Collectors.toList());
            LocalDate localDate = optionDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            isEqual = localDates.stream().anyMatch(date -> date.isEqual(localDate));
        }
        return isEqual;
    }

    @Override
    public List<RkMarketLogEntity> getByManHourList(RkMarketLogPagination rkMarketLogPagination) {
        Object rkMarketLogObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int rkMarketLogNum = 0;
        QueryWrapper rkMarketLogQueryWrapper = new QueryWrapper();
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkMarketLogObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkMarketLogQueryWrapper, rkMarketLogPagination.getMenuId(), "rk_market_log"));
            if (ObjectUtil.isEmpty((Object)rkMarketLogObj)) {
                return new ArrayList<RkMarketLogEntity>();
            }
            rkMarketLogQueryWrapper = (QueryWrapper)rkMarketLogObj;
            ++rkMarketLogNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            rkMarketLogObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkMarketLogQueryWrapper, rkMarketLogPagination.getMenuId(), "rk_market_log"));
            if (ObjectUtil.isEmpty((Object)rkMarketLogObj)) {
                return new ArrayList<RkMarketLogEntity>();
            }
            rkMarketLogQueryWrapper = (QueryWrapper)rkMarketLogObj;
            ++rkMarketLogNum;
        }
        if (StringUtils.isNotEmpty((String)rkMarketLogPagination.getCompanyId())) {
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogEntity::getOrganizeId, (Object)rkMarketLogPagination.getCompanyId());
        }
        rkMarketLogQueryWrapper.lambda().eq(RkMarketLogEntity::getState, (Object)"1");
        if (!Strings.isBlank((String)rkMarketLogPagination.getCreatorUserId())) {
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogEntity::getCreatorUserId, (Object)rkMarketLogPagination.getCreatorUserId());
        }
        if (rkMarketLogPagination.getStartTime() != null && rkMarketLogPagination.getStartTime().size() > 0) {
            rkMarketLogPagination.setStartTimes(new SimpleDateFormat("yyyy-MM-dd").format(new Date(rkMarketLogPagination.getStartTime().get(0))));
            rkMarketLogPagination.setEndTime(new SimpleDateFormat("yyyy-MM-dd").format(new Date(rkMarketLogPagination.getStartTime().get(1) + 86400000L)));
            rkMarketLogQueryWrapper.lambda().between(RkMarketLogEntity::getCreatorTime, (Object)rkMarketLogPagination.getStartTimes(), (Object)rkMarketLogPagination.getEndTime());
        }
        if (ObjectUtil.isNotEmpty((Object)rkMarketLogPagination.getOptionDate())) {
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogEntity::getOptionDate, (Object)new SimpleDateFormat("yyyy-MM-dd").format(new Date(rkMarketLogPagination.getOptionDate())));
        }
        if (StringUtil.isNotEmpty((String)rkMarketLogPagination.getCustomerId())) {
            rkMarketLogQueryWrapper.lambda().and(s -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)s.or()).like(RkMarketLogEntity::getCustomerId, (Object)rkMarketLogPagination.getCustomerId());
            });
        }
        if (StringUtil.isNotEmpty((String)rkMarketLogPagination.getKeyword())) {
            ++rkMarketLogNum;
            rkMarketLogQueryWrapper.lambda().and(s -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)s.or()).like(RkMarketLogEntity::getTitle, (Object)rkMarketLogPagination.getRkContractProjectId());
            });
        }
        if (StringUtil.isNotEmpty((String)rkMarketLogPagination.getStartTimes()) && StringUtil.isNotEmpty((String)rkMarketLogPagination.getEndTime())) {
            ++rkMarketLogNum;
            rkMarketLogQueryWrapper.lambda().between(RkMarketLogEntity::getCreatorTime, (Object)rkMarketLogPagination.getStartTimes(), (Object)rkMarketLogPagination.getEndTime());
        }
        if (StringUtil.isNotEmpty((String)rkMarketLogPagination.getType())) {
            ++rkMarketLogNum;
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogEntity::getLogType, (Object)rkMarketLogPagination.getType());
        }
        if (StringUtil.isNotEmpty((String)rkMarketLogPagination.getState())) {
            ++rkMarketLogNum;
            rkMarketLogQueryWrapper.lambda().eq(RkMarketLogEntity::getState, (Object)rkMarketLogPagination.getState());
        }
        if (AllIdList.size() > 0) {
            rkMarketLogQueryWrapper.lambda().in(RkMarketLogEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)rkMarketLogPagination.getSidx())) {
            rkMarketLogQueryWrapper.lambda().orderByDesc(RkMarketLogEntity::getId);
        } else {
            try {
                String sidx = rkMarketLogPagination.getSidx();
                RkMarketLogEntity rkMarketLogEntity = new RkMarketLogEntity();
                Field declaredField = rkMarketLogEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkMarketLogQueryWrapper = "asc".equals(rkMarketLogPagination.getSort().toLowerCase()) ? (QueryWrapper)rkMarketLogQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkMarketLogQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkMarketLogPagination.getCurrentPage(), rkMarketLogPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkMarketLogQueryWrapper);
            return rkMarketLogPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkMarketLogPagination.setData(list, list.size());
    }

    @Override
    public int getDateCount() throws ParseException {
        List frontDate = DateUtil.getFrontDate((Date)DateUtil.getNowDate(), (int)2);
        int count = 0;
        for (String date : frontDate) {
            String workingDay = HolidayUtil.isWorkingDay(date);
            if (StrUtil.equals((CharSequence)workingDay, (CharSequence)"0")) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean getExceedManHour(RkMarketLogCrForm form) {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkMarketLogEntity::getCreatorUserId, (Object)userInfo.getUserId());
        queryWrapper.lambda().and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(RkMarketLogEntity::getState, (Object)MarketLogStateEnum.SUBMIT.getEnableMark())).or()).eq(RkMarketLogEntity::getState, (Object)MarketLogStateEnum.CONFIRM.getEnableMark()));
        queryWrapper.lambda().eq(RkMarketLogEntity::getOptionDate, (Object)form.getOptionDate());
        queryWrapper.lambda().select(new SFunction[]{RkMarketLogEntity::getManHour});
        List list = this.list((Wrapper)queryWrapper);
        BigDecimal reduce = list.stream().map(RkMarketLogEntity::getManHour).reduce(BigDecimal.ZERO, BigDecimal::add);
        reduce = reduce.add(form.getManHour());
        BigDecimal num = new BigDecimal("14");
        int i = reduce.compareTo(num);
        return i > 0;
    }

    @Override
    public BigDecimal getExceedManHourTotality(RkMarketLogCrForm form) {
        UserInfo userInfo = this.userProvider.get();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkMarketLogEntity::getCreatorUserId, (Object)userInfo.getUserId());
        queryWrapper.lambda().and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(RkMarketLogEntity::getState, (Object)MarketLogStateEnum.SUBMIT.getEnableMark())).or()).eq(RkMarketLogEntity::getState, (Object)MarketLogStateEnum.CONFIRM.getEnableMark()));
        queryWrapper.lambda().eq(RkMarketLogEntity::getOptionDate, (Object)form.getOptionDate());
        queryWrapper.lambda().select(new SFunction[]{RkMarketLogEntity::getManHour});
        List list = this.list((Wrapper)queryWrapper);
        BigDecimal reduce = list.stream().map(RkMarketLogEntity::getManHour).reduce(BigDecimal.ZERO, BigDecimal::add);
        reduce = reduce.add(form.getManHour());
        return reduce;
    }

    @Override
    public void delete(RkMarketLogEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

