/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.PadUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.constant.MessageTypeEnum;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.model.rkcontractproduct.RkContractProductCrForm;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkReportingAgentContactService;
import com.bringspring.contract.service.RkReportingCustomerContactService;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.entity.CrmDepartConnectEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.entity.CrmProductVersionEntity;
import com.bringspring.crm.model.crmcustomer.CrmCustomerUpForm;
import com.bringspring.crm.model.crmproduct.CrmProductPagination;
import com.bringspring.crm.model.crmproductversion.CrmProductVersionListVO;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.crm.service.CrmProductVersionService;
import com.bringspring.quotation.entity.SaleQuotationEntity;
import com.bringspring.quotation.entity.SaleQuotationProfitEntity;
import com.bringspring.quotation.service.SaleQuotationProfitService;
import com.bringspring.quotation.service.SaleQuotationService;
import com.bringspring.system.base.entity.BillRuleEntity;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.MessageTemplateEntity;
import com.bringspring.system.base.mapper.BillRuleMapper;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.MessageTemplateService;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.MessageUtils;
import com.bringspring.visit.constant.MessageTypeConst;
import com.bringspring.visit.entity.AfterSalesAttachmentEntity;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.entity.RkProjectReportingStageTrendsEntity;
import com.bringspring.visit.mapper.RkProjectReportingMapper;
import com.bringspring.visit.model.attendanceCalendar.AttendanceCalendarModel;
import com.bringspring.visit.model.rkprojectreporting.RkProjectReportingAuditForm;
import com.bringspring.visit.model.rkprojectreporting.RkProjectReportingCrForm;
import com.bringspring.visit.model.rkprojectreporting.RkProjectReportingInfoVO;
import com.bringspring.visit.model.rkprojectreporting.RkProjectReportingListVO;
import com.bringspring.visit.model.rkprojectreporting.RkProjectReportingPagination;
import com.bringspring.visit.model.rkprojectreporting.RkProjectReportingReconsiderForm;
import com.bringspring.visit.model.rkprojectreporting.RkProjectReportingStopForm;
import com.bringspring.visit.model.rkprojectreporting.RkProjectReportingUpForm;
import com.bringspring.visit.model.rkprojectreporting.RkReportingTransformPagination;
import com.bringspring.visit.model.rkprojectreportingtrends.RkProjectReportingTrendsTransferForm;
import com.bringspring.visit.service.AfterSalesAttachmentService;
import com.bringspring.visit.service.AttendanceCalendarService;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.visit.service.RkProjectReportingStageTrendsService;
import com.bringspring.visit.service.RkProjectReportingTrendsService;
import com.bringspring.visit.utils.AfterSalesAttachmentTypeEnum;
import com.bringspring.visit.utils.ProjectReportStageTrendsTypeEnum;
import com.bringspring.visit.utils.ProjectReportingEnum;
import com.bringspring.visit.utils.ProjectReportingTrendsEnum;
import com.bringspring.visit.utils.SalesRoleUtils;
import com.bringspring.visit.utils.UserRelationUtil;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkProjectReportingServiceImpl
extends ServiceImpl<RkProjectReportingMapper, RkProjectReportingEntity>
implements RkProjectReportingService {
    Logger logger = LoggerFactory.getLogger(RkProjectReportingServiceImpl.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkProjectReportingTrendsService rkProjectReportingTrendsService;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private AfterSalesAttachmentService afterSalesAttachmentService;
    @Autowired
    private UserService userService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private SalesRoleUtils salesRoleUtils;
    @Autowired
    private MessageTemplateService messageTemplateService;
    @Autowired
    private UserRelationUtil userRelationUtil;
    @Autowired
    private RkProjectReportingStageTrendsService rkProjectReportingStageTrendsService;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private BillRuleMapper billRuleMapper;
    @Autowired
    private RkProjectReportingMapper rkProjectReportingMapper;
    @Autowired
    private RkAgentService rkAgentService;
    @Autowired
    private RkReportingAgentContactService rkReportingAgentContactService;
    @Autowired
    private RkReportingCustomerContactService rkReportingCustomerContactService;
    @Autowired
    private SaleQuotationService saleQuotationService;
    @Autowired
    private SaleQuotationProfitService saleQuotationProfitService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmProductVersionService crmProductVersionService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private AttendanceCalendarService attendanceCalendarService;

    @Override
    public List<RkProjectReportingEntity> getList(RkProjectReportingPagination rkProjectReportingPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper rkProjectReportingQueryWrapper = this.appendWhere(rkProjectReportingPagination);
        if (Objects.isNull(rkProjectReportingQueryWrapper)) {
            return CollectionUtil.list((boolean)false);
        }
        if (AllIdList.size() > 0) {
            rkProjectReportingQueryWrapper.lambda().in(RkProjectReportingEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)rkProjectReportingPagination.getSidx())) {
            rkProjectReportingQueryWrapper.lambda().orderByDesc(RkProjectReportingEntity::getCreatorTime);
        } else {
            try {
                RkProjectReportingEntity rkProjectReportingEntity;
                String sidx = rkProjectReportingPagination.getSidx();
                if (StrUtil.equals((CharSequence)sidx, (CharSequence)"garde")) {
                    List list = this.dictionaryDataService.getList("361888069978164485");
                    String collect = list.stream().map(DictionaryDataEntity::getId).collect(Collectors.joining(","));
                    if ("asc".equals(rkProjectReportingPagination.getSort().toLowerCase())) {
                        rkProjectReportingQueryWrapper.last("ORDER BY FIELD(garde, " + collect + ") desc ");
                    } else {
                        rkProjectReportingQueryWrapper.last("ORDER BY FIELD(garde, " + collect + ") asc ");
                    }
                } else if (StrUtil.equals((CharSequence)sidx, (CharSequence)"productCompany")) {
                    List allCompanyList = this.organizeService.getAllCompanyList("");
                    String collect = allCompanyList.stream().map(OrganizeEntity::getId).collect(Collectors.joining(","));
                    rkProjectReportingQueryWrapper.last("ORDER BY FIELD(product_company, " + collect + ") " + rkProjectReportingPagination.getSort().toLowerCase() + " ");
                } else if (StrUtil.equals((CharSequence)sidx, (CharSequence)"customerName") || StrUtil.equals((CharSequence)sidx, (CharSequence)"reportingProject") || StrUtil.equals((CharSequence)sidx, (CharSequence)"creatorUserName")) {
                    rkProjectReportingEntity = new RkProjectReportingEntity();
                    Field declaredField = rkProjectReportingEntity.getClass().getDeclaredField(sidx);
                    declaredField.setAccessible(true);
                    String value = declaredField.getAnnotation(TableField.class).value();
                    rkProjectReportingQueryWrapper.last(" ORDER BY CONVERT(" + value + " USING gbk) COLLATE gbk_chinese_ci  " + rkProjectReportingPagination.getSort().toLowerCase() + " ");
                } else {
                    rkProjectReportingEntity = new RkProjectReportingEntity();
                    Field declaredField = rkProjectReportingEntity.getClass().getDeclaredField(sidx);
                    declaredField.setAccessible(true);
                    String value = declaredField.getAnnotation(TableField.class).value();
                    rkProjectReportingQueryWrapper = "asc".equals(rkProjectReportingPagination.getSort().toLowerCase()) ? (QueryWrapper)rkProjectReportingQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkProjectReportingQueryWrapper.orderByDesc((Object)value);
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(rkProjectReportingPagination.getCurrentPage(), rkProjectReportingPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkProjectReportingQueryWrapper);
            return rkProjectReportingPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return rkProjectReportingPagination.setData(list, list.size());
    }

    @Override
    public List<RkProjectReportingEntity> getListSelf(RkProjectReportingPagination rkProjectReportingPagination) {
        QueryWrapper rkProjectReportingQueryWrapper = new QueryWrapper();
        rkProjectReportingQueryWrapper.lambda().eq(RkProjectReportingEntity::getCreatorUserId, (Object)rkProjectReportingPagination.getCreatorUserId());
        if (ObjectUtil.isNotEmpty(rkProjectReportingPagination.getSaleStageList())) {
            rkProjectReportingQueryWrapper.lambda().in(RkProjectReportingEntity::getSaleStage, rkProjectReportingPagination.getSaleStageList());
        }
        if (StringUtil.isNotEmpty((String)rkProjectReportingPagination.getCustomerId())) {
            rkProjectReportingQueryWrapper.lambda().eq(RkProjectReportingEntity::getCustomerId, (Object)rkProjectReportingPagination.getCustomerId());
        }
        if (!ObjectUtil.isEmpty((Object)rkProjectReportingPagination.getKeyword())) {
            rkProjectReportingQueryWrapper.lambda().and(wq -> {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)wq.like(RkProjectReportingEntity::getReportingProject, (Object)rkProjectReportingPagination.getKeyword())).or()).like(RkProjectReportingEntity::getProjectScale, (Object)rkProjectReportingPagination.getKeyword());
                rkProjectReportingQueryWrapper.lambda().orderByDesc(RkProjectReportingEntity::getCreatorTime);
            });
        }
        return this.list((Wrapper)rkProjectReportingQueryWrapper);
    }

    private QueryWrapper<RkProjectReportingEntity> appendWhere(RkProjectReportingPagination rkProjectReportingPagination) {
        List<AttendanceCalendarModel> beforeWorkDate;
        Long sec;
        Long fir;
        QueryWrapper rkProjectReportingQueryWrapper = new QueryWrapper();
        boolean permission = true;
        Integer isAuth = rkProjectReportingPagination.getIsAuth();
        if (0 == isAuth) {
            permission = false;
        }
        if (StringUtil.isNotEmpty((String)rkProjectReportingPagination.getResourceType()) && "self".equals(rkProjectReportingPagination.getResourceType())) {
            rkProjectReportingQueryWrapper.lambda().eq(RkProjectReportingEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId());
        } else if (permission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object rkProjectReportingObj = this.authorizeService.getCondition(new AuthorizeConditionModel(rkProjectReportingQueryWrapper, rkProjectReportingPagination.getMenuId(), "rk_project_reporting"));
            if (ObjectUtil.isEmpty((Object)rkProjectReportingObj)) {
                rkProjectReportingQueryWrapper.and(this.defaultWrapper());
            } else {
                rkProjectReportingQueryWrapper = (QueryWrapper)rkProjectReportingObj;
            }
        }
        if (StringUtil.isNotEmpty((String)rkProjectReportingPagination.getDepartment())) {
            rkProjectReportingQueryWrapper.lambda().in(RkProjectReportingEntity::getDepartment, new Object[]{rkProjectReportingPagination.getDepartment()});
        }
        if (StringUtil.isNotEmpty((String)rkProjectReportingPagination.getReportingType())) {
            rkProjectReportingQueryWrapper.lambda().eq(RkProjectReportingEntity::getReportingType, (Object)rkProjectReportingPagination.getReportingType());
        }
        if (StringUtil.isNotEmpty((String)rkProjectReportingPagination.getSaleStage())) {
            rkProjectReportingQueryWrapper.lambda().eq(RkProjectReportingEntity::getSaleStage, (Object)rkProjectReportingPagination.getSaleStage());
        }
        if (ObjectUtil.isNotEmpty(rkProjectReportingPagination.getSaleStageList())) {
            rkProjectReportingQueryWrapper.lambda().in(RkProjectReportingEntity::getSaleStage, rkProjectReportingPagination.getSaleStageList());
        }
        if (CollectionUtil.isNotEmpty(rkProjectReportingPagination.getEnabledMark())) {
            rkProjectReportingQueryWrapper.lambda().in(RkProjectReportingEntity::getEnabledMark, rkProjectReportingPagination.getEnabledMark());
        }
        if (StringUtil.isNotEmpty((String)rkProjectReportingPagination.getReportingProject())) {
            rkProjectReportingQueryWrapper.lambda().like(RkProjectReportingEntity::getReportingProject, (Object)rkProjectReportingPagination.getReportingProject());
        }
        if (StringUtil.isNotEmpty((String)rkProjectReportingPagination.getCustomerId())) {
            rkProjectReportingQueryWrapper.lambda().eq(RkProjectReportingEntity::getCustomerId, (Object)rkProjectReportingPagination.getCustomerId());
        }
        if (StringUtil.isNotEmpty((String)rkProjectReportingPagination.getCustomerName())) {
            rkProjectReportingQueryWrapper.lambda().like(RkProjectReportingEntity::getCustomerName, (Object)rkProjectReportingPagination.getCustomerName());
        }
        if (StringUtil.isNotEmpty((String)rkProjectReportingPagination.getGarde())) {
            rkProjectReportingQueryWrapper.lambda().eq(RkProjectReportingEntity::getGarde, (Object)rkProjectReportingPagination.getGarde());
        }
        if (StringUtil.isNotEmpty((String)rkProjectReportingPagination.getCreatorUserId())) {
            rkProjectReportingQueryWrapper.lambda().eq(RkProjectReportingEntity::getCreatorUserId, (Object)rkProjectReportingPagination.getCreatorUserId());
        }
        if (CollectionUtil.isNotEmpty(rkProjectReportingPagination.getCompanyIdList())) {
            rkProjectReportingQueryWrapper.lambda().and(wrapper -> ((LambdaQueryWrapper)wrapper.and(w1 -> {
                w1.apply("find_in_set('" + rkProjectReportingPagination.getCompanyIdList().get(0) + "',product_company)", new Object[0]);
                for (int i = 1; i < rkProjectReportingPagination.getCompanyIdList().size(); ++i) {
                    ((LambdaQueryWrapper)w1.or()).apply("find_in_set('" + rkProjectReportingPagination.getCompanyIdList().get(i) + "',product_company)", new Object[0]);
                }
            })).or(w2 -> w2.in(RkProjectReportingEntity::getCompanyId, rkProjectReportingPagination.getCompanyIdList())));
        }
        if (CollectionUtil.isNotEmpty(rkProjectReportingPagination.getSalerCompanyIdList())) {
            rkProjectReportingQueryWrapper.lambda().in(RkProjectReportingEntity::getCompanyId, rkProjectReportingPagination.getSalerCompanyIdList());
        }
        if (StringUtil.isNotEmpty((String)rkProjectReportingPagination.getCompanyId())) {
            rkProjectReportingQueryWrapper.lambda().eq(RkProjectReportingEntity::getCompanyId, (Object)rkProjectReportingPagination.getCompanyId());
        }
        if (StrUtil.isNotBlank((CharSequence)rkProjectReportingPagination.getProductCompany())) {
            rkProjectReportingQueryWrapper.apply("find_in_set('" + rkProjectReportingPagination.getProductCompany() + "',product_company)", new Object[0]);
        }
        if (StrUtil.isNotBlank((CharSequence)rkProjectReportingPagination.getProductId())) {
            rkProjectReportingQueryWrapper.apply("find_in_set('" + rkProjectReportingPagination.getProductId() + "',product_id)", new Object[0]);
        }
        if (StrUtil.isNotBlank((CharSequence)rkProjectReportingPagination.getProductType())) {
            rkProjectReportingQueryWrapper.apply("find_in_set('" + rkProjectReportingPagination.getProductType() + "',product_type)", new Object[0]);
        }
        if (StringUtils.isNotEmpty(rkProjectReportingPagination.getCreatorTime())) {
            List<String> CreatorTimeList = rkProjectReportingPagination.getCreatorTime();
            fir = Long.valueOf(CreatorTimeList.get(0));
            sec = Long.valueOf(CreatorTimeList.get(1));
            ((LambdaQueryWrapper)rkProjectReportingQueryWrapper.lambda().ge(RkProjectReportingEntity::getCreatorTime, (Object)new Date(fir))).le(RkProjectReportingEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty(rkProjectReportingPagination.getLastFollowTimeList())) {
            List<String> lastFollowTimeList = rkProjectReportingPagination.getLastFollowTimeList();
            fir = Long.valueOf(lastFollowTimeList.get(0));
            sec = Long.valueOf(lastFollowTimeList.get(1));
            ((LambdaQueryWrapper)rkProjectReportingQueryWrapper.lambda().ge(RkProjectReportingEntity::getLastFollowTime, (Object)new Date(fir))).le(RkProjectReportingEntity::getLastFollowTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty(rkProjectReportingPagination.getExpectedSigningDateList())) {
            List<String> expectedSigningDateList = rkProjectReportingPagination.getExpectedSigningDateList();
            fir = Long.valueOf(expectedSigningDateList.get(0));
            sec = Long.valueOf(expectedSigningDateList.get(1));
            ((LambdaQueryWrapper)rkProjectReportingQueryWrapper.lambda().ge(RkProjectReportingEntity::getExpectedSigningDate, (Object)new Date(fir))).le(RkProjectReportingEntity::getExpectedSigningDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (CollectionUtil.isNotEmpty(rkProjectReportingPagination.getAddress())) {
            rkProjectReportingPagination.getAddress().stream().filter(x -> {
                boolean flag = x.size() < 2 && ((String)x.get(0)).equals("10");
                return !flag;
            }).collect(Collectors.toList());
            if (rkProjectReportingPagination.getAddress().size() < 2 && rkProjectReportingPagination.getAddress().get(0).equals("10")) {
                rkProjectReportingPagination.setAddress(null);
            }
        }
        if (CollectionUtil.isNotEmpty(rkProjectReportingPagination.getAddress())) {
            rkProjectReportingQueryWrapper.lambda().and(x -> {
                for (List<String> ll : rkProjectReportingPagination.getAddress()) {
                    List addressList = JsonUtil.getJsonToList(ll, String.class);
                    if (addressList.size() > 1) {
                        String collect = addressList.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","));
                        collect = "[" + collect;
                        ((LambdaQueryWrapper)x.or()).like(RkProjectReportingEntity::getAddress, (Object)collect);
                        continue;
                    }
                    String s2 = (String)addressList.get(addressList.size() - 1);
                    s2 = "[\"" + s2 + "\"";
                    ((LambdaQueryWrapper)x.or()).like(RkProjectReportingEntity::getAddress, (Object)s2);
                }
            });
        }
        if (CollectionUtil.isNotEmpty(rkProjectReportingPagination.getAuthAddress())) {
            rkProjectReportingPagination.getAuthAddress().stream().filter(x -> {
                boolean flag = x.size() < 2 && ((String)x.get(0)).equals("10");
                return !flag;
            }).collect(Collectors.toList());
            if (rkProjectReportingPagination.getAuthAddress().size() < 2 && rkProjectReportingPagination.getAuthAddress().get(0).equals("10")) {
                rkProjectReportingPagination.setAuthAddress(null);
            }
        }
        if (CollectionUtil.isNotEmpty(rkProjectReportingPagination.getCanSeeUserIdList()) || CollectionUtil.isNotEmpty(rkProjectReportingPagination.getAuthAddress())) {
            rkProjectReportingQueryWrapper.lambda().and(y -> {
                if (CollectionUtil.isNotEmpty(rkProjectReportingPagination.getCanSeeUserIdList())) {
                    ((LambdaQueryWrapper)y.or()).in(RkProjectReportingEntity::getCreatorUserId, rkProjectReportingPagination.getCanSeeUserIdList());
                }
                if (CollectionUtil.isNotEmpty(rkProjectReportingPagination.getAuthAddress())) {
                    ((LambdaQueryWrapper)y.or()).or(x -> {
                        for (List<String> ll : rkProjectReportingPagination.getAuthAddress()) {
                            List addressList = JsonUtil.getJsonToList(ll, String.class);
                            if (addressList.size() > 1) {
                                String collect = addressList.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","));
                                collect = "[" + collect;
                                ((LambdaQueryWrapper)x.or()).like(RkProjectReportingEntity::getAddress, (Object)collect);
                                continue;
                            }
                            String s2 = (String)addressList.get(addressList.size() - 1);
                            s2 = "[\"" + s2 + "\"";
                            ((LambdaQueryWrapper)x.or()).like(RkProjectReportingEntity::getAddress, (Object)s2);
                        }
                    });
                }
            });
        }
        if (StringUtils.isNotEmpty((String)rkProjectReportingPagination.getRegion())) {
            rkProjectReportingQueryWrapper.lambda().eq(RkProjectReportingEntity::getRegion, (Object)rkProjectReportingPagination.getRegion());
        }
        if (StringUtils.isNotEmpty((String)rkProjectReportingPagination.getProv())) {
            rkProjectReportingQueryWrapper.lambda().eq(RkProjectReportingEntity::getProv, (Object)rkProjectReportingPagination.getProv());
        }
        if (null != rkProjectReportingPagination.getWinOrLose()) {
            rkProjectReportingQueryWrapper.lambda().eq(RkProjectReportingEntity::getWinOrLose, (Object)rkProjectReportingPagination.getWinOrLose());
        }
        if (ObjectUtil.equal((Object)rkProjectReportingPagination.getFollowType(), (Object)1) && CollectionUtil.isNotEmpty(beforeWorkDate = this.attendanceCalendarService.getBeforeWorkDate(DateUtil.getNowDate(), 8, true))) {
            rkProjectReportingQueryWrapper.lambda().lt(RkProjectReportingEntity::getLastFollowTime, (Object)beforeWorkDate.get(beforeWorkDate.size() - 1).getWdate());
            rkProjectReportingQueryWrapper.lambda().eq(RkProjectReportingEntity::getWinOrLose, (Object)-1);
        }
        if (ObjectUtil.equal((Object)rkProjectReportingPagination.getFollowType(), (Object)2)) {
            rkProjectReportingQueryWrapper.lambda().ge(RkProjectReportingEntity::getLastFollowTime, (Object)DateUtil.dateAddDays((Date)DateUtil.getNowDate(), (int)-1));
            rkProjectReportingQueryWrapper.lambda().eq(RkProjectReportingEntity::getWinOrLose, (Object)-1);
        }
        return rkProjectReportingQueryWrapper;
    }

    private Consumer<QueryWrapper<RkProjectReportingEntity>> defaultWrapper() {
        final String userId = this.userProvider.get().getUserId();
        return new Consumer<QueryWrapper<RkProjectReportingEntity>>(){

            @Override
            public void accept(QueryWrapper<RkProjectReportingEntity> saleQuotationTemplateQueryWrapper) {
                saleQuotationTemplateQueryWrapper.lambda().eq(RkProjectReportingEntity::getCreatorUserId, (Object)userId);
            }
        };
    }

    @Override
    public List<RkProjectReportingEntity> getTypeList(RkProjectReportingPagination rkProjectReportingPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper rkProjectReportingQueryWrapper = this.appendWhere(rkProjectReportingPagination);
        if (Objects.isNull(rkProjectReportingQueryWrapper)) {
            return CollectionUtil.list((boolean)false);
        }
        if (AllIdList.size() > 0) {
            rkProjectReportingQueryWrapper.lambda().in(RkProjectReportingEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)rkProjectReportingPagination.getSidx())) {
            rkProjectReportingQueryWrapper.lambda().orderByDesc(RkProjectReportingEntity::getCreatorTime);
        } else {
            try {
                String sidx = rkProjectReportingPagination.getSidx();
                RkProjectReportingEntity rkProjectReportingEntity = new RkProjectReportingEntity();
                Field declaredField = rkProjectReportingEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                rkProjectReportingQueryWrapper = "asc".equals(rkProjectReportingPagination.getSort().toLowerCase()) ? (QueryWrapper)rkProjectReportingQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)rkProjectReportingQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(rkProjectReportingPagination.getCurrentPage(), rkProjectReportingPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)rkProjectReportingQueryWrapper);
                return rkProjectReportingPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return rkProjectReportingPagination.setData(list, list.size());
        }
        return this.list((Wrapper)rkProjectReportingQueryWrapper);
    }

    @Override
    public long countReporting(RkProjectReportingPagination rkProjectReportingPagination) {
        QueryWrapper<RkProjectReportingEntity> queryWrapper = this.appendWhere(rkProjectReportingPagination);
        if (ObjectUtil.isEmpty(queryWrapper)) {
            return 0L;
        }
        return this.count((Wrapper)queryWrapper);
    }

    @Override
    public BigDecimal countReportingAmount(RkProjectReportingPagination rkProjectReportingPagination) {
        QueryWrapper<RkProjectReportingEntity> queryWrapper = this.appendWhere(rkProjectReportingPagination);
        if (ObjectUtil.isEmpty(queryWrapper)) {
            return BigDecimal.ZERO;
        }
        queryWrapper.select(new String[]{"sum(estimated_signing_amount) as estimatedSigningAmount"});
        Map map = this.getMap((Wrapper)queryWrapper);
        if (ObjectUtil.isNull((Object)map) || ObjectUtil.isNull(map.get("estimatedSigningAmount"))) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(map.get("estimatedSigningAmount").toString());
    }

    @Override
    public RkProjectReportingEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkProjectReportingEntity::getId, (Object)id);
        return (RkProjectReportingEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkProjectReportingEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, RkProjectReportingEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(RkProjectReportingEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public void removeInfo(String id) {
        this.removeById((Serializable)((Object)id));
    }

    @Override
    @DSTransactional
    public void saveProjectReporting(RkProjectReportingCrForm rkProjectReportingCrForm) {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        RkProjectReportingEntity entity = (RkProjectReportingEntity)JsonUtil.getJsonToBean((Object)rkProjectReportingCrForm, RkProjectReportingEntity.class);
        if (StringUtils.isNotEmpty((String)rkProjectReportingCrForm.getPrimaryCode()) && StringUtils.isNotEmpty((String)rkProjectReportingCrForm.getPrimaryCodeName())) {
            entity.setId(rkProjectReportingCrForm.getPrimaryCodeName());
            BillRuleEntity billRuleEntity = this.getBillRule("mj_Business");
            billRuleEntity.setOutputNumber(rkProjectReportingCrForm.getPrimaryCode());
            billRuleEntity.setThisNumber(Integer.valueOf(billRuleEntity.getThisNumber() + 1));
            this.billRuleMapper.updateById((Object)billRuleEntity);
        } else {
            entity.setId(mainId);
        }
        entity.setCompanyId(userInfo.getOrganizeId());
        entity.setDepartment(userInfo.getDepartmentId());
        if (StringUtils.equals((CharSequence)rkProjectReportingCrForm.getEnabledMark(), (CharSequence)ProjectReportingEnum.AUDIT_NODE.getType())) {
            entity.setNextDealRole(ProjectReportingEnum.AUDIT_NODE.getType());
        }
        if (StringUtil.isNotEmpty((String)rkProjectReportingCrForm.getAddress())) {
            String[] split = rkProjectReportingCrForm.getAddress().replace("\"", "").replace("[", "").replace("]", "").split(",");
            for (int i = 0; i < split.length; ++i) {
                if (i == 0) {
                    entity.setRegion(split[0]);
                    entity.setRegionName(this.baseDataUtil.provinceData(entity.getRegion()));
                }
                if (i == 1) {
                    entity.setProv(split[1]);
                    entity.setProvName(this.baseDataUtil.provinceData(entity.getProv()));
                }
                if (i != 2) continue;
                entity.setCity(split[2]);
                entity.setCityName(this.baseDataUtil.provinceData(entity.getCity()));
            }
        }
        this.save(entity);
        List AfterSalesAttachmentList = JsonUtil.getJsonToList(rkProjectReportingCrForm.getAttachmentList(), AfterSalesAttachmentEntity.class);
        for (AfterSalesAttachmentEntity entitys : AfterSalesAttachmentList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setObjId(entity.getId());
            entitys.setFileType(AfterSalesAttachmentTypeEnum.REPORTING_TYPE.getType());
            this.afterSalesAttachmentService.save(entitys);
        }
        if (StringUtils.equals((CharSequence)rkProjectReportingCrForm.getEnabledMark(), (CharSequence)ProjectReportingEnum.AUDIT_NODE.getType())) {
            this.rkProjectReportingTrendsService.createTrends(ProjectReportingTrendsEnum.CREATE_NODE.getType(), entity.getId(), entity.getCustomerId(), entity.getCustomerName(), entity.getCompanyId(), "\u65b0\u589e\u62a5\u5907", 1, null, null, 1);
            try {
                SentMessageForm sentMessageForm = this.getMessageForm(MessageTypeConst.PROJECT_REPORT_NEED_AUDIT.getType(), MessageTypeConst.PROJECT_REPORT_NEED_AUDIT.getTemplateCode());
                if (!ObjectUtil.isEmpty((Object)sentMessageForm)) {
                    sentMessageForm.setToUserIds(this.salesRoleUtils.getRegionalManager());
                    sentMessageForm.setTitle("\u6709\u9700\u8981\u60a8\u5ba1\u6279\u7684\u62a5\u5907\u9879\u76ee\uff0c\u8bf7\u77e5\u6089\uff01");
                    String type = entity.getReportingType() == 1 ? "\u957f\u671f\u9879\u76ee" : "\u51c6\u5ba2\u6237\u9879\u76ee";
                    StringBuffer contentWechat = new StringBuffer();
                    contentWechat.append("\u5ba2\u6237\u540d\u79f0:" + entity.getCustomerName());
                    contentWechat.append("\n\u62a5\u5907\u7c7b\u578b:" + type);
                    contentWechat.append("\n\u9879\u76ee\u540d\u79f0:" + entity.getReportingProject());
                    contentWechat.append("\n\u62a5\u5907\u4eba:" + userInfo.getUserName());
                    String messageTime = DateUtil.dateFormat((Date)new Date());
                    contentWechat.append("\n\u7533\u8bf7\u65f6\u95f4:" + messageTime);
                    sentMessageForm.setContent(contentWechat.toString());
                    this.messagePush(sentMessageForm);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private SentMessageForm getMessageForm(Integer type, String templateCode) {
        QueryWrapper templateEntityQueryWrapper = new QueryWrapper();
        templateEntityQueryWrapper.lambda().eq(MessageTemplateEntity::getEnCode, (Object)templateCode);
        MessageTemplateEntity one = (MessageTemplateEntity)this.messageTemplateService.getOne((Wrapper)templateEntityQueryWrapper);
        if (Objects.isNull(one)) {
            this.logger.info("\u672a\u914d\u7f6e\u6d88\u606f\u6a21\u677f,code:{}", (Object)templateCode);
            return null;
        }
        SentMessageForm sentMessageForm = new SentMessageForm();
        sentMessageForm.setType(type);
        sentMessageForm.setTemplateId(one.getId());
        return sentMessageForm;
    }

    @Override
    public void updateProjectReporting(RkProjectReportingUpForm rkProjectReportingUpForm) {
        UserInfo userInfo = this.userProvider.get();
        RkProjectReportingEntity entity = this.getInfo(rkProjectReportingUpForm.getId());
        if (entity != null) {
            RkProjectReportingEntity subentity = (RkProjectReportingEntity)JsonUtil.getJsonToBean((Object)rkProjectReportingUpForm, RkProjectReportingEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            this.update(rkProjectReportingUpForm.getId(), subentity);
            QueryWrapper AfterSalesAttachmentqueryWrapper = new QueryWrapper();
            AfterSalesAttachmentqueryWrapper.lambda().eq(AfterSalesAttachmentEntity::getObjId, (Object)entity.getId());
            this.afterSalesAttachmentService.remove((Wrapper)AfterSalesAttachmentqueryWrapper);
            List AfterSalesAttachmentList = JsonUtil.getJsonToList(rkProjectReportingUpForm.getAttachmentList(), AfterSalesAttachmentEntity.class);
            for (AfterSalesAttachmentEntity entitys : AfterSalesAttachmentList) {
                entitys.setId(RandomUtil.uuId());
                entitys.setObjId(entity.getId());
                this.afterSalesAttachmentService.save(entitys);
            }
            if (StringUtils.equals((CharSequence)rkProjectReportingUpForm.getEnabledMark(), (CharSequence)ProjectReportingEnum.AUDIT_NODE.getType()) && StringUtils.equals((CharSequence)entity.getEnabledMark(), (CharSequence)ProjectReportingEnum.DRAFT_NODE.getType())) {
                this.rkProjectReportingTrendsService.createTrends(ProjectReportingTrendsEnum.CREATE_NODE.getType(), entity.getId(), entity.getCustomerId(), entity.getCustomerName(), entity.getCompanyId(), "\u65b0\u589e\u62a5\u5907", 1, null, null, 1);
            }
            CrmCustomerUpForm crmCustomerUpForm = new CrmCustomerUpForm();
            crmCustomerUpForm.setId(entity.getCustomerId());
            crmCustomerUpForm.setHisManufacturer(entity.getHisManufacturer());
            crmCustomerUpForm.setEmrManufacturer(entity.getEmrManufacturer());
            crmCustomerUpForm.setHandNumbness(entity.getHandNumbness());
            crmCustomerUpForm.setIcu(entity.getIcu());
            crmCustomerUpForm.setEmss(entity.getEmss());
            crmCustomerUpForm.setFiveCenter(entity.getFiveCenter());
            crmCustomerUpForm.setOutpatientCall(entity.getOutpatientCall());
            crmCustomerUpForm.setMedicalIntercom(entity.getMedicalIntercom());
            crmCustomerUpForm.setHemodialysis(entity.getHemodialysis());
            crmCustomerUpForm.setMris(entity.getMris());
            crmCustomerUpForm.setPaperlessSystem(entity.getPaperlessSystem());
            crmCustomerUpForm.setDip(entity.getDip());
            crmCustomerUpForm.setHomeQuality(entity.getHomeQuality());
            crmCustomerUpForm.setAdverseEvent(entity.getAdverseEvent());
            crmCustomerUpForm.setNationalExaminationReport(entity.getNationalExaminationReport());
            crmCustomerUpForm.setLogisticsSystem(entity.getLogisticsSystem());
            crmCustomerUpForm.setEmergencyTreatment(entity.getEmergencyTreatment());
            CrmCustomerEntity crmCustomerEntity = (CrmCustomerEntity)JsonUtil.getJsonToBean((Object)((Object)crmCustomerUpForm), CrmCustomerEntity.class);
            this.crmCustomerService.updateById(crmCustomerEntity);
            try {
                SentMessageForm sentMessageForm = this.userRelationUtil.getMessageForm(MessageTypeConst.PROJECT_REPORT_NEED_AUDIT.getType(), MessageTypeConst.PROJECT_REPORT_NEED_AUDIT.getTemplateCode());
                if (!ObjectUtil.isEmpty((Object)sentMessageForm)) {
                    sentMessageForm.setToUserIds(this.salesRoleUtils.getRegionalManager());
                    sentMessageForm.setTitle("\u6709\u9700\u8981\u60a8\u5ba1\u6279\u7684\u62a5\u5907\u9879\u76ee\uff0c\u8bf7\u77e5\u6089\uff01");
                    String type = entity.getReportingType() == 1 ? "\u957f\u671f\u9879\u76ee" : "\u51c6\u5ba2\u6237\u9879\u76ee";
                    StringBuffer contentWechat = new StringBuffer();
                    contentWechat.append("\u5ba2\u6237\u540d\u79f0:" + entity.getCustomerName());
                    contentWechat.append("\n\u62a5\u5907\u7c7b\u578b:" + type);
                    contentWechat.append("\n\u9879\u76ee\u540d\u79f0:" + entity.getReportingProject());
                    contentWechat.append("\n\u62a5\u5907\u4eba:" + userInfo.getUserName());
                    contentWechat.append("\n\u7533\u8bf7\u65f6\u95f4:" + DateUtil.dateFormat((Date)new Date()));
                    sentMessageForm.setContent(contentWechat.toString());
                    this.messagePush(sentMessageForm);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    @DSTransactional
    public void auditProjectReporting(RkProjectReportingAuditForm rkProjectReportingAuditForm) {
        RkProjectReportingEntity entity = this.getInfo(rkProjectReportingAuditForm.getId());
        if (entity != null) {
            RkProjectReportingEntity subentity = (RkProjectReportingEntity)JsonUtil.getJsonToBean((Object)rkProjectReportingAuditForm, RkProjectReportingEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            Integer dealResult = StrUtil.equals((CharSequence)rkProjectReportingAuditForm.getEnabledMark(), (CharSequence)ProjectReportingEnum.PASS_NODE.getType()) ? 1 : 0;
            if (dealResult == 0) {
                subentity.setNextDealRole("create");
            }
            this.update(rkProjectReportingAuditForm.getId(), subentity);
            this.rkProjectReportingTrendsService.createTrends(ProjectReportingTrendsEnum.AUDIT_NODE.getType(), entity.getId(), entity.getCustomerId(), entity.getCustomerName(), entity.getCompanyId(), rkProjectReportingAuditForm.getAuditRemark(), dealResult, null, null, 0);
            try {
                SentMessageForm sentMessageForm = this.userRelationUtil.getMessageForm(MessageTypeConst.PROJECT_REPORT_AUDIT_PUSH.getType(), MessageTypeConst.PROJECT_REPORT_AUDIT_PUSH.getTemplateCode());
                if (!ObjectUtil.isEmpty((Object)sentMessageForm)) {
                    sentMessageForm.setToUserIds(CollectionUtil.list((boolean)false, (Object[])new String[]{entity.getCreatorUserId()}));
                    sentMessageForm.setTitle("\u6709\u9700\u8981\u5ba1\u6279\u7684\u62a5\u5907\u9879\u76ee\uff0c\u8bf7\u77e5\u6089\uff01");
                    String type = entity.getReportingType() == 1 ? "\u957f\u671f\u9879\u76ee" : "\u51c6\u5ba2\u6237\u9879\u76ee";
                    String auditResult = dealResult == 1 ? "\u5ba1\u6279\u901a\u8fc7" : "\u5ba1\u6279\u9a73\u56de";
                    StringBuffer contentWechat = new StringBuffer();
                    contentWechat.append("\u5ba2\u6237\u540d\u79f0:" + entity.getCustomerName());
                    contentWechat.append("\n\u62a5\u5907\u7c7b\u578b:" + type);
                    contentWechat.append("\n\u9879\u76ee\u540d\u79f0:" + entity.getReportingProject());
                    contentWechat.append("\n\u5ba1\u6279\u7ed3\u679c:" + auditResult);
                    contentWechat.append("\n\u5ba1\u6279\u610f\u89c1:" + rkProjectReportingAuditForm.getAuditRemark());
                    contentWechat.append("\n\u5ba1\u6279\u65f6\u95f4:" + DateUtil.dateFormat((Date)new Date()));
                    sentMessageForm.setContent(contentWechat.toString());
                    ArrayList<SentMessageForm> messageListAll = new ArrayList<SentMessageForm>();
                    messageListAll.add(sentMessageForm);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    @DSTransactional
    public void updateFyProjectReporting(RkProjectReportingUpForm rkProjectReportingUpForm) {
        RkProjectReportingEntity entity = this.getInfo(rkProjectReportingUpForm.getId());
        if (entity != null) {
            RkProjectReportingEntity subentity = (RkProjectReportingEntity)JsonUtil.getJsonToBean((Object)rkProjectReportingUpForm, RkProjectReportingEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            if (StringUtils.equals((CharSequence)rkProjectReportingUpForm.getEnabledMark(), (CharSequence)ProjectReportingEnum.RECONSIDER_NODE.getType())) {
                subentity.setNextDealRole("reconsider");
            }
            this.update(rkProjectReportingUpForm.getId(), subentity);
            if (StringUtils.equals((CharSequence)rkProjectReportingUpForm.getEnabledMark(), (CharSequence)ProjectReportingEnum.RECONSIDER_NODE.getType())) {
                this.rkProjectReportingTrendsService.createTrends(ProjectReportingTrendsEnum.TO_RECONSIDER_NODE.getType(), entity.getId(), entity.getCustomerId(), entity.getCustomerName(), entity.getCompanyId(), "\u63d0\u4ea4\u590d\u8bae", 1, null, null, 1);
            }
        }
    }

    @Override
    public void saveToJudgment(RkProjectReportingUpForm rkProjectReportingUpForm) {
        RkProjectReportingEntity entity = this.getInfo(rkProjectReportingUpForm.getId());
        if (entity != null) {
            RkProjectReportingEntity jsonToBean = (RkProjectReportingEntity)JsonUtil.getJsonToBean((Object)rkProjectReportingUpForm, RkProjectReportingEntity.class);
            jsonToBean.setToJudgmentRemark(rkProjectReportingUpForm.getToJudgmentRemark());
            if (StringUtils.equals((CharSequence)rkProjectReportingUpForm.getEnabledMark(), (CharSequence)ProjectReportingEnum.REJECTED_NODE.getType())) {
                jsonToBean.setEnabledMark(ProjectReportingEnum.REJECTED_NODE.getType());
                jsonToBean.setNextDealRole("create");
            } else {
                jsonToBean.setEnabledMark(ProjectReportingEnum.JUDGMENT_NODE.getType());
                jsonToBean.setNextDealRole(ProjectReportingEnum.JUDGMENT_NODE.getType());
                try {
                    SentMessageForm sentMessageForm = this.userRelationUtil.getMessageForm(MessageTypeConst.PROJECT_REPORT_NEED_AUDIT.getType(), MessageTypeConst.PROJECT_REPORT_NEED_AUDIT.getTemplateCode());
                    if (!ObjectUtil.isEmpty((Object)sentMessageForm)) {
                        sentMessageForm.setToUserIds(this.salesRoleUtils.getManager());
                        sentMessageForm.setTitle("\u6709\u9700\u8981\u60a8\u88c1\u51b3\u7684\u62a5\u5907\u9879\u76ee\uff0c\u8bf7\u77e5\u6089\uff01");
                        String type = entity.getReportingType() == 1 ? "\u957f\u671f\u9879\u76ee" : "\u51c6\u5ba2\u6237\u9879\u76ee";
                        StringBuffer contentWechat = new StringBuffer();
                        contentWechat.append("\u5ba2\u6237\u540d\u79f0:" + entity.getCustomerName());
                        contentWechat.append("\n\u62a5\u5907\u7c7b\u578b:" + type);
                        contentWechat.append("\n\u9879\u76ee\u540d\u79f0:" + entity.getReportingProject());
                        contentWechat.append("\n\u62a5\u5907\u4eba:" + ((UserEntity)this.userService.getById((Serializable)((Object)entity.getCreatorUserId()))).getRealName());
                        contentWechat.append("\n\u7533\u8bf7\u65f6\u95f4:" + DateUtil.dateFormat((Date)new Date()));
                        sentMessageForm.setContent(contentWechat.toString());
                        this.messagePush(sentMessageForm);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.update(entity.getId(), jsonToBean);
            this.rkProjectReportingTrendsService.createTrends(ProjectReportingTrendsEnum.TO_JUDGMENT_NODE.getType(), entity.getId(), entity.getCustomerId(), entity.getCustomerName(), entity.getCompanyId(), rkProjectReportingUpForm.getToJudgmentRemark(), 1, null, null, 0);
        }
    }

    @Override
    public void savejudgment(RkProjectReportingUpForm rkProjectReportingUpForm) {
        RkProjectReportingEntity entity = this.getInfo(rkProjectReportingUpForm.getId());
        if (entity != null) {
            entity.setJudgmentRemark(rkProjectReportingUpForm.getJudgmentRemark());
            entity.setEnabledMark(rkProjectReportingUpForm.getEnabledMark());
            entity.setNextDealRole("end");
            this.updateById(entity);
            Integer dealResult = StrUtil.equals((CharSequence)rkProjectReportingUpForm.getEnabledMark(), (CharSequence)ProjectReportingEnum.PASS_NODE.getType()) ? 1 : 0;
            this.rkProjectReportingTrendsService.createTrends(ProjectReportingTrendsEnum.JUDGMENT_NODE.getType(), entity.getId(), entity.getCustomerId(), entity.getCustomerName(), entity.getCompanyId(), rkProjectReportingUpForm.getJudgmentRemark(), dealResult, null, null, 0);
            try {
                SentMessageForm sentMessageForm = this.userRelationUtil.getMessageForm(MessageTypeConst.PROJECT_REPORT_AUDIT_PUSH.getType(), MessageTypeConst.PROJECT_REPORT_AUDIT_PUSH.getTemplateCode());
                if (!ObjectUtil.isEmpty((Object)sentMessageForm)) {
                    sentMessageForm.setToUserIds(CollectionUtil.list((boolean)false, (Object[])new String[]{entity.getCreatorUserId()}));
                    sentMessageForm.setTitle("\u60a8\u7533\u8bf7\u7684\u9879\u76ee\u62a5\u5907\u5df2\u5ba1\u6279\u7ed3\u675f\uff0c\u8bf7\u77e5\u6089\uff01");
                    String type = entity.getReportingType() == 1 ? "\u957f\u671f\u9879\u76ee" : "\u51c6\u5ba2\u6237\u9879\u76ee";
                    String auditResult = dealResult == 1 ? "\u5ba1\u6279\u901a\u8fc7" : "\u5ba1\u6279\u9a73\u56de";
                    StringBuffer contentWechat = new StringBuffer();
                    contentWechat.append("\u5ba2\u6237\u540d\u79f0:" + entity.getCustomerName());
                    contentWechat.append("\n\u62a5\u5907\u7c7b\u578b:" + type);
                    contentWechat.append("\n\u9879\u76ee\u540d\u79f0:" + entity.getReportingProject());
                    contentWechat.append("\n\u5ba1\u6279\u7ed3\u679c:" + auditResult);
                    contentWechat.append("\n\u5ba1\u6279\u610f\u89c1:" + rkProjectReportingUpForm.getJudgmentRemark());
                    contentWechat.append("\n\u5ba1\u6279\u65f6\u95f4:" + DateUtil.dateFormat((Date)new Date()));
                    sentMessageForm.setContent(contentWechat.toString());
                    this.messagePush(sentMessageForm);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void saveProjectReconsiderInfo(RkProjectReportingReconsiderForm reconsiderForm) {
        RkProjectReportingEntity entity = this.getInfo(reconsiderForm.getId());
        if (entity != null) {
            entity.setIsMaterialComplete(reconsiderForm.getIsMaterialComplete());
            entity.setIsRepeatedFiling(reconsiderForm.getIsRepeatedFiling());
            entity.setReconsiderRemark(reconsiderForm.getReconsiderRemark());
            entity.setNextDealRole(ProjectReportingTrendsEnum.AUDIT_NODE.getType());
            this.updateById(entity);
            this.rkProjectReportingTrendsService.createTrends(ProjectReportingTrendsEnum.RECONSIDER_NODE.getType(), entity.getId(), entity.getCustomerId(), entity.getCustomerName(), entity.getCompanyId(), reconsiderForm.getReconsiderRemark(), 1, reconsiderForm.getIsRepeatedFiling(), reconsiderForm.getIsMaterialComplete(), 0);
            try {
                SentMessageForm sentMessageForm = this.userRelationUtil.getMessageForm(MessageTypeConst.PROJECT_REPORT_NEED_AUDIT.getType(), MessageTypeConst.PROJECT_REPORT_NEED_AUDIT.getTemplateCode());
                if (!ObjectUtil.isEmpty((Object)sentMessageForm)) {
                    sentMessageForm.setToUserIds(this.salesRoleUtils.getRegionalManager());
                    sentMessageForm.setTitle("\u6709\u9700\u8981\u5ba1\u6279\u7684\u62a5\u5907\u9879\u76ee\uff0c\u8bf7\u77e5\u6089\uff01");
                    String type = entity.getReportingType() == 1 ? "\u957f\u671f\u9879\u76ee" : "\u51c6\u5ba2\u6237\u9879\u76ee";
                    StringBuffer contentWechat = new StringBuffer();
                    contentWechat.append("\u5ba2\u6237\u540d\u79f0:" + entity.getCustomerName());
                    contentWechat.append("\n\u62a5\u5907\u7c7b\u578b:" + type);
                    contentWechat.append("\n\u9879\u76ee\u540d\u79f0:" + entity.getReportingProject());
                    contentWechat.append("\n\u62a5\u5907\u4eba:" + ((UserEntity)this.userService.getById((Serializable)((Object)entity.getCreatorUserId()))).getRealName());
                    contentWechat.append("\n\u590d\u8bae\u4eba:" + this.userProvider.get().getUserName());
                    contentWechat.append("\n\u7533\u8bf7\u65f6\u95f4:" + DateUtil.dateFormat((Date)new Date()));
                    sentMessageForm.setContent(contentWechat.toString());
                    this.messagePush(sentMessageForm);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public List<Map<String, Object>> countByEnabledMark(String enabledMark) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"count(*) as count,enabled_mark as enabledMark"});
        if (StringUtil.isNotEmpty((String)enabledMark)) {
            queryWrapper.lambda().eq(RkProjectReportingEntity::getEnabledMark, (Object)enabledMark);
        }
        queryWrapper.groupBy((Object)"enabled_mark");
        List listMaps = this.listMaps((Wrapper)queryWrapper);
        return listMaps;
    }

    @Override
    public List<Map<String, Object>> countByEnabledMark(RkProjectReportingPagination rkProjectReportingPagination) {
        QueryWrapper<RkProjectReportingEntity> queryWrapper = this.appendWhere(rkProjectReportingPagination);
        if (Objects.isNull(queryWrapper)) {
            return CollectionUtil.list((boolean)false);
        }
        queryWrapper.select(new String[]{"count(*) as count,enabled_mark as enabledMark"});
        queryWrapper.groupBy((Object)"enabled_mark");
        List listMaps = this.listMaps((Wrapper)queryWrapper);
        return listMaps;
    }

    @Override
    public List<Map<String, Object>> countBySaleStage(RkProjectReportingPagination rkProjectReportingPagination) {
        QueryWrapper<RkProjectReportingEntity> queryWrapper = this.appendWhere(rkProjectReportingPagination);
        if (Objects.isNull(queryWrapper)) {
            return CollectionUtil.list((boolean)false);
        }
        queryWrapper.select(new String[]{"count(*) as count,sale_stage as saleStage"});
        queryWrapper.groupBy((Object)"sale_stage");
        List listMaps = this.listMaps((Wrapper)queryWrapper);
        return listMaps;
    }

    @Override
    @DSTransactional
    public HashMap transfer(RkProjectReportingTrendsTransferForm trendsTransferForm) {
        UserInfo userInfo = this.userProvider.get();
        HashMap map = MapUtil.newHashMap();
        RkProjectReportingEntity info = this.getInfo(trendsTransferForm.getReportingId());
        if (ObjectUtil.isNull((Object)info)) {
            map.put("error", "\u62a5\u5907\u5546\u673a\u4e0d\u5b58\u5728");
            return map;
        }
        UserEntity userEntity = this.userService.getInfo(trendsTransferForm.getUserId());
        if (ObjectUtil.isNull((Object)userEntity)) {
            map.put("error", "\u7528\u6237\u4e0d\u5b58\u5728");
            return map;
        }
        OrganizeEntity organizeEntity = this.organizeService.getInfo(userEntity.getOrganizeId());
        if (null != organizeEntity) {
            info.setDepartment(organizeEntity.getId());
            info.setDepartmentName(organizeEntity.getFullName());
            String organizeIdTree = organizeEntity.getOrganizeIdTree();
            String[] organizeIdTreeArray = organizeIdTree.split(",");
            info.setDepartmentOne(organizeIdTreeArray[2]);
            info.setDepartmentOneName(this.baseDataUtil.comSelectValues(info.getDepartmentOne()));
            info.setDepartmentTree(organizeIdTree);
            info.setDepartmentTreeName(this.baseDataUtil.comSelectValues(info.getDepartmentTree()));
        }
        String oldFollowUser = this.baseDataUtil.userSelectValueNoAccount(info.getCreatorUserId());
        info.setCreatorUserId(trendsTransferForm.getUserId());
        info.setCreatorUserName(userEntity.getRealName());
        this.updateById(info);
        RkProjectReportingStageTrendsEntity trendsEntity = new RkProjectReportingStageTrendsEntity();
        trendsEntity.setId(RandomUtil.uuId());
        trendsEntity.setReportingId(trendsTransferForm.getReportingId());
        trendsEntity.setTrendsType(ProjectReportStageTrendsTypeEnum.TRANSFER.getType());
        trendsEntity.setOppId(info.getOppId());
        trendsEntity.setStageChangeDesc(userInfo.getUserName() + "\u8f6c\u79fb\u5546\u673a");
        trendsEntity.setDescription(trendsTransferForm.getDescription());
        this.rkProjectReportingStageTrendsService.save(trendsEntity);
        String dicName = this.baseDataUtil.getDictName(info.getSaleStage(), "ReportingSaleStage");
        try {
            String type = info.getReportingType() == 1 ? "\u957f\u671f\u9879\u76ee" : "\u51c6\u5ba2\u6237\u9879\u76ee";
            String taskCode = MessageTypeEnum.PROJECT_REPORT_TRANSFER.getMessage();
            String sendCode = MessageTypeEnum.PROJECT_REPORT_TRANSFER.getTemplateCode();
            HashMap keys = MapUtil.newHashMap();
            keys.put("title", "\u6709\u8f6c\u79fb\u7ed9\u60a8\u7684\u5546\u673a\u62a5\u5907\u4fe1\u606f\uff0c\u8bf7\u77e5\u6089\uff01");
            keys.put("content", userInfo.getUserName() + "\u628a\u3010" + info.getReportingProject() + "\u3011\u8f6c\u79fb\u7ed9\u60a8\uff01");
            keys.put("saleStage", dicName);
            keys.put("reportingProject", info.getReportingProject());
            keys.put("customerName", info.getCustomerName());
            keys.put("reportingType", type);
            keys.put("FollowUser", oldFollowUser);
            keys.put("transferUser", userInfo.getUserName());
            keys.put("MessageTime", DateUtil.getNow());
            String appUrl = "/#/pages/crm/crmReporting/Details?id=" + trendsTransferForm.getReportingId();
            String pcUrl = "/#/reporting/list?id=" + trendsTransferForm.getReportingId();
            String termType = TermTypeEnum.TERM_APP_PC.getCode();
            this.messageUtils.sendMessageNew(taskCode, sendCode, keys, null, appUrl, pcUrl, trendsTransferForm.getUserId(), termType, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    @Override
    public long countByCustomerId(String customerId) {
        RkProjectReportingPagination rkProjectReportingPagination = new RkProjectReportingPagination();
        rkProjectReportingPagination.setCustomerId(customerId);
        QueryWrapper<RkProjectReportingEntity> rkProjectReportingQueryWrapper = this.appendWhere(rkProjectReportingPagination);
        if (ObjectUtil.isNull(rkProjectReportingQueryWrapper)) {
            return 0L;
        }
        return this.count((Wrapper)rkProjectReportingQueryWrapper);
    }

    @Override
    public long countByCustomerId(String customerId, String menuId) {
        RkProjectReportingPagination pagination = new RkProjectReportingPagination();
        pagination.setCustomerId(customerId);
        pagination.setMenuId(menuId);
        QueryWrapper<RkProjectReportingEntity> rkProjectReportingQueryWrapper = this.appendWhere(pagination);
        if (ObjectUtil.isNull(rkProjectReportingQueryWrapper)) {
            return 0L;
        }
        return this.count((Wrapper)rkProjectReportingQueryWrapper);
    }

    @Override
    public List<RkProjectReportingEntity> getListByUserAndDate(List<String> userList, List<Date> dateList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (ObjectUtil.isNotEmpty(userList)) {
            queryWrapper.lambda().in(RkProjectReportingEntity::getCreatorUserId, userList);
        }
        if (ObjectUtil.isNotEmpty(dateList)) {
            queryWrapper.lambda().between(RkProjectReportingEntity::getCreatorTime, (Object)dateList.get(0), (Object)dateList.get(1));
        }
        queryWrapper.lambda().eq(RkProjectReportingEntity::getWinOrLose, (Object)1);
        return this.list((Wrapper)queryWrapper);
    }

    public void messagePush(SentMessageForm sentMessageForm) {
        if (ObjectUtil.isNull((Object)sentMessageForm)) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title", sentMessageForm.getTitle());
        map.put("content", sentMessageForm.getContent());
        map.put("AppUrl", sentMessageForm.getUrl());
        map.put("MessageTime", sentMessageForm.getMessageTime());
        sentMessageForm.setParameterMap(map);
        sentMessageForm.setBodyText(map);
        ArrayList<SentMessageForm> messageListAll = new ArrayList<SentMessageForm>();
        messageListAll.add(sentMessageForm);
    }

    @Override
    public List<RkProjectReportingEntity> notFollowByUserIdAndDay(String userId, Integer day) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(RkProjectReportingEntity::getCreatorUserId, (Object)userId)).eq(RkProjectReportingEntity::getWinOrLose, (Object)-1)).and(x -> ((LambdaQueryWrapper)x.lt(RkProjectReportingEntity::getLastFollowTime, (Object)DateUtil.dateAddDays((Date)DateUtil.getDayBegin(), (int)(day * -1)))).or(y -> ((LambdaQueryWrapper)y.isNull(RkProjectReportingEntity::getLastFollowTime)).lt(RkProjectReportingEntity::getApprovedTime, (Object)DateUtil.dateAddDays((Date)DateUtil.getDayBegin(), (int)(day * -1)))));
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkProjectReportingEntity> expectedSigning(String userId, Integer day) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(RkProjectReportingEntity::getCreatorUserId, (Object)userId)).eq(RkProjectReportingEntity::getWinOrLose, (Object)-1)).le(RkProjectReportingEntity::getExpectedSigningDate, (Object)DateUtil.dateAddDays((Date)DateUtil.getDayBegin(), (int)day));
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<RkProjectReportingEntity> getListByCustomerIdAndWinOrLoseIn(String customerId, List<Integer> winOrLoseList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RkProjectReportingEntity::getCustomerId, (Object)customerId);
        if (CollectionUtil.isNotEmpty(winOrLoseList)) {
            queryWrapper.in(RkProjectReportingEntity::getWinOrLose, winOrLoseList);
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public String getBillNumber(String enCode, boolean isCache) {
        String strNumber;
        String tenantId;
        String string = tenantId = !StringUtils.isEmpty((String)this.userProvider.get().getTenantId()) ? this.userProvider.get().getTenantId() : "";
        if (isCache) {
            String cacheKey = tenantId + this.userProvider.get().getUserId() + enCode;
            if (!this.cacheUtil.exists("foreverCacheSpace", cacheKey)) {
                strNumber = this.getNumber(enCode);
                this.cacheUtil.insert("foreverCacheSpace", cacheKey, (Object)strNumber);
            } else {
                strNumber = String.valueOf(this.cacheUtil.query("foreverCacheSpace", cacheKey));
            }
        } else {
            strNumber = this.getNumber(enCode);
        }
        return strNumber;
    }

    private BillRuleEntity getBillRule(String enCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(BillRuleEntity::getEnCode, (Object)enCode);
        BillRuleEntity entity = (BillRuleEntity)this.billRuleMapper.selectOne((Wrapper)queryWrapper);
        return entity;
    }

    public String getNumber(String enCode) throws DataException {
        Integer startNumber;
        StringBuilder strNumber = new StringBuilder();
        BillRuleEntity entity = this.getBillRule(enCode);
        if (entity != null) {
            startNumber = Integer.parseInt(entity.getStartNumber());
            String dateFor = entity.getDateFormat();
            if (StringUtils.isNotEmpty((String)entity.getOutputNumber())) {
                entity.setThisNumber(Integer.valueOf(entity.getThisNumber() + 1));
                if (!"no".equals(dateFor)) {
                    String thisDate = DateUtil.dateNow((String)entity.getDateFormat());
                    String serialDate = entity.getOutputNumber().substring(entity.getOutputNumber().length() - dateFor.length() - entity.getDigit(), entity.getOutputNumber().length() - entity.getDigit());
                    if (!serialDate.equals(thisDate)) {
                        entity.setThisNumber(Integer.valueOf(0));
                    }
                }
            } else {
                entity.setThisNumber(Integer.valueOf(0));
            }
            strNumber.append(entity.getPrefix());
            if (!"no".equals(dateFor)) {
                strNumber.append(DateUtil.dateNow((String)entity.getDateFormat()));
            }
        } else {
            throw new DataException("\u5355\u636e\u89c4\u5219\u4e0d\u5b58\u5728");
        }
        strNumber.append(PadUtil.padRight((String)String.valueOf(startNumber + entity.getThisNumber()), (int)entity.getDigit(), (char)'0'));
        entity.setOutputNumber(strNumber.toString());
        return strNumber.toString();
    }

    @Override
    public void stopOrStart(RkProjectReportingStopForm stopForm) {
        RkProjectReportingEntity entity = this.getInfo(stopForm.getReportingId());
        if (entity != null) {
            entity.setStopDesc(stopForm.getStopDesc());
            entity.setStopTime(DateUtil.getNowDate());
            RkProjectReportingStageTrendsEntity trendsEntity = new RkProjectReportingStageTrendsEntity();
            trendsEntity.setId(RandomUtil.uuId());
            trendsEntity.setReportingId(stopForm.getReportingId());
            if (ObjectUtil.equal((Object)stopForm.getType(), (Object)1)) {
                entity.setEnabledMark(ProjectReportingEnum.STOP_NODE.getType());
                if (CollectionUtil.isNotEmpty(stopForm.getStopDateList())) {
                    entity.setStopStartDate(stopForm.getStopDateList().get(0));
                    entity.setStopEndDate(stopForm.getStopDateList().get(1));
                }
                trendsEntity.setDescription(stopForm.getStopDesc());
                trendsEntity.setTrendsType(ProjectReportStageTrendsTypeEnum.STOP.getType());
                trendsEntity.setStageChangeDesc("\u5546\u673a\u6682\u505c");
            } else {
                entity.setEnabledMark(ProjectReportingEnum.PASS_NODE.getType());
                trendsEntity.setTrendsType(ProjectReportStageTrendsTypeEnum.CANCEL_STOP.getType());
                trendsEntity.setStageChangeDesc("\u5546\u673a\u53d6\u6d88\u6682\u505c");
                trendsEntity.setDescription(stopForm.getStopDesc());
                UpdateWrapper updateWrapper = new UpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.lambda().set(RkProjectReportingEntity::getStopStartDate, null)).set(RkProjectReportingEntity::getStopEndDate, null)).eq(RkProjectReportingEntity::getId, (Object)stopForm.getReportingId());
                this.update((Wrapper)updateWrapper);
                entity.setStopStartDate(null);
                entity.setStopEndDate(null);
            }
            this.update(stopForm.getReportingId(), entity);
            trendsEntity.setOppId(entity.getOppId());
            trendsEntity.setFollowTime(DateUtil.getNowDate());
            this.rkProjectReportingStageTrendsService.save(trendsEntity);
        }
    }

    @Override
    public List<RkProjectReportingEntity> getNeedToWarnList(String s, String toTestUserAccount) {
        return this.rkProjectReportingMapper.getNeedToWarnList(s, toTestUserAccount);
    }

    @Override
    public List<RkProjectReportingEntity> getNeedToWarnListGroupBy(String s, String toTestUserAccount) {
        return this.rkProjectReportingMapper.getNeedToWarnListGroupBy(s, toTestUserAccount);
    }

    @Override
    public void appendBrokerInfo(RkProjectReportingListVO rkProjectReportingVO) {
        String agentId = "";
        if (StringUtils.isNotEmpty((String)rkProjectReportingVO.getBrokerId())) {
            agentId = rkProjectReportingVO.getBrokerId();
        } else if (StringUtils.isNotEmpty((String)rkProjectReportingVO.getChannelId())) {
            agentId = rkProjectReportingVO.getChannelId();
            rkProjectReportingVO.setBrokerContactName(rkProjectReportingVO.getChannelContact());
            rkProjectReportingVO.setBrokerPhone(rkProjectReportingVO.getChannelContactPhone());
        } else if (StringUtils.isNotEmpty((String)rkProjectReportingVO.getIntegratorName())) {
            rkProjectReportingVO.setBrokerName(rkProjectReportingVO.getIntegratorName());
            rkProjectReportingVO.setBrokerContactName(rkProjectReportingVO.getIntegratorProjectManager());
            rkProjectReportingVO.setBrokerPhone(rkProjectReportingVO.getIntegratorContactPhone());
        }
        if (StrUtil.isNotEmpty((CharSequence)agentId)) {
            RkAgentEntity agent = this.rkAgentService.getInfo(agentId);
            rkProjectReportingVO.setBrokerName(ObjectUtil.isNull((Object)agent) ? "" : agent.getName());
        }
    }

    @Override
    public List<RkProjectReportingEntity> connectContactResource(CrmDepartConnectEntity connectEntity) {
        if (StrUtil.isBlank((CharSequence)connectEntity.getObjectId()) || StringUtils.isBlank((CharSequence)connectEntity.getConnectUser())) {
            return new ArrayList<RkProjectReportingEntity>();
        }
        List<String> idsList = Arrays.asList(connectEntity.getObjectId().split(","));
        if (CollectionUtil.isNotEmpty(idsList)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(RkProjectReportingEntity::getId, idsList);
            List reportingList = this.list((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)reportingList)) {
                String salerName = this.baseDataUtil.userSelectValueNoAccount(connectEntity.getConnectUser());
                reportingList.forEach(x -> {
                    x.setOriginalCreatorUserId(connectEntity.getResignUser());
                    x.setCreatorUserId(connectEntity.getConnectUser());
                    x.setConnectType(connectEntity.getConnectType());
                    if (StrUtil.isBlank((CharSequence)x.getConnectRecords())) {
                        ArrayList<CrmDepartConnectEntity> connectEntityList = new ArrayList<CrmDepartConnectEntity>();
                        connectEntityList.add(connectEntity);
                        x.setConnectRecords(JSON.toJSONString(connectEntityList));
                    } else {
                        List departConnectEntities = JsonUtil.getJsonToList((String)x.getConnectRecords(), CrmDepartConnectEntity.class);
                        departConnectEntities.add(connectEntity);
                        x.setConnectRecords(JSON.toJSONString((Object)departConnectEntities));
                    }
                });
                QueryWrapper quotationQueryWrapper = new QueryWrapper();
                quotationQueryWrapper.lambda().in(SaleQuotationEntity::getOpportunityId, idsList);
                quotationQueryWrapper.lambda().eq(SaleQuotationEntity::getQuotationUser, (Object)connectEntity.getResignUser());
                List quotationList = this.saleQuotationService.list((Wrapper)quotationQueryWrapper);
                if (CollectionUtil.isNotEmpty((Collection)quotationList)) {
                    quotationList.forEach(x -> {
                        x.setQuotationUser(connectEntity.getConnectUser());
                        if (StrUtil.isBlank((CharSequence)x.getConnectRecords())) {
                            ArrayList<CrmDepartConnectEntity> connectEntityList = new ArrayList<CrmDepartConnectEntity>();
                            connectEntityList.add(connectEntity);
                            x.setConnectRecords(JSON.toJSONString(connectEntityList));
                        } else {
                            List departConnectEntities = JsonUtil.getJsonToList((String)x.getConnectRecords(), CrmDepartConnectEntity.class);
                            departConnectEntities.add(connectEntity);
                            x.setConnectRecords(JSON.toJSONString((Object)departConnectEntities));
                        }
                    });
                    this.saleQuotationService.updateBatchById(quotationList);
                    List quotationIds = quotationList.stream().map(SaleQuotationEntity::getId).collect(Collectors.toList());
                    QueryWrapper profitWrapper = new QueryWrapper();
                    profitWrapper.lambda().in(SaleQuotationProfitEntity::getQuotationId, quotationIds);
                    profitWrapper.lambda().eq(SaleQuotationProfitEntity::getSaleId, (Object)connectEntity.getResignUser());
                    List profitList = this.saleQuotationProfitService.list((Wrapper)profitWrapper);
                    if (CollectionUtil.isNotEmpty((Collection)profitList)) {
                        profitList.forEach(x -> {
                            x.setSaleId(connectEntity.getConnectUser());
                            if (StrUtil.isBlank((CharSequence)x.getConnectRecords())) {
                                ArrayList<CrmDepartConnectEntity> connectEntityList = new ArrayList<CrmDepartConnectEntity>();
                                connectEntityList.add(connectEntity);
                                x.setConnectRecords(JSON.toJSONString(connectEntityList));
                            } else {
                                List departConnectEntities = JsonUtil.getJsonToList((String)x.getConnectRecords(), CrmDepartConnectEntity.class);
                                departConnectEntities.add(connectEntity);
                                x.setConnectRecords(JSON.toJSONString((Object)departConnectEntities));
                            }
                        });
                        this.saleQuotationProfitService.updateBatchById(profitList);
                    }
                }
            }
            this.updateBatchById(reportingList);
            return reportingList;
        }
        return new ArrayList<RkProjectReportingEntity>();
    }

    @Override
    public RkProjectReportingInfoVO getReportingForContract(String reportingId) {
        RkProjectReportingEntity reportingEntity = this.getInfo(reportingId);
        RkProjectReportingInfoVO vo = new RkProjectReportingInfoVO();
        if (null != reportingEntity) {
            CrmCustomerEntity customer;
            vo = (RkProjectReportingInfoVO)JsonUtil.getJsonToBean((Object)reportingEntity, RkProjectReportingInfoVO.class);
            if (StringUtils.isNotEmpty((String)vo.getCustomerId()) && null != (customer = this.crmCustomerService.getInfo(vo.getCustomerId()))) {
                vo.setCustomerName(customer.getName());
                vo.setCustomerAddress(customer.getAddress());
            }
            ArrayList<RkContractProductCrForm> productList = new ArrayList<RkContractProductCrForm>();
            if (StringUtils.isNotEmpty((String)vo.getProductId())) {
                CrmProductPagination crmProductPagination = new CrmProductPagination();
                crmProductPagination.setIsAuth(0);
                crmProductPagination.setProductIds(vo.getProductId());
                List<CrmProductEntity> crmProductList = this.crmProductService.getList(crmProductPagination);
                List<CrmProductVersionEntity> versionEntityList = null;
                List versionEntityListVO = null;
                RkContractProductCrForm product = null;
                for (CrmProductEntity crmProduct : crmProductList) {
                    product = new RkContractProductCrForm();
                    product.setProductId(crmProduct.getId());
                    product.setProductName(crmProduct.getProductName());
                    product.setProductCode(crmProduct.getProductCode());
                    product.setNum("1");
                    versionEntityList = this.crmProductVersionService.getListByProductId(crmProduct.getId());
                    versionEntityListVO = JsonUtil.getJsonToList(versionEntityList, CrmProductVersionListVO.class);
                    product.setVersionList(versionEntityListVO);
                    product.setProductVersion(crmProduct.getProductVersion());
                    product.setProductAmount(BigDecimal.ZERO);
                    product.setAllocationRatio("0");
                    productList.add(product);
                }
            }
            vo.setProductList(productList);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(SaleQuotationEntity::getOpportunityId, (Object)reportingId);
            queryWrapper.lambda().eq(SaleQuotationEntity::getState, (Object)2);
            queryWrapper.lambda().orderByDesc(SaleQuotationEntity::getId);
            List quotationList = this.saleQuotationService.list((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)quotationList)) {
                vo.setLatestQuotationId(((SaleQuotationEntity)quotationList.get(0)).getId());
            }
        }
        return vo;
    }

    @Override
    public List getReportingTransform(RkReportingTransformPagination pagination) {
        UserInfo userInfo = this.userProvider.get();
        List userEntities = CollectionUtil.list((boolean)false);
        if (!userInfo.getIsAdministrator().booleanValue()) {
            QueryWrapper userEntityQueryWrapper = new QueryWrapper();
            Object reportingTransformObj = this.authorizeService.getCondition(new AuthorizeConditionModel(userEntityQueryWrapper, pagination.getMenuId(), "base_user"));
            if (ObjectUtil.isEmpty((Object)reportingTransformObj)) {
                userEntities = this.userService.getListByOraganizetionId(userInfo.getOrganizeId());
            } else {
                userEntityQueryWrapper = (QueryWrapper)reportingTransformObj;
                userEntities = this.userService.list((Wrapper)userEntityQueryWrapper);
            }
        }
        if (StringUtils.isNotEmpty((String)pagination.getCompanyId())) {
            List<String> companyArray = Arrays.asList(pagination.getCompanyId().split(","));
            for (String companyId : companyArray) {
                userEntities.addAll(this.userService.getListByOraganizetionId(companyId));
            }
        }
        if (StringUtils.isEmpty((String)pagination.getDataType()) || !StringUtils.equals((CharSequence)pagination.getDataType(), (CharSequence)"1")) {
            PageHelper.startPage((int)((int)pagination.getCurrentPage()), (int)((int)pagination.getPageSize()));
        }
        String startDate = "";
        String endDate = "";
        if (CollectionUtil.isNotEmpty(pagination.getCreatorTime())) {
            startDate = DateUtil.formatDate((Date)pagination.getCreatorTime().get(0)) + " 00:00:00";
            endDate = DateUtil.formatDate((Date)pagination.getCreatorTime().get(1)) + " 23:59:59";
        }
        List collect = userEntities.stream().map(UserEntity::getId).collect(Collectors.toList());
        if (StrUtil.isNotEmpty((CharSequence)pagination.getUserId())) {
            if (CollectionUtil.contains(collect, (Object)pagination.getUserId()) || userInfo.getIsAdministrator().booleanValue()) {
                collect = CollectionUtil.list((boolean)false, (Object[])new String[]{pagination.getUserId()});
            } else {
                PageInfo pageInfo = new PageInfo(CollectionUtil.list((boolean)false));
                return pagination.setData(pageInfo.getList(), pageInfo.getTotal());
            }
        }
        List reportingTransform = this.rkProjectReportingMapper.getReportingTransform(startDate, endDate, collect);
        PageInfo pageInfo = new PageInfo(reportingTransform);
        return pagination.setData(pageInfo.getList(), pageInfo.getTotal());
    }

    @Override
    public Map<String, Object> countBySaleStageAmount(RkProjectReportingPagination rkProjectReportingPagination) {
        HashMap map = MapUtil.newHashMap();
        map.put("negotiateContractsAmount", "0");
        map.put("winAmount", "0");
        map.put("loseAmount", "0");
        rkProjectReportingPagination.setSaleStage(null);
        QueryWrapper<RkProjectReportingEntity> queryWrapper = this.appendWhere(rkProjectReportingPagination);
        if (Objects.isNull(queryWrapper)) {
            return map;
        }
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            BigDecimal negotiateContractsAmount = list.stream().filter(x -> StrUtil.equals((CharSequence)x.getSaleStage(), (CharSequence)"negotiateContracts")).filter(x -> ObjectUtil.isNotEmpty((Object)x.getEstimatedSigningAmount())).map(RkProjectReportingEntity::getEstimatedSigningAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            map.put("negotiateContractsAmount", negotiateContractsAmount);
            BigDecimal winAmount = list.stream().filter(x -> StrUtil.equals((CharSequence)x.getSaleStage(), (CharSequence)"win")).filter(x -> ObjectUtil.isNotEmpty((Object)x.getEstimatedSigningAmount())).map(RkProjectReportingEntity::getEstimatedSigningAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            map.put("winAmount", winAmount);
            BigDecimal loseAmount = list.stream().filter(x -> StrUtil.equals((CharSequence)x.getSaleStage(), (CharSequence)"lose")).filter(x -> ObjectUtil.isNotEmpty((Object)x.getEstimatedSigningAmount())).map(RkProjectReportingEntity::getEstimatedSigningAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            map.put("loseAmount", loseAmount);
        }
        return map;
    }
}

