/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.ConvertUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.constant.MessageTypeEnum;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.service.CrmProductPriceService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.quotation.constant.TemplateEnableMarkEnum;
import com.bringspring.quotation.entity.SaleQuotationTemplateEntity;
import com.bringspring.quotation.service.SaleQuotationTemplateService;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.DictionaryTypeService;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.MessageUtils;
import com.bringspring.utils.StrUtils;
import com.bringspring.visit.constant.OpportunityTypeEnum;
import com.bringspring.visit.entity.RkProjectReportingEntity;
import com.bringspring.visit.entity.RkReportingProductPriceEntity;
import com.bringspring.visit.entity.RkReportingProductPriceItemEntity;
import com.bringspring.visit.mapper.RkReportingProductPriceMapper;
import com.bringspring.visit.model.rkreportingproductprice.RkReportingProductPriceCrForm;
import com.bringspring.visit.model.rkreportingproductprice.RkReportingProductPriceInfoVO;
import com.bringspring.visit.model.rkreportingproductprice.RkReportingProductPriceItemModel;
import com.bringspring.visit.model.rkreportingproductprice.RkReportingProductPricePagination;
import com.bringspring.visit.model.rkreportingproductprice.RkReportingProductPriceUpForm;
import com.bringspring.visit.service.RkProjectReportingService;
import com.bringspring.visit.service.RkReportingProductPriceItemService;
import com.bringspring.visit.service.RkReportingProductPriceService;
import com.bringspring.visit.utils.SalesHeadEnum;
import com.bringspring.visit.utils.UserRelationUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RkReportingProductPriceServiceImpl
extends ServiceImpl<RkReportingProductPriceMapper, RkReportingProductPriceEntity>
implements RkReportingProductPriceService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RkReportingProductPriceItemService rkReportingProductPriceItemService;
    @Autowired
    private RkProjectReportingService rkProjectReportingService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmProductPriceService crmProductPriceService;
    @Autowired
    private DictionaryTypeService dictionaryTypeService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private UserRelationUtil userRelationUtil;
    @Autowired
    private SaleQuotationTemplateService saleQuotationTemplateService;

    @Override
    public List<RkReportingProductPriceEntity> getList(RkReportingProductPricePagination rkReportingProductPricePagination) {
        QueryWrapper<RkReportingProductPriceEntity> rkReportingProductPriceQueryWrapper = this.appendWrapper(rkReportingProductPricePagination);
        if (1 == rkReportingProductPricePagination.getIsPage()) {
            Page page = new Page(rkReportingProductPricePagination.getCurrentPage(), rkReportingProductPricePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkReportingProductPriceQueryWrapper);
            return rkReportingProductPricePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return this.list((Wrapper)rkReportingProductPriceQueryWrapper);
    }

    private QueryWrapper<RkReportingProductPriceEntity> appendWrapper(RkReportingProductPricePagination pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean permission = true;
        Integer isAuth = pagination.getIsAuth();
        if (0 == isAuth) {
            permission = false;
        }
        if (permission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            Object queryObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "rk_reporting_product_price"));
            if (ObjectUtil.isEmpty((Object)queryObj)) {
                queryWrapper.lambda().eq(RkReportingProductPriceEntity::getCreatorUserId, (Object)this.userProvider.get().getUserId());
            } else {
                queryWrapper = (QueryWrapper)queryObj;
            }
        }
        if (StringUtils.isNotEmpty((String)pagination.getReportingId())) {
            queryWrapper.lambda().eq(RkReportingProductPriceEntity::getReportingId, (Object)pagination.getReportingId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getTitle())) {
            queryWrapper.lambda().like(RkReportingProductPriceEntity::getTitle, (Object)pagination.getTitle());
        }
        if (1 == pagination.getIsSort()) {
            if (StringUtils.isEmpty((String)pagination.getSidx())) {
                queryWrapper.lambda().orderByDesc(RkReportingProductPriceEntity::getId);
            } else {
                try {
                    String sidx = pagination.getSidx();
                    RkReportingProductPriceEntity rkReportingProductPriceEntity = new RkReportingProductPriceEntity();
                    Field declaredField = rkReportingProductPriceEntity.getClass().getDeclaredField(sidx);
                    declaredField.setAccessible(true);
                    String value = declaredField.getAnnotation(TableField.class).value();
                    queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
        }
        return queryWrapper;
    }

    @Override
    public List<RkReportingProductPriceEntity> getTypeList(RkReportingProductPricePagination rkReportingProductPricePagination, String dataType) {
        QueryWrapper<RkReportingProductPriceEntity> rkReportingProductPriceQueryWrapper = this.appendWrapper(rkReportingProductPricePagination);
        if ("0".equals(dataType)) {
            Page page = new Page(rkReportingProductPricePagination.getCurrentPage(), rkReportingProductPricePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)rkReportingProductPriceQueryWrapper);
            return rkReportingProductPricePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        return this.list((Wrapper)rkReportingProductPriceQueryWrapper);
    }

    @Override
    public RkReportingProductPriceEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkReportingProductPriceEntity::getId, (Object)id);
        return (RkReportingProductPriceEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(RkReportingProductPriceCrForm rkReportingProductPriceCrForm) {
        String mainId = RandomUtil.uuId();
        RkReportingProductPriceEntity entity = (RkReportingProductPriceEntity)JsonUtil.getJsonToBean((Object)rkReportingProductPriceCrForm, RkReportingProductPriceEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    public void update(String id, RkReportingProductPriceUpForm rkReportingProductPriceUpForm) {
        UserInfo userInfo = this.userProvider.get();
        RkReportingProductPriceEntity entity = this.getInfo(id);
        if (entity != null) {
            RkReportingProductPriceEntity subentity = (RkReportingProductPriceEntity)JsonUtil.getJsonToBean((Object)rkReportingProductPriceUpForm, RkReportingProductPriceEntity.class);
            this.updateById(subentity);
        }
    }

    @Override
    public void delete(RkReportingProductPriceEntity entity) {
        if (entity != null) {
            this.rkReportingProductPriceItemService.removeByPriceId(entity.getId());
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public void insertInfo(RkReportingProductPriceCrForm rkReportingProductPriceCrForm) {
        String mainId = RandomUtil.uuId();
        RkReportingProductPriceEntity entity = (RkReportingProductPriceEntity)JsonUtil.getJsonToBean((Object)rkReportingProductPriceCrForm, RkReportingProductPriceEntity.class);
        entity.setId(mainId);
        this.save(entity);
        List<RkReportingProductPriceItemEntity> priceItemList = rkReportingProductPriceCrForm.getProductPriceItemList();
        if (CollectionUtil.isNotEmpty(priceItemList)) {
            for (RkReportingProductPriceItemEntity priceItem : priceItemList) {
                priceItem.setId(RandomUtil.uuId());
                priceItem.setPriceId(mainId);
                priceItem.setReportingId(entity.getReportingId());
            }
            this.rkReportingProductPriceItemService.saveBatch(priceItemList);
        }
        this.messageNotice(entity);
    }

    @Override
    public void editInfo(String id, RkReportingProductPriceUpForm rkReportingProductPriceUpForm) throws DataException {
        RkReportingProductPriceEntity entity = this.getInfo(id);
        if (null == entity) {
            throw new DataException("\u4ef7\u683c\u5907\u6848\u4e0d\u5b58\u5728");
        }
        RkReportingProductPriceEntity subEntity = (RkReportingProductPriceEntity)JsonUtil.getJsonToBean((Object)rkReportingProductPriceUpForm, RkReportingProductPriceEntity.class);
        this.updateById(subEntity);
        this.rkReportingProductPriceItemService.removeByPriceId(subEntity.getId());
        List<RkReportingProductPriceItemEntity> priceItemList = rkReportingProductPriceUpForm.getProductPriceItemList();
        if (CollectionUtil.isNotEmpty(priceItemList)) {
            for (RkReportingProductPriceItemEntity priceItem : priceItemList) {
                priceItem.setId(RandomUtil.uuId());
                priceItem.setPriceId(subEntity.getId());
                priceItem.setReportingId(subEntity.getReportingId());
            }
            this.rkReportingProductPriceItemService.saveBatch(priceItemList);
        }
    }

    @Override
    public RkReportingProductPriceInfoVO initInfo(String reportingId) throws DataException {
        RkProjectReportingEntity reportingEntity = this.rkProjectReportingService.getInfo(reportingId);
        if (null == reportingEntity) {
            throw new DataException("\u5546\u673a\u62a5\u5907\u4e0d\u5b58\u5728");
        }
        RkReportingProductPriceInfoVO vo = new RkReportingProductPriceInfoVO();
        vo.setCompanyId(reportingEntity.getCompanyId());
        vo.setReportingId(reportingEntity.getId());
        vo.setReportingName(reportingEntity.getReportingProject());
        vo.setTitle(vo.getReportingName() + "\u4ef7\u683c\u5907\u6848-" + DateUtil.getDateString((Date)new Date(), (String)"yyyy-MM-dd"));
        vo.setProductType(reportingEntity.getProductType());
        vo.setProductId(reportingEntity.getProductId());
        vo.setProductName(reportingEntity.getProductName());
        vo.setOpportunityType(reportingEntity.getOpportunityType());
        vo.setCustomerId(reportingEntity.getCustomerId());
        vo.setCustomerName(reportingEntity.getCustomerName());
        vo.setGarde(reportingEntity.getGarde());
        vo.setCreatorTime(DateUtil.getNowDate().getTime());
        vo.setTotalAmount(BigDecimal.ZERO);
        vo.setFloorTotalAmount(BigDecimal.ZERO);
        QueryWrapper priceCountQuery = new QueryWrapper();
        priceCountQuery.lambda().eq(RkReportingProductPriceEntity::getReportingId, (Object)reportingId);
        vo.setHistoryCount(this.count((Wrapper)priceCountQuery));
        ArrayList<RkReportingProductPriceItemModel> priceItemList = new ArrayList<RkReportingProductPriceItemModel>();
        if (StringUtils.isNotEmpty((String)reportingEntity.getProductId())) {
            List<CrmProductEntity> productList = this.crmProductService.getListByProductIds(Arrays.asList(reportingEntity.getProductId().split(",")));
            List priceList = null;
            if (CollectionUtil.isNotEmpty(productList)) {
                RkReportingProductPriceItemModel item = null;
                QueryWrapper templateQuery = null;
                BigDecimal floorTotalAmount = BigDecimal.ZERO;
                for (CrmProductEntity product : productList) {
                    item = new RkReportingProductPriceItemModel();
                    item.setProductId(product.getId());
                    item.setProductName(product.getProductName());
                    item.setCategoryId(product.getCategoryId());
                    templateQuery = new QueryWrapper();
                    templateQuery.lambda().eq(SaleQuotationTemplateEntity::getDeleteFlag, (Object)"0");
                    templateQuery.lambda().eq(SaleQuotationTemplateEntity::getEnabledMark, (Object)TemplateEnableMarkEnum.ENABLE.getEnableMark());
                    templateQuery.lambda().and(x -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(SaleQuotationTemplateEntity::getIsUnLimitUse, (Object)"1")).or(a -> {
                            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)a.le(SaleQuotationTemplateEntity::getActiveStartTime, (Object)new Date())).ge(SaleQuotationTemplateEntity::getActiveEndTime, (Object)new Date());
                        });
                    });
                    templateQuery.lambda().eq(SaleQuotationTemplateEntity::getProductId, (Object)product.getId());
                    if (StringUtils.isNotEmpty((String)vo.getGarde())) {
                        templateQuery.and(x -> {
                            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.apply(" FIND_IN_SET(" + vo.getGarde() + ",hospital_level)", new Object[0])).or()).apply(" hospital_level is null or hospital_level = ''", new Object[0]);
                        });
                    }
                    templateQuery.lambda().eq(SaleQuotationTemplateEntity::getCompanyId, (Object)vo.getCompanyId());
                    priceList = this.saleQuotationTemplateService.list((Wrapper)templateQuery);
                    if (CollectionUtil.isNotEmpty((Collection)priceList) && priceList.size() == 1) {
                        item.setTemplateId(((SaleQuotationTemplateEntity)priceList.get(0)).getId());
                        item.setTemplateName(((SaleQuotationTemplateEntity)priceList.get(0)).getTemplateName());
                        item.setStandardPrice(ConvertUtil.toBigDecimal((Object)((SaleQuotationTemplateEntity)priceList.get(0)).getStandardTotalAmount(), (BigDecimal)BigDecimal.ZERO));
                        if (OpportunityTypeEnum.CHANNEL.getEnCode().equals(reportingEntity.getOpportunityType())) {
                            item.setFloorPrice(ConvertUtil.toBigDecimal((Object)((SaleQuotationTemplateEntity)priceList.get(0)).getChannelTotalAmount(), (BigDecimal)BigDecimal.ZERO));
                        } else {
                            item.setFloorPrice(ConvertUtil.toBigDecimal((Object)((SaleQuotationTemplateEntity)priceList.get(0)).getTotalAmount(), (BigDecimal)BigDecimal.ZERO));
                        }
                    }
                    item.setNumber(1);
                    item.setFloorTotalAmount(ConvertUtil.toBigDecimal((Object)item.getFloorPrice(), (BigDecimal)BigDecimal.ZERO));
                    floorTotalAmount = floorTotalAmount.add(item.getFloorTotalAmount());
                    priceItemList.add(item);
                }
                vo.setFloorTotalAmount(floorTotalAmount);
            }
        }
        vo.setProductPriceItemList(priceItemList);
        return vo;
    }

    @Override
    public void messageNotice(RkReportingProductPriceEntity entity) {
        Map<String, SalesHeadEnum> allToMap;
        SalesHeadEnum headEnum;
        List<UserRelationEntity> roleUsers;
        if (null == entity) {
            return;
        }
        UserInfo userInfo = this.userProvider.get();
        String taskCode = MessageTypeEnum.REPORTING_PRICE_RECORD.getMessage();
        String sendCode = MessageTypeEnum.REPORTING_PRICE_RECORD.getTemplateCode();
        HashMap keys = MapUtil.newHashMap();
        keys.put("title", entity.getTitle());
        RkProjectReportingEntity reportingEntity = this.rkProjectReportingService.getInfo(entity.getReportingId());
        if (null != reportingEntity) {
            keys.put("reportingName", reportingEntity.getReportingProject());
            keys.put("customerName", reportingEntity.getCustomerName());
        }
        keys.put("salerName", userInfo.getRealName());
        keys.put("productName", entity.getProductName());
        keys.put("floorTotalAmount", StrUtils.formatAmount(entity.getFloorTotalAmount()));
        keys.put("totalAmount", StrUtils.formatAmount(entity.getTotalAmount()));
        keys.put("MessageTime", DateUtil.getNow());
        String appUrl = "/#/pages/crm/crmReporting/Details?id=" + entity.getReportingId();
        String pcUrl = "/#/reporting/list?id=" + entity.getReportingId();
        String termType = TermTypeEnum.TERM_APP_PC.getCode();
        ArrayList<String> userIds = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)userInfo.getManagerId())) {
            userIds.add(userInfo.getManagerId());
        }
        if (CollectionUtil.isNotEmpty(roleUsers = this.userRelationUtil.getListByRoleCode((headEnum = (allToMap = SalesHeadEnum.getAllToMap()).get(userInfo.getOrganizeId())).getRole()))) {
            userIds.addAll(roleUsers.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList()));
        }
        this.messageUtils.sendMessageNew(taskCode, sendCode, keys, null, appUrl, pcUrl, CollectionUtil.join(userIds, (CharSequence)","), termType, null);
    }

    @Override
    public RkReportingProductPriceInfoVO detailByReporting(String reportingId) {
        List<RkReportingProductPriceEntity> priceList = this.getListByReportingId(reportingId);
        if (CollectionUtil.isNotEmpty(priceList)) {
            RkReportingProductPriceInfoVO vo = (RkReportingProductPriceInfoVO)JsonUtil.getJsonToBean((Object)priceList.get(0), RkReportingProductPriceInfoVO.class);
            List<RkReportingProductPriceItemEntity> itemEntityList = this.rkReportingProductPriceItemService.queryByPriceId(vo.getId());
            List modelList = JsonUtil.getJsonToList(itemEntityList, RkReportingProductPriceItemModel.class);
            SaleQuotationTemplateEntity templateEntity = null;
            for (RkReportingProductPriceItemModel model : modelList) {
                if (!StringUtils.isNotEmpty((String)model.getTemplateId()) || null == (templateEntity = this.saleQuotationTemplateService.getInfo(model.getTemplateId()))) continue;
                model.setTemplateName(templateEntity.getTemplateName());
            }
            vo.setProductPriceItemList(modelList);
            return vo;
        }
        return null;
    }

    @Override
    public List<RkReportingProductPriceEntity> getListByReportingId(String reportingId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(RkReportingProductPriceEntity::getReportingId, (Object)reportingId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public RkReportingProductPriceInfoVO queryInfo(String id) {
        RkProjectReportingEntity reportingEntity;
        RkReportingProductPriceEntity entity = this.getInfo(id);
        RkReportingProductPriceInfoVO vo = (RkReportingProductPriceInfoVO)JsonUtil.getJsonToBean((Object)entity, RkReportingProductPriceInfoVO.class);
        if (StringUtils.isNotEmpty((String)entity.getReportingId()) && null != (reportingEntity = this.rkProjectReportingService.getInfo(entity.getReportingId()))) {
            vo.setReportingName(reportingEntity.getReportingProject());
        }
        List<RkReportingProductPriceItemEntity> itemEntityList = this.rkReportingProductPriceItemService.queryByPriceId(vo.getId());
        List modelList = JsonUtil.getJsonToList(itemEntityList, RkReportingProductPriceItemModel.class);
        SaleQuotationTemplateEntity templateEntity = null;
        for (RkReportingProductPriceItemModel model : modelList) {
            if (!StringUtils.isNotEmpty((String)model.getTemplateId()) || null == (templateEntity = this.saleQuotationTemplateService.getInfo(model.getTemplateId()))) continue;
            model.setTemplateName(templateEntity.getTemplateName());
        }
        vo.setProductPriceItemList(modelList);
        return vo;
    }
}

