/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.visit.entity.VisitContactEntity;
import com.bringspring.visit.mapper.VisitContactMapper;
import com.bringspring.visit.model.visitcontact.VisitContactCrForm;
import com.bringspring.visit.model.visitcontact.VisitContactPagination;
import com.bringspring.visit.model.visitcontact.VisitCustomerContactCrForm;
import com.bringspring.visit.service.VisitContactService;
import com.bringspring.visit.utils.DeleteMarkEnum;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VisitContactServiceImpl
extends ServiceImpl<VisitContactMapper, VisitContactEntity>
implements VisitContactService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public List<VisitContactEntity> getList(VisitContactPagination visitContactPagination) {
        Object visitContactObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int visitContactNum = 0;
        QueryWrapper visitContactQueryWrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty((String)visitContactPagination.getCreatorUserId())) {
            ++visitContactNum;
            visitContactQueryWrapper.lambda().eq(VisitContactEntity::getCreatorUserId, (Object)visitContactPagination.getCreatorUserId());
        }
        visitContactQueryWrapper.lambda().eq(VisitContactEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDeleteMark());
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            visitContactObj = this.authorizeService.getCondition(new AuthorizeConditionModel(visitContactQueryWrapper, visitContactPagination.getMenuId(), "visitContact"));
            if (ObjectUtil.isEmpty((Object)visitContactObj)) {
                return new ArrayList<VisitContactEntity>();
            }
            visitContactQueryWrapper = (QueryWrapper)visitContactObj;
            ++visitContactNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            visitContactObj = this.authorizeService.getCondition(new AuthorizeConditionModel(visitContactQueryWrapper, visitContactPagination.getMenuId(), "visitContact"));
            if (ObjectUtil.isEmpty((Object)visitContactObj)) {
                return new ArrayList<VisitContactEntity>();
            }
            visitContactQueryWrapper = (QueryWrapper)visitContactObj;
            ++visitContactNum;
        }
        if (StringUtil.isNotEmpty((String)visitContactPagination.getCustomerId())) {
            ++visitContactNum;
            visitContactQueryWrapper.lambda().eq(VisitContactEntity::getCustomerId, (Object)visitContactPagination.getCustomerId());
        }
        if (StringUtil.isNotEmpty((String)visitContactPagination.getName())) {
            ++visitContactNum;
            visitContactQueryWrapper.lambda().like(VisitContactEntity::getName, (Object)visitContactPagination.getName());
        }
        if (StringUtil.isNotEmpty((String)visitContactPagination.getPhone())) {
            ++visitContactNum;
            visitContactQueryWrapper.lambda().like(VisitContactEntity::getPhone, (Object)visitContactPagination.getPhone());
        }
        if (StringUtil.isNotEmpty((String)visitContactPagination.getPosition())) {
            ++visitContactNum;
            visitContactQueryWrapper.lambda().like(VisitContactEntity::getPosition, (Object)visitContactPagination.getPosition());
        }
        if (StringUtil.isNotEmpty((String)visitContactPagination.getRemark())) {
            ++visitContactNum;
            visitContactQueryWrapper.lambda().like(VisitContactEntity::getRemark, (Object)visitContactPagination.getRemark());
        }
        if (StringUtil.isNotEmpty((String)visitContactPagination.getEnabledMark())) {
            ++visitContactNum;
            visitContactQueryWrapper.lambda().eq(VisitContactEntity::getEnabledMark, (Object)visitContactPagination.getEnabledMark());
        }
        if (StringUtil.isNotEmpty((String)visitContactPagination.getKeyword())) {
            ++visitContactNum;
            visitContactQueryWrapper.lambda().and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.like(VisitContactEntity::getName, (Object)visitContactPagination.getKeyword())).or()).like(VisitContactEntity::getPhone, (Object)visitContactPagination.getKeyword())).or()).like(VisitContactEntity::getPinyin, (Object)visitContactPagination.getKeyword()));
        }
        if (StringUtils.isNotEmpty(visitContactPagination.getSortCode())) {
            ++visitContactNum;
            List<String> SortCodeList = visitContactPagination.getSortCode();
            for (int i = 0; i < SortCodeList.size(); ++i) {
                String id = SortCodeList.get(i);
                boolean idAll = StringUtil.isNotEmpty((String)id);
                if (!idAll) continue;
                BigDecimal b = new BigDecimal(id);
                if (i == 0) {
                    visitContactQueryWrapper.lambda().ge(VisitContactEntity::getSortCode, (Object)b);
                    continue;
                }
                visitContactQueryWrapper.lambda().le(VisitContactEntity::getSortCode, (Object)b);
            }
        }
        if (AllIdList.size() > 0) {
            visitContactQueryWrapper.lambda().in(VisitContactEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)visitContactPagination.getSidx())) {
            visitContactQueryWrapper.lambda().orderByAsc(VisitContactEntity::getSortCode);
        } else {
            try {
                String sidx = visitContactPagination.getSidx();
                VisitContactEntity visitContactEntity = new VisitContactEntity();
                Field declaredField = visitContactEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                visitContactQueryWrapper = "asc".equals(visitContactPagination.getSort().toLowerCase()) ? (QueryWrapper)visitContactQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)visitContactQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(visitContactPagination.getCurrentPage(), visitContactPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)visitContactQueryWrapper);
            return visitContactPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return visitContactPagination.setData(list, list.size());
    }

    @Override
    public List<VisitContactEntity> getTypeList(VisitContactPagination visitContactPagination, String dataType) {
        Object visitContactObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int visitContactNum = 0;
        QueryWrapper visitContactQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            visitContactObj = this.authorizeService.getCondition(new AuthorizeConditionModel(visitContactQueryWrapper, visitContactPagination.getMenuId(), "visitContact"));
            if (ObjectUtil.isEmpty((Object)visitContactObj)) {
                return new ArrayList<VisitContactEntity>();
            }
            visitContactQueryWrapper = (QueryWrapper)visitContactObj;
            ++visitContactNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            visitContactObj = this.authorizeService.getCondition(new AuthorizeConditionModel(visitContactQueryWrapper, visitContactPagination.getMenuId(), "visitContact"));
            if (ObjectUtil.isEmpty((Object)visitContactObj)) {
                return new ArrayList<VisitContactEntity>();
            }
            visitContactQueryWrapper = (QueryWrapper)visitContactObj;
            ++visitContactNum;
        }
        if (StringUtil.isNotEmpty((String)visitContactPagination.getCustomerId())) {
            ++visitContactNum;
            visitContactQueryWrapper.lambda().like(VisitContactEntity::getCustomerId, (Object)visitContactPagination.getCustomerId());
        }
        if (StringUtil.isNotEmpty((String)visitContactPagination.getName())) {
            ++visitContactNum;
            visitContactQueryWrapper.lambda().like(VisitContactEntity::getName, (Object)visitContactPagination.getName());
        }
        if (StringUtil.isNotEmpty((String)visitContactPagination.getPhone())) {
            ++visitContactNum;
            visitContactQueryWrapper.lambda().like(VisitContactEntity::getPhone, (Object)visitContactPagination.getPhone());
        }
        if (StringUtil.isNotEmpty((String)visitContactPagination.getPosition())) {
            ++visitContactNum;
            visitContactQueryWrapper.lambda().like(VisitContactEntity::getPosition, (Object)visitContactPagination.getPosition());
        }
        if (StringUtil.isNotEmpty((String)visitContactPagination.getRemark())) {
            ++visitContactNum;
            visitContactQueryWrapper.lambda().like(VisitContactEntity::getRemark, (Object)visitContactPagination.getRemark());
        }
        if (StringUtil.isNotEmpty((String)visitContactPagination.getEnabledMark())) {
            ++visitContactNum;
            visitContactQueryWrapper.lambda().like(VisitContactEntity::getEnabledMark, (Object)visitContactPagination.getEnabledMark());
        }
        if (StringUtils.isNotEmpty(visitContactPagination.getSortCode())) {
            ++visitContactNum;
            List<String> SortCodeList = visitContactPagination.getSortCode();
            for (int i = 0; i < SortCodeList.size(); ++i) {
                String id = SortCodeList.get(i);
                boolean idAll = StringUtil.isNotEmpty((String)id);
                if (!idAll) continue;
                BigDecimal b = new BigDecimal(id);
                if (i == 0) {
                    visitContactQueryWrapper.lambda().ge(VisitContactEntity::getSortCode, (Object)b);
                    continue;
                }
                visitContactQueryWrapper.lambda().le(VisitContactEntity::getSortCode, (Object)b);
            }
        }
        if (AllIdList.size() > 0) {
            visitContactQueryWrapper.lambda().in(VisitContactEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)visitContactPagination.getSidx())) {
            visitContactQueryWrapper.lambda().orderByDesc(VisitContactEntity::getId);
        } else {
            try {
                String sidx = visitContactPagination.getSidx();
                VisitContactEntity visitContactEntity = new VisitContactEntity();
                Field declaredField = visitContactEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                visitContactQueryWrapper = "asc".equals(visitContactPagination.getSort().toLowerCase()) ? (QueryWrapper)visitContactQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)visitContactQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(visitContactPagination.getCurrentPage(), visitContactPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)visitContactQueryWrapper);
                return visitContactPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return visitContactPagination.setData(list, list.size());
        }
        return this.list((Wrapper)visitContactQueryWrapper);
    }

    @Override
    public VisitContactEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(VisitContactEntity::getId, (Object)id);
        return (VisitContactEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(VisitContactEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, VisitContactEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(VisitContactEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public HashMap saveContact(VisitContactCrForm visitContactCrForm) {
        HashMap map = MapUtil.newHashMap();
        UserInfo userInfo = this.userProvider.get();
        List<VisitContactEntity> contactEntityList = this.findByNameAndUserId(visitContactCrForm.getName(), userInfo.getUserId(), "");
        if (CollectionUtil.isNotEmpty(contactEntityList)) {
            map.put("error", "\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
            return map;
        }
        String mainId = RandomUtil.uuId();
        VisitContactEntity entity = (VisitContactEntity)JsonUtil.getJsonToBean((Object)visitContactCrForm, VisitContactEntity.class);
        entity.setId(mainId);
        entity.setCompanyId(userInfo.getOrganizeId());
        entity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getDeleteMark());
        this.save(entity);
        return map;
    }

    @Override
    @DSTransactional
    public HashMap saveContactList(VisitCustomerContactCrForm customerContactCrForm) {
        Long sortCode;
        List<VisitContactCrForm> list = customerContactCrForm.getContactList();
        UserInfo userInfo = this.userProvider.get();
        HashMap map = MapUtil.newHashMap();
        if (CollectionUtil.isEmpty(list)) {
            map.put("error", "\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
            return map;
        }
        List collect = list.stream().filter(x -> !Objects.isNull(x.getName())).collect(Collectors.toList());
        Set collect1 = collect.stream().map(VisitContactCrForm::getName).collect(Collectors.toSet());
        if (collect1.size() < collect.size()) {
            map.put("error", "\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
            return map;
        }
        List nameList = CollectionUtil.list((boolean)false);
        nameList.addAll(collect1);
        List<VisitContactEntity> contactEntityList = this.getByCreateIdAndCustomerId(userInfo.getUserId(), customerContactCrForm.getCustomerId());
        long[] i = new long[]{0L};
        if (CollectionUtil.isNotEmpty(contactEntityList) && (sortCode = contactEntityList.get(0).getSortCode()) != null) {
            i[0] = sortCode;
        }
        List jsonToList = JsonUtil.getJsonToList(list, VisitContactEntity.class);
        jsonToList.stream().forEach(entity -> {
            i[0] = i[0] + 1L;
            entity.setCustomerId(customerContactCrForm.getCustomerId());
            entity.setCustomerSource(customerContactCrForm.getCustomerSource());
            entity.setSortCode(i[0]);
            entity.setId(RandomUtil.uuId());
            entity.setPinyin(PinyinUtil.getFirstLetter((String)entity.getName(), (String)""));
            entity.setEnabledMark(customerContactCrForm.getEnabledMark());
            entity.setCompanyId(userInfo.getOrganizeId());
            entity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getDeleteMark());
        });
        this.saveBatch(jsonToList);
        return map;
    }

    @Override
    public List<VisitContactEntity> findByNameAndUserId(String name, String userId, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(VisitContactEntity::getCreatorUserId, (Object)userId)).eq(VisitContactEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDeleteMark())).eq(VisitContactEntity::getName, (Object)name);
        if (StrUtil.isNotEmpty((CharSequence)id)) {
            queryWrapper.lambda().ne(VisitContactEntity::getId, (Object)id);
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<VisitContactEntity> findByNameListAndUserId(List<String> nameList, String userId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(VisitContactEntity::getCreatorUserId, (Object)userId)).eq(VisitContactEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDeleteMark())).in(VisitContactEntity::getName, nameList);
        return this.list((Wrapper)queryWrapper);
    }

    public List<VisitContactEntity> getByCreateIdAndCustomerId(String createId, String customerId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(VisitContactEntity::getCreatorUserId, (Object)createId)).eq(VisitContactEntity::getCustomerId, (Object)customerId)).eq(VisitContactEntity::getDeleteMark, (Object)DeleteMarkEnum.NOT_DELETE.getDeleteMark())).orderByAsc(VisitContactEntity::getSortCode);
        return this.list((Wrapper)queryWrapper);
    }
}

