/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.constant.UserRelationObjectTypeEnum;
import com.bringspring.system.base.util.UserAuthAreaUtils;
import com.bringspring.system.permission.entity.OrganizeAdministratorEntity;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.organize.OrganizeCrModel;
import com.bringspring.system.permission.model.user.vo.UserBaseVO;
import com.bringspring.system.permission.service.OrganizeAdministratorService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.visit.constant.AfterSalesHeadEnum;
import com.bringspring.visit.utils.UserRelationUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AfterSalesRoleUtils {
    private static final Logger log = LoggerFactory.getLogger(AfterSalesRoleUtils.class);
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private OrganizeAdministratorService organizeAdministratorService;
    @Autowired
    private UserRelationUtil userRelationUtil;

    public List getWhoCanMe() {
        List list = CollectionUtil.list((boolean)false);
        UserInfo userInfo = this.userProvider.get();
        String organizeId = userInfo.getOrganizeId();
        List manager = this.getManager();
        list.addAll(manager);
        List regionalManager = this.getRegionalManager();
        list.addAll(regionalManager);
        List departmentManager = this.getDepartmentManager();
        list.addAll(departmentManager);
        List managerId = this.getManagerId();
        list.addAll(managerId);
        list = list.stream().filter(s -> !StrUtil.equals((CharSequence)s, (CharSequence)userInfo.getUserId())).collect(Collectors.toList());
        list = list.stream().distinct().collect(Collectors.toList());
        return list;
    }

    public List getDepartmentManager() {
        List list = CollectionUtil.list((boolean)false);
        UserInfo userInfo = this.userProvider.get();
        String departmentId = userInfo.getDepartmentId();
        OrganizeEntity byId = (OrganizeEntity)this.organizeService.getById((Serializable)((Object)departmentId));
        if (ObjectUtil.isNotNull((Object)byId) && StrUtil.isNotEmpty((CharSequence)byId.getManagerId())) {
            list.add(byId.getManagerId());
        }
        return list;
    }

    public List getManagerId() {
        List list = CollectionUtil.list((boolean)false);
        UserInfo userInfo = this.userProvider.get();
        if (StrUtil.isNotEmpty((CharSequence)userInfo.getManagerId())) {
            list.add(userInfo.getManagerId());
        }
        return list;
    }

    public List getManager() {
        List list = CollectionUtil.list((boolean)false);
        Map<String, AfterSalesHeadEnum> allToMap = AfterSalesHeadEnum.getAllToMap();
        AfterSalesHeadEnum headEnum = allToMap.get(this.userProvider.get().getOrganizeId());
        if (ObjectUtil.isNull((Object)((Object)headEnum))) {
            return list;
        }
        List<UserRelationEntity> listByRoleCode = this.userRelationUtil.getListByRoleCode(headEnum.getRole());
        if (CollectionUtil.isNotEmpty(listByRoleCode)) {
            list.addAll(listByRoleCode.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList()));
        }
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            List userEntityList = this.userService.listByIds((Collection)list);
            log.info("\u67e5\u8be2\u5230\u7684\u8d1f\u8d23\u4eba:", (Object)JsonUtil.getObjectToString((Object)userEntityList));
        } else {
            log.info("\u67e5\u8be2\u5230\u7684\u8d1f\u8d23\u4eba:\u3010\u3011");
        }
        return list;
    }

    public List getRegionalManager() {
        List list = CollectionUtil.list((boolean)false);
        UserInfo userInfo = this.userProvider.get();
        List arealist = this.userRelationService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UserRelationEntity::getObjectType, (Object)UserRelationObjectTypeEnum.AFTER_AREA.getObjectType())).eq(UserRelationEntity::getUserId, (Object)userInfo.getUserId()));
        if (CollectionUtil.isNotEmpty((Collection)arealist)) {
            List collect;
            QueryWrapper queryWrapper = new QueryWrapper();
            List haveSameAuthAreaWithMe = UserAuthAreaUtils.getHaveSameAuthAreaAndRoleTypeWithMe((Integer)2, (String)UserRelationObjectTypeEnum.AFTER_AREA.getObjectType());
            if (CollectionUtil.isEmpty((Collection)haveSameAuthAreaWithMe)) {
                return CollectionUtil.list((boolean)false);
            }
            queryWrapper.lambda().in(UserRelationEntity::getUserId, (Collection)haveSameAuthAreaWithMe);
            List authList = this.userRelationService.list((Wrapper)queryWrapper);
            List<UserRelationEntity> salesManagerList = this.userRelationUtil.getListByObjectType(UserRelationObjectTypeEnum.AFTER_AREA_MANAGER.getObjectType());
            if (CollectionUtil.isNotEmpty((Collection)authList) && CollectionUtil.isNotEmpty(salesManagerList) && CollectionUtil.isNotEmpty(collect = authList.stream().filter(s -> salesManagerList.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList()).contains(s.getUserId())).collect(Collectors.toList()))) {
                list.addAll(collect.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList()));
            }
        }
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            List userEntityList = this.userService.listByIds((Collection)list);
            log.info("\u67e5\u8be2\u5230\u7684\u533a\u57df\u7ecf\u7406:", (Object)JsonUtil.getObjectToString((Object)userEntityList));
        } else {
            log.info("\u67e5\u8be2\u5230\u7684\u533a\u57df\u7ecf\u7406:\u3010\u3011");
        }
        return list;
    }

    public HashMap getICanWho(UserInfo userInfo, String bussinessType) {
        List arealist;
        String organizeId = userInfo.getOrganizeId();
        HashMap map = MapUtil.newHashMap();
        map.put("isAll", false);
        map.put("companyId", organizeId);
        map.put("idList", CollectionUtil.list((boolean)false));
        if (userInfo.getUserId().equals("admin")) {
            map.put("isAll", true);
            return map;
        }
        Map<String, AfterSalesHeadEnum> allToMap = AfterSalesHeadEnum.getAllToMap();
        AfterSalesHeadEnum headEnum = allToMap.get(organizeId);
        List role = this.userRelationService.getListByObjectType(userInfo.getUserId(), "Role");
        List<String> roleIds = role.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
        List<String> roleCodes = this.userRelationUtil.getUserRoleInFo(roleIds, 1);
        if (roleCodes.contains(headEnum.getRole())) {
            map.put("isAll", true);
            return map;
        }
        if (roleCodes.contains("inspectionTeamLeader")) {
            map.put("isAll", true);
            return map;
        }
        List returnUserIdList = CollectionUtil.list((boolean)false);
        returnUserIdList.add(userInfo.getUserId());
        if (roleCodes.contains("AfterSaleRegionalDirector") && CollectionUtil.isNotEmpty((Collection)(arealist = this.userRelationService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UserRelationEntity::getObjectType, (Object)"Area")).eq(UserRelationEntity::getUserId, (Object)userInfo.getUserId()))))) {
            List haveSameAuthAreaWithMe = UserAuthAreaUtils.getHaveSameAuthAreaAndRoleTypeWithMe((String)UserRelationObjectTypeEnum.AFTER_AREA.getObjectType());
            returnUserIdList.addAll(haveSameAuthAreaWithMe);
        }
        List listByManagerId = this.userService.getListByManagerId(userInfo.getUserId(), "");
        List depIdList = listByManagerId.stream().map(UserBaseVO::getId).collect(Collectors.toList());
        List organizeAdministratorEntity = this.organizeAdministratorService.getOrganizeAdministratorEntity(userInfo.getUserId());
        if (!organizeAdministratorEntity.isEmpty()) {
            List orgList = organizeAdministratorEntity.stream().map(OrganizeAdministratorEntity::getOrganizeId).collect(Collectors.toList());
            List listByOrgId = this.userRelationService.getListByOrgId(orgList);
            List userIds = listByOrgId.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
            returnUserIdList.addAll(userIds);
        }
        returnUserIdList.addAll(depIdList);
        map.put("idList", returnUserIdList);
        return map;
    }

    public String getCompanyShortName(String companyId) {
        if (StrUtil.isBlank((CharSequence)companyId)) {
            return "";
        }
        List<String> companyStr = Arrays.asList(companyId.split(","));
        ArrayList<String> companyShortNameList = new ArrayList<String>();
        List organizeEntityList = this.organizeService.listByIds(companyStr);
        if (organizeEntityList != null && !organizeEntityList.isEmpty()) {
            for (OrganizeEntity byId : organizeEntityList) {
                try {
                    OrganizeCrModel crModel = (OrganizeCrModel)JsonUtil.getJsonToBean((String)byId.getPropertyJson(), OrganizeCrModel.class);
                    if (crModel == null) continue;
                    companyShortNameList.add(crModel.getShortName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return String.join((CharSequence)",", companyShortNameList);
    }
}

