/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.utils;

import com.alibaba.fastjson.JSONArray;
import com.bringspring.common.util.StringUtils;
import com.github.pagehelper.util.StringUtil;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Clock;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import org.quartz.CronExpression;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class DateUtil {
    public static Date getDayBegin() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date formatStringToDate(String base, Boolean isTotal) {
        Date baseTime;
        String format = isTotal != false ? "yyyy-MM-dd hh-mm-ss" : "yyyy-MM-dd";
        SimpleDateFormat df = new SimpleDateFormat(format);
        try {
            baseTime = df.parse(base);
        }
        catch (Exception e) {
            return null;
        }
        return baseTime;
    }

    public static int getDayOfWeek(Calendar calendar) {
        int today = calendar != null ? calendar.get(7) : Calendar.getInstance().get(7);
        if (today == 1) {
            return 7;
        }
        return today - 1;
    }

    public static String getNow() {
        LocalDateTime ldt1 = LocalDateTime.now();
        DateTimeFormatter dtf1 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String temp = dtf1.format(ldt1);
        return temp;
    }

    public static String getdaNow() {
        LocalDateTime ldt1 = LocalDateTime.now();
        DateTimeFormatter dtf1 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String temp = dtf1.format(ldt1);
        return temp;
    }

    public static String getNow(String zone) {
        LocalDateTime ldt1 = LocalDateTime.now(ZoneId.of(zone));
        DateTimeFormatter dtf1 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String temp = dtf1.format(ldt1);
        return temp;
    }

    public static String getmmNow() {
        LocalDateTime ldt1 = LocalDateTime.now();
        DateTimeFormatter dtf1 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        String temp = dtf1.format(ldt1);
        return temp;
    }

    public static Date getNowDate() {
        Date date = new Date();
        return date;
    }

    public static Date getDayEnd() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static Date getBeginDayOfYesterday() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getDayBegin());
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date getEndDayOfYesterday() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getDayEnd());
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date getBeginDayOfTomorrow() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getDayBegin());
        cal.add(5, 1);
        return cal.getTime();
    }

    public static Date getEndDayOfTomorrow() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getDayEnd());
        cal.add(5, 1);
        return cal.getTime();
    }

    public static Timestamp getDayStartTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Timestamp getDayEndTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Date getBeginDayOfWeek() {
        Date date = new Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayOfWeek = cal.get(7);
        if (dayOfWeek == 1) {
            dayOfWeek += 7;
        }
        cal.add(5, 2 - dayOfWeek);
        return DateUtil.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getBeginDayOfWeek());
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return DateUtil.getDayEndTime(weekEndSta);
    }

    public static Date getBeginDayOfLastWeek() {
        Date date = new Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek - 7);
        return DateUtil.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfLastWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getBeginDayOfLastWeek());
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return DateUtil.getDayEndTime(weekEndSta);
    }

    public static Date getBeginDayOfNextWeek() {
        Date date = new Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek + 7);
        return DateUtil.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfNextWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getBeginDayOfNextWeek());
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return DateUtil.getDayEndTime(weekEndSta);
    }

    public static Integer getNowYear() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(1);
    }

    public static int getNowMonth() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(2) + 1;
    }

    public static String getNowMonthStr() {
        String dateString = DateUtil.getDateString(new Date(), "YYYY-MM");
        return dateString;
    }

    public static Date getBeginDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateUtil.getNowYear(), DateUtil.getNowMonth() - 1, 1);
        return DateUtil.getDayStartTime(calendar.getTime());
    }

    public static Date getBeginDayOfMonth(String date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.strToDate(date));
        return DateUtil.getDayStartTime(calendar.getTime());
    }

    public static Date getEndDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateUtil.getNowYear(), DateUtil.getNowMonth() - 1, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(DateUtil.getNowYear(), DateUtil.getNowMonth() - 1, day);
        return DateUtil.getDayEndTime(calendar.getTime());
    }

    public static Date getEndDayOfMonth(String date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtil.strToDate(date));
        int day = calendar.getActualMaximum(5);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        calendar.set(year, month - 1, day);
        return DateUtil.getDayEndTime(calendar.getTime());
    }

    public static void main(String[] args) {
        String weekStr = DateUtil.getWeekStr(DateUtil.getdaNow());
        System.out.println(weekStr);
    }

    public static Date getBeginDayOfLastMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateUtil.getNowYear(), DateUtil.getNowMonth() - 2, 1);
        return DateUtil.getDayStartTime(calendar.getTime());
    }

    public static Date getEndDayOfLastMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateUtil.getNowYear(), DateUtil.getNowMonth() - 2, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(DateUtil.getNowYear(), DateUtil.getNowMonth() - 2, day);
        return DateUtil.getDayEndTime(calendar.getTime());
    }

    public static Date getBeginDayOfYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, DateUtil.getNowYear());
        cal.set(2, 0);
        cal.set(5, 1);
        return DateUtil.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, DateUtil.getNowYear());
        cal.set(2, 11);
        cal.set(5, 31);
        return DateUtil.getDayEndTime(cal.getTime());
    }

    public static int getDiffDays(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            throw new IllegalArgumentException("getDiffDays param is null!");
        }
        long diff = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        int days = new Long(diff).intValue();
        return days;
    }

    public static long dateDiff(Date beginDate, Date endDate) {
        long date1ms = beginDate.getTime();
        long date2ms = endDate.getTime();
        return date2ms - date1ms;
    }

    public static Date max(Date beginDate, Date endDate) {
        if (beginDate == null) {
            return endDate;
        }
        if (endDate == null) {
            return beginDate;
        }
        if (beginDate.after(endDate)) {
            return beginDate;
        }
        return endDate;
    }

    public static Date min(Date beginDate, Date endDate) {
        if (beginDate == null) {
            return endDate;
        }
        if (endDate == null) {
            return beginDate;
        }
        if (beginDate.after(endDate)) {
            return endDate;
        }
        return beginDate;
    }

    public static Date getFirstSeasonDate(Date date) {
        int[] season = new int[]{1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int sean = season[cal.get(2)];
        cal.set(2, sean * 3 - 3);
        return cal.getTime();
    }

    public static Date getBeginDayOfSeason(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int quarter = calendar.get(2) / 3 + 1;
        int year = calendar.get(1);
        int quarterStartMonth = (quarter - 1) * 3;
        calendar.set(year, quarterStartMonth, 1);
        return DateUtil.getDayStartTime(calendar.getTime());
    }

    public static Date getEndDayOfSeason(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int quarter = calendar.get(2) / 3 + 1;
        int year = calendar.get(1);
        int quarterStartMonth = (quarter - 1) * 3;
        calendar.set(year, quarterStartMonth + 3, 1);
        calendar.add(5, -1);
        return DateUtil.getDayStartTime(calendar.getTime());
    }

    public static Date getNextDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) + i);
        return cal.getTime();
    }

    public static Date getFrontDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) - i);
        return cal.getTime();
    }

    public static List<String> getFrontDate(Date date, int i) {
        ArrayList<String> returnDate = new ArrayList<String>();
        Integer j = 0;
        while (j < i) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            cal.set(5, cal.get(5) - j);
            returnDate.add(DateUtil.daFormat(cal.getTime()));
            Integer n = j;
            Integer n2 = j = Integer.valueOf(j + 1);
        }
        return returnDate;
    }

    public static List getTimeList(int beginYear, int beginMonth, int k) {
        ArrayList<Date> list = new ArrayList<Date>();
        GregorianCalendar begincal = new GregorianCalendar(beginYear, beginMonth, 1);
        int max = ((Calendar)begincal).getActualMaximum(5);
        for (int i = 1; i < max; i += k) {
            list.add(begincal.getTime());
            ((Calendar)begincal).add(5, k);
        }
        begincal = new GregorianCalendar(beginYear, beginMonth, max);
        list.add(begincal.getTime());
        return list;
    }

    public static List getTimeList(int beginYear, int beginMonth, int endYear, int endMonth, int k) {
        ArrayList<List> list = new ArrayList<List>();
        if (beginYear == endYear) {
            for (int j = beginMonth; j <= endMonth; ++j) {
                list.add(DateUtil.getTimeList(beginYear, j, k));
            }
        } else {
            int j;
            for (j = beginMonth; j < 12; ++j) {
                list.add(DateUtil.getTimeList(beginYear, j, k));
            }
            for (int i = beginYear + 1; i < endYear; ++i) {
                for (int j2 = 0; j2 < 12; ++j2) {
                    list.add(DateUtil.getTimeList(i, j2, k));
                }
            }
            for (j = 0; j <= endMonth; ++j) {
                list.add(DateUtil.getTimeList(endYear, j, k));
            }
        }
        return list;
    }

    public static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public static String dateNow(String pattern) {
        Date date = new Date();
        if (pattern == null && "".equals(pattern)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        String dateString = formatter.format(date);
        return dateString;
    }

    public static String dateToString(Date date, String pattern) {
        if (StringUtil.isEmpty((String)pattern) && date == null) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        String dateString = formatter.format(date);
        return dateString;
    }

    public static String dateFormat(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(date);
        return dateString;
    }

    public static String daFormat(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = formatter.format(date);
        return dateString;
    }

    public static String dayFormat(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM\u6708dd\u65e5");
        String dateString = formatter.format(date);
        return dateString;
    }

    public static String monthFormat(Date date, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        String dateString = formatter.format(date);
        return dateString;
    }

    public static String formatCTS(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        SimpleDateFormat sim1 = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
        try {
            Date date = sim1.parse(str);
            System.out.println(date);
            return com.bringspring.common.util.DateUtil.daFormat((Date)date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            try {
                Date date = com.bringspring.common.util.DateUtil.strToDate((String)str);
                return com.bringspring.common.util.DateUtil.daFormat((Date)date);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return "";
            }
        }
    }

    public static String daFormat(Long date) {
        DateTimeFormatter ftf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String dateString = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(date), ZoneId.of("+8")));
        return dateString;
    }

    public static String daFormatYmd(Long date) {
        DateTimeFormatter ftf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String dateString = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(date), ZoneId.of("+8")));
        return dateString;
    }

    public static String dateFormatHHmmssAddEight(Long date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date time = DateUtil.dateAddHours(new Date(date), 8);
        String dateString = formatter.format(time);
        return dateString;
    }

    public static String daFormatHHMMSS(Long date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date time = new Date(date);
        String dateString = formatter.format(time);
        return dateString;
    }

    public static Date daFormatDate(Long date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date time = new Date(date);
        return time;
    }

    public static Date daFormatMonth(Long date, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        Date time = new Date(date);
        return time;
    }

    public static Date stringToDate(String str) {
        Date date = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            date = formatter.parse(str);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            return date;
        }
        return date;
    }

    public static Date stringToDates(String str) {
        Date date = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            date = formatter.parse(str);
        }
        catch (ParseException e) {
            return date;
        }
        return date;
    }

    public static String cstFormat(String str) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
            Date date = formatter.parse(str);
            return DateUtil.dateFormat(date);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Date longToDate(long str) throws ParseException {
        return new Date(str * 1000L);
    }

    public static boolean isEffectiveDate(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return false;
        }
        long currentTime = new Date().getTime();
        return currentTime >= startDate.getTime() && currentTime <= endDate.getTime();
    }

    public static String getTwoDay(String secondString, String firstString) {
        SimpleDateFormat myFormatter = new SimpleDateFormat("yyyy-MM-dd");
        long day = 0L;
        try {
            Date secondTime = myFormatter.parse(secondString);
            Date firstTime = myFormatter.parse(firstString);
            day = (secondTime.getTime() - firstTime.getTime()) / 86400000L;
        }
        catch (Exception e) {
            return "";
        }
        return day + "";
    }

    public static String getPreTime(String stringTime, String minute) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String mydate1 = "";
        try {
            Date date1 = format.parse(stringTime);
            long time = date1.getTime() / 1000L + (long)(Integer.parseInt(minute) * 60);
            date1.setTime(time * 1000L);
            mydate1 = format.format(date1);
        }
        catch (Exception e) {
            return "";
        }
        return mydate1;
    }

    public static long getTime(Date data) {
        if (data != null) {
            return data.getTime() / 1000L;
        }
        return 0L;
    }

    public static Date strToDate(String strDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;
    }

    public static String getNextDay(String nowdate, String delay) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String mdate = "";
            Date d = DateUtil.strToDate(nowdate);
            long myTime = d.getTime() / 1000L + (long)(Integer.parseInt(delay) * 24 * 60 * 60);
            d.setTime(myTime * 1000L);
            mdate = format.format(d);
            return mdate;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static boolean isLeapYear(String ddate) {
        Date d = DateUtil.strToDate(ddate);
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(d);
        int year = gc.get(1);
        if (year % 400 == 0) {
            return true;
        }
        if (year % 4 == 0) {
            return year % 100 != 0;
        }
        return false;
    }

    public static String geteDate(String str) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(str, pos);
        String j = strtodate.toString();
        String[] k = j.split(" ");
        return k[2] + k[1].toUpperCase() + k[5].substring(2, 4);
    }

    public static boolean isSameWeekDates(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        int subYear = cal1.get(1) - cal2.get(1);
        return 0 == subYear ? cal1.get(3) == cal2.get(3) : (1 == subYear && 11 == cal2.get(2) ? cal1.get(3) == cal2.get(3) : -1 == subYear && 11 == cal1.get(2) && cal1.get(3) == cal2.get(3));
    }

    public static String getSeqWeek(long startTime) {
        Calendar c = Calendar.getInstance(Locale.CHINA);
        c.setTimeInMillis(startTime);
        String week = Integer.toString(c.get(3));
        if (week.length() == 1) {
            week = "0" + week;
        }
        String year = Integer.toString(c.get(1));
        int i = c.get(2) + 1;
        String month = null;
        month = i < 10 ? "0" + i : i + "";
        return year + "-" + month + "\u7b2c" + week + "\u5468";
    }

    public static String getWeek(String sdate, String num) {
        Date dd = DateUtil.strToDate(sdate);
        Calendar c = Calendar.getInstance();
        c.setTime(dd);
        if ("1".equals(num)) {
            c.set(7, 2);
        } else if ("2".equals(num)) {
            c.set(7, 3);
        } else if ("3".equals(num)) {
            c.set(7, 4);
        } else if ("4".equals(num)) {
            c.set(7, 5);
        } else if ("5".equals(num)) {
            c.set(7, 6);
        } else if ("6".equals(num)) {
            c.set(7, 7);
        } else if ("0".equals(num)) {
            c.set(7, 1);
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(c.getTime());
    }

    public static String getWeek(String sdate) {
        Date date = DateUtil.strToDate(sdate);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return new SimpleDateFormat("EEEE").format(c.getTime());
    }

    public static String getWeekStr(String sdate) {
        String str = "";
        str = DateUtil.getWeek(sdate);
        if ("1".equals(str)) {
            str = "\u661f\u671f\u65e5";
        } else if ("2".equals(str)) {
            str = "\u661f\u671f\u4e00";
        } else if ("3".equals(str)) {
            str = "\u661f\u671f\u4e8c";
        } else if ("4".equals(str)) {
            str = "\u661f\u671f\u4e09";
        } else if ("5".equals(str)) {
            str = "\u661f\u671f\u56db";
        } else if ("6".equals(str)) {
            str = "\u661f\u671f\u4e94";
        } else if ("7".equals(str)) {
            str = "\u661f\u671f\u516d";
        }
        return str;
    }

    public static long getDays(String date1, String date2) {
        if (date1 == null || "".equals(date1)) {
            return 0L;
        }
        if (date2 == null || "".equals(date2)) {
            return 0L;
        }
        SimpleDateFormat myFormatter = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        Date mydate = null;
        try {
            date = myFormatter.parse(date1);
            mydate = myFormatter.parse(date2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long day = 0L;
        if (date != null) {
            day = (date.getTime() - mydate.getTime()) / 86400000L;
        }
        return day;
    }

    public static String getNowMonth(String sdate) {
        sdate = sdate.substring(0, 8) + "01";
        Date date = DateUtil.strToDate(sdate);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int u = c.get(7);
        String newday = DateUtil.getNextDay(sdate, 1 - u + "");
        return newday;
    }

    public static String getUserDate(String sformat) {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat(sformat);
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static String getDateString(Date date, String sformat) {
        Date currentTime = null;
        currentTime = date == null ? new Date() : date;
        SimpleDateFormat formatter = new SimpleDateFormat(sformat);
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public static String getRandom(int i) {
        Random jjj = new Random();
        if (i == 0) {
            return "";
        }
        String jj = "";
        for (int k = 0; k < i; ++k) {
            jj = jj + jjj.nextInt(9);
        }
        return jj;
    }

    public static LocalDateTime dateToLocalDateTime(Date date) {
        if (date != null) {
            Instant instant = date.toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
            return localDateTime;
        }
        return null;
    }

    public static Date localDateTimeToDate(LocalDateTime localDateTime) {
        if (localDateTime != null) {
            ZoneId zoneId = ZoneId.systemDefault();
            ZonedDateTime zdt = localDateTime.atZone(zoneId);
            Date date = Date.from(zdt.toInstant());
            return date;
        }
        return null;
    }

    public static Date dateAddHours(Date startDate, int hours) {
        if (startDate == null) {
            startDate = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        c.set(10, c.get(10) + hours);
        return c.getTime();
    }

    public static Date dateAddMinutes(Date startDate, int minutes) {
        if (startDate == null) {
            startDate = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        c.set(12, c.get(12) + minutes);
        return c.getTime();
    }

    public static Date dateAddSeconds(Date startDate, int seconds) {
        if (startDate == null) {
            startDate = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        c.set(13, c.get(13) + seconds);
        return c.getTime();
    }

    public static Date dateAddYears(Date startDate, int years) {
        if (startDate == null) {
            startDate = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        c.set(1, c.get(1) + years);
        return c.getTime();
    }

    public static Date dateAddMonths(Date startDate, int months) {
        if (startDate == null) {
            startDate = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        c.set(2, c.get(2) + months);
        return c.getTime();
    }

    public static Date dateAddDays(Date startDate, int days) {
        if (startDate == null) {
            startDate = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        c.set(5, c.get(5) + days);
        return c.getTime();
    }

    public static LocalDateTime localDateAddHours(LocalDateTime localDateTime, int hours) {
        if (localDateTime == null) {
            localDateTime = LocalDateTime.now();
        }
        return localDateTime.plusHours(hours);
    }

    public static LocalDateTime localDateAddMinutes(LocalDateTime localDateTime, int minutes) {
        if (localDateTime == null) {
            localDateTime = LocalDateTime.now();
        }
        return localDateTime.plusMinutes(minutes);
    }

    public static LocalDateTime localDateAddSeconds(LocalDateTime localDateTime, int seconds) {
        if (localDateTime == null) {
            localDateTime = LocalDateTime.now();
        }
        return localDateTime.plusSeconds(seconds);
    }

    public static LocalDateTime localDateAddYears(LocalDateTime localDateTime, int years) {
        if (localDateTime == null) {
            localDateTime = LocalDateTime.now();
        }
        return localDateTime.plusYears(years);
    }

    public static LocalDateTime localDateMonths(LocalDateTime localDateTime, int months) {
        if (localDateTime == null) {
            localDateTime = LocalDateTime.now();
        }
        return localDateTime.plusMonths(months);
    }

    public static LocalDateTime localDateAddDays(LocalDateTime localDateTime, int days) {
        if (localDateTime == null) {
            localDateTime = LocalDateTime.now();
        }
        return localDateTime.plusDays(days);
    }

    public static int dateCompare(Date myDate, Date compareDate) {
        Calendar myCal = Calendar.getInstance();
        Calendar compareCal = Calendar.getInstance();
        myCal.setTime(myDate);
        compareCal.setTime(compareDate);
        return myCal.compareTo(compareCal);
    }

    public static Date dateMin(Date date, Date compareDate) {
        if (date == null) {
            return compareDate;
        }
        if (compareDate == null) {
            return date;
        }
        if (1 == DateUtil.dateCompare(date, compareDate)) {
            return compareDate;
        }
        if (-1 == DateUtil.dateCompare(date, compareDate)) {
            return date;
        }
        return date;
    }

    public static Date dateMax(Date date, Date compareDate) {
        if (date == null) {
            return compareDate;
        }
        if (compareDate == null) {
            return date;
        }
        if (1 == DateUtil.dateCompare(date, compareDate)) {
            return date;
        }
        if (-1 == DateUtil.dateCompare(date, compareDate)) {
            return compareDate;
        }
        return date;
    }

    public static int getLastDayOfMonth(Date startDate, int month) {
        if (startDate == null) {
            startDate = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        c.set(c.get(1), month, 1);
        c.add(5, -1);
        int day = c.get(5);
        return day;
    }

    public static List<Date> getAllDays(Date startTime, Date endTime) {
        ArrayList<Date> listDay = new ArrayList<Date>();
        Date dtDay = new Date();
        dtDay = startTime;
        while (dtDay.compareTo(endTime) <= 0) {
            listDay.add(dtDay);
            dtDay = com.bringspring.common.util.DateUtil.dateAddDays((Date)dtDay, (int)1);
        }
        return listDay;
    }

    public static List<String> getRecentExecTime(String cron, int numTimes) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
            cronTriggerImpl.setCronExpression(cron);
            List dates = TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, null, (int)numTimes);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (Date date : dates) {
                list.add(dateFormat.format(date));
            }
        }
        catch (ParseException e) {
            e.getMessage();
        }
        return list;
    }

    public static String getNextCron(String cron, Date dates) {
        String crons = null;
        if (dates == null) {
            dates = new Date();
        }
        if (StringUtil.isEmpty((String)cron)) {
            return crons;
        }
        CronExpression cronExpression = null;
        try {
            cronExpression = new CronExpression(cron);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            return crons;
        }
        Date date = cronExpression.getNextValidTimeAfter(dates);
        if (date != null) {
            crons = DateUtil.dateFormat(date);
        }
        return crons;
    }

    public static Date getNextCronDate(String cron, Date dates) {
        Date crons = new Date();
        if (dates == null) {
            dates = new Date();
        }
        if (StringUtil.isEmpty((String)cron)) {
            return crons;
        }
        CronExpression cronExpression = null;
        try {
            cronExpression = new CronExpression(cron);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            return crons;
        }
        Date date = cronExpression.getNextValidTimeAfter(dates);
        return date;
    }

    public static String getDateToCron(Date date) {
        String cron = null;
        String dateFormat = "ss mm HH dd MM ?";
        cron = date == null ? DateUtil.dateNow(dateFormat) : DateUtil.dateToString(date, dateFormat);
        return cron;
    }

    public static boolean timeCalendar(Date nowTime, Date dayTimeStart, Date dayTimeEnd) {
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar timeStart = Calendar.getInstance();
        timeStart.setTime(dayTimeStart);
        Calendar timeEnd = Calendar.getInstance();
        timeEnd.setTime(dayTimeEnd);
        if (date.equals(timeStart) || date.equals(timeEnd)) {
            return true;
        }
        return date.after(timeStart) && date.before(timeEnd);
    }

    public static boolean isValidDate(String str) {
        boolean convertSuccess = true;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (str.length() == 10) {
            format = new SimpleDateFormat("yyyy-MM-dd");
        }
        try {
            format.setLenient(false);
            format.parse(str);
        }
        catch (ParseException e) {
            convertSuccess = false;
        }
        return convertSuccess;
    }

    public static boolean isOverlap(Date leftStartDate, Date leftEndDate, Date rightStartDate, Date rightEndDate) {
        return leftStartDate.getTime() >= rightStartDate.getTime() && leftStartDate.getTime() < rightEndDate.getTime() || leftStartDate.getTime() > rightStartDate.getTime() && leftStartDate.getTime() <= rightEndDate.getTime() || rightStartDate.getTime() >= leftStartDate.getTime() && rightStartDate.getTime() < leftEndDate.getTime() || rightStartDate.getTime() > leftStartDate.getTime() && rightStartDate.getTime() <= leftEndDate.getTime();
    }

    public static JSONArray addCon(JSONArray jsonArray, String type, String format) {
        if ("timeRange".equals(type)) {
            String value1 = jsonArray.get(0).toString();
            String value2 = jsonArray.get(1).toString();
            jsonArray.clear();
            jsonArray.add((Object)(value1 + "\u81f3"));
            jsonArray.add((Object)value2);
        }
        if ("dateRange".equals(type)) {
            DateTimeFormatter ftfDateRange = DateTimeFormatter.ofPattern(format);
            long date1 = Long.parseLong(String.valueOf(jsonArray.get(0)));
            long date2 = Long.parseLong(String.valueOf(jsonArray.get(1)));
            String value1 = ftfDateRange.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(date1), ZoneId.systemDefault()));
            String value2 = ftfDateRange.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(date2), ZoneId.systemDefault()));
            jsonArray.clear();
            jsonArray.add((Object)(value1 + "\u81f3"));
            jsonArray.add((Object)value2);
        }
        return jsonArray;
    }

    public static Long getMillis2() {
        return Instant.now().toEpochMilli();
    }

    public static Long localDateTime2Millis(LocalDateTime localDateTime) {
        return localDateTime.toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
    }

    public static Long localDate2Millis(LocalDate localDate) {
        return LocalDateTime.of(localDate, LocalTime.MIN).toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
    }

    public static Long clock2Millis(Clock clock) {
        return clock.millis();
    }

    public static Long zoneDateTime2Millis(ZonedDateTime zonedDateTime) {
        return zonedDateTime.toLocalDateTime().toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
    }

    public static Long string2MillisWithJdk8(String dateStr, String formatStr) {
        return LocalDateTime.parse(dateStr, DateTimeFormatter.ofPattern(formatStr)).toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
    }

    public static String getZonedDateTimeToString(ZonedDateTime zonedDateTime) {
        ZonedDateTime zoneDateTime1 = zonedDateTime.plusHours(11L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return zoneDateTime1.format(formatter);
    }

    public double calLeaveDays(Date startTime, Date endTime) {
        double leaveDays = 0.0;
        Date flag = startTime;
        Calendar cal = Calendar.getInstance();
        while (flag.compareTo(endTime) != 1) {
            cal.setTime(flag);
            int week = cal.get(7) - 1;
            if (week == 0 || week == 6) {
                cal.add(5, 1);
                flag = cal.getTime();
                continue;
            }
            try {
                LocalDate localDate = flag.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                DayOfWeek dayOfWeek = localDate.getDayOfWeek();
                cal.add(5, 1);
                flag = cal.getTime();
            }
            catch (Exception e) {
                e.printStackTrace();
                leaveDays += 1.0;
                cal.add(5, 1);
                flag = cal.getTime();
            }
        }
        return leaveDays;
    }

    public static int getWorkDays(Date startTime, Date endTime) {
        int workDays = 0;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date begin = simpleDateFormat.parse(simpleDateFormat.format(startTime));
            Date end = simpleDateFormat.parse(simpleDateFormat.format(endTime));
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(begin);
            while (begin.getTime() <= end.getTime()) {
                int week = calendar.get(7) - 1;
                calendar.add(5, 1);
                if (week != 0 && week != 6) {
                    ++workDays;
                }
                begin = calendar.getTime();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workDays;
    }
}

