/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.StringUtils;
import com.bringspring.visit.utils.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HolidayUtil {
    private static Set<Calendar> holidays = new HashSet<Calendar>();
    static Map<String, List<String>> holiday;
    static Map<String, List<String>> extraWorkDay;
    private static final int RETRY_COUNT = 3;

    public static Calendar subtractWorkdaysToDate(Calendar date, int workdays) {
        for (int i = 0; i < workdays; ++i) {
            date.add(5, -1);
            while (date.get(7) == 1 || date.get(7) == 7 || holidays.contains(date)) {
                date.add(5, -1);
            }
        }
        return date;
    }

    public static Calendar addWorkdaysToDate(Calendar date, int workdays) {
        for (int i = 0; i < workdays; ++i) {
            date.add(5, 1);
            while (date.get(7) == 1 || date.get(7) == 7 || holidays.contains(date)) {
                date.add(5, 1);
            }
        }
        return date;
    }

    public static Boolean judgmentDate(Date date, Date endDate) {
        if (date.compareTo(endDate) > 0) {
            return true;
        }
        if (date.compareTo(endDate) < 0) {
            return false;
        }
        return false;
    }

    public static Integer getSubtractDate(Date start, Date end) {
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        endCalendar.setTime(end);
        long milliseconds = start.getTime() - end.getTime();
        int days = (int)(milliseconds / 86400000L);
        return days;
    }

    public static String getdaNow() throws ParseException {
        LocalDateTime ldt1 = LocalDateTime.now();
        DateTimeFormatter dtf1 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String temp = dtf1.format(ldt1);
        return temp;
    }

    public static Date getNow() throws ParseException {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String formattedDate = sdf.format(now);
        Date parse = sdf.parse(formattedDate);
        return parse;
    }

    public static Date getNowFormat() throws ParseException {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formattedDate = sdf.format(now);
        Date parse = sdf.parse(formattedDate);
        return parse;
    }

    public static LocalDateTime getBeginDayOfWeek(String date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate parsedDate = LocalDate.parse(date, formatter);
        LocalDateTime localDateTime = parsedDate.atStartOfDay();
        return localDateTime;
    }

    public static LocalDateTime getEndDayOfWeek(String date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate parsedDate = LocalDate.parse(date, formatter);
        LocalDateTime midnight = parsedDate.atTime(LocalTime.MAX);
        return midnight;
    }

    public static Date getDayBegin() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public static Date getDayEnd() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static String dateFormat(Date date) {
        if (ObjectUtil.isEmpty((Object)date)) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = formatter.format(date);
        return dateString;
    }

    public static String isWorkingDay(String time) throws ParseException {
        String holiday;
        Date parse = null;
        if (StringUtils.isNotBlank((CharSequence)time)) {
            SimpleDateFormat getYearFormat = new SimpleDateFormat("yyyy-MM-dd");
            parse = getYearFormat.parse(time);
        } else {
            parse = new Date();
        }
        String newDate = new SimpleDateFormat("yyyy").format(parse);
        if (!HolidayUtil.holiday.containsKey(newDate) && "No!".equals(holiday = HolidayUtil.getYearHoliday(newDate))) {
            return "\u8be5\u5e74\u4efd\u672a\u5206\u914d\u65e5\u671f\u5b89\u6392\uff01";
        }
        Date date = DateUtil.formatStringToDate(time, false);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int weekday = DateUtil.getDayOfWeek(calendar);
        if (CollectionUtil.isNotEmpty(HolidayUtil.holiday)) {
            if (HolidayUtil.holiday.get(newDate).contains(time)) {
                return "2";
            }
            if (extraWorkDay.get(newDate).contains(time)) {
                return "0";
            }
            if (weekday == 7 || weekday == 6) {
                return "1";
            }
            return "0";
        }
        return null;
    }

    public static String getYearHoliday(String date) throws ParseException {
        String httpUrl = "https://api.jiejiariapi.com/v1/holidays/" + date;
        String result = null;
        try {
            JSONObject json = JSONArray.parseObject((String)"{\"code\":0,\"holiday\":{\"01-01\":{\"holiday\":true,\"name\":\"\u5143\u65e6\",\"wage\":3,\"date\":\"2025-01-01\",\"rest\":29},\"01-26\":{\"holiday\":false,\"name\":\"\u6625\u8282\u524d\u8865\u73ed\",\"wage\":1,\"after\":false,\"target\":\"\u6625\u8282\",\"date\":\"2025-01-26\",\"rest\":17},\"01-28\":{\"holiday\":true,\"name\":\"\u9664\u5915\",\"wage\":2,\"date\":\"2025-01-28\",\"rest\":19},\"01-29\":{\"holiday\":true,\"name\":\"\u521d\u4e00\",\"wage\":3,\"date\":\"2025-01-29\",\"rest\":1},\"01-30\":{\"holiday\":true,\"name\":\"\u521d\u4e8c\",\"wage\":3,\"date\":\"2025-01-30\",\"rest\":1},\"01-31\":{\"holiday\":true,\"name\":\"\u521d\u4e09\",\"wage\":3,\"date\":\"2025-01-31\",\"rest\":1},\"02-01\":{\"holiday\":true,\"name\":\"\u521d\u56db\",\"wage\":2,\"date\":\"2025-02-01\",\"rest\":1},\"02-02\":{\"holiday\":true,\"name\":\"\u521d\u4e94\",\"wage\":2,\"date\":\"2025-02-02\",\"rest\":1},\"02-03\":{\"holiday\":true,\"name\":\"\u521d\u516d\",\"wage\":2,\"date\":\"2025-02-03\",\"rest\":1},\"02-04\":{\"holiday\":true,\"name\":\"\u521d\u4e03\",\"wage\":2,\"date\":\"2025-02-04\",\"rest\":1},\"02-08\":{\"holiday\":false,\"name\":\"\u6625\u8282\u540e\u8865\u73ed\",\"wage\":1,\"target\":\"\u6625\u8282\",\"after\":true,\"date\":\"2025-02-08\",\"rest\":1},\"04-04\":{\"holiday\":true,\"name\":\"\u6e05\u660e\u8282\",\"wage\":3,\"date\":\"2025-04-04\",\"rest\":11},\"04-05\":{\"holiday\":true,\"name\":\"\u6e05\u660e\u8282\",\"wage\":2,\"date\":\"2025-04-05\",\"rest\":1},\"04-06\":{\"holiday\":true,\"name\":\"\u6e05\u660e\u8282\",\"wage\":2,\"date\":\"2025-04-06\",\"rest\":1},\"04-27\":{\"holiday\":false,\"name\":\"\u52b3\u52a8\u8282\u524d\u8865\u73ed\",\"wage\":1,\"target\":\"\u52b3\u52a8\u8282\",\"after\":false,\"date\":\"2025-04-27\",\"rest\":5},\"05-01\":{\"holiday\":true,\"name\":\"\u52b3\u52a8\u8282\",\"wage\":3,\"date\":\"2025-05-01\",\"rest\":9},\"05-02\":{\"holiday\":true,\"name\":\"\u52b3\u52a8\u8282\",\"wage\":2,\"date\":\"2025-05-02\",\"rest\":1},\"05-03\":{\"holiday\":true,\"name\":\"\u52b3\u52a8\u8282\",\"wage\":3,\"date\":\"2025-05-03\",\"rest\":1},\"05-04\":{\"holiday\":true,\"name\":\"\u52b3\u52a8\u8282\",\"wage\":3,\"date\":\"2025-05-04\",\"rest\":1},\"05-05\":{\"holiday\":true,\"name\":\"\u52b3\u52a8\u8282\",\"wage\":3,\"date\":\"2025-05-05\",\"rest\":1},\"05-31\":{\"holiday\":true,\"name\":\"\u7aef\u5348\u8282\",\"wage\":3,\"date\":\"2025-05-31\",\"rest\":10},\"06-01\":{\"holiday\":true,\"name\":\"\u7aef\u5348\u8282\",\"wage\":2,\"date\":\"2025-06-01\",\"rest\":1},\"06-02\":{\"holiday\":true,\"name\":\"\u7aef\u5348\u8282\",\"wage\":2,\"date\":\"2025-06-02\",\"rest\":1},\"09-28\":{\"holiday\":false,\"name\":\"\u56fd\u5e86\u8282\u524d\u8865\u73ed\",\"after\":false,\"wage\":1,\"target\":\"\u56fd\u5e86\u8282\",\"date\":\"2025-09-28\",\"rest\":22},\"10-01\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":3,\"date\":\"2025-10-01\",\"rest\":25},\"10-02\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":3,\"date\":\"2025-10-02\",\"rest\":1},\"10-03\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":3,\"date\":\"2025-10-03\",\"rest\":1},\"10-04\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":2,\"date\":\"2025-10-04\",\"rest\":1},\"10-05\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":2,\"date\":\"2025-10-05\",\"rest\":1},\"10-06\":{\"holiday\":true,\"name\":\"\u4e2d\u79cb\u8282\",\"wage\":2,\"date\":\"2025-10-06\",\"rest\":1},\"10-07\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":2,\"date\":\"2025-10-07\",\"rest\":1},\"10-08\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":2,\"date\":\"2025-10-08\",\"rest\":1},\"10-11\":{\"holiday\":false,\"after\":true,\"wage\":1,\"name\":\"\u56fd\u5e86\u8282\u540e\u8865\u73ed\",\"target\":\"\u56fd\u5e86\u8282\",\"date\":\"2025-10-11\"}}}");
            JSONObject holiday = json.getJSONObject("holiday");
            if (holiday.size() == 0) {
                return "No!";
            }
            ArrayList<String> hoList = new ArrayList<String>();
            ArrayList<String> extraList = new ArrayList<String>();
            for (Map.Entry entry : holiday.entrySet()) {
                String value = entry.getValue().toString();
                JSONObject jsonObject = JSONObject.parseObject((String)value);
                String hoBool = jsonObject.getString("holiday");
                String extra = jsonObject.getString("date");
                if (hoBool.equals("true")) {
                    hoList.add(extra);
                    HolidayUtil.holiday.put(date, hoList);
                    continue;
                }
                extraList.add(extra);
                extraWorkDay.put(date, extraList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    static {
        Calendar cleansMonday = Calendar.getInstance();
        cleansMonday.set(2024, 2, 30);
        holidays.add(cleansMonday);
        Calendar laborDay = Calendar.getInstance();
        laborDay.set(2024, 4, 1);
        holidays.add(laborDay);
        holiday = new HashMap<String, List<String>>();
        extraWorkDay = new HashMap<String, List<String>>();
    }
}

