/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.common.util.StringUtils;
import com.bringspring.contract.entity.AfterSalesProjectsEntity;
import com.bringspring.contract.entity.RkAgentEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProductEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.SaleNoContractEntity;
import com.bringspring.contract.service.AfterSalesProjectsService;
import com.bringspring.contract.service.RkAgentService;
import com.bringspring.contract.service.RkContractProductService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.service.SaleContractCustomerService;
import com.bringspring.contract.service.SaleNoContractService;
import com.bringspring.contract.utils.AllMaintenanceTypeEnum;
import com.bringspring.visit.entity.AfterSalesMaintenanceEntity;
import com.bringspring.visit.service.AfterSalesCommunicationRecordService;
import com.bringspring.visit.service.AfterSalesMaintenanceService;
import com.bringspring.visit.utils.HolidayUtil;
import com.bringspring.visit.utils.QuestionTimeUtil;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MaintenanceScheduledTaskUtil {
    Logger logger = LoggerFactory.getLogger(QuestionTimeUtil.class);
    @Autowired
    private AfterSalesMaintenanceService afterSalesMaintenanceService;
    @Autowired
    private AfterSalesCommunicationRecordService afterSalesCommunicationRecordService;
    @Autowired
    private AfterSalesProjectsService afterSalesProjectsService;
    @Autowired
    private RkContractProductService rkContractProductService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private SaleContractCustomerService saleContractCustomerService;
    @Autowired
    private SaleNoContractService saleNoContractService;
    @Autowired
    private RkContractService contractService;
    @Autowired
    private RkAgentService agentService;

    @JsbosTask(fullName="\u540c\u6b65\u7ef4\u4fdd\u8ddf\u8fdb\u6570\u636e", description="\u540c\u6b65\u7ef4\u4fdd\u8ddf\u8fdb\u6570\u636e", cron="0 0 4 * * ?")
    public void getSynchronousData() throws Exception {
        List<AfterSalesProjectsEntity> list = this.afterSalesProjectsService.getListAll();
        List distinctStudents = list.stream().collect(Collectors.toMap(AfterSalesProjectsEntity2 -> Arrays.asList(AfterSalesProjectsEntity2.getCustomerId(), AfterSalesProjectsEntity2.getIncomeType()), AfterSalesProjectsEntity2 -> AfterSalesProjectsEntity2, (existing, replacement) -> existing.getWarrantyEndDate().compareTo(replacement.getWarrantyEndDate()) > 0 ? existing : replacement)).values().stream().collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(distinctStudents)) {
            for (AfterSalesProjectsEntity afterSalesProjectsEntity : distinctStudents) {
                LocalDate endDate;
                LocalDate now;
                String collect;
                List<RkContractProductEntity> listByContractId;
                AfterSalesMaintenanceEntity maintenanceEntity = new AfterSalesMaintenanceEntity();
                maintenanceEntity.setFollowStatus(AllMaintenanceTypeEnum.FOLLOWED.getType());
                maintenanceEntity.setProjectId(afterSalesProjectsEntity.getProjectId());
                maintenanceEntity.setProjectName(afterSalesProjectsEntity.getProjectName());
                maintenanceEntity.setProjectCode(afterSalesProjectsEntity.getProjectCode());
                maintenanceEntity.setProjectAmount(afterSalesProjectsEntity.getProjectAmount());
                maintenanceEntity.setSalerId(afterSalesProjectsEntity.getSalerId());
                maintenanceEntity.setSalerName(afterSalesProjectsEntity.getSalerName());
                maintenanceEntity.setCompanyId(afterSalesProjectsEntity.getCompanyId());
                maintenanceEntity.setProductId(afterSalesProjectsEntity.getProduct());
                maintenanceEntity.setTransferDate(afterSalesProjectsEntity.getTransferDate());
                maintenanceEntity.setCustomerId(afterSalesProjectsEntity.getCustomerId());
                maintenanceEntity.setCustomerName(afterSalesProjectsEntity.getCustomerName());
                maintenanceEntity.setState(afterSalesProjectsEntity.getWarrantyState());
                maintenanceEntity.setExpirationDate(afterSalesProjectsEntity.getWarrantyEndDate());
                maintenanceEntity.setContractSignDate(afterSalesProjectsEntity.getContractSignDate());
                maintenanceEntity.setAfterSalesRegional(afterSalesProjectsEntity.getAfterSalesManager());
                maintenanceEntity.setAfterSalesPerson(afterSalesProjectsEntity.getAfterSalesAssistant());
                maintenanceEntity.setDepartmentId(afterSalesProjectsEntity.getDepartment());
                maintenanceEntity.setAssistantsUser(afterSalesProjectsEntity.getAssistantsUser());
                maintenanceEntity.setIncomeType(afterSalesProjectsEntity.getIncomeType());
                maintenanceEntity.setCustomerAddress(afterSalesProjectsEntity.getAddress());
                RkContractProjectEntity projectEntity = this.rkContractProjectService.getInfo(afterSalesProjectsEntity.getProjectId());
                if (ObjectUtil.isNull((Object)projectEntity)) {
                    RkContractProjectEntity info = this.rkContractProjectService.getInfo(afterSalesProjectsEntity.getId());
                    if (ObjectUtil.isNotEmpty((Object)info)) {
                        projectEntity = info;
                    } else {
                        this.logger.error("\u9879\u76eeid\uff1a{}\uff0c\u9879\u76ee\u4e0d\u5b58\u5728", (Object)afterSalesProjectsEntity.getId());
                        continue;
                    }
                }
                RkContractEntity contractEntity = (RkContractEntity)this.contractService.getById((Serializable)((Object)projectEntity.getContractId()));
                if (!StrUtil.isBlank((CharSequence)projectEntity.getContractId())) {
                    listByContractId = this.rkContractProductService.getListByContractId(projectEntity.getContractId());
                    collect = listByContractId.stream().map(RkContractProductEntity::getProductName).collect(Collectors.joining(","));
                    String productList = listByContractId.stream().map(RkContractProductEntity::getProductId).collect(Collectors.joining(","));
                    maintenanceEntity.setProductId(productList);
                    maintenanceEntity.setProductName(collect);
                    if (ObjectUtil.isNotEmpty((Object)contractEntity)) {
                        maintenanceEntity.setContractId(contractEntity.getId());
                        maintenanceEntity.setContractCode(contractEntity.getContractCode());
                        maintenanceEntity.setContractName(contractEntity.getContractName());
                        maintenanceEntity.setContractAmount(contractEntity.getContractAmount());
                        maintenanceEntity.setAgentId(contractEntity.getAgentId());
                        if (ObjectUtil.equals((Object)contractEntity.getIsAgent(), (Object)1)) {
                            RkAgentEntity agent;
                            if (StringUtils.isNotEmpty((String)contractEntity.getAgentId()) && null != (agent = this.agentService.getInfo(contractEntity.getAgentId()))) {
                                maintenanceEntity.setAgentName(agent.getName());
                            }
                        } else if (StringUtils.isNotEmpty((String)contractEntity.getCustomerIds())) {
                            maintenanceEntity.setAgentName(this.saleContractCustomerService.getCustomerNamesByContractId(contractEntity.getId()));
                        }
                    }
                } else if (!StrUtil.isBlank((CharSequence)projectEntity.getNoContractId())) {
                    listByContractId = this.rkContractProductService.getListByContractId(projectEntity.getNoContractId());
                    collect = listByContractId.stream().map(RkContractProductEntity::getProductName).collect(Collectors.joining(","));
                    String productList = listByContractId.stream().map(RkContractProductEntity::getProductId).collect(Collectors.joining(","));
                    maintenanceEntity.setProductId(productList);
                    maintenanceEntity.setProductName(collect);
                    SaleNoContractEntity noContract = (SaleNoContractEntity)this.saleNoContractService.getById((Serializable)((Object)projectEntity.getNoContractId()));
                    if (null != noContract) {
                        maintenanceEntity.setContractId(noContract.getId());
                        maintenanceEntity.setContractCode(noContract.getContractCode());
                        maintenanceEntity.setContractName(noContract.getContractName());
                        maintenanceEntity.setContractAmount(noContract.getExpectedContractAmount());
                        maintenanceEntity.setAgentId(noContract.getCustomerId());
                        if (StringUtils.isNotEmpty((String)noContract.getCustomerIds())) {
                            maintenanceEntity.setAgentName(this.saleContractCustomerService.getCustomerNamesByContractId(noContract.getId()));
                        }
                    }
                }
                if (ObjectUtil.isNotEmpty((Object)maintenanceEntity.getState()) && ObjectUtil.isNotEmpty((Object)maintenanceEntity.getExpirationDate()) && !StrUtil.equals((CharSequence)maintenanceEntity.getState(), (CharSequence)"derelivery")) {
                    now = LocalDate.now();
                    long between = ChronoUnit.DAYS.between(now, endDate = LocalDate.ofEpochDay(maintenanceEntity.getExpirationDate().getTime() / 86400000L));
                    if ((int)between <= 60) {
                        maintenanceEntity.setWarrantyState(AllMaintenanceTypeEnum.NORMAL.getType());
                    }
                    if ((int)between <= 0 && (int)between >= -60) {
                        maintenanceEntity.setWarrantyState(AllMaintenanceTypeEnum.OVERDUEWARNING.getType());
                    }
                }
                if (StrUtil.equals((CharSequence)maintenanceEntity.getState(), (CharSequence)"derelivery") && ObjectUtil.isNotEmpty((Object)maintenanceEntity.getExpirationDate())) {
                    now = LocalDate.now();
                    endDate = LocalDate.ofEpochDay(maintenanceEntity.getExpirationDate().getTime() / 86400000L);
                    long between = ChronoUnit.DAYS.between(endDate, now);
                    if ((int)between <= 60) {
                        maintenanceEntity.setWarrantyState(AllMaintenanceTypeEnum.NORMAL.getType());
                    }
                    if ((int)between <= 0 && (int)between >= -60) {
                        maintenanceEntity.setWarrantyState(AllMaintenanceTypeEnum.OVERDUEWARNING.getType());
                    }
                }
                this.afterSalesMaintenanceService.create(maintenanceEntity);
            }
        }
    }

    @JsbosTask(fullName="\u81ea\u52a8\u8ddf\u8fdb\u72b6\u6001", description="\u81ea\u52a8\u8ddf\u8fdb\u72b6\u6001", cron="0 0 1 * * ?")
    public void getFollowStatus() throws Exception {
        List<String> list;
        List<AfterSalesMaintenanceEntity> list2;
        List<AfterSalesMaintenanceEntity> allList;
        List<AfterSalesMaintenanceEntity> list3 = this.afterSalesMaintenanceService.getListAll(null, AllMaintenanceTypeEnum.OVERDUE.getType());
        if (CollectionUtil.isNotEmpty(list3)) {
            for (AfterSalesMaintenanceEntity afterSalesMaintenanceEntity : list3) {
                if (HolidayUtil.judgmentDate(new Date(), afterSalesMaintenanceEntity.getNextCommunicationDate()).booleanValue()) {
                    afterSalesMaintenanceEntity.setFollowStatus(AllMaintenanceTypeEnum.OVERDUE.getType());
                }
                this.afterSalesMaintenanceService.update(afterSalesMaintenanceEntity.getId(), afterSalesMaintenanceEntity);
            }
        }
        if (CollectionUtil.isNotEmpty(allList = this.afterSalesMaintenanceService.getListAll(null, "all"))) {
            for (AfterSalesMaintenanceEntity entity : allList) {
                long between;
                LocalDate endDate;
                LocalDate now;
                if (ObjectUtil.isNotEmpty((Object)entity.getState()) && ObjectUtil.isNotEmpty((Object)entity.getExpirationDate()) && !StrUtil.equals((CharSequence)entity.getState(), (CharSequence)"derelivery")) {
                    now = LocalDate.now();
                    between = ChronoUnit.DAYS.between(now, endDate = LocalDate.ofEpochDay(entity.getExpirationDate().getTime() / 86400000L));
                    if ((int)between <= 60) {
                        entity.setWarrantyState(AllMaintenanceTypeEnum.NORMAL.getType());
                    }
                    if ((int)between <= 0 && (int)between >= -60) {
                        entity.setWarrantyState(AllMaintenanceTypeEnum.OVERDUEWARNING.getType());
                    }
                }
                if (StrUtil.equals((CharSequence)entity.getState(), (CharSequence)"derelivery") && ObjectUtil.isNotEmpty((Object)entity.getExpirationDate())) {
                    now = LocalDate.now();
                    endDate = LocalDate.ofEpochDay(entity.getExpirationDate().getTime() / 86400000L);
                    between = ChronoUnit.DAYS.between(endDate, now);
                    if ((int)between <= 60) {
                        entity.setWarrantyState(AllMaintenanceTypeEnum.NORMAL.getType());
                    }
                    if ((int)between <= 0 && (int)between >= -60) {
                        entity.setWarrantyState(AllMaintenanceTypeEnum.OVERDUEWARNING.getType());
                    }
                }
                this.afterSalesMaintenanceService.update(entity.getId(), entity);
            }
        }
        if (CollectionUtil.isNotEmpty(list2 = this.afterSalesMaintenanceService.getListAll(list = this.afterSalesCommunicationRecordService.getSupertimeList(), AllMaintenanceTypeEnum.ABNORMAL.getType()))) {
            for (AfterSalesMaintenanceEntity entity : list2) {
                entity.setWarrantyState(AllMaintenanceTypeEnum.ABNORMAL.getType());
                this.afterSalesMaintenanceService.update(entity.getId(), entity);
            }
        }
    }
}

