/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.constant.MessageTypeEnum;
import com.bringspring.contract.entity.AfterSalesProjectsEntity;
import com.bringspring.contract.entity.RkContractEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.service.AfterSalesProjectsService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkContractService;
import com.bringspring.contract.utils.Constants;
import com.bringspring.contract.utils.DateUtils;
import com.bringspring.crm.config.OpportunityPushConfig;
import com.bringspring.crm.entity.CrmCustomerEntity;
import com.bringspring.crm.service.CrmCustomerService;
import com.bringspring.crm.util.CrmReminderEnum;
import com.bringspring.system.base.entity.MessageTemplateEntity;
import com.bringspring.system.base.entity.ModuleEntity;
import com.bringspring.system.base.exception.LoginException;
import com.bringspring.system.base.service.MessageTemplateService;
import com.bringspring.system.base.service.ModuleService;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.external.util.JSSDKUtil;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.mapper.SynThirdInfoMapper;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.msgcenter.util.SendTaskMsgUtils;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.utils.MessageUtils;
import com.bringspring.visit.entity.AfterSalesFollowRulesEntity;
import com.bringspring.visit.entity.AfterSalesInspectTaskEntity;
import com.bringspring.visit.entity.AfterSalesQuestionEntity;
import com.bringspring.visit.entity.AfterSalesQuestionTrendsEntity;
import com.bringspring.visit.entity.AfterSalesRepairDetailEntity;
import com.bringspring.visit.entity.AfterSalesRepairEntity;
import com.bringspring.visit.entity.AfterSalesTelephoneTaskDetailEntity;
import com.bringspring.visit.entity.AfterSalesTelephoneTaskEntity;
import com.bringspring.visit.entity.RkMarketLogEntity;
import com.bringspring.visit.model.rkMarketLog.RkMarketLogCrForm;
import com.bringspring.visit.model.rkMarketLog.RkMrketLogProjectListVO;
import com.bringspring.visit.service.AfterSalesFollowRulesService;
import com.bringspring.visit.service.AfterSalesInspectTaskService;
import com.bringspring.visit.service.AfterSalesQuestionService;
import com.bringspring.visit.service.AfterSalesQuestionTrendsService;
import com.bringspring.visit.service.AfterSalesRepairDetailService;
import com.bringspring.visit.service.AfterSalesRepairService;
import com.bringspring.visit.service.AfterSalesTelephoneTaskDetailService;
import com.bringspring.visit.service.AfterSalesTelephoneTaskService;
import com.bringspring.visit.service.RkMarketLogService;
import com.bringspring.visit.utils.CreateChatInfo;
import com.bringspring.visit.utils.HolidayUtil;
import com.bringspring.visit.utils.QuestionEnableMarkEnum;
import com.bringspring.visit.utils.QuestionTrendsTypeEnum;
import com.bringspring.visit.utils.RoleVisitUtils;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import com.bringspring.workitem.service.CrmWorkitemService;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QuestionTimeUtil {
    Logger logger = LoggerFactory.getLogger(QuestionTimeUtil.class);
    @Autowired
    private AfterSalesQuestionService afterSalesQuestionService;
    @Autowired
    private AfterSalesProjectsService afterSalesProjectsService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AfterSalesQuestionTrendsService afterSalesQuestionTrendsService;
    @Autowired
    private MessageTemplateService messageTemplateService;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private OpportunityPushConfig opportunityPushConfig;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private UserService userService;
    @Autowired
    private RoleVisitUtils roleVisitUtils;
    @Autowired
    private RkMarketLogService rkMarketLogService;
    @Autowired
    private SendTaskMsgUtils sendTaskMsgUtils;
    @Autowired
    private AfterSalesRepairDetailService afterSalesRepairDetailService;
    @Autowired
    private AfterSalesRepairService afterSalesRepairService;
    @Autowired
    private AfterSalesTelephoneTaskService afterSalesTelephoneTaskService;
    @Autowired
    private AfterSalesTelephoneTaskDetailService afterSalesTelephoneTaskDetailService;
    @Autowired
    private AfterSalesInspectTaskService afterSalesInspectTaskService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private AfterSalesQuestionTrendsService AfterSalesQuestionTrendsService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private CrmWorkitemService crmWorkitemService;
    @Autowired
    private RkContractService rkContractService;
    @Autowired
    private CrmCustomerService crmCustomerService;
    @Autowired
    private AfterSalesFollowRulesService afterSalesFollowRulesService;

    @JsbosTask(fullName="\u552e\u540e\u5de5\u5355\u548c400\u5de5\u5355\u81ea\u52a8\u5173\u95ed", description="\u552e\u540e\u5de5\u5355\u548c400\u5de5\u5355\u81ea\u52a8\u5173\u95ed", cron="0 0 2 * * ?")
    public void workOrderCloseVisit() throws Exception {
        List<AfterSalesQuestionEntity> listAll = this.afterSalesQuestionService.workOrderCloseVisit();
        if (CollectionUtil.isNotEmpty(listAll)) {
            for (AfterSalesQuestionEntity entity : listAll) {
                Calendar newDate400;
                Calendar newDate;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(entity.getDealTime());
                entity.setCloseReason("\u5df2\u81ea\u52a8\u5173\u95ed");
                entity.setCloseType(2);
                if (entity.getFeedbackSource() == 4 && this.getSubtractDate((newDate = HolidayUtil.addWorkdaysToDate(calendar, 7)).getTime(), new Date()) <= 0) {
                    entity.setEnabledMark(QuestionTrendsTypeEnum.CLOSE_ORDER_TYPE.getType());
                    entity.setCloseTime(DateUtil.getNowDate());
                    this.afterSalesQuestionService.updateById(entity);
                    this.afterSalesQuestionTrendsService.createTrends(entity.getId(), QuestionTrendsTypeEnum.CLOSE_ORDER_TYPE.getType(), entity.getCloseReason(), "admin", null);
                }
                if (entity.getFeedbackSource() != 2 || this.getSubtractDate((newDate400 = HolidayUtil.addWorkdaysToDate(calendar, 3)).getTime(), new Date()) > 0) continue;
                entity.setEnabledMark(QuestionTrendsTypeEnum.CLOSE_ORDER_TYPE.getType());
                entity.setCloseTime(DateUtil.getNowDate());
                this.afterSalesQuestionService.updateById(entity);
                this.afterSalesQuestionTrendsService.createTrends(entity.getId(), QuestionTrendsTypeEnum.CLOSE_ORDER_TYPE.getType(), entity.getCloseReason(), "admin", null);
            }
        }
    }

    @JsbosTask(fullName="\u65e5\u5e38\u968f\u8bbf\u81ea\u52a8\u751f\u6210", description="\u65e5\u5e38\u968f\u8bbf\u81ea\u52a8\u751f\u6210", cron="0 1/10 * * * ?")
    public void dailyWorkOrderVisit() throws Exception {
        List<RkContractEntity> list = this.rkContractService.getAfterSalesDaily();
        AfterSalesFollowRulesEntity rulesEntity = this.afterSalesFollowRulesService.getByType();
        if (ObjectUtil.isNull((Object)rulesEntity)) {
            return;
        }
        if (StrUtil.equals((CharSequence)DateUtil.daFormat((Date)rulesEntity.getOneAfterSalesTime()), (CharSequence)DateUtil.daFormat((Date)new Date()))) {
            this.addAfterSalesTelephoneTaskRkContract(list, "dailyFollow");
            rulesEntity.setBeforeAfterSalesTime(new Date());
            this.afterSalesFollowRulesService.updateById(rulesEntity);
        } else if (ObjectUtil.isNotEmpty((Object)rulesEntity.getBeforeAfterSalesTime())) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(rulesEntity.getBeforeAfterSalesTime());
            Calendar threeDaysLater = HolidayUtil.addWorkdaysToDate(calendar, rulesEntity.getCycle());
            if (this.getSubtractDate(threeDaysLater.getTime(), new Date()) <= 0) {
                this.addAfterSalesTelephoneTaskRkContract(list, "dailyFollow");
                rulesEntity.setBeforeAfterSalesTime(new Date());
                this.afterSalesFollowRulesService.updateById(rulesEntity);
            }
        }
    }

    private void addAfterSalesTelephoneTaskRkContract(List<RkContractEntity> listAll, String templateType) {
        if (CollectionUtil.isNotEmpty(listAll)) {
            List<RkContractEntity> rk = listAll.stream().filter(x -> x.getCompanyId().equals("2")).collect(Collectors.toList());
            List<RkContractEntity> sh = listAll.stream().filter(x -> x.getCompanyId().equals("14")).collect(Collectors.toList());
            List<RkContractEntity> mj = listAll.stream().filter(x -> x.getCompanyId().equals("9")).collect(Collectors.toList());
            List<RkContractEntity> jc = listAll.stream().filter(x -> x.getCompanyId().equals("3")).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(rk)) {
                this.addAfterSalesTelepList(rk, templateType);
            }
            if (CollectionUtil.isNotEmpty(sh)) {
                this.addAfterSalesTelepList(sh, templateType);
            }
            if (CollectionUtil.isNotEmpty(mj)) {
                this.addAfterSalesTelepList(mj, templateType);
            }
            if (CollectionUtil.isNotEmpty(jc)) {
                this.addAfterSalesTelepList(jc, templateType);
            }
        }
    }

    public void addAfterSalesTelepList(List<RkContractEntity> list, String templateType) {
        AfterSalesTelephoneTaskEntity taskEntity = new AfterSalesTelephoneTaskEntity();
        taskEntity.setId(RandomUtil.uuId());
        taskEntity.setCompanyId(list.get(0).getCompanyId());
        taskEntity.setName(DateUtil.daFormat((Date)new Date()) + " " + this.baseDataUtil.getDictName(templateType, "TelephonefollowUpType"));
        taskEntity.setType(templateType);
        taskEntity.setIsAuto("automaticGeneration");
        taskEntity.setCreatorUserId("admin");
        taskEntity.setEnabledMark(0);
        taskEntity.setType(templateType);
        this.afterSalesTelephoneTaskService.create(taskEntity);
        for (RkContractEntity entity : list) {
            AfterSalesTelephoneTaskDetailEntity detailEntity = new AfterSalesTelephoneTaskDetailEntity();
            detailEntity.setId(RandomUtil.uuId());
            detailEntity.setTaskId(taskEntity.getId());
            detailEntity.setTaskName(taskEntity.getName());
            detailEntity.setCreatorOrganize(entity.getCompanyId());
            CrmCustomerEntity info = this.crmCustomerService.getInfo(entity.getCustomerId());
            if (ObjectUtil.isNotEmpty((Object)info)) {
                detailEntity.setCreatorUserId(info.getCreatorUserId());
                detailEntity.setCustomerId(info.getId());
                detailEntity.setCustomerName(info.getName());
                detailEntity.setAddress(info.getAddress());
            }
            detailEntity.setType(templateType);
            detailEntity.setEnabledMark(0);
            this.afterSalesTelephoneTaskDetailService.create(detailEntity);
        }
    }

    @JsbosTask(fullName="400\u5de5\u5355\u968f\u8bbf\u81ea\u52a8\u751f\u6210", description="400\u5de5\u5355\u968f\u8bbf\u81ea\u52a8\u751f\u6210", cron="0 10 3 * * ?")
    public void workOrderVisit400() throws Exception {
        List<AfterSalesQuestionEntity> list400 = this.afterSalesQuestionService.getListFeedbackSourceTime();
        this.getWorkOrderVisit400(list400);
    }

    public void getWorkOrderVisit400(List<AfterSalesQuestionEntity> list) {
        ArrayList<AfterSalesQuestionEntity> listAll = new ArrayList<AfterSalesQuestionEntity>();
        String templateType = "";
        if (CollectionUtil.isNotEmpty(list)) {
            for (AfterSalesQuestionEntity entity : list) {
                Calendar threeDaysLater;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(entity.getCloseTime());
                if (entity.getFeedbackSource() != 2 || this.getSubtractDate((threeDaysLater = HolidayUtil.addWorkdaysToDate(calendar, 1)).getTime(), new Date()) > 0) continue;
                listAll.add(entity);
                templateType = "workOrderFollow400";
            }
        }
        this.getByCompanyId(listAll, templateType);
    }

    @JsbosTask(fullName="\u5de5\u5355\u968f\u8bbf\u81ea\u52a8\u751f\u6210", description="\u5de5\u5355\u968f\u8bbf\u81ea\u52a8\u751f\u6210", cron="0 0 3 * * ?")
    public void workOrderVisit() throws Exception {
        List<AfterSalesQuestionEntity> list = this.afterSalesQuestionService.getListAndBeforeTime();
        this.getWorkOrderAll(list);
    }

    public void getWorkOrderAll(List<AfterSalesQuestionEntity> list) {
        ArrayList<AfterSalesQuestionEntity> listAll = new ArrayList<AfterSalesQuestionEntity>();
        String templateType = "";
        if (CollectionUtil.isNotEmpty(list)) {
            for (AfterSalesQuestionEntity entity : list) {
                Calendar threeDaysLater2;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(entity.getCloseTime());
                if (entity.getFeedbackSource() != 1 && entity.getFeedbackSource() != 3 && entity.getFeedbackSource() != 4 || this.getSubtractDate((threeDaysLater2 = HolidayUtil.addWorkdaysToDate(calendar, 7)).getTime(), new Date()) > 0) continue;
                listAll.add(entity);
                templateType = "workOrderFollow";
            }
        }
        this.getByCompanyId(listAll, templateType);
    }

    private void getByCompanyId(List<AfterSalesQuestionEntity> listAll, String templateType) {
        if (CollectionUtil.isNotEmpty(listAll)) {
            ArrayList<AfterSalesQuestionEntity> rk = new ArrayList<AfterSalesQuestionEntity>();
            ArrayList<AfterSalesQuestionEntity> sh = new ArrayList<AfterSalesQuestionEntity>();
            ArrayList<AfterSalesQuestionEntity> mj = new ArrayList<AfterSalesQuestionEntity>();
            ArrayList<AfterSalesQuestionEntity> jc = new ArrayList<AfterSalesQuestionEntity>();
            for (AfterSalesQuestionEntity entity : listAll) {
                if (StringUtils.isEmpty((String)entity.getProductCompanyId())) continue;
                if (entity.getProductCompanyId().equals("2")) {
                    sh.add(entity);
                    continue;
                }
                if (entity.getProductCompanyId().equals("14")) {
                    sh.add(entity);
                    continue;
                }
                if (entity.getProductCompanyId().equals("9")) {
                    mj.add(entity);
                    continue;
                }
                if (!entity.getProductCompanyId().equals("3")) continue;
                jc.add(entity);
            }
            this.addAfterSalesTelephoneTask(rk, templateType);
            this.addAfterSalesTelephoneTask(sh, templateType);
            this.addAfterSalesTelephoneTask(mj, templateType);
            this.addAfterSalesTelephoneTask(jc, templateType);
        }
    }

    private void addAfterSalesTelephoneTask(List<AfterSalesQuestionEntity> list, String templateType) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        AfterSalesTelephoneTaskEntity taskEntity = new AfterSalesTelephoneTaskEntity();
        taskEntity.setId(RandomUtil.uuId());
        taskEntity.setCompanyId(list.get(0).getProductCompanyId());
        taskEntity.setName(DateUtil.daFormat((Date)new Date()) + " " + this.baseDataUtil.getDictName(templateType, "TelephonefollowUpType"));
        taskEntity.setType(templateType);
        taskEntity.setIsAuto("automaticGeneration");
        taskEntity.setCreatorUserId("admin");
        taskEntity.setEnabledMark(0);
        this.afterSalesTelephoneTaskService.create(taskEntity);
        for (AfterSalesQuestionEntity entity : list) {
            entity.setIsAutogeneration(1);
            this.afterSalesQuestionService.updateById(entity);
            AfterSalesTelephoneTaskDetailEntity detailEntity = new AfterSalesTelephoneTaskDetailEntity();
            detailEntity.setId(RandomUtil.uuId());
            detailEntity.setQuestionId(entity.getId());
            detailEntity.setTelephoneQuestionId(entity.getId());
            detailEntity.setTelephoneQuestionName(entity.getDescription());
            detailEntity.setTaskId(taskEntity.getId());
            detailEntity.setTaskName(taskEntity.getName());
            detailEntity.setCreatorOrganize(entity.getProductCompanyId());
            detailEntity.setCreatorUserId(entity.getCreatorUserId());
            detailEntity.setCustomerId(entity.getCustomerId());
            detailEntity.setCustomerName(entity.getCustomerName());
            detailEntity.setType(entity.getFeedbackSource() == 2 ? "workOrderFollow400" : "workOrderFollow");
            detailEntity.setEnabledMark(0);
            detailEntity.setProjectId(entity.getProjectId());
            detailEntity.setProjectName(entity.getProjectName());
            CrmCustomerEntity byId1 = (CrmCustomerEntity)this.crmCustomerService.getById((Serializable)((Object)entity.getCustomerId()));
            if (ObjectUtil.isNotEmpty((Object)byId1)) {
                detailEntity.setAddress(byId1.getAddress());
            }
            this.afterSalesTelephoneTaskDetailService.create(detailEntity);
        }
    }

    @JsbosTask(fullName="\u552e\u540e\u5de5\u5355\u672a\u5173\u95ed\u8d85\u51fa\u4e09\u5929\u63d0\u9192", description="\u552e\u540e\u5de5\u5355\u672a\u5173\u95ed\u8d85\u51fa\u4e09\u5929\u63d0\u9192", cron="0 0 8 * * ?")
    public void workOrderBeyond() throws Exception {
        List<String> userIdList;
        String type;
        String appUrl;
        String pcUrl;
        String title;
        List<Object> list;
        String workingDay = HolidayUtil.isWorkingDay(HolidayUtil.getdaNow());
        if ("0".equals(workingDay)) {
            list = this.afterSalesQuestionService.getByDealType();
            List<AfterSalesQuestionEntity> userList = this.afterSalesQuestionService.getByDealSource();
            list.addAll(userList);
            ArrayList<AfterSalesQuestionEntity> listAll = new ArrayList<AfterSalesQuestionEntity>();
            if (CollectionUtil.isNotEmpty(list)) {
                for (AfterSalesQuestionEntity afterSalesQuestionEntity : list) {
                    Date threeDaysLater;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(afterSalesQuestionEntity.getDealTime());
                    switch (afterSalesQuestionEntity.getCompanyId()) {
                        case "2": {
                            calendar.add(5, 2);
                            break;
                        }
                    }
                    if (this.getSubtractDate(threeDaysLater = calendar.getTime(), new Date()) > 0) continue;
                    listAll.add(afterSalesQuestionEntity);
                }
            }
            title = "\u60a8\u6709\u552e\u540e\u5de5\u5355\u8d85\u8fc73\u5929\u672a\u5173\u95ed\uff0c\u8bf7\u53ca\u65f6\u5904\u7406";
            String string = "\u60a8\u6709\u552e\u540e\u5de5\u5355\u8d85\u8fc73\u5929\u672a\u5173\u95ed\uff0c\u8bf7\u53ca\u65f6\u5904\u7406";
            pcUrl = "/#/after-sales/question?resolved=resolved";
            appUrl = "/#/pages/afterSale/sale-create/index";
            type = TermTypeEnum.TERM_APP_PC.getCode();
            List feedbackSourceList = listAll.stream().filter(s -> s.getFeedbackSource() == 3).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(feedbackSourceList)) {
                ArrayList<String> userId = new ArrayList<String>();
                userId.add("15716693072");
                this.crmWorkitemService.newSendMessage("\u552e\u540e\u5de5\u5355", "afterSalesOrder", title, string, appUrl, pcUrl, userId, type, null);
            }
            if (CollectionUtil.isNotEmpty(userIdList = listAll.stream().filter(s -> s.getFeedbackSource() != 3).map(AfterSalesQuestionEntity::getCreatorUserId).collect(Collectors.toList()))) {
                this.crmWorkitemService.newSendMessage("\u552e\u540e\u5de5\u5355", "afterSalesOrder", title, string, appUrl, pcUrl, userIdList, type, null);
            }
        }
        if ("0".equals(workingDay) && CollectionUtil.isNotEmpty(list = this.afterSalesTelephoneTaskDetailService.getRemindTime())) {
            for (Object entity : list) {
                title = "\u5206\u6d3e\u7ed9\u60a8\u7684\u552e\u540e\u968f\u8bbf\u672a\u5b8c\u6210\uff0c\u8bf7\u53ca\u65f6\u5904\u7406";
                String string = "\u5206\u6d3e\u7ed9\u60a8\u7684\u552e\u540e\u968f\u8bbf\u672a\u5b8c\u6210\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\n\u6267\u884c\u7ed3\u675f\u65e5\u671f\uff1a" + DateUtil.daFormat((Date)((AfterSalesTelephoneTaskDetailEntity)entity).getExecutionEndDate());
                pcUrl = "/#/after-sales/telephone/result";
                String type2 = TermTypeEnum.TERM_PC.getCode();
                String typeDesc = "\u8bf7\u7528pc\u7aef\u6253\u5f00\u94fe\u63a5\uff0c\u8fdb\u884c\u4fe1\u606f\u786e\u8ba4";
                ArrayList<String> userIdList2 = new ArrayList<String>();
                userIdList2.add(((AfterSalesTelephoneTaskDetailEntity)entity).getAcceptorId());
                this.crmWorkitemService.newSendMessage("\u552e\u540e\u5de5\u5355", "afterSalesOrder", title, string, null, pcUrl, userIdList2, type2, typeDesc);
            }
        }
        if ("0".equals(workingDay) && CollectionUtil.isNotEmpty(list = this.afterSalesInspectTaskService.getRemindTime())) {
            for (Object entity : list) {
                title = "\u5206\u6d3e\u7ed9\u60a8\u7684\u56de\u8bbf\u4efb\u52a1\u672a\u5b8c\u6210\uff0c\u8bf7\u53ca\u65f6\u5904\u7406";
                String string = "\u5206\u6d3e\u7ed9\u60a8\u7684\u56de\u8bbf\u4efb\u52a1\u672a\u5b8c\u6210\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\n\u6267\u884c\u7ed3\u675f\u65e5\u671f\uff1a" + DateUtil.daFormat((Date)((AfterSalesInspectTaskEntity)entity).getExecutionEndTime());
                pcUrl = "/#/after-sales/telephone/result";
                appUrl = "/#/pages/afterSale/inspect/myInspect/index";
                type = TermTypeEnum.TERM_APP_PC.getCode();
                String typeDesc = "\u8bf7\u7528pc\u7aef\u6253\u5f00\u94fe\u63a5\uff0c\u8fdb\u884c\u4fe1\u606f\u786e\u8ba4";
                userIdList = new ArrayList();
                userIdList.add(((AfterSalesInspectTaskEntity)entity).getInspectUserId());
                this.crmWorkitemService.newSendMessage("\u552e\u540e\u5de5\u5355", "afterSalesOrder", title, string, appUrl, pcUrl, userIdList, type, typeDesc);
            }
        }
    }

    private Integer getSubtractDate(Date start, Date end) {
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        endCalendar.setTime(end);
        long milliseconds = start.getTime() - end.getTime();
        int days = (int)(milliseconds / 86400000L);
        return days;
    }

    @JsbosTask(fullName="\u7ef4\u4fee\u5355\u8fc7\u671f\u63d0\u9192", description="\u7ef4\u4fee\u5355\u8fc7\u671f\u63d0\u9192", cron="0 0 10,11,12,13,14,15,16,17 * * ?")
    public void maintainRemindPast() throws Exception {
        List<AfterSalesRepairDetailEntity> list;
        if (QuestionTimeUtil.isWithinWorkingHours(LocalTime.now()) && CollectionUtil.isNotEmpty(list = this.afterSalesRepairDetailService.getMaintainRemindPast())) {
            for (AfterSalesRepairDetailEntity entity : list) {
                AfterSalesRepairEntity info = this.afterSalesRepairService.getInfo(entity.getRepairId());
                if (!ObjectUtil.isNotEmpty((Object)info)) continue;
                this.afterSalesRepairService.getSendMessage(info, "remindPast", entity.getId());
            }
        }
    }

    public static boolean isWithinWorkingHours(LocalTime time) {
        LocalTime startTime = LocalTime.of(10, 0);
        LocalTime endTime = LocalTime.of(16, 0);
        return !time.isBefore(startTime) && !time.isAfter(endTime);
    }

    @JsbosTask(fullName="\u4ea4\u4ed8\u65e5\u5fd7\u672a\u63d0\u4ea4\u63d0\u9192", description="\u4ea4\u4ed8\u65e5\u5fd7\u672a\u63d0\u4ea4\u63d0\u9192", cron="0 0 18 * * ?")
    public void deliveryLogRemind() throws Exception {
        String workingDay = HolidayUtil.isWorkingDay(HolidayUtil.getdaNow());
        if ("0".equals(workingDay)) {
            ArrayList<String> orgIdList = new ArrayList<String>();
            List companyById = this.organizeService.getUnderOrganizations("562965037317098181");
            List technologyCompanyById = this.organizeService.getUnderOrganizations("562965589052623557");
            orgIdList.addAll(companyById);
            orgIdList.addAll(technologyCompanyById);
            orgIdList.add("462179070071810885");
            List userList = this.userService.getUserByOrgIds(orgIdList);
            List userIds = userList.stream().map(UserEntity::getId).collect(Collectors.toList());
            List<RkMarketLogEntity> marketLogList = this.rkMarketLogService.getDateTime();
            List marketUserId = marketLogList.stream().map(RkMarketLogEntity::getCreatorUserId).collect(Collectors.toList());
            List ids = ListUtils.subtract(userIds, marketUserId);
            try {
                String url = this.sysConfigService.getConfigByKeyName("sysMobileUrl").getKeyValue();
                String pcUrl = "/#/visit/projectLog";
                String page = "/#/pages/market/delivery-log/form?jurisdictionType=btn_detail";
                String messageTime = DateUtil.dateFormat((Date)new Date());
                String title = "\u4eca\u65e5\u672a\u63d0\u4ea4\u4ea4\u4ed8\u65e5\u5fd7\uff0c\u8bf7\u5c3d\u5feb\u63d0\u4ea4\uff01";
                String content = "\u4eca\u65e5\u672a\u63d0\u4ea4\u4ea4\u4ed8\u65e5\u5fd7\uff0c\u8bf7\u5c3d\u5feb\u63d0\u4ea4\uff01\n" + messageTime;
                String type = TermTypeEnum.TERM_APP_PC.getCode();
                this.crmWorkitemService.newSendMessage("\u9879\u76ee\u7ba1\u7406", Constants.marketLog, title, content, page, pcUrl, ids, type, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @JsbosTask(fullName="\u8d85\u8fc77\u5929\u672a\u5ba1\u6838\u552e\u540e\u95ee\u9898\u63d0\u9192", description="\u8d85\u8fc77\u5929\u672a\u5ba1\u6838\u552e\u540e\u95ee\u9898\u63d0\u9192", cron="0 0 9 * * ?")
    public void pushToAudit() throws Exception {
        Date date = DateUtil.dateAddDays((Date)DateUtil.getNowDate(), (int)-8);
        List<AfterSalesQuestionEntity> audit = this.afterSalesQuestionService.getListByEnabledMarkAndBeforeTime("audit", date);
        this.logger.info("\u67e5\u8be2\u5f85\u5ba1\u6838\u7684\u95ee\u9898:{} \u6761", (Object)audit.size());
        if (audit.size() == 0) {
            return;
        }
        String title = "\u6709\u5f85\u60a8\u5ba1\u6838\u7684\u552e\u540e\u95ee\u9898\uff0c\u8bf7\u67e5\u6536!";
        String content = "\u6709" + audit.size() + "\u6761\u552e\u540e\u95ee\u9898\u8d85\u8fc77\u5929\u672a\u5ba1\u6838!";
        this.sendAudit(audit, title, content);
    }

    public void sendAudit(List<AfterSalesQuestionEntity> audit, String title, String content) throws Exception {
        List list = this.moduleService.getList("App", "", "2", "1", "", "verifyQuestion");
        String appMenuId = "";
        if (CollectionUtil.isNotEmpty((Collection)list) && list.size() == 1) {
            appMenuId = ((ModuleEntity)list.get(0)).getId();
        }
        if (StrUtil.isEmpty((CharSequence)appMenuId)) {
            appMenuId = "495258172785696581";
        }
        List webList = this.moduleService.getList("Web", "", "2", "1", "", "afterSalesQuestion");
        String webMenuId = "";
        if (CollectionUtil.isNotEmpty((Collection)webList) && webList.size() == 1) {
            webMenuId = ((ModuleEntity)webList.get(0)).getId();
        }
        if (StrUtil.isEmpty((CharSequence)webMenuId)) {
            webMenuId = "495142155980027397";
        }
        String url = "pages/afterSale/sale-create/index?menuId=" + appMenuId;
        List userIdList = CollectionUtil.list((boolean)false, (Object[])new String[]{"15252124869"});
        this.pushQuestion(title, content, userIdList, appMenuId, webMenuId, url);
    }

    @JsbosTask(fullName="\u552e\u540e\u95ee\u9898\u5ba1\u6838\u901a\u8fc7\u4e4b\u540e\u672a\u5206\u6d3e\u7684\u6bcf\u5929\u63d0\u9192\u4e00\u6b21", description="\u552e\u540e\u95ee\u9898\u5ba1\u6838\u901a\u8fc7\u4e4b\u540e\u672a\u5206\u6d3e\u7684\u6bcf\u5929\u63d0\u9192\u4e00\u6b21", cron="0 0 9 * * ?")
    public void pushToAccepted() throws Exception {
        List<AfterSalesQuestionEntity> accepted = this.afterSalesQuestionService.getListByEnabledMarkAndBeforeTime("accepted", new Date());
        this.logger.info("\u67e5\u8be2\u5f85\u5b50\u516c\u53f8\u8d1f\u8d23\u4eba\u5206\u6d3e\u7684\u95ee\u9898:{} \u6761", (Object)accepted.size());
        if (accepted.size() == 0) {
            return;
        }
        List list = this.moduleService.getList("App", "", "2", "1", "", "verifyQuestion");
        String appMenuId = "";
        if (CollectionUtil.isNotEmpty((Collection)list) && list.size() == 1) {
            appMenuId = ((ModuleEntity)list.get(0)).getId();
        }
        if (StrUtil.isEmpty((CharSequence)appMenuId)) {
            appMenuId = "495258172785696581";
        }
        List webList = this.moduleService.getList("Web", "", "2", "1", "", "afterSalesQuestion");
        String webMenuId = "";
        if (CollectionUtil.isNotEmpty((Collection)webList) && webList.size() == 1) {
            webMenuId = ((ModuleEntity)webList.get(0)).getId();
        }
        if (StrUtil.isEmpty((CharSequence)webMenuId)) {
            webMenuId = "495142155980027397";
        }
        String url = "pages/afterSale/sale-create/index?menuId=" + appMenuId;
        String title = "\u6709\u5f85\u60a8\u5904\u7406\u7684\u552e\u540e\u95ee\u9898\uff0c\u8bf7\u67e5\u6536!";
        String content = "\u6709\u7ed9\u60a8\u5206\u6d3e\u7684\u552e\u540e\u95ee\u9898\u8bf7\u53ca\u65f6\u5206\u6d3e\u5904\u7406!";
        Set collect = accepted.stream().filter(s -> StrUtil.isNotEmpty((CharSequence)s.getProcessedBy())).map(AfterSalesQuestionEntity::getProcessedBy).collect(Collectors.toSet());
        this.pushQuestion(title, content, CollectionUtil.list((boolean)false, collect), appMenuId, webMenuId, url);
    }

    @JsbosTask(fullName="\u552e\u540e\u95ee\u9898\u8d85\u671f30\u5929\u621610\u5929\u672a\u5904\u7406\u6d88\u606f\u63d0\u9192", description="\u8d85\u671f(1|5|10|30)\u672a\u5904\u7406\u552e\u540e\u95ee\u9898\u63d0\u9192", cron="0 0 9,14 * * ?")
    public void problemExpiredUnprocessedMessage() throws Exception {
        List<AfterSalesQuestionEntity> assign = this.afterSalesQuestionService.getListByEnabledMark();
        String title = "";
        String content = "";
        for (AfterSalesQuestionEntity question : assign) {
            int days;
            List<Object> userIds = new ArrayList<String>();
            String userName = this.baseDataUtil.userSelectValueNoAccount(question.getProcessedBy());
            if (QuestionEnableMarkEnum.ENABLE_PENDING_ORDERS.getEnableMark().equals(question.getEnabledMark())) {
                List<AfterSalesQuestionTrendsEntity> trends;
                if (ObjectUtil.isEmpty((Object)question.getReceivedDate()) && ObjectUtil.isNotEmpty(trends = this.AfterSalesQuestionTrendsService.getListByQuestionId(question.getId()))) {
                    for (AfterSalesQuestionTrendsEntity trend : trends) {
                        if (!QuestionTrendsTypeEnum.ASSIGN_TYPE.getType().equals(trend.getType())) continue;
                        question.setReceivedDate(trend.getCreatorTime());
                        break;
                    }
                }
                if (ObjectUtil.isEmpty((Object)question.getReceivedDate())) continue;
                days = DateUtil.getDiffDays((Date)question.getReceivedDate(), (Date)new Date());
                if (days >= 1) {
                    if (StringUtils.isNotEmpty((String)question.getProcessedBy())) {
                        userIds.add(question.getProcessedBy());
                    }
                    title = "\u6709\u4e00\u4e2a[" + question.getCustomerName() + "]\u7684\u552e\u540e\u95ee\u9898\u6307\u6d3e\u7ed9\u60a8\uff0c\u5df2\u8d85\u8fc7 24 \u5c0f\u65f6\u672a\u63a5\u5355\uff01";
                    content = "\u6709\u4e00\u4e2a[" + question.getCustomerName() + "]\u7684\u552e\u540e\u95ee\u9898\u6307\u6d3e\u7ed9\u60a8\uff0c\u5df2\u8d85\u8fc7 24 \u5c0f\u65f6\u672a\u63a5\u5355\uff0c\u8bf7\u53ca\u65f6\u63a5\u5355\u6216\u5206\u6d3e\uff01\u95ee\u9898\u7f16\u53f7[" + question.getQuestionNumber() + "]\u3002";
                }
            } else {
                List<AfterSalesQuestionTrendsEntity> trends;
                if (QuestionTrendsTypeEnum.PENDING_TYPE.getType().equals(question.getEnabledMark())) {
                    question.setReceivedDate(question.getEstimatedTime());
                }
                if (ObjectUtil.isEmpty((Object)question.getReceivedDate()) && ObjectUtil.isNotEmpty(trends = this.AfterSalesQuestionTrendsService.getListByQuestionId(question.getId()))) {
                    for (AfterSalesQuestionTrendsEntity trend : trends) {
                        if (!question.getEnabledMark().equals(trend.getType())) continue;
                        question.setReceivedDate(trend.getCreatorTime());
                        break;
                    }
                }
                if (ObjectUtil.isEmpty((Object)question.getEstimatedTime())) continue;
                days = DateUtil.getDiffDays((Date)question.getEstimatedTime(), (Date)new Date());
                if (days >= 1) {
                    List<String> ids;
                    title = "\u60a8\u6709\u4e00\u4e2a[" + question.getCustomerName() + "]\u63d0\u4ea4\u7684\u552e\u540e\u95ee\u9898\u5df2\u8d85\u8fc7 24 \u5c0f\u65f6\u672a\u5904\u7406\uff01";
                    content = "\u60a8\u6709\u4e00\u4e2a[" + question.getCustomerName() + "]\u63d0\u4ea4\u7684\u552e\u540e\u95ee\u9898\u5df2\u8d85\u8fc7 24 \u5c0f\u65f6\u672a\u5904\u7406\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\uff01\u95ee\u9898\u7f16\u53f7[" + question.getQuestionNumber() + "]\u3002";
                    if (StringUtils.isNotEmpty((String)question.getProcessedBy())) {
                        userIds.add(question.getProcessedBy());
                    }
                    String companyId = question.getProductCompanyId();
                    if (5 <= days && 10 > days) {
                        title = "[" + question.getCustomerName() + "]\u63d0\u4ea4\u7684\u552e\u540e\u95ee\u9898\u5df2\u8d85\u8fc7" + days + " \u5929\u672a\u5904\u7406\uff01";
                        content = "[" + question.getCustomerName() + "]\u63d0\u4ea4\u7684\u552e\u540e\u95ee\u9898\u5df2\u8d85\u8fc7 " + days + " \u5929\u672a\u5904\u7406\uff0c\u8bf7\u63d0\u9192[" + userName + "]\u53ca\u65f6\u5904\u7406\uff01\u95ee\u9898\u7f16\u53f7[" + question.getQuestionNumber() + "]\u3002";
                        UserEntity user = this.userService.getInfo(question.getProcessedBy());
                        if (ObjectUtil.isNotNull((Object)user) && StringUtils.isNotEmpty((String)user.getManagerId())) {
                            userIds.add(user.getManagerId());
                        }
                    }
                    if (10 <= days && 30 > days) {
                        title = "[" + question.getCustomerName() + "]\u63d0\u4ea4\u7684\u552e\u540e\u95ee\u9898\u5df2\u8d85\u8fc7" + days + "\u5929\u672a\u5904\u7406\uff01";
                        content = "[" + question.getCustomerName() + "]\u63d0\u4ea4\u7684\u552e\u540e\u95ee\u9898\uff0c\u5df2\u8d85\u8fc7" + days + " \u5929\u672a\u5904\u7406\uff0c\u8bf7\u63d0\u9192[" + userName + "]\u53ca\u65f6\u5904\u7406\uff01\u95ee\u9898\u7f16\u53f7[" + question.getQuestionNumber() + "]\u3002";
                        ids = this.getUserIdsByRoleId(companyId, 10);
                        if (ObjectUtil.isNotEmpty(ids)) {
                            userIds.addAll(ids);
                        }
                    }
                    if (30 <= days) {
                        title = "[" + question.getCustomerName() + "]\u63d0\u4ea4\u7684\u552e\u540e\u95ee\u9898\u5df2\u8d85\u8fc7 30 \u5929\u672a\u5904\u7406\uff01";
                        content = "[" + question.getCustomerName() + "]\u63d0\u4ea4\u7684\u552e\u540e\u95ee\u9898\uff0c\u5df2\u8d85\u8fc7 30 \u5929\u672a\u5904\u7406\uff0c\u8bf7\u63d0\u9192[" + userName + "]\u53ca\u65f6\u5904\u7406\uff01\u95ee\u9898\u7f16\u53f7[" + question.getQuestionNumber() + "]\u3002";
                        ids = this.getUserIdsByRoleId(companyId, 30);
                        if (ObjectUtil.isNotEmpty(ids)) {
                            userIds.addAll(ids);
                        }
                    }
                    if (60 <= days) {
                        title = "[" + question.getCustomerName() + "]\u63d0\u4ea4\u7684\u552e\u540e\u95ee\u9898\u5df2\u8d85\u8fc7 60 \u5929\u672a\u5904\u7406\uff01";
                        content = "[" + question.getCustomerName() + "]\u63d0\u4ea4\u7684\u552e\u540e\u95ee\u9898\uff0c\u5df2\u8d85\u8fc7 60 \u5929\u672a\u5904\u7406\uff0c\u8bf7\u63d0\u9192[" + userName + "]\u53ca\u65f6\u5904\u7406\uff01\u95ee\u9898\u7f16\u53f7[" + question.getQuestionNumber() + "]\u3002";
                        userIds.add("410818927690520453");
                    }
                }
            }
            if (!ObjectUtil.isNotEmpty(userIds)) continue;
            userIds = userIds.stream().distinct().collect(Collectors.toList());
            userIds = userIds.stream().filter(str -> !str.isEmpty()).collect(Collectors.toList());
            List list = this.moduleService.getList("App", "", "2", "1", "", "toMe");
            String appMenuId = "";
            if (CollectionUtil.isNotEmpty((Collection)list) && list.size() == 1) {
                appMenuId = ((ModuleEntity)list.get(0)).getId();
            }
            List webList = this.moduleService.getList("Web", "", "2", "1", "", "afterSalesQuestion");
            String webMenuId = "";
            if (CollectionUtil.isNotEmpty((Collection)webList) && webList.size() == 1) {
                webMenuId = ((ModuleEntity)webList.get(0)).getId();
            }
            if (StrUtil.isEmpty((CharSequence)appMenuId)) {
                appMenuId = "495258172785696581";
            }
            if (StrUtil.isEmpty((CharSequence)webMenuId)) {
                webMenuId = "495142155980027397";
            }
            String url = "pages/afterSale/sale-create/form?jurisdictionType=btn_detail&id=" + question.getId() + "&menuId=" + appMenuId + "&type=2&title=\u6307\u6d3e\u7ed9\u6211";
            String feedbackSourceDesc = this.baseDataUtil.getDictName(question.getFeedbackSource() + "", "questionFeedbackSource");
            this.pushQuestion(title, content, userIds, appMenuId, webMenuId, url, question.getCustomerName(), question.getReceivedDate(), userName, question.getId(), feedbackSourceDesc);
        }
    }

    private void pushQuestion(String title, String content, List<String> userIdList, String appMeuId, String webMenuId, String url, String customerName, Date receivedDate, String processedUser, String questionId, String feedbackSourceDesc) throws Exception {
        String taskCode = MessageTypeEnum.AFTER_SALES_QUESTION_MSG.getMessage();
        String sendCode = MessageTypeEnum.AFTER_SALES_QUESTION_MSG.getTemplateCode();
        HashMap keys = MapUtil.newHashMap();
        String messageTime = DateUtil.dateFormat((Date)new Date());
        keys.put("title", title);
        keys.put("content", content);
        keys.put("customerName", customerName);
        keys.put("receivedDate", receivedDate + "");
        keys.put("processedUser", processedUser);
        keys.put("feedbackSourceDesc", feedbackSourceDesc);
        keys.put("MessageTime", messageTime);
        String appUrl = "/#/" + url;
        String pcUrl = "/#/after-sales/question?id=" + questionId;
        String type = TermTypeEnum.TERM_APP_PC.getCode();
        this.messageUtils.sendMessageNew(taskCode, sendCode, keys, null, appUrl, pcUrl, CollectionUtil.join(userIdList, (CharSequence)","), type, null);
    }

    List<String> getUserIdsByRoleId(String companyId, Integer days) {
        String roleId;
        List userList;
        ArrayList<String> userIds = new ArrayList<String>();
        String roleCode = "";
        roleCode = days == 30 ? QuestionEnableMarkEnum.QUESTION_EXCEED_30.getEnableMark() : QuestionEnableMarkEnum.QUESTION_EXCEED_10.getEnableMark();
        List roelList = this.roleService.getListByEnCode(roleCode);
        if (ObjectUtil.isNotEmpty((Object)roelList) && ObjectUtil.isNotEmpty((Object)(userList = this.userService.getUserListByRoleId(roleId = ((RoleEntity)roelList.get(0)).getId())))) {
            for (UserEntity user : userList) {
                if ("\u738b\u529f\u5b66".equals(user.getRealName())) {
                    userIds.add(user.getId());
                    continue;
                }
                OrganizeEntity org = this.organizeService.getInfo(user.getOrganizeId());
                if (!ObjectUtil.isNotEmpty((Object)org) || !companyId.equals(org.getOrganizeId())) continue;
                userIds.add(user.getId());
            }
        }
        return userIds;
    }

    @JsbosTask(fullName="\u8d85\u8fc77\u5929\u672a\u5904\u7406\u552e\u540e\u95ee\u9898\u63d0\u9192", description="\u8d85\u8fc77\u5929\u672a\u5904\u7406\u552e\u540e\u95ee\u9898\u63d0\u9192", cron="0 0 9 * * ?")
    public void pushToAssign() throws Exception {
        Date date = DateUtil.dateAddDays((Date)DateUtil.getNowDate(), (int)-8);
        List<AfterSalesQuestionEntity> assign = this.afterSalesQuestionService.getListByEnabledMarkAndBeforeTime("assign", date);
        this.logger.info("\u67e5\u8be2\u5f85\u89e3\u51b3\u7684\u95ee\u9898:{} \u6761", (Object)assign.size());
        if (assign.size() == 0) {
            return;
        }
        List list = this.moduleService.getList("App", "", "2", "1", "", "toMe");
        String appMenuId = "";
        if (CollectionUtil.isNotEmpty((Collection)list) && list.size() == 1) {
            appMenuId = ((ModuleEntity)list.get(0)).getId();
        }
        List webList = this.moduleService.getList("Web", "", "2", "1", "", "afterSalesQuestion");
        String webMenuId = "";
        if (CollectionUtil.isNotEmpty((Collection)webList) && webList.size() == 1) {
            webMenuId = ((ModuleEntity)webList.get(0)).getId();
        }
        if (StrUtil.isEmpty((CharSequence)appMenuId)) {
            appMenuId = "495258172785696581";
        }
        if (StrUtil.isEmpty((CharSequence)webMenuId)) {
            webMenuId = "495142155980027397";
        }
        Set collect = assign.stream().filter(s -> StrUtil.isNotEmpty((CharSequence)s.getProcessedBy())).map(AfterSalesQuestionEntity::getProcessedBy).collect(Collectors.toSet());
        String url = "pages/afterSale/sale-create/index?menuId=" + appMenuId;
        String title = "\u6709\u5f85\u60a8\u5904\u7406\u7684\u552e\u540e\u95ee\u9898\uff0c\u8bf7\u67e5\u6536!";
        String content = "\u6709\u7ed9\u60a8\u5206\u6d3e\u7684\u552e\u540e\u95ee\u9898\u8d85\u8fc77\u5929\u672a\u5904\u7406\uff0c\u8bf7\u53ca\u65f6\u5904\u7406!";
        this.pushQuestion(title, content, CollectionUtil.list((boolean)false, collect), appMenuId, webMenuId, url);
    }

    @JsbosTask(fullName="\u8d85\u8fc715\u5929\u672a\u89e3\u51b3\u552e\u540e\u95ee\u9898\u63d0\u9192\uff08\u5f85\u89e3\u51b3\u7684\uff09", description="\u8d85\u8fc715\u5929\u672a\u89e3\u51b3\u552e\u540e\u95ee\u9898\u63d0\u9192\uff08\u5f85\u89e3\u51b3\u7684\uff09", cron="0 0 9 * * ?")
    public void pushToDocked() throws Exception {
        Date date = DateUtil.dateAddDays((Date)DateUtil.getNowDate(), (int)-15);
        List<AfterSalesQuestionEntity> docked = this.afterSalesQuestionService.getListByEnabledMarkAndBeforeTime("docked", date);
        this.logger.info("\u67e5\u8be2\u5f85\u5bf9\u63a5\u7684\u95ee\u9898:{} \u6761", (Object)docked.size());
        if (docked.size() == 0) {
            return;
        }
        List list = this.moduleService.getList("App", "", "2", "1", "", "toMe");
        String appMenuId = "";
        if (CollectionUtil.isNotEmpty((Collection)list) && list.size() == 1) {
            appMenuId = ((ModuleEntity)list.get(0)).getId();
        }
        List webList = this.moduleService.getList("Web", "", "2", "1", "", "afterSalesQuestion");
        String webMenuId = "";
        if (CollectionUtil.isNotEmpty((Collection)webList) && webList.size() == 1) {
            webMenuId = ((ModuleEntity)webList.get(0)).getId();
        }
        if (StrUtil.isEmpty((CharSequence)appMenuId)) {
            appMenuId = "495258172785696581";
        }
        if (StrUtil.isEmpty((CharSequence)webMenuId)) {
            webMenuId = "495142155980027397";
        }
        String url = "pages/afterSale/sale-create/index?menuId=" + appMenuId;
        Set collect = docked.stream().filter(s -> StrUtil.isNotEmpty((CharSequence)s.getProcessedBy()) && cn.hutool.core.date.DateUtil.betweenDay((Date)s.getCreatorTime(), (Date)new Date(), (boolean)true) % 15L == 0L).map(AfterSalesQuestionEntity::getProcessedBy).collect(Collectors.toSet());
        String title = "\u6709\u5f85\u60a8\u5904\u7406\u7684\u552e\u540e\u95ee\u9898\uff0c\u8bf7\u67e5\u6536!";
        String content = "\u6709\u5f85\u60a8\u5904\u7406\u7684\u5df2\u5bf9\u63a5\u7684\u552e\u540e\u95ee\u9898\u8d85\u8fc715\u5929\u672a\u89e3\u51b3\uff0c\u8bf7\u53ca\u65f6\u89e3\u51b3!";
        this.pushQuestion(title, content, CollectionUtil.list((boolean)false, collect), appMenuId, webMenuId, url);
    }

    private void pushQuestion(String title, String content, List<String> userIdList, String appMeuId, String webMenuId, String url) throws Exception {
        String taskCode = MessageTypeEnum.AFTER_SALES_QUESTION_SIMPLE_MSG.getMessage();
        String sendCode = MessageTypeEnum.AFTER_SALES_QUESTION_SIMPLE_MSG.getTemplateCode();
        HashMap keys = MapUtil.newHashMap();
        keys.put("title", title);
        keys.put("content", content);
        keys.put("MessageTime", DateUtil.getNow());
        String appUrl = "/#/" + url;
        String pcUrl = "/#/after-sales/question";
        String type = TermTypeEnum.TERM_APP_PC.getCode();
        this.messageUtils.sendMessageNew(taskCode, sendCode, keys, null, appUrl, pcUrl, CollectionUtil.join(userIdList, (CharSequence)","), type, null);
    }

    private SentMessageForm getMessageForm(Integer type, String templateCode) {
        QueryWrapper templateEntityQueryWrapper = new QueryWrapper();
        templateEntityQueryWrapper.lambda().eq(MessageTemplateEntity::getEnCode, (Object)templateCode);
        MessageTemplateEntity one = (MessageTemplateEntity)this.messageTemplateService.getOne((Wrapper)templateEntityQueryWrapper);
        if (ObjectUtil.isEmpty((Object)one)) {
            this.logger.info("\u672a\u914d\u7f6e\u6d88\u606f\u6a21\u677f,code:{}", (Object)templateCode);
            return null;
        }
        SentMessageForm sentMessageForm = new SentMessageForm();
        sentMessageForm.setType(type);
        sentMessageForm.setTemplateId(one.getId());
        return sentMessageForm;
    }

    public static String getCreateChat(CreateChatInfo info) throws Exception {
        if (StrUtil.isEmpty((CharSequence)info.getChatid())) {
            return null;
        }
        InputStream is = null;
        BufferedReader br = null;
        String accessToken = JSSDKUtil.getAccessToken();
        String url = " https://qyapi.weixin.qq.com/cgi-bin/appchat/get??access_token=" + accessToken + "&chatid=" + info.getChatid();
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("GET");
        con.setRequestProperty("Accept", "application/json");
        int responseCode = con.getResponseCode();
        if (responseCode == 200) {
            is = con.getInputStream();
            br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            StringBuffer stringBuffer = new StringBuffer();
            String line = null;
            while ((line = br.readLine()) != null) {
                stringBuffer.append(line);
                stringBuffer.append("\r\n");
            }
            String result = stringBuffer.toString();
            return result;
        }
        throw new LoginException("\u4f01\u4e1a\u5fae\u4fe1\u83b7\u53d6\u7fa4\u804a\u4fe1\u606f\u5931\u8d25\uff01", responseCode);
    }

    public static void createChat(CreateChatInfo info) throws Exception {
        if (CollectionUtil.isEmpty(info.getUserlist()) || info.getUserlist().size() < 2) {
            return;
        }
        SynThirdInfoService synThirdInfoService = (SynThirdInfoService)SpringContext.getBean(SynThirdInfoService.class);
        List listByObjId = synThirdInfoService.getListByObjId(Integer.valueOf("1"), info.getUserlist());
        if (CollectionUtil.isEmpty((Collection)listByObjId)) {
            return;
        }
        List userIdList = listByObjId.stream().map(SynThirdInfoEntity::getThirdObjectId).collect(Collectors.toList());
        SynThirdInfoMapper synThirdInfoMapper = (SynThirdInfoMapper)SpringContext.getBean(SynThirdInfoMapper.class);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SynThirdInfoEntity::getThirdType, (Object)Integer.valueOf("1"));
        queryWrapper.lambda().eq(SynThirdInfoEntity::getSystemObjectId, (Object)info.getOwner());
        SynThirdInfoEntity synThirdInfoEntity = (SynThirdInfoEntity)synThirdInfoMapper.selectOne((Wrapper)queryWrapper);
        if (ObjectUtil.isNotEmpty((Object)synThirdInfoEntity)) {
            info.setOwner(synThirdInfoEntity.getThirdObjectId());
        } else {
            info.setOwner((String)userIdList.get(0));
        }
        RedisUtil redisUtil = (RedisUtil)SpringContext.getBean(RedisUtil.class);
        redisUtil.remove("js_sdk_access_token");
        String accessToken = JSSDKUtil.getAccessToken();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/appchat/create?access_token=" + accessToken;
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/json");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)info.getName());
        jsonObject.put("owner", (Object)info.getOwner());
        jsonObject.put("userlist", userIdList);
        jsonObject.put("chatid", (Object)info.getChatid());
        con.setDoOutput(true);
        try (OutputStream os = con.getOutputStream();){
            byte[] input = jsonObject.toJSONString().getBytes("utf-8");
            os.write(input, 0, input.length);
        }
        int responseCode = con.getResponseCode();
        if (responseCode != 200) {
            throw new LoginException("\u4f01\u4e1a\u5fae\u4fe1\u81ea\u52a8\u62c9\u7fa4\u5931\u8d25\uff01", responseCode);
        }
    }

    public static void updateCreateChat(CreateChatInfo info) throws Exception {
        if (StrUtil.isEmpty((CharSequence)info.getChatid())) {
            return;
        }
        if (CollectionUtil.isEmpty(info.getAddUserList())) {
            return;
        }
        List<Object> addUserLsit = new ArrayList();
        List<Object> delUserList = new ArrayList();
        SynThirdInfoService synThirdInfoService = (SynThirdInfoService)SpringContext.getBean(SynThirdInfoService.class);
        List listByObjId = synThirdInfoService.getListByObjId(Integer.valueOf("1"), info.getAddUserList());
        if (CollectionUtil.isEmpty((Collection)listByObjId)) {
            return;
        }
        addUserLsit = listByObjId.stream().map(SynThirdInfoEntity::getThirdObjectId).collect(Collectors.toList());
        if (StrUtil.isNotEmpty((CharSequence)info.getOwner())) {
            SynThirdInfoMapper synThirdInfoMapper = (SynThirdInfoMapper)SpringContext.getBean(SynThirdInfoMapper.class);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(SynThirdInfoEntity::getThirdType, (Object)Integer.valueOf("1"));
            queryWrapper.lambda().eq(SynThirdInfoEntity::getSystemObjectId, (Object)info.getOwner());
            SynThirdInfoEntity synThirdInfoEntity = (SynThirdInfoEntity)synThirdInfoMapper.selectOne((Wrapper)queryWrapper);
            if (ObjectUtil.isNotEmpty((Object)synThirdInfoEntity)) {
                info.setOwner(synThirdInfoEntity.getThirdObjectId());
            } else {
                info.setOwner((String)addUserLsit.get(0));
            }
        }
        if (CollectionUtil.isNotEmpty(info.getDelUserList())) {
            List listByObjId2 = synThirdInfoService.getListByObjId(Integer.valueOf("1"), info.getDelUserList());
            delUserList = listByObjId2.stream().map(SynThirdInfoEntity::getThirdObjectId).collect(Collectors.toList());
        }
        String accessToken = JSSDKUtil.getAccessToken();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/appchat/update?access_token=" + accessToken;
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/json");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("chatid", (Object)info.getChatid());
        jsonObject.put("owner", (Object)info.getOwner());
        jsonObject.put("add_user_list", addUserLsit);
        jsonObject.put("del_user_list", delUserList);
        con.setDoOutput(true);
        try (OutputStream os = con.getOutputStream();){
            byte[] input = jsonObject.toJSONString().getBytes("utf-8");
            os.write(input, 0, input.length);
        }
        int responseCode = con.getResponseCode();
        if (responseCode != 200) {
            throw new LoginException("\u4f01\u4e1a\u5fae\u4fe1\u4fee\u6539\u7fa4\u804a\u6210\u5458\u5931\u8d25\uff01", responseCode);
        }
    }

    public static void sendMessage(CreateChatInfo info) throws Exception {
        if (StrUtil.isEmpty((CharSequence)info.getChatid())) {
            return;
        }
        String accessToken = JSSDKUtil.getAccessToken();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/appchat/send?access_token=" + accessToken;
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/json");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("chatid", (Object)info.getChatid());
        jsonObject.put("msgtype", (Object)info.getMsgType());
        JSONObject contentJSon = new JSONObject();
        contentJSon.put("title", (Object)info.getTitle());
        contentJSon.put("description", (Object)info.getDescription());
        contentJSon.put("url", (Object)info.getUrl());
        contentJSon.put("btntxt", (Object)info.getBtnTxt());
        jsonObject.put("textcard", (Object)contentJSon);
        jsonObject.put("saft", (Object)info.getSafe());
        con.setDoOutput(true);
        try (OutputStream os = con.getOutputStream();){
            byte[] input = jsonObject.toJSONString().getBytes("utf-8");
            os.write(input, 0, input.length);
        }
        int responseCode = con.getResponseCode();
        if (responseCode != 200) {
            throw new LoginException("\u4f01\u4e1a\u5fae\u4fe1\u53d1\u9001\u7fa4\u804a\u6d88\u606f\u5931\u8d25\uff01", responseCode);
        }
    }

    @JsbosTask(fullName="\u552e\u540e\u5de5\u5355\u540c\u6b65\u5230\u4ea4\u4ed8\u65e5\u5fd7", description="\u552e\u540e\u5de5\u5355\u540c\u6b65\u5230\u4ea4\u4ed8\u65e5\u5fd7", cron="0 0 19 * * ?")
    public void afterSalesQuestionLogRemind() throws Exception {
        UserInfo userInfo = this.userProvider.get();
        List<AfterSalesQuestionEntity> entityList = this.afterSalesQuestionService.byTodayUserList();
        for (AfterSalesQuestionEntity subentity : entityList) {
            AfterSalesProjectsEntity afterSalesProjectsEntity = this.afterSalesProjectsService.getInfo(subentity.getProjectId());
            RkMarketLogCrForm form = new RkMarketLogCrForm();
            form.setLogType("672368944337665733");
            form.setOptionDate(HolidayUtil.getNow());
            form.setTitle(userInfo.getUserName() + DateUtil.daFormat((Date)DateUtils.getNowDate()) + "\u9879\u76ee\u5de5\u4f5c\u65e5\u62a5");
            form.setManHour(subentity.getManHour());
            String type = this.baseDataUtil.getDictName(subentity.getType(), "problemType");
            form.setContent("\u6700\u7ec8\u5ba2\u6237\uff1a" + subentity.getCustomerName() + "\n\u5de5\u5355\u7c7b\u578b\uff1a" + type + "\n\u5de5\u65f6\uff1a" + subentity.getManHour() + "\uff08\u65f6\uff09");
            form.setState("1");
            form.setMarketType("afterSale");
            form.setAfterSalesQuestionId(subentity.getId());
            form.setIsAutomatic(CrmReminderEnum.TS.getType());
            List<AfterSalesQuestionEntity> questionUserList = this.afterSalesQuestionService.byTodayUserList(subentity.getCreatorUserId());
            ArrayList<RkMrketLogProjectListVO> projectListVO = new ArrayList<RkMrketLogProjectListVO>();
            for (AfterSalesQuestionEntity entity : questionUserList) {
                RkContractProjectEntity info = null;
                if (ObjectUtil.isNotEmpty((Object)afterSalesProjectsEntity) && ObjectUtil.isNull((Object)(info = this.rkContractProjectService.getInfo(afterSalesProjectsEntity.getProjectId())))) continue;
                RkMrketLogProjectListVO vo = new RkMrketLogProjectListVO();
                vo.setCustomerId(entity.getCustomerId());
                vo.setCustomerName(entity.getCustomerName());
                vo.setRkContractProjectId(info.getId());
                vo.setRkContractProjectName(entity.getProjectName());
                vo.setContent(entity.getDescription());
                vo.setManHour(String.valueOf(entity.getManHour()));
                projectListVO.add(vo);
            }
            form.setProjectLogDetaList(projectListVO);
            this.rkMarketLogService.insert(form);
        }
    }

    public static void main(String[] args) throws Exception {
        int i = 0;
        System.out.println(i);
    }
}

