/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.MessageTemplateEntity;
import com.bringspring.system.base.entity.ProvinceEntity;
import com.bringspring.system.base.mapper.DictionaryDataMapper;
import com.bringspring.system.base.mapper.ProvinceMapper;
import com.bringspring.system.base.service.MessageTemplateService;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PermissionEntityBase;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.mapper.OrganizeMapper;
import com.bringspring.system.permission.mapper.UserMapper;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.visit.constant.CacheKeyVisitUtil;
import com.github.pagehelper.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserRelationUtil {
    Logger logger = LoggerFactory.getLogger(UserRelationUtil.class);
    @Autowired
    private RoleService roleService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private UserService userService;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private ProvinceMapper provinceMapper;
    @Autowired
    private OrganizeMapper organizeMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private MessageTemplateService messageTemplateService;
    @Autowired
    private DictionaryDataMapper dictionaryDataMapper;

    public List<DictionaryDataEntity> dictByCodeAndTypeId(String code, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(DictionaryDataEntity::getEnCode, (Object)code)).eq(DictionaryDataEntity::getDictionaryTypeId, (Object)id);
        return this.dictionaryDataMapper.selectList((Wrapper)queryWrapper);
    }

    public List<String> getUserRoleInFo(List<String> roleIds, Integer type) {
        ArrayList<String> roleCode;
        ArrayList<String> roleType;
        block4: {
            roleType = new ArrayList<String>();
            roleCode = new ArrayList<String>();
            if (roleIds.isEmpty() || roleIds.size() <= 0) break block4;
            if (type == 0) {
                for (String roleId : roleIds) {
                    RoleEntity info = this.roleService.getInfo(roleId);
                    roleType.add(info.getType());
                }
            } else {
                for (String roleId : roleIds) {
                    RoleEntity info = this.roleService.getInfo(roleId);
                    roleCode.add(info.getEnCode());
                }
            }
        }
        return type == 0 ? roleType : roleCode;
    }

    public SentMessageForm getMessageForm(Integer type, String templateCode) {
        QueryWrapper templateEntityQueryWrapper = new QueryWrapper();
        templateEntityQueryWrapper.lambda().eq(MessageTemplateEntity::getEnCode, (Object)templateCode);
        MessageTemplateEntity one = (MessageTemplateEntity)this.messageTemplateService.getOne((Wrapper)templateEntityQueryWrapper);
        if (Objects.isNull(one)) {
            this.logger.info("\u672a\u914d\u7f6e\u6d88\u606f\u6a21\u677f,code:{}", (Object)templateCode);
            return null;
        }
        SentMessageForm sentMessageForm = new SentMessageForm();
        sentMessageForm.setType(type);
        sentMessageForm.setTemplateId(one.getId());
        return sentMessageForm;
    }

    public List<UserRelationEntity> getListByRoleCode(String code) {
        List listByEnCode = this.roleService.getListByEnCode(code);
        if (CollectionUtil.isEmpty((Collection)listByEnCode)) {
            return CollectionUtil.list((boolean)false);
        }
        String roleId = ((RoleEntity)listByEnCode.get(0)).getId();
        List list = this.userRelationService.getListByObjectId(roleId, "Role");
        return list;
    }

    public List<UserRelationEntity> getListByObjectType(String objectType) {
        List list = this.userRelationService.getListByObjectId(null, objectType);
        return list;
    }

    public String userSelectValuesNoAccount(String ids) {
        if (StringUtil.isEmpty((String)ids)) {
            return ids;
        }
        if (ids.contains("[")) {
            ArrayList<String> nameList = new ArrayList<String>();
            List jsonToList = JsonUtil.getJsonToList((String)ids, String.class);
            for (String userId : jsonToList) {
                UserEntity info = this.userService.getInfo(userId);
                nameList.add(Objects.nonNull(info) ? info.getRealName() : userId);
            }
            return String.join((CharSequence)";", nameList);
        }
        ArrayList<String> userInfoList = new ArrayList<String>();
        String[] idList = ids.split(",");
        if (idList.length > 0) {
            for (String id : idList) {
                UserEntity userEntity = this.userService.getInfo(id);
                if (!ObjectUtil.isNotEmpty((Object)userEntity)) continue;
                String info = userEntity.getRealName();
                userInfoList.add(info);
            }
        }
        return String.join((CharSequence)"-", userInfoList);
    }

    public ProvinceEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ProvinceEntity::getId, (Object)id);
        return (ProvinceEntity)this.provinceMapper.selectOne((Wrapper)queryWrapper);
    }

    public ProvinceEntity getInfo(String id, boolean isCache) {
        if (!isCache) {
            return this.getInfo(id);
        }
        ProvinceEntity entity = null;
        String key = CacheKeyVisitUtil.SYSTEM_AREA_KEY_ID + id;
        Object object = this.cacheUtil.query("oneDayCacheSpace", key);
        if (Objects.isNull(object)) {
            entity = this.getInfo(id);
            this.cacheUtil.insert("oneDayCacheSpace", key, (Object)entity, 86400L);
        } else {
            entity = (ProvinceEntity)JsonUtil.getJsonToBean((String)String.valueOf(object), ProvinceEntity.class);
        }
        return entity;
    }

    public List<UserEntity> getUserListByCompanyId(List<String> companyId) {
        if (Objects.isNull(companyId)) {
            return null;
        }
        ArrayList underCompanyAllList = new ArrayList();
        for (String s : companyId) {
            List strings = this.getUnderCompanyAllList(s).stream().map(OrganizeEntity::getId).collect(Collectors.toList());
            underCompanyAllList.addAll(strings);
        }
        if (!Objects.isNull(underCompanyAllList)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(UserEntity::getOrganizeId, underCompanyAllList);
            List list = this.userMapper.selectList((Wrapper)queryWrapper);
            return list;
        }
        return null;
    }

    public List<OrganizeEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(PermissionEntityBase::getSortCode)).orderByDesc(PermissionEntityBase::getCreatorTime);
        return this.organizeMapper.selectList((Wrapper)queryWrapper);
    }

    public List<OrganizeEntity> getUnderCompanyAllList(String companyId) {
        ArrayList<OrganizeEntity> totalIds = new ArrayList<OrganizeEntity>();
        this.getUserOrganizations(companyId, this.getList(), totalIds);
        return totalIds;
    }

    private void getUserOrganizations(String organizeId, List<OrganizeEntity> allIdList, List<OrganizeEntity> totalIds) {
        List collect = allIdList.stream().filter(org -> org.getParentId().equals(organizeId)).collect(Collectors.toList());
        if (collect.size() > 0) {
            totalIds.addAll(collect);
            for (OrganizeEntity organizeEntity : collect) {
                this.getUserOrganizations(organizeEntity.getId(), allIdList, totalIds);
            }
        }
    }

    public List<UserEntity> getListByRoleIds(String roleId) {
        ArrayList<UserEntity> list = new ArrayList<UserEntity>();
        this.userRelationService.getListByRoleIds(roleId).forEach(u -> {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(UserEntity::getId, (Object)u.getUserId());
            UserEntity user = (UserEntity)this.userMapper.selectOne((Wrapper)queryWrapper);
            list.add(user);
        });
        return list;
    }
}

