/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visit.utils;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.contract.utils.Constants;
import com.bringspring.crm.config.OpportunityPushConfig;
import com.bringspring.system.base.entity.MessageTemplateEntity;
import com.bringspring.system.base.service.MessageTemplateService;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.visit.config.ConfigDomainUtil;
import com.bringspring.visit.constant.MessageTypeConst;
import com.bringspring.visit.utils.DateUtil;
import com.bringspring.visit.utils.UserRelationUtil;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VisitTimeUtil {
    Logger logger = LoggerFactory.getLogger(VisitTimeUtil.class);
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private ConfigDomainUtil configValueUtil;
    @Autowired
    private OpportunityPushConfig opportunityPushConfig;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private MessageTemplateService messageTemplateService;
    @Autowired
    private UserRelationUtil userRelationUtil;

    public void pushBeforeSalerFollowRecord() {
        if (this.opportunityPushConfig.getIsTest() == 1) {
            this.pushVisitFollowToBeforeSaler();
        } else {
            String weekStr = DateUtil.getWeekStr(DateUtil.getdaNow());
            if (weekStr.equals("\u661f\u671f\u4e94")) {
                this.pushVisitFollowToBeforeSaler();
            }
        }
    }

    private void pushVisitFollowToBeforeSaler() {
        String nowStr = DateUtil.getdaNow();
        Date date = DateUtil.dateAddDays(DateUtil.getNowDate(), -7);
        String startDate = DateUtil.daFormat(date);
        List toUserIds = CollectionUtil.list((boolean)false);
        if (this.opportunityPushConfig.getIsTest() == 1) {
            Object[] split = this.opportunityPushConfig.getToTestUserAccount().split(",");
            toUserIds = CollectionUtil.list((boolean)false, (Object[])split);
        } else {
            List<UserRelationEntity> listByRoleCode = this.userRelationUtil.getListByRoleCode("");
            toUserIds = listByRoleCode.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
        }
        SentMessageForm sentMessageForm = this.getMessageForm(MessageTypeConst.VISITFOLLOW_PUSH.getType(), Constants.VISITFOLLOW_PUSH_TEMPLATECODE);
        if (Objects.isNull(sentMessageForm)) {
            return;
        }
        sentMessageForm.setToUserIds(toUserIds);
        sentMessageForm.setTitle("\u62dc\u8bbf\u8ddf\u8fdb\u4fe1\u606f\u7edf\u8ba1\u6c47\u603b\uff08\u6bcf\u5468\u63a8\u9001\u4e00\u6b21\uff09");
        HashMap<String, String> map = new HashMap<String, String>();
        String statisticalDate = startDate + "--" + nowStr;
        map.put("title", sentMessageForm.getTitle());
        map.put("content", sentMessageForm.getTitle());
        map.put("statisticalDate", statisticalDate);
        String messageTime = DateUtil.dateFormat(new Date());
        map.put("MessageTime", messageTime);
        StringBuffer contentWechat = new StringBuffer();
        contentWechat.append("\n\u7edf\u8ba1\u5468\u671f:" + statisticalDate);
        contentWechat.append("\n\u901a\u77e5\u65f6\u95f4:" + messageTime);
        String url = this.configValueUtil.getDomain() + "/api/visit/VisitFollowUp/Actions/Export/app";
        map.put("content", contentWechat.toString());
        map.put("AppUrl", url + "?startDateStr=" + startDate + "&endDateStr=" + nowStr);
        sentMessageForm.setParameterMap(map);
        sentMessageForm.setBodyText(map);
        ArrayList<SentMessageForm> messageListAll = new ArrayList<SentMessageForm>();
        messageListAll.add(sentMessageForm);
    }

    private SentMessageForm getMessageForm(Integer type, String templateCode) {
        QueryWrapper templateEntityQueryWrapper = new QueryWrapper();
        templateEntityQueryWrapper.lambda().eq(MessageTemplateEntity::getEnCode, (Object)templateCode);
        MessageTemplateEntity one = (MessageTemplateEntity)this.messageTemplateService.getOne((Wrapper)templateEntityQueryWrapper);
        if (Objects.isNull(one)) {
            this.logger.info("\u672a\u914d\u7f6e\u6d88\u606f\u6a21\u677f,code:{}", (Object)templateCode);
            return null;
        }
        SentMessageForm sentMessageForm = new SentMessageForm();
        sentMessageForm.setType(type);
        sentMessageForm.setTemplateId(one.getId());
        return sentMessageForm;
    }
}

