/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workitem.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.NoDataSourceBind;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.FilePathUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workitem.entity.CrmLicenseEntity;
import com.bringspring.workitem.model.crmLicense.CrmLicenseCrForm;
import com.bringspring.workitem.model.crmLicense.CrmLicenseInfoVO;
import com.bringspring.workitem.model.crmLicense.CrmLicenseListVO;
import com.bringspring.workitem.model.crmLicense.CrmLicensePagination;
import com.bringspring.workitem.model.crmLicense.CrmLicenseUpForm;
import com.bringspring.workitem.service.CrmLicenseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8bb8\u53ef\u8bc1\u4fe1\u606f"}, value="crm")
@RequestMapping(value={"/api/crm/CrmLicense"})
public class CrmLicenseController {
    private static final Logger log = LoggerFactory.getLogger(CrmLicenseController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmLicenseService crmLicenseService;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmLicensePagination crmLicensePagination) throws IOException {
        List<CrmLicenseEntity> list = this.crmLicenseService.getList(crmLicensePagination);
        for (CrmLicenseEntity entity : list) {
            entity.setCreatorUserId(this.baseDataUtil.userSelectValue(entity.getCreatorUserId()));
            entity.setLastModifyUserId(this.baseDataUtil.userSelectValue(entity.getLastModifyUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, CrmLicenseListVO.class);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmLicensePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @NoDataSourceBind
    @ApiOperation(value="License\u6587\u4ef6\u4e0b\u8f7d")
    @GetMapping(value={"/licenseDownload/{id}"})
    public ActionResult licenseDownload(@PathVariable(value="id") String id) {
        String fileName = this.crmLicenseService.generateLicense(id);
        UserInfo userInfo = this.userProvider.get();
        String filePath = FilePathUtil.getFilePath((String)"license") + fileName;
        if (FileUtil.fileIsFile((String)filePath)) {
            DownloadVO vo = DownloadVO.builder().name(fileName).url(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + fileName + "#" + "license"))).build();
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)"\u751f\u6210\u4e0b\u8f7d\u8def\u5f84\u5931\u8d25");
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid CrmLicenseCrForm crmLicenseCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        crmLicenseCrForm.setCreatorUserId(userInfo.getUserId());
        crmLicenseCrForm.setCreatorTime(DateUtil.getNow());
        CrmLicenseEntity entity = (CrmLicenseEntity)JsonUtil.getJsonToBean((Object)crmLicenseCrForm, CrmLicenseEntity.class);
        entity.setId(mainId);
        this.crmLicenseService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmLicenseInfoVO> info(@PathVariable(value="id") String id) {
        CrmLicenseEntity entity = this.crmLicenseService.getInfo(id);
        CrmLicenseInfoVO vo = (CrmLicenseInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmLicenseInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmLicenseInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmLicenseEntity entity = this.crmLicenseService.getInfo(id);
        CrmLicenseInfoVO vo = (CrmLicenseInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmLicenseInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmLicenseUpForm crmLicenseUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        CrmLicenseEntity entity = this.crmLicenseService.getInfo(id);
        if (entity != null) {
            crmLicenseUpForm.setLastModifyTime(DateUtil.getNow());
            crmLicenseUpForm.setLastModifyUserId(userInfo.getUserId());
            CrmLicenseEntity subentity = (CrmLicenseEntity)JsonUtil.getJsonToBean((Object)crmLicenseUpForm, CrmLicenseEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            this.crmLicenseService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmLicenseEntity entity = this.crmLicenseService.getInfo(id);
        if (entity != null) {
            this.crmLicenseService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

