/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workitem.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.contract.entity.AfterSalesProjectsEntity;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.service.AfterSalesProjectsService;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkProjectQuestionService;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.entity.CrmProductUserEntity;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.crm.service.CrmProductUserService;
import com.bringspring.crm.util.CrmConstants;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workitem.entity.CrmWorkitemEntity;
import com.bringspring.workitem.entity.CrmWorkitemLogsEntity;
import com.bringspring.workitem.model.crmworkitem.CrmWorkitemCrForm;
import com.bringspring.workitem.model.crmworkitem.CrmWorkitemInfoVO;
import com.bringspring.workitem.model.crmworkitem.CrmWorkitemListVO;
import com.bringspring.workitem.model.crmworkitem.CrmWorkitemPagination;
import com.bringspring.workitem.model.crmworkitem.CrmWorkitemPaginationExportModel;
import com.bringspring.workitem.model.crmworkitem.CrmWorkitemUpForm;
import com.bringspring.workitem.service.CrmWorkitemLogsService;
import com.bringspring.workitem.service.CrmWorkitemService;
import com.bringspring.workitem.utils.WorkItemTypeEnum;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5de5\u4f5c\u9879"}, value="crm")
@RequestMapping(value={"/api/crm/CrmWorkitem"})
public class CrmWorkitemController {
    private static final Logger log = LoggerFactory.getLogger(CrmWorkitemController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmWorkitemService crmWorkitemService;
    @Autowired
    private CrmWorkitemLogsService crmWorkitemLogsService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmProductUserService crmProductUserService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private RkProjectQuestionService rkProjectQuestionService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private AfterSalesProjectsService afterSalesProjectsService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmWorkitemPagination crmWorkitemPagination) throws IOException {
        List<CrmWorkitemEntity> list = this.crmWorkitemService.getList(crmWorkitemPagination);
        for (CrmWorkitemEntity crmWorkitemEntity : list) {
            CrmProductEntity info;
            crmWorkitemEntity.setPersonInCharge(this.baseDataUtil.userSelectValues(crmWorkitemEntity.getPersonInCharge()));
            crmWorkitemEntity.setCreatorUserId(this.baseDataUtil.userSelectValues(crmWorkitemEntity.getCreatorUserId()));
            if (ObjectUtil.isEmpty((Object)crmWorkitemEntity.getProductId()) || !ObjectUtil.isNotEmpty((Object)(info = this.crmProductService.getInfo(crmWorkitemEntity.getProductId())))) continue;
            crmWorkitemEntity.setProductId(info.getProductName());
        }
        List listVO = JsonUtil.getJsonToList(list, CrmWorkitemListVO.class);
        for (CrmWorkitemListVO crmWorkitemVO : listVO) {
            RkContractProjectEntity info = this.rkContractProjectService.getInfo(crmWorkitemVO.getProjectId());
            if (ObjectUtil.isNotEmpty((Object)info)) {
                crmWorkitemVO.setProjectName(info.getProjectName());
            }
            crmWorkitemVO.setPriorityCode(crmWorkitemVO.getPriority());
            crmWorkitemVO.setPriority(this.baseDataUtil.getDictName(crmWorkitemVO.getPriority(), "demandPriority"));
            crmWorkitemVO.setEnabledMarkCode(crmWorkitemVO.getEnabledMark());
            crmWorkitemVO.setEnabledMark(this.baseDataUtil.getDictName(String.valueOf(crmWorkitemVO.getEnabledMark()), "demandMark"));
            crmWorkitemVO.setTypeCode(crmWorkitemVO.getType());
            crmWorkitemVO.setType(this.baseDataUtil.getDictName(crmWorkitemVO.getType(), "demandType"));
            crmWorkitemVO.setProposeUserId(this.baseDataUtil.userSelectValues(crmWorkitemVO.getProposeUserId()));
            crmWorkitemVO.setProposeUserDepartment(this.baseDataUtil.comSelectValues(crmWorkitemVO.getProposeUserDepartment()));
            crmWorkitemVO.setAcceptanceUserId(this.baseDataUtil.userSelectValues(crmWorkitemVO.getAcceptanceUserId()));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmWorkitemPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @GetMapping(value={"/getWorkItemList/{id}"})
    public ActionResult getWorkItemList(@PathVariable(value="id") String id) throws IOException {
        List<CrmWorkitemEntity> workItemList = this.crmWorkitemService.getWorkItemList();
        return ActionResult.success(workItemList);
    }

    @GetMapping(value={"/getRelationWorkItemList/{id}"})
    public ActionResult getRelationWorkItemList(@PathVariable(value="id") String id) throws IOException {
        List<CrmWorkitemEntity> workItemList = this.crmWorkitemService.getRelationWorkItemList(id);
        for (CrmWorkitemEntity crmWorkitemEntity : workItemList) {
            crmWorkitemEntity.setPersonInCharge(this.baseDataUtil.userSelectValues(crmWorkitemEntity.getPersonInCharge()));
            crmWorkitemEntity.setCoordinateUserId(this.baseDataUtil.userSelectValues(crmWorkitemEntity.getCoordinateUserId()));
        }
        return ActionResult.success(workItemList);
    }

    @GetMapping(value={"/getListByAllWorkItem"})
    public ActionResult getListByAllWorkItem() throws IOException {
        List<CrmProductEntity> listByAllWorkItem = this.crmWorkitemService.getListByAllWorkItem();
        return ActionResult.success(listByAllWorkItem);
    }

    @GetMapping(value={"/urging/{id}"})
    public ActionResult urging(@PathVariable(value="id") String id) throws DataException {
        CrmWorkitemEntity entity = this.crmWorkitemService.getInfo(id);
        ArrayList<String> list = new ArrayList<String>();
        list.add(entity.getPersonInCharge());
        String title = entity.getName() + "\u8bf7\u5c3d\u5feb\u5b8c\u6210\uff01";
        String content = "\u6807\u9898\uff1a" + entity.getName();
        String pcUrl = CrmConstants.PC_DEMAND_DETAIL + entity.getId();
        String type = TermTypeEnum.TERM_PC.getCode();
        String typeDesc = "\u8bf7\u7528pc\u7aef\u6253\u5f00\u94fe\u63a5\uff0c\u8fdb\u884c\u4fe1\u606f\u786e\u8ba4";
        this.crmWorkitemService.newSendMessage("\u9700\u6c42\u7ba1\u7406", CrmConstants.DEMAND_SENDMESSAGE, title, content, CrmConstants.APP_DEMAND_DETAIL, pcUrl, list, type, typeDesc);
        return ActionResult.success((Object)entity);
    }

    @PostMapping
    @Transactional
    @DSTransactional
    public ActionResult create(@RequestBody @Valid CrmWorkitemCrForm crmWorkitemCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        CrmWorkitemEntity entity = (CrmWorkitemEntity)JsonUtil.getJsonToBean((Object)crmWorkitemCrForm, CrmWorkitemEntity.class);
        entity.setId(mainId);
        entity.setParentId(StrUtil.isBlank((CharSequence)entity.getParentId()) ? "-1" : entity.getParentId());
        entity.setUserCompanyId(userInfo.getOrganizeId());
        CrmProductEntity info = this.crmProductService.getInfo(entity.getProductId());
        if (ObjectUtil.isNotEmpty((Object)info)) {
            CrmProductUserEntity productUserEntity;
            CrmProductCategoryEntity categoryEntity = this.crmProductCategoryService.getInfo(info.getCategoryId());
            if (ObjectUtil.isNotEmpty((Object)categoryEntity)) {
                entity.setProductCompanyId(categoryEntity.getParentId());
            }
            if (ObjectUtil.isNotEmpty((Object)(productUserEntity = this.crmProductUserService.getByProductId(info.getId())))) {
                entity.setExploitHead(productUserEntity.getExploitHead());
                entity.setTestHead(productUserEntity.getTestHead());
                entity.setProductHead(productUserEntity.getProductManager());
            }
        }
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setCreatorTime(DateUtil.getNowDate());
        if ("inprogress".equals(entity.getEnabledMark())) {
            entity.setActualStartDate(DateUtil.getNowDate());
        }
        if (!ObjectUtil.isEmpty((Object)entity.getPersonInCharge())) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(entity.getPersonInCharge());
            list.add(entity.getCoordinateUserId());
            if (!"true".equals(crmWorkitemCrForm.getAutoSave())) {
                String title = "\u6709" + entity.getName() + "\u5f85\u60a8\u5b8c\u6210";
                String content = "\u6807\u9898\uff1a" + entity.getName();
                String pcUrl = CrmConstants.PC_DEMAND_DETAIL + entity.getId();
                String type = TermTypeEnum.TERM_PC.getCode();
                String typeDesc = "\u8bf7\u7528pc\u7aef\u6253\u5f00\u94fe\u63a5\uff0c\u8fdb\u884c\u4fe1\u606f\u786e\u8ba4";
                this.crmWorkitemService.newSendMessage("\u9700\u6c42\u7ba1\u7406", CrmConstants.DEMAND_SENDMESSAGE, title, content, CrmConstants.APP_DEMAND_DETAIL, pcUrl, list, type, typeDesc);
            }
        }
        ArrayList<CrmWorkitemLogsEntity> crmWorkitemLogsEntities = new ArrayList<CrmWorkitemLogsEntity>();
        CrmWorkitemLogsEntity crmWorkitemLogsEntity = new CrmWorkitemLogsEntity();
        crmWorkitemLogsEntity.setId(mainId);
        crmWorkitemLogsEntity.setDescription(userInfo.getUserName() + "\u521b\u5efa\u4efb\u52a1");
        crmWorkitemLogsEntity.setOpraterType(WorkItemTypeEnum.RECORD_LOG_TYPE.getType());
        crmWorkitemLogsEntity.setWorkitemId(entity.getId());
        crmWorkitemLogsEntity.setDeleteMark(0);
        crmWorkitemLogsEntities.add(crmWorkitemLogsEntity);
        this.crmWorkitemLogsService.saveBatch(crmWorkitemLogsEntities);
        if (!StrUtil.isBlank((CharSequence)entity.getJumpQueue()) && entity.getJumpQueue().equals("1")) {
            List<CrmWorkitemEntity> jumpList = this.crmWorkitemService.getJumpList(entity.getPersonInCharge());
            if (jumpList.size() > 0) {
                return ActionResult.success((String)"duplication");
            }
            List<CrmWorkitemEntity> list = this.crmWorkitemService.executeJumpQueue(entity);
        }
        this.crmWorkitemService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmWorkitemInfoVO> info(@PathVariable(value="id") String id) {
        CrmProductEntity info;
        CrmWorkitemEntity entity = this.crmWorkitemService.getInfo(id);
        CrmWorkitemInfoVO vo = (CrmWorkitemInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmWorkitemInfoVO.class);
        if (!ObjectUtil.isEmpty((Object)entity.getProductId()) && ObjectUtil.isNotEmpty((Object)(info = this.crmProductService.getInfo(entity.getProductId())))) {
            vo.setProductName(info.getProductName());
        }
        if (!ObjectUtil.isEmpty((Object)entity.getParentId())) {
            CrmWorkitemEntity serviceInfo = this.crmWorkitemService.getInfo(vo.getParentId());
            vo.setParentName(ObjectUtil.isEmpty((Object)serviceInfo) ? "" : serviceInfo.getName());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmWorkitemInfoVO> detailInfo(@PathVariable(value="id") String id) {
        Object info;
        CrmWorkitemEntity entity = this.crmWorkitemService.getInfo(id);
        if (ObjectUtil.isEmpty((Object)entity)) {
            return ActionResult.success();
        }
        CrmWorkitemInfoVO vo = (CrmWorkitemInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmWorkitemInfoVO.class);
        if (!ObjectUtil.isEmpty((Object)entity.getProductId()) && ObjectUtil.isNotEmpty((Object)(info = this.crmProductService.getInfo(entity.getProductId())))) {
            vo.setProductName(((CrmProductEntity)info).getProductName());
        }
        if (!ObjectUtil.isEmpty((Object)entity.getParentId())) {
            info = this.crmWorkitemService.getInfo(vo.getParentId());
            vo.setParentName(ObjectUtil.isEmpty((Object)info) ? "" : ((CrmWorkitemEntity)info).getName());
        }
        vo.setPriority(this.baseDataUtil.getDictName(vo.getPriority(), "demandPriority"));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValues(vo.getCreatorUserId()));
        if (!ObjectUtil.isEmpty((Object)entity.getProjectId())) {
            RkContractProjectEntity projectServiceInfo = this.rkContractProjectService.getInfo(entity.getProjectId());
            if (ObjectUtil.isNotEmpty((Object)projectServiceInfo)) {
                vo.setProjectId(projectServiceInfo.getProjectName());
            } else {
                AfterSalesProjectsEntity info2 = this.afterSalesProjectsService.getInfo(entity.getProjectId());
                if (ObjectUtil.isNotEmpty((Object)info2)) {
                    vo.setProjectId(info2.getProjectName());
                }
            }
        }
        if (StringUtils.isNotEmpty((String)vo.getCoordinateUserId())) {
            vo.setCoordinateUserId(this.baseDataUtil.userSelectValues(vo.getCoordinateUserId()));
        }
        if (StringUtils.isNotEmpty((String)vo.getProposeUserId())) {
            vo.setProposeUserId(this.baseDataUtil.userSelectValues(vo.getProposeUserId()));
        }
        if (StringUtils.isNotEmpty((String)vo.getProposeUserDepartment())) {
            vo.setProposeUserDepartment(this.baseDataUtil.comSelectValues(vo.getProposeUserDepartment()));
        }
        vo.setAcceptanceUserId(this.baseDataUtil.userSelectValues(vo.getAcceptanceUserId()));
        vo.setPersonInCharge(this.baseDataUtil.userSelectValues(vo.getPersonInCharge()));
        return ActionResult.success((Object)vo);
    }

    public String equalsStr(String oldStr, String newStr) {
        if (StringUtils.isNull((Object)oldStr) && StringUtils.isNull((Object)newStr)) {
            return "1";
        }
        if (StringUtils.isNotEmpty((String)oldStr) && StringUtils.isNull((Object)newStr)) {
            return "2";
        }
        if (StringUtils.isNull((Object)oldStr) && StringUtils.isNotEmpty((String)newStr)) {
            return "3";
        }
        if (oldStr.equals(newStr)) {
            return "1";
        }
        return "1";
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmWorkitemUpForm crmWorkitemUpForm) throws Exception {
        String res = this.crmWorkitemService.updateHandle(id, crmWorkitemUpForm);
        if (res == "true") {
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        if (res == "duplication") {
            return ActionResult.success((String)"duplication");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmWorkitemEntity entity = this.crmWorkitemService.getInfo(id);
        if (entity != null) {
            this.crmWorkitemService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(CrmWorkitemPaginationExportModel crmWorkitemPaginationExportModel) throws IOException {
        if (StringUtil.isEmpty((String)crmWorkitemPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        DownloadVO vo = this.crmWorkitemService.exportData(crmWorkitemPaginationExportModel);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/getWorkItemUserList/{id}"})
    public ActionResult getWorkItemUserList(@PathVariable(value="id") String id) throws IOException {
        List<Object> workItemUserList = this.crmWorkitemService.getWorkItemUserList(id);
        return ActionResult.success(workItemUserList);
    }

    @PostMapping(value={"/getParentChildList"})
    public ActionResult getParentChildList(@RequestBody CrmWorkitemPagination crmWorkitemPagination) {
        List<CrmWorkitemListVO> listVO = this.crmWorkitemService.getParentChildList(crmWorkitemPagination);
        PageInfo pageInfo = new PageInfo(listVO);
        crmWorkitemPagination.setData(pageInfo.getList(), crmWorkitemPagination.getTotal());
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmWorkitemPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/getParentChildList/{parentId}"})
    public ActionResult getParentChildList(@PathVariable(value="parentId") String parentId) {
        List<CrmWorkitemListVO> listVO = this.crmWorkitemService.getPlanListByParentId(parentId, 1);
        return ActionResult.success(listVO);
    }
}

