/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workitem.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.bringspring.workitem.entity.CrmWorkitemInnovateEntity;
import com.bringspring.workitem.model.crmWorkitemInnovate.CrmWorkitemInnovateCrForm;
import com.bringspring.workitem.model.crmWorkitemInnovate.CrmWorkitemInnovateInfoVO;
import com.bringspring.workitem.model.crmWorkitemInnovate.CrmWorkitemInnovateListVO;
import com.bringspring.workitem.model.crmWorkitemInnovate.CrmWorkitemInnovatePagination;
import com.bringspring.workitem.service.CrmWorkitemInnovateService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u521b\u65b0\u8d21\u732e\u8bb0\u5f55"}, value="example")
@RequestMapping(value={"/api/crm/CrmWorkitemInnovate"})
public class CrmWorkitemInnovateController {
    private static final Logger log = LoggerFactory.getLogger(CrmWorkitemInnovateController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmWorkitemInnovateService crmWorkitemInnovateService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmWorkitemInnovatePagination crmWorkitemInnovatePagination) throws IOException {
        List<CrmWorkitemInnovateEntity> list = this.crmWorkitemInnovateService.getList(crmWorkitemInnovatePagination);
        for (CrmWorkitemInnovateEntity crmWorkitemInnovateEntity : list) {
            crmWorkitemInnovateEntity.setFiles(this.baseDataUtil.getFileNameInJson(crmWorkitemInnovateEntity.getFiles()));
            crmWorkitemInnovateEntity.setCreatorUserId(this.baseDataUtil.userSelectValue(crmWorkitemInnovateEntity.getCreatorUserId()));
            crmWorkitemInnovateEntity.setLastModifyUserId(this.baseDataUtil.userSelectValue(crmWorkitemInnovateEntity.getLastModifyUserId()));
        }
        List listVO = JsonUtil.getJsonToList(list, CrmWorkitemInnovateListVO.class);
        for (CrmWorkitemInnovateListVO crmWorkitemInnovateListVO : listVO) {
        }
        for (CrmWorkitemInnovateListVO vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmWorkitemInnovatePagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException {
        CrmWorkitemInnovateCrForm crmWorkitemInnovateCrForm = (CrmWorkitemInnovateCrForm)((Object)JsonUtil.getJsonToBean(crData, CrmWorkitemInnovateCrForm.class));
        String mainId = RandomUtil.uuId();
        String flowEngineId = "603113673300378245";
        UserInfo userInfo = this.userProvider.get();
        crmWorkitemInnovateCrForm.setCreatorUserId(userInfo.getUserId());
        crmWorkitemInnovateCrForm.setCreatorTime(DateUtil.getNow());
        CrmWorkitemInnovateEntity entity = (CrmWorkitemInnovateEntity)JsonUtil.getJsonToBean((Object)((Object)crmWorkitemInnovateCrForm), CrmWorkitemInnovateEntity.class);
        entity.setId(mainId);
        this.crmWorkitemInnovateService.save(entity);
        if (FlowTaskStatusEnum.Handle.getCode().equals(crmWorkitemInnovateCrForm.getStatus())) {
            try {
                FlowUtil.saveOrSubmit((String)crmWorkitemInnovateCrForm.getTaskId(), (String)flowEngineId, (String)crmWorkitemInnovateCrForm.getTemplateId(), (String)mainId, (Object)((Object)crmWorkitemInnovateCrForm), (Integer)crmWorkitemInnovateCrForm.getStatus(), (String)crmWorkitemInnovateCrForm.getName());
            }
            catch (WorkFlowException e) {
                e.printStackTrace();
            }
            return ActionResult.success((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85");
        }
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmWorkitemInnovateInfoVO> info(@PathVariable(value="id") String id) {
        CrmWorkitemInnovateEntity entity = this.crmWorkitemInnovateService.getInfo(id);
        CrmWorkitemInnovateInfoVO vo = (CrmWorkitemInnovateInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmWorkitemInnovateInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws WorkFlowException {
        CrmWorkitemInnovateCrForm crmWorkitemInnovateUpForm = (CrmWorkitemInnovateCrForm)((Object)JsonUtil.getJsonToBean(upData, CrmWorkitemInnovateCrForm.class));
        String flowEngineId = "603113673300378245";
        UserInfo userInfo = this.userProvider.get();
        CrmWorkitemInnovateEntity entity = this.crmWorkitemInnovateService.getInfo(id);
        if (entity != null) {
            crmWorkitemInnovateUpForm.setLastModifyUserId(userInfo.getUserId());
            crmWorkitemInnovateUpForm.setLastModifyTime(DateUtil.getNow());
            CrmWorkitemInnovateEntity subentity = (CrmWorkitemInnovateEntity)JsonUtil.getJsonToBean((Object)((Object)crmWorkitemInnovateUpForm), CrmWorkitemInnovateEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            this.crmWorkitemInnovateService.update(id, subentity);
            if (FlowTaskStatusEnum.Handle.getCode().equals(crmWorkitemInnovateUpForm.getStatus())) {
                FlowUtil.saveOrSubmit((String)crmWorkitemInnovateUpForm.getTaskId(), (String)flowEngineId, (String)crmWorkitemInnovateUpForm.getTemplateId(), (String)id, (Object)((Object)crmWorkitemInnovateUpForm), (Integer)crmWorkitemInnovateUpForm.getStatus());
                return ActionResult.success((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85");
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) throws WorkFlowException {
        CrmWorkitemInnovateEntity entity = this.crmWorkitemInnovateService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                FlowUtil.deleteByProcessId((String)id);
            }
            this.crmWorkitemInnovateService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

