/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workitem.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.model.user.vo.UserInfoVO;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workitem.entity.CrmWorkitemEntity;
import com.bringspring.workitem.entity.CrmWorkitemLogsEntity;
import com.bringspring.workitem.model.crmworkitemlogs.CrmWorkitemLogsCrForm;
import com.bringspring.workitem.model.crmworkitemlogs.CrmWorkitemLogsInfoVO;
import com.bringspring.workitem.model.crmworkitemlogs.CrmWorkitemLogsListVO;
import com.bringspring.workitem.model.crmworkitemlogs.CrmWorkitemLogsPagination;
import com.bringspring.workitem.model.crmworkitemlogs.CrmWorkitemLogsUpForm;
import com.bringspring.workitem.service.CrmWorkitemLogsService;
import com.bringspring.workitem.service.CrmWorkitemService;
import com.bringspring.workitem.utils.WorkItemTypeEnum;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5de5\u4f5c\u9879\u65e5\u5fd7"}, value="crm")
@RequestMapping(value={"/api/crm/CrmWorkitemLogs"})
public class CrmWorkitemLogsController {
    private static final Logger log = LoggerFactory.getLogger(CrmWorkitemLogsController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmWorkitemLogsService crmWorkitemLogsService;
    @Autowired
    private CrmWorkitemService crmWorkitemService;
    @Autowired
    private UserService userService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmWorkitemLogsPagination crmWorkitemLogsPagination) throws IOException, DataException {
        List<CrmWorkitemLogsEntity> list = this.crmWorkitemLogsService.getList(crmWorkitemLogsPagination);
        List listVO = JsonUtil.getJsonToList(list, CrmWorkitemLogsListVO.class);
        for (CrmWorkitemLogsListVO logsListVO : listVO) {
            logsListVO.setCreatorUserId(this.baseDataUtil.userSelectValue(logsListVO.getCreatorUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmWorkitemLogsPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/getList/{id}/{operateType}"})
    public ActionResult getListById(@PathVariable(value="id") String id, @PathVariable(value="operateType") String operateType) {
        List<CrmWorkitemLogsEntity> list = this.crmWorkitemLogsService.getListById(id, operateType);
        CrmWorkitemEntity info = this.crmWorkitemService.getInfo(id);
        list.sort((o1, o2) -> o2.getCreatorTime().compareTo(o1.getCreatorTime()));
        if (!StrUtil.isBlank((CharSequence)info.getFilePath()) && !StrUtil.equals((CharSequence)info.getFilePath(), (CharSequence)"[]")) {
            CrmWorkitemLogsEntity infoJsonToBean = (CrmWorkitemLogsEntity)JsonUtil.getJsonToBean((Object)info, CrmWorkitemLogsEntity.class);
            infoJsonToBean.setWorkitemId(id);
            infoJsonToBean.setOpraterType(WorkItemTypeEnum.FILE_WORK_TYPE.getType());
            list.add(0, infoJsonToBean);
        }
        List listVO = JsonUtil.getJsonToList(list, CrmWorkitemLogsListVO.class);
        for (CrmWorkitemLogsListVO logsListVO : listVO) {
            UserInfoVO userInfoVO = null;
            try {
                userInfoVO = this.userService.getInfoDetail(logsListVO.getCreatorUserId());
                if (userInfoVO != null) {
                    logsListVO.setHeadIcon(userInfoVO.getHeadIcon());
                    userInfoVO.getOrganizeNames().stream().forEach(organizeName -> {
                        if (organizeName.getIsDefault().booleanValue()) {
                            if (organizeName.getFullName().contains("/")) {
                                String[] split = organizeName.getFullName().split("/");
                                organizeName.setFullName(split[split.length - 1].substring(0, split[split.length - 1].length() - 1));
                            }
                            logsListVO.setDepartment(organizeName.getFullName());
                        }
                    });
                }
                if (!StrUtil.isBlank((CharSequence)logsListVO.getNoticeUser())) {
                    logsListVO.setNoticeUserName(this.baseDataUtil.userSelectValues(logsListVO.getNoticeUser()));
                }
            }
            catch (DataException e) {
                throw new RuntimeException(e);
            }
            logsListVO.setCreatorUserId(this.baseDataUtil.userSelectValue(logsListVO.getCreatorUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid CrmWorkitemLogsCrForm crmWorkitemLogsCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        crmWorkitemLogsCrForm.setCreatorUserId(userInfo.getUserId());
        crmWorkitemLogsCrForm.setCreatorTime(DateUtil.getNow());
        CrmWorkitemLogsEntity entity = (CrmWorkitemLogsEntity)JsonUtil.getJsonToBean((Object)crmWorkitemLogsCrForm, CrmWorkitemLogsEntity.class);
        entity.setId(mainId);
        if (!StrUtil.isBlank((CharSequence)entity.getNoticeUser())) {
            this.crmWorkitemLogsService.sendMessage(entity.getNoticeUser(), entity.getWorkitemId());
        }
        entity.setDeleteMark(0);
        this.crmWorkitemLogsService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmWorkitemLogsInfoVO> info(@PathVariable(value="id") String id) {
        CrmWorkitemLogsEntity entity = this.crmWorkitemLogsService.getInfo(id);
        CrmWorkitemLogsInfoVO vo = (CrmWorkitemLogsInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmWorkitemLogsInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmWorkitemLogsInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmWorkitemLogsEntity entity = this.crmWorkitemLogsService.getInfo(id);
        CrmWorkitemLogsInfoVO vo = (CrmWorkitemLogsInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmWorkitemLogsInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid CrmWorkitemLogsUpForm crmWorkitemLogsUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        CrmWorkitemLogsEntity entity = this.crmWorkitemLogsService.getInfo(id);
        if (entity != null) {
            CrmWorkitemLogsEntity subentity = (CrmWorkitemLogsEntity)JsonUtil.getJsonToBean((Object)crmWorkitemLogsUpForm, CrmWorkitemLogsEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            this.crmWorkitemLogsService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        CrmWorkitemLogsEntity entity = this.crmWorkitemLogsService.getInfo(id);
        if (entity != null) {
            entity.setDeleteMark(1);
            entity.setDeleteTime(new Date());
            entity.setDeleteUserId(this.userProvider.get().getUserId());
            this.crmWorkitemLogsService.update(id, entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

