/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workitem.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.utils.DateUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.bringspring.workitem.entity.CrmWorkitemReviewEntity;
import com.bringspring.workitem.model.crmWorkitemReview.CrmWorkitemReviewCrForm;
import com.bringspring.workitem.model.crmWorkitemReview.CrmWorkitemReviewInfoVO;
import com.bringspring.workitem.model.crmWorkitemReview.CrmWorkitemReviewListVO;
import com.bringspring.workitem.model.crmWorkitemReview.CrmWorkitemReviewPagination;
import com.bringspring.workitem.service.CrmWorkitemReviewService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u529f\u80fd\u4ee3\u7801\u8bc4\u5ba1"}, value="example")
@RequestMapping(value={"/api/crm/CrmWorkitemReview"})
public class CrmWorkitemReviewController {
    private static final Logger log = LoggerFactory.getLogger(CrmWorkitemReviewController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CrmWorkitemReviewService crmWorkitemReviewService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody CrmWorkitemReviewPagination crmWorkitemReviewPagination) throws IOException {
        List<CrmWorkitemReviewEntity> list = this.crmWorkitemReviewService.getList(crmWorkitemReviewPagination);
        for (CrmWorkitemReviewEntity crmWorkitemReviewEntity : list) {
            crmWorkitemReviewEntity.setReviewedUser(this.baseDataUtil.userSelectValues(crmWorkitemReviewEntity.getReviewedUser()));
            crmWorkitemReviewEntity.setReviewUsers(this.baseDataUtil.userSelectValues(crmWorkitemReviewEntity.getReviewUsers()));
            crmWorkitemReviewEntity.setFiles(this.baseDataUtil.getFileNameInJson(crmWorkitemReviewEntity.getFiles()));
        }
        List listVO = JsonUtil.getJsonToList(list, CrmWorkitemReviewListVO.class);
        for (CrmWorkitemReviewListVO crmWorkitemReviewVO : listVO) {
            crmWorkitemReviewVO.setCreatorUserName(this.baseDataUtil.userSelectValue(crmWorkitemReviewVO.getCreatorUserId()));
            crmWorkitemReviewVO.setLastModifyUserName(this.baseDataUtil.userSelectValue(crmWorkitemReviewVO.getLastModifyUserId()));
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)crmWorkitemReviewPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws WorkFlowException {
        CrmWorkitemReviewCrForm crmWorkitemReviewCrForm = (CrmWorkitemReviewCrForm)JsonUtil.getJsonToBean(crData, CrmWorkitemReviewCrForm.class);
        String flowEngineId = "603117967869215365";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        crmWorkitemReviewCrForm.setCreatorUserId(userInfo.getUserId());
        crmWorkitemReviewCrForm.setCreatorTime(DateUtil.getNow());
        CrmWorkitemReviewEntity entity = (CrmWorkitemReviewEntity)JsonUtil.getJsonToBean((Object)crmWorkitemReviewCrForm, CrmWorkitemReviewEntity.class);
        entity.setId(mainId);
        this.crmWorkitemReviewService.save(entity);
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<CrmWorkitemReviewInfoVO> info(@PathVariable(value="id") String id) {
        CrmWorkitemReviewEntity entity = this.crmWorkitemReviewService.getInfo(id);
        CrmWorkitemReviewInfoVO vo = (CrmWorkitemReviewInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmWorkitemReviewInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws WorkFlowException {
        CrmWorkitemReviewCrForm crmWorkitemReviewUpForm = (CrmWorkitemReviewCrForm)JsonUtil.getJsonToBean(upData, CrmWorkitemReviewCrForm.class);
        String flowEngineId = "603117967869215365";
        UserInfo userInfo = this.userProvider.get();
        CrmWorkitemReviewEntity entity = this.crmWorkitemReviewService.getInfo(id);
        if (entity != null) {
            CrmWorkitemReviewEntity subentity = (CrmWorkitemReviewEntity)JsonUtil.getJsonToBean((Object)crmWorkitemReviewUpForm, CrmWorkitemReviewEntity.class);
            this.crmWorkitemReviewService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<CrmWorkitemReviewInfoVO> detailInfo(@PathVariable(value="id") String id) {
        CrmWorkitemReviewEntity entity = this.crmWorkitemReviewService.getInfo(id);
        CrmWorkitemReviewInfoVO vo = (CrmWorkitemReviewInfoVO)JsonUtil.getJsonToBean((Object)entity, CrmWorkitemReviewInfoVO.class);
        vo.setReviewedUser(this.baseDataUtil.userSelectValues(vo.getReviewedUser()));
        vo.setReviewUsers(this.baseDataUtil.userSelectValues(vo.getReviewUsers()));
        vo.setFiles(this.baseDataUtil.getFileNameInJson(vo.getFiles()));
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        return ActionResult.success((Object)vo);
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) throws WorkFlowException {
        CrmWorkitemReviewEntity entity = this.crmWorkitemReviewService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                FlowUtil.deleteByProcessId((String)id);
            }
            this.crmWorkitemReviewService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

