/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workitem.license;

import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.Md5Util;
import com.bringspring.workitem.license.model.LicenseCheckModel;
import com.bringspring.workitem.license.utils.AbstractServerInfo;
import com.bringspring.workitem.license.utils.LinuxServerInfo;
import com.bringspring.workitem.license.utils.WindowsServerInfo;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseContentException;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.LicenseNotary;
import de.schlichtherle.license.LicenseParam;
import de.schlichtherle.license.NoLicenseInstalledException;
import de.schlichtherle.xml.GenericCertificate;
import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class CustomLicenseManager
extends LicenseManager {
    private static final String XML_CHARSET = "UTF-8";
    private static final int DEFAULT_BUFSIZE = 8192;

    public CustomLicenseManager(LicenseParam param) {
        super(param);
    }

    protected synchronized byte[] create(LicenseContent content, LicenseNotary notary) throws Exception {
        this.initialize(content);
        this.validateCreate(content);
        GenericCertificate certificate = notary.sign((Object)content);
        return this.getPrivacyGuard().cert2key(certificate);
    }

    protected synchronized LicenseContent install(byte[] key, LicenseNotary notary) throws Exception {
        GenericCertificate certificate = this.getPrivacyGuard().key2cert(key);
        notary.verify(certificate);
        LicenseContent content = (LicenseContent)this.load(certificate.getEncoded());
        this.validate(content);
        this.setLicenseKey(key);
        this.setCertificate(certificate);
        return content;
    }

    protected synchronized LicenseContent verify(LicenseNotary notary) throws Exception {
        GenericCertificate certificate = this.getCertificate();
        byte[] key = this.getLicenseKey();
        if (null == key) {
            throw new NoLicenseInstalledException(this.getLicenseParam().getSubject());
        }
        certificate = this.getPrivacyGuard().key2cert(key);
        notary.verify(certificate);
        LicenseContent content = (LicenseContent)this.load(certificate.getEncoded());
        this.validate(content);
        this.setCertificate(certificate);
        return content;
    }

    protected synchronized void validateCreate(LicenseContent content) throws LicenseContentException {
        Date now = new Date();
        Date notBefore = content.getNotBefore();
        Date notAfter = content.getNotAfter();
        if (null != notAfter && now.after(notAfter)) {
            throw new LicenseContentException("\u8bc1\u4e66\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
        if (null != notBefore && null != notAfter && notAfter.before(notBefore)) {
            throw new LicenseContentException("\u8bc1\u4e66\u751f\u6548\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u8bc1\u4e66\u5931\u6548\u65f6\u95f4");
        }
        String consumerType = content.getConsumerType();
        if (null == consumerType) {
            throw new LicenseContentException("\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    protected synchronized void validate(LicenseContent content) throws LicenseContentException {
        super.validate(content);
        String extra = content.getExtra().toString();
        LicenseCheckModel serverCheckModel = this.getServerInfos();
        String computeCode = Md5Util.getStringMd5((String)JSONObject.toJSONString((Object)serverCheckModel));
        if (StringUtils.isNotEmpty((CharSequence)computeCode)) {
            if (!extra.equals(computeCode)) {
                throw new LicenseContentException("\u5f53\u524d\u670d\u52a1\u5668\u7684\u673a\u5668\u7801\u6ca1\u5728\u6388\u6743\u8303\u56f4\u5185");
            }
        } else {
            throw new LicenseContentException("\u4e0d\u80fd\u83b7\u53d6\u670d\u52a1\u5668\u786c\u4ef6\u4fe1\u606f");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object load(String encoded) {
        BufferedInputStream inputStream = null;
        XMLDecoder decoder = null;
        try {
            inputStream = new BufferedInputStream(new ByteArrayInputStream(encoded.getBytes(XML_CHARSET)));
            decoder = new XMLDecoder(new BufferedInputStream(inputStream, 8192), null, null);
            Object object = decoder.readObject();
            return object;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (decoder != null) {
                    decoder.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public LicenseCheckModel getServerInfos() {
        String osName = System.getProperty("os.name").toLowerCase();
        AbstractServerInfo abstractServerInfo = null;
        abstractServerInfo = osName.startsWith("windows") ? new WindowsServerInfo() : (osName.startsWith("linux") ? new LinuxServerInfo() : new LinuxServerInfo());
        return LicenseCheckModel.installServerInfo(abstractServerInfo);
    }

    public CustomLicenseManager() {
    }
}

