/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workitem.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.Md5Util;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.workitem.entity.CrmLicenseEntity;
import com.bringspring.workitem.license.LicenseCreator;
import com.bringspring.workitem.license.LicenseCreatorParam;
import com.bringspring.workitem.license.model.LicenseCheckModel;
import com.bringspring.workitem.license.utils.AbstractServerInfo;
import com.bringspring.workitem.license.utils.LinuxServerInfo;
import com.bringspring.workitem.license.utils.WindowsServerInfo;
import com.bringspring.workitem.mapper.CrmLicenseMapper;
import com.bringspring.workitem.model.crmLicense.CrmLicensePagination;
import com.bringspring.workitem.service.CrmLicenseService;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrmLicenseServiceImpl
extends ServiceImpl<CrmLicenseMapper, CrmLicenseEntity>
implements CrmLicenseService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @Override
    public List<CrmLicenseEntity> getList(CrmLicensePagination crmLicensePagination) {
        Long sec;
        Long fir;
        Object crmLicenseObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int crmLicenseNum = 0;
        QueryWrapper crmLicenseQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmLicenseObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmLicenseQueryWrapper, crmLicensePagination.getMenuId(), "crmLicense"));
            if (ObjectUtil.isEmpty((Object)crmLicenseObj)) {
                return new ArrayList<CrmLicenseEntity>();
            }
            crmLicenseQueryWrapper = (QueryWrapper)crmLicenseObj;
            ++crmLicenseNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmLicenseObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmLicenseQueryWrapper, crmLicensePagination.getMenuId(), "crmLicense"));
            if (ObjectUtil.isEmpty((Object)crmLicenseObj)) {
                return new ArrayList<CrmLicenseEntity>();
            }
            crmLicenseQueryWrapper = (QueryWrapper)crmLicenseObj;
            ++crmLicenseNum;
        }
        if (StringUtils.isNotEmpty((String)crmLicensePagination.getType())) {
            ++crmLicenseNum;
            crmLicenseQueryWrapper.lambda().eq(CrmLicenseEntity::getType, (Object)crmLicensePagination.getType());
        }
        if (StringUtils.isNotEmpty((String)crmLicensePagination.getName())) {
            ++crmLicenseNum;
            crmLicenseQueryWrapper.lambda().like(CrmLicenseEntity::getName, (Object)crmLicensePagination.getName());
        }
        if (StringUtils.isNotEmpty((String)crmLicensePagination.getMachineCode())) {
            ++crmLicenseNum;
            crmLicenseQueryWrapper.lambda().like(CrmLicenseEntity::getMachineCode, (Object)crmLicensePagination.getMachineCode());
        }
        if (StringUtils.isNotEmpty(crmLicensePagination.getStartDatetime())) {
            ++crmLicenseNum;
            List<String> StartDatetimeList = crmLicensePagination.getStartDatetime();
            fir = Long.valueOf(StartDatetimeList.get(0));
            sec = Long.valueOf(StartDatetimeList.get(1));
            ((LambdaQueryWrapper)crmLicenseQueryWrapper.lambda().ge(CrmLicenseEntity::getStartDatetime, (Object)new Date(fir))).le(CrmLicenseEntity::getStartDatetime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty(crmLicensePagination.getEndDatetime())) {
            ++crmLicenseNum;
            List<String> EndDatetimeList = crmLicensePagination.getEndDatetime();
            fir = Long.valueOf(EndDatetimeList.get(0));
            sec = Long.valueOf(EndDatetimeList.get(1));
            ((LambdaQueryWrapper)crmLicenseQueryWrapper.lambda().ge(CrmLicenseEntity::getEndDatetime, (Object)new Date(fir))).le(CrmLicenseEntity::getEndDatetime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (AllIdList.size() > 0) {
            crmLicenseQueryWrapper.lambda().in(CrmLicenseEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)crmLicensePagination.getSidx())) {
            crmLicenseQueryWrapper.lambda().orderByDesc(CrmLicenseEntity::getCreatorTime);
        } else {
            try {
                String sidx = crmLicensePagination.getSidx();
                CrmLicenseEntity crmLicenseEntity = new CrmLicenseEntity();
                Field declaredField = crmLicenseEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmLicenseQueryWrapper = "asc".equals(crmLicensePagination.getSort().toLowerCase()) ? (QueryWrapper)crmLicenseQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmLicenseQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(crmLicensePagination.getCurrentPage(), crmLicensePagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)crmLicenseQueryWrapper);
            return crmLicensePagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return crmLicensePagination.setData(list, list.size());
    }

    @Override
    public List<CrmLicenseEntity> getTypeList(CrmLicensePagination crmLicensePagination, String dataType) {
        Long sec;
        Long fir;
        Object crmLicenseObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int crmLicenseNum = 0;
        QueryWrapper crmLicenseQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmLicenseObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmLicenseQueryWrapper, crmLicensePagination.getMenuId(), "crmLicense"));
            if (ObjectUtil.isEmpty((Object)crmLicenseObj)) {
                return new ArrayList<CrmLicenseEntity>();
            }
            crmLicenseQueryWrapper = (QueryWrapper)crmLicenseObj;
            ++crmLicenseNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmLicenseObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmLicenseQueryWrapper, crmLicensePagination.getMenuId(), "crmLicense"));
            if (ObjectUtil.isEmpty((Object)crmLicenseObj)) {
                return new ArrayList<CrmLicenseEntity>();
            }
            crmLicenseQueryWrapper = (QueryWrapper)crmLicenseObj;
            ++crmLicenseNum;
        }
        if (StringUtils.isNotEmpty((String)crmLicensePagination.getType())) {
            ++crmLicenseNum;
            crmLicenseQueryWrapper.lambda().eq(CrmLicenseEntity::getType, (Object)crmLicensePagination.getType());
        }
        if (StringUtils.isNotEmpty((String)crmLicensePagination.getName())) {
            ++crmLicenseNum;
            crmLicenseQueryWrapper.lambda().like(CrmLicenseEntity::getName, (Object)crmLicensePagination.getName());
        }
        if (StringUtils.isNotEmpty((String)crmLicensePagination.getMachineCode())) {
            ++crmLicenseNum;
            crmLicenseQueryWrapper.lambda().like(CrmLicenseEntity::getMachineCode, (Object)crmLicensePagination.getMachineCode());
        }
        if (StringUtils.isNotEmpty(crmLicensePagination.getStartDatetime())) {
            ++crmLicenseNum;
            List<String> StartDatetimeList = crmLicensePagination.getStartDatetime();
            fir = Long.valueOf(StartDatetimeList.get(0));
            sec = Long.valueOf(StartDatetimeList.get(1));
            ((LambdaQueryWrapper)crmLicenseQueryWrapper.lambda().ge(CrmLicenseEntity::getStartDatetime, (Object)new Date(fir))).le(CrmLicenseEntity::getStartDatetime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty(crmLicensePagination.getEndDatetime())) {
            ++crmLicenseNum;
            List<String> EndDatetimeList = crmLicensePagination.getEndDatetime();
            fir = Long.valueOf(EndDatetimeList.get(0));
            sec = Long.valueOf(EndDatetimeList.get(1));
            ((LambdaQueryWrapper)crmLicenseQueryWrapper.lambda().ge(CrmLicenseEntity::getEndDatetime, (Object)new Date(fir))).le(CrmLicenseEntity::getEndDatetime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (AllIdList.size() > 0) {
            crmLicenseQueryWrapper.lambda().in(CrmLicenseEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)crmLicensePagination.getSidx())) {
            crmLicenseQueryWrapper.lambda().orderByDesc(CrmLicenseEntity::getCreatorTime);
        } else {
            try {
                String sidx = crmLicensePagination.getSidx();
                CrmLicenseEntity crmLicenseEntity = new CrmLicenseEntity();
                Field declaredField = crmLicenseEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmLicenseQueryWrapper = "asc".equals(crmLicensePagination.getSort().toLowerCase()) ? (QueryWrapper)crmLicenseQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmLicenseQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(crmLicensePagination.getCurrentPage(), crmLicensePagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)crmLicenseQueryWrapper);
                return crmLicensePagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return crmLicensePagination.setData(list, list.size());
        }
        return this.list((Wrapper)crmLicenseQueryWrapper);
    }

    @Override
    public CrmLicenseEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmLicenseEntity::getId, (Object)id);
        return (CrmLicenseEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public String getMachineCode() {
        String osName = System.getProperty("os.name").toLowerCase();
        AbstractServerInfo abstractServerInfo = osName.startsWith("windows") ? new WindowsServerInfo() : (osName.startsWith("linux") ? new LinuxServerInfo() : new LinuxServerInfo());
        return Md5Util.getStringMd5((String)JSONObject.toJSONString((Object)LicenseCheckModel.installServerInfo(abstractServerInfo)));
    }

    @Override
    public String generateLicense(String id) {
        String path = this.configValueUtil.getLicenseFilePath();
        FileUtil.mkdir((String)path);
        CrmLicenseEntity info = this.getInfo(id);
        String licenseName = id + ".lic";
        LicenseCreatorParam param = new LicenseCreatorParam();
        param.setSubject("jsbos");
        param.setPrivateAlias("jsbos");
        param.setKeyPass("RongKe@888");
        param.setStorePass("RongKe@888");
        param.setLicensePath(path + File.separator + licenseName);
        param.setPrivateKeysStorePath("jsbos_private.keystore");
        param.setDescription(info.getDescription());
        param.setIssuedTime(info.getStartDatetime());
        param.setExpiryTime(info.getEndDatetime());
        param.setLicenseCode(info.getMachineCode());
        LicenseCreator licenseCreator = new LicenseCreator(param);
        licenseCreator.generateLicense();
        return licenseName;
    }

    @Override
    public void create(CrmLicenseEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, CrmLicenseEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(CrmLicenseEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

