/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workitem.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.crm.util.CrmConstants;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.workitem.entity.CrmWorkitemLogsEntity;
import com.bringspring.workitem.mapper.CrmWorkitemLogsMapper;
import com.bringspring.workitem.model.crmworkitemlogs.CrmWorkitemLogsPagination;
import com.bringspring.workitem.service.CrmWorkitemLogsService;
import com.bringspring.workitem.service.CrmWorkitemService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrmWorkitemLogsServiceImpl
extends ServiceImpl<CrmWorkitemLogsMapper, CrmWorkitemLogsEntity>
implements CrmWorkitemLogsService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private CrmWorkitemService crmWorkitemService;

    @Override
    public List<CrmWorkitemLogsEntity> getList(CrmWorkitemLogsPagination crmWorkitemLogsPagination) {
        Object crmWorkitemLogsObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int crmWorkitemLogsNum = 0;
        QueryWrapper crmWorkitemLogsQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmWorkitemLogsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmWorkitemLogsQueryWrapper, crmWorkitemLogsPagination.getMenuId(), "crmWorkitemLogs"));
            if (ObjectUtil.isEmpty((Object)crmWorkitemLogsObj)) {
                return new ArrayList<CrmWorkitemLogsEntity>();
            }
            crmWorkitemLogsQueryWrapper = (QueryWrapper)crmWorkitemLogsObj;
            ++crmWorkitemLogsNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmWorkitemLogsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmWorkitemLogsQueryWrapper, crmWorkitemLogsPagination.getMenuId(), "crmWorkitemLogs"));
            if (ObjectUtil.isEmpty((Object)crmWorkitemLogsObj)) {
                return new ArrayList<CrmWorkitemLogsEntity>();
            }
            crmWorkitemLogsQueryWrapper = (QueryWrapper)crmWorkitemLogsObj;
            ++crmWorkitemLogsNum;
        }
        crmWorkitemLogsQueryWrapper.lambda().eq(CrmWorkitemLogsEntity::getDeleteMark, (Object)0);
        if (!StrUtil.isBlank((CharSequence)crmWorkitemLogsPagination.getOpraterType())) {
            ++crmWorkitemLogsNum;
            crmWorkitemLogsQueryWrapper.lambda().eq(CrmWorkitemLogsEntity::getOpraterType, (Object)crmWorkitemLogsPagination.getOpraterType());
        }
        if (StringUtils.isNotEmpty((String)crmWorkitemLogsPagination.getDescription())) {
            ++crmWorkitemLogsNum;
            crmWorkitemLogsQueryWrapper.lambda().like(CrmWorkitemLogsEntity::getDescription, (Object)crmWorkitemLogsPagination.getDescription());
        }
        if (StringUtils.isNotEmpty((String)crmWorkitemLogsPagination.getCreatorUserId())) {
            ++crmWorkitemLogsNum;
            crmWorkitemLogsQueryWrapper.lambda().eq(CrmWorkitemLogsEntity::getCreatorUserId, (Object)crmWorkitemLogsPagination.getCreatorUserId());
        }
        if (AllIdList.size() > 0) {
            crmWorkitemLogsQueryWrapper.lambda().in(CrmWorkitemLogsEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)crmWorkitemLogsPagination.getSidx())) {
            crmWorkitemLogsQueryWrapper.lambda().orderByDesc(CrmWorkitemLogsEntity::getId);
        } else {
            try {
                String sidx = crmWorkitemLogsPagination.getSidx();
                CrmWorkitemLogsEntity crmWorkitemLogsEntity = new CrmWorkitemLogsEntity();
                Field declaredField = crmWorkitemLogsEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmWorkitemLogsQueryWrapper = "asc".equals(crmWorkitemLogsPagination.getSort().toLowerCase()) ? (QueryWrapper)crmWorkitemLogsQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmWorkitemLogsQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(crmWorkitemLogsPagination.getCurrentPage(), crmWorkitemLogsPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)crmWorkitemLogsQueryWrapper);
            return crmWorkitemLogsPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return crmWorkitemLogsPagination.setData(list, list.size());
    }

    @Override
    public List<CrmWorkitemLogsEntity> getTypeList(CrmWorkitemLogsPagination crmWorkitemLogsPagination, String dataType) {
        Object crmWorkitemLogsObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int crmWorkitemLogsNum = 0;
        QueryWrapper crmWorkitemLogsQueryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmWorkitemLogsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmWorkitemLogsQueryWrapper, crmWorkitemLogsPagination.getMenuId(), "crmWorkitemLogs"));
            if (ObjectUtil.isEmpty((Object)crmWorkitemLogsObj)) {
                return new ArrayList<CrmWorkitemLogsEntity>();
            }
            crmWorkitemLogsQueryWrapper = (QueryWrapper)crmWorkitemLogsObj;
            ++crmWorkitemLogsNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmWorkitemLogsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmWorkitemLogsQueryWrapper, crmWorkitemLogsPagination.getMenuId(), "crmWorkitemLogs"));
            if (ObjectUtil.isEmpty((Object)crmWorkitemLogsObj)) {
                return new ArrayList<CrmWorkitemLogsEntity>();
            }
            crmWorkitemLogsQueryWrapper = (QueryWrapper)crmWorkitemLogsObj;
            ++crmWorkitemLogsNum;
        }
        if (StringUtils.isNotEmpty((String)crmWorkitemLogsPagination.getDescription())) {
            ++crmWorkitemLogsNum;
            crmWorkitemLogsQueryWrapper.lambda().like(CrmWorkitemLogsEntity::getDescription, (Object)crmWorkitemLogsPagination.getDescription());
        }
        if (StringUtils.isNotEmpty((String)crmWorkitemLogsPagination.getCreatorUserId())) {
            ++crmWorkitemLogsNum;
            crmWorkitemLogsQueryWrapper.lambda().eq(CrmWorkitemLogsEntity::getCreatorUserId, (Object)crmWorkitemLogsPagination.getCreatorUserId());
        }
        if (AllIdList.size() > 0) {
            crmWorkitemLogsQueryWrapper.lambda().in(CrmWorkitemLogsEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)crmWorkitemLogsPagination.getSidx())) {
            crmWorkitemLogsQueryWrapper.lambda().orderByDesc(CrmWorkitemLogsEntity::getId);
        } else {
            try {
                String sidx = crmWorkitemLogsPagination.getSidx();
                CrmWorkitemLogsEntity crmWorkitemLogsEntity = new CrmWorkitemLogsEntity();
                Field declaredField = crmWorkitemLogsEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmWorkitemLogsQueryWrapper = "asc".equals(crmWorkitemLogsPagination.getSort().toLowerCase()) ? (QueryWrapper)crmWorkitemLogsQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmWorkitemLogsQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(crmWorkitemLogsPagination.getCurrentPage(), crmWorkitemLogsPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)crmWorkitemLogsQueryWrapper);
                return crmWorkitemLogsPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return crmWorkitemLogsPagination.setData(list, list.size());
        }
        return this.list((Wrapper)crmWorkitemLogsQueryWrapper);
    }

    @Override
    public CrmWorkitemLogsEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmWorkitemLogsEntity::getId, (Object)id);
        return (CrmWorkitemLogsEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(CrmWorkitemLogsEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, CrmWorkitemLogsEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public List<CrmWorkitemLogsEntity> getListById(String id, String operateType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmWorkitemLogsEntity::getWorkitemId, (Object)id);
        queryWrapper.lambda().eq(CrmWorkitemLogsEntity::getDeleteMark, (Object)0);
        if (!StrUtil.isBlank((CharSequence)operateType)) {
            queryWrapper.lambda().in(CrmWorkitemLogsEntity::getOpraterType, Arrays.asList(operateType.split(",")));
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void sendMessage(String noticeUser, String workitemId) {
        List<String> asList = Arrays.asList(noticeUser.split(","));
        String title = "\u7814\u53d1\u5de5\u4f5c\u9879\u7ba1\u7406\u6709\u4e00\u4e2a\u65b0\u589e\u8bc4\u8bba\u5f85\u60a8\u67e5\u770b\uff01";
        String content = "\u8bf7\u70b9\u51fb\u94fe\u63a5\u8fdb\u5165\u8be6\u60c5\u9875\u3002";
        String pcUrl = CrmConstants.PC_DEMANDLIST_DETAIL + workitemId;
        String type = TermTypeEnum.TERM_PC.getCode();
        String typeDesc = "\u8bf7\u7528pc\u7aef\u6253\u5f00\u94fe\u63a5\uff0c\u8fdb\u884c\u4fe1\u606f\u786e\u8ba4";
        this.crmWorkitemService.newSendMessage("\u9700\u6c42\u7ba1\u7406", CrmConstants.DEMAND_SENDMESSAGE, title, content, CrmConstants.APP_DEMAND_DETAIL, pcUrl, asList, type, typeDesc);
    }

    @Override
    public void delete(CrmWorkitemLogsEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

