/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workitem.service.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.contract.entity.RkContractProjectEntity;
import com.bringspring.contract.entity.RkProjectQuestionEntity;
import com.bringspring.contract.service.RkContractProjectService;
import com.bringspring.contract.service.RkProjectQuestionService;
import com.bringspring.crm.config.AppPageConfig;
import com.bringspring.crm.constant.MessageTypeConst;
import com.bringspring.crm.entity.CrmProductCategoryEntity;
import com.bringspring.crm.entity.CrmProductEntity;
import com.bringspring.crm.entity.CrmProductUserEntity;
import com.bringspring.crm.service.CrmProductCategoryService;
import com.bringspring.crm.service.CrmProductService;
import com.bringspring.crm.service.CrmProductUserService;
import com.bringspring.crm.util.CrmConstants;
import com.bringspring.meeting.utils.DateUtils;
import com.bringspring.meeting.utils.ObjectComparator;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.msgcenter.model.BusinessKeys;
import com.bringspring.system.msgcenter.model.CustomKeysLink;
import com.bringspring.system.msgcenter.model.LinkMsgKeys;
import com.bringspring.system.msgcenter.model.TaskMsg;
import com.bringspring.system.msgcenter.util.SendTaskMsgUtils;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.visit.entity.AfterSalesQuestionEntity;
import com.bringspring.visit.service.AfterSalesQuestionService;
import com.bringspring.visit.utils.CreateChatInfo;
import com.bringspring.visit.utils.QuestionTimeUtil;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import com.bringspring.workitem.entity.CrmWorkitemEntity;
import com.bringspring.workitem.entity.CrmWorkitemLogsEntity;
import com.bringspring.workitem.mapper.CrmWorkitemMapper;
import com.bringspring.workitem.model.crmworkitem.CrmWorkitemCrForm;
import com.bringspring.workitem.model.crmworkitem.CrmWorkitemListVO;
import com.bringspring.workitem.model.crmworkitem.CrmWorkitemPagination;
import com.bringspring.workitem.model.crmworkitem.CrmWorkitemPaginationExportModel;
import com.bringspring.workitem.model.crmworkitem.CrmWorkitemUpForm;
import com.bringspring.workitem.service.CrmWorkitemLogsService;
import com.bringspring.workitem.service.CrmWorkitemService;
import com.bringspring.workitem.utils.WorkItemTypeEnum;
import com.github.pagehelper.util.StringUtil;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrmWorkitemServiceImpl
extends ServiceImpl<CrmWorkitemMapper, CrmWorkitemEntity>
implements CrmWorkitemService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private UserService userService;
    @Autowired
    private CrmProductService crmProductService;
    @Autowired
    private CrmProductCategoryService crmProductCategoryService;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private AppPageConfig appPageConfig;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private CrmWorkitemLogsService crmWorkitemLogsService;
    @Autowired
    private SendTaskMsgUtils sendTaskMsgUtils;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private CrmWorkitemService crmWorkitemService;
    @Autowired
    private RkProjectQuestionService rkProjectQuestionService;
    @Autowired
    private AfterSalesQuestionService afterSalesQuestionService;
    @Autowired
    private RkContractProjectService rkContractProjectService;
    @Autowired
    private CrmProductUserService crmProductUserService;

    @Override
    public List<CrmWorkitemEntity> getList(CrmWorkitemPagination crmWorkitemPagination) {
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper crmWorkitemQueryWrapper = this.appendWrapper(crmWorkitemPagination);
        if (StringUtils.isEmpty((String)crmWorkitemPagination.getSidx())) {
            ((LambdaQueryWrapper)crmWorkitemQueryWrapper.lambda().orderByAsc(CrmWorkitemEntity::getPriority)).orderByDesc(CrmWorkitemEntity::getId);
        } else {
            try {
                String sidx = crmWorkitemPagination.getSidx();
                CrmWorkitemEntity crmWorkitemEntity = new CrmWorkitemEntity();
                Field declaredField = crmWorkitemEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmWorkitemQueryWrapper = "asc".equals(crmWorkitemPagination.getSort().toLowerCase()) ? (QueryWrapper)crmWorkitemQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmWorkitemQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(crmWorkitemPagination.getCurrentPage(), crmWorkitemPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)crmWorkitemQueryWrapper);
            return crmWorkitemPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return crmWorkitemPagination.setData(list, list.size());
    }

    @Override
    public List<CrmWorkitemEntity> getTypeList(CrmWorkitemPagination crmWorkitemPagination, String dataType) {
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper crmWorkitemQueryWrapper = this.appendWrapper(crmWorkitemPagination);
        if (StringUtils.isEmpty((String)crmWorkitemPagination.getSidx())) {
            crmWorkitemQueryWrapper.lambda().orderByDesc(CrmWorkitemEntity::getId);
        } else {
            try {
                String sidx = crmWorkitemPagination.getSidx();
                CrmWorkitemEntity crmWorkitemEntity = new CrmWorkitemEntity();
                Field declaredField = crmWorkitemEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                crmWorkitemQueryWrapper = "asc".equals(crmWorkitemPagination.getSort().toLowerCase()) ? (QueryWrapper)crmWorkitemQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)crmWorkitemQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(crmWorkitemPagination.getCurrentPage(), crmWorkitemPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)crmWorkitemQueryWrapper);
                return crmWorkitemPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return crmWorkitemPagination.setData(list, list.size());
        }
        return this.list((Wrapper)crmWorkitemQueryWrapper);
    }

    private QueryWrapper<CrmWorkitemEntity> appendWrapper(CrmWorkitemPagination crmWorkitemPagination) {
        List<String> EndDateList;
        Long sec;
        List<String> StartDateList;
        Object crmWorkitemObj;
        String userId = this.userProvider.get().getUserId();
        boolean total = false;
        int crmWorkitemNum = 0;
        QueryWrapper crmWorkitemQueryWrapper = new QueryWrapper();
        crmWorkitemQueryWrapper.lambda().select(CrmWorkitemEntity.class, info -> !info.getColumn().equals("DESCRIPTION"));
        boolean pcPermission = true;
        boolean appPermission = true;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmWorkitemObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmWorkitemQueryWrapper, crmWorkitemPagination.getMenuId(), "crm_workitem"));
            if (ObjectUtil.isEmpty((Object)crmWorkitemObj)) {
                crmWorkitemQueryWrapper.and(this.defaultWrapper());
            } else {
                crmWorkitemQueryWrapper = (QueryWrapper)crmWorkitemObj;
                ++crmWorkitemNum;
            }
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            crmWorkitemObj = this.authorizeService.getCondition(new AuthorizeConditionModel(crmWorkitemQueryWrapper, crmWorkitemPagination.getMenuId(), "crm_workitem"));
            if (ObjectUtil.isEmpty((Object)crmWorkitemObj)) {
                crmWorkitemQueryWrapper.and(this.defaultWrapper());
            } else {
                crmWorkitemQueryWrapper = (QueryWrapper)crmWorkitemObj;
                ++crmWorkitemNum;
            }
        }
        if (crmWorkitemPagination.getIsShowTree().booleanValue()) {
            crmWorkitemQueryWrapper.lambda().eq(CrmWorkitemEntity::getParentId, (Object)"-1");
        }
        if (!StrUtil.isBlank((CharSequence)crmWorkitemPagination.getWorkBigCatagory())) {
            crmWorkitemQueryWrapper.lambda().eq(CrmWorkitemEntity::getWorkBigCatagory, (Object)crmWorkitemPagination.getWorkBigCatagory());
        } else {
            crmWorkitemQueryWrapper.lambda().eq(CrmWorkitemEntity::getWorkBigCatagory, (Object)WorkItemTypeEnum.NORMAL_WORK_TYPE.getType());
        }
        if (crmWorkitemPagination.getCreatorTimeList() != null && crmWorkitemPagination.getCreatorTimeList().size() > 0) {
            crmWorkitemPagination.setStartTimes(new SimpleDateFormat("yyyy-MM-dd").format(new Date(crmWorkitemPagination.getCreatorTimeList().get(0))));
            crmWorkitemPagination.setEndTime(new SimpleDateFormat("yyyy-MM-dd").format(new Date(crmWorkitemPagination.getCreatorTimeList().get(1) + 86400000L)));
            crmWorkitemQueryWrapper.lambda().between(CrmWorkitemEntity::getCreatorTime, (Object)crmWorkitemPagination.getStartTimes(), (Object)crmWorkitemPagination.getEndTime());
        }
        if (crmWorkitemPagination.getStartTime() != null && crmWorkitemPagination.getStartTime().size() > 0) {
            crmWorkitemQueryWrapper.lambda().between(CrmWorkitemEntity::getActualStartDate, (Object)crmWorkitemPagination.getStartTime().get(0), (Object)new Date(crmWorkitemPagination.getStartTime().get(1).getTime() + 86400000L));
        }
        if (crmWorkitemPagination.getActualStart() != null && crmWorkitemPagination.getActualStart().size() > 0) {
            crmWorkitemQueryWrapper.lambda().between(CrmWorkitemEntity::getActualEndDate, (Object)crmWorkitemPagination.getActualStart().get(0), (Object)new Date(crmWorkitemPagination.getActualStart().get(1).getTime() + 86400000L));
        }
        if (StringUtils.isNotEmpty((String)crmWorkitemPagination.getIsProjectDate())) {
            ++crmWorkitemNum;
            if (crmWorkitemPagination.getIsProjectDate().equals("0")) {
                crmWorkitemQueryWrapper.lambda().isNotNull(CrmWorkitemEntity::getStartDate);
            } else {
                crmWorkitemQueryWrapper.lambda().isNull(CrmWorkitemEntity::getStartDate);
            }
        }
        if (StringUtils.isNotEmpty((String)crmWorkitemPagination.getName())) {
            ++crmWorkitemNum;
            crmWorkitemQueryWrapper.lambda().and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(CrmWorkitemEntity::getName, (Object)crmWorkitemPagination.getName())).or(w1 -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w1.like(CrmWorkitemEntity::getDescription, (Object)crmWorkitemPagination.getName());
                });
            });
        }
        if (StringUtils.isNotEmpty((String)crmWorkitemPagination.getCurrentProductVersionName())) {
            ++crmWorkitemNum;
            crmWorkitemQueryWrapper.lambda().like(CrmWorkitemEntity::getCurrentProductVersionName, (Object)crmWorkitemPagination.getCurrentProductVersionName());
        }
        if (StringUtils.isNotEmpty((String)crmWorkitemPagination.getProjectId())) {
            ++crmWorkitemNum;
            crmWorkitemQueryWrapper.lambda().like(CrmWorkitemEntity::getProjectId, (Object)crmWorkitemPagination.getProjectId());
        }
        if (CollectionUtil.isNotEmpty(crmWorkitemPagination.getProductId())) {
            ++crmWorkitemNum;
            crmWorkitemQueryWrapper.lambda().in(CrmWorkitemEntity::getProductId, crmWorkitemPagination.getProductId());
        }
        if (StringUtils.isNotEmpty((String)crmWorkitemPagination.getSwitchType())) {
            switch (crmWorkitemPagination.getSwitchType()) {
                case "myTask": {
                    ++crmWorkitemNum;
                    crmWorkitemQueryWrapper.lambda().eq(CrmWorkitemEntity::getPersonInCharge, (Object)userId);
                    break;
                }
                case "myCreate": {
                    ++crmWorkitemNum;
                    crmWorkitemQueryWrapper.lambda().eq(CrmWorkitemEntity::getCreatorUserId, (Object)userId);
                    break;
                }
                case "myCoordinate": {
                    ++crmWorkitemNum;
                    crmWorkitemQueryWrapper.lambda().eq(CrmWorkitemEntity::getCoordinateUserId, (Object)userId);
                }
            }
        }
        if (StringUtils.isNotEmpty((String)crmWorkitemPagination.getPersonInCharge())) {
            ++crmWorkitemNum;
            crmWorkitemQueryWrapper.lambda().eq(CrmWorkitemEntity::getPersonInCharge, (Object)crmWorkitemPagination.getPersonInCharge());
        }
        if (StringUtils.isNotEmpty((String)crmWorkitemPagination.getAcceptanceUserId())) {
            ++crmWorkitemNum;
            crmWorkitemQueryWrapper.lambda().eq(CrmWorkitemEntity::getAcceptanceUserId, (Object)crmWorkitemPagination.getAcceptanceUserId());
        }
        if (StringUtils.isNotEmpty((String)crmWorkitemPagination.getProposeUserId())) {
            ++crmWorkitemNum;
            crmWorkitemQueryWrapper.lambda().eq(CrmWorkitemEntity::getProposeUserId, (Object)crmWorkitemPagination.getProposeUserId());
        }
        if (StringUtils.isNotEmpty((String)crmWorkitemPagination.getProposeUserDepartment())) {
            ++crmWorkitemNum;
            crmWorkitemQueryWrapper.lambda().eq(CrmWorkitemEntity::getProposeUserDepartment, (Object)crmWorkitemPagination.getProposeUserDepartment());
        }
        if (StringUtils.isNotEmpty(crmWorkitemPagination.getStartDate())) {
            ++crmWorkitemNum;
            StartDateList = crmWorkitemPagination.getStartDate();
            Long fir = Long.valueOf(StartDateList.get(0));
            sec = Long.valueOf(StartDateList.get(1));
            ((LambdaQueryWrapper)crmWorkitemQueryWrapper.lambda().ge(CrmWorkitemEntity::getStartDate, (Object)new Date(fir))).le(CrmWorkitemEntity::getStartDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty(crmWorkitemPagination.getEndDate())) {
            ++crmWorkitemNum;
            EndDateList = crmWorkitemPagination.getEndDate();
            Long fir = Long.valueOf(EndDateList.get(0));
            sec = Long.valueOf(EndDateList.get(1));
            ((LambdaQueryWrapper)crmWorkitemQueryWrapper.lambda().ge(CrmWorkitemEntity::getEndDate, (Object)new Date(fir))).le(CrmWorkitemEntity::getEndDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty(crmWorkitemPagination.getActualDateList())) {
            ++crmWorkitemNum;
            StartDateList = crmWorkitemPagination.getActualDateList();
            Long fir = Long.valueOf(StartDateList.get(0));
            sec = Long.valueOf(StartDateList.get(1));
            ((LambdaQueryWrapper)crmWorkitemQueryWrapper.lambda().ge(CrmWorkitemEntity::getActualEndDate, (Object)new Date(fir))).le(CrmWorkitemEntity::getActualEndDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty((String)crmWorkitemPagination.getType())) {
            ++crmWorkitemNum;
            crmWorkitemQueryWrapper.lambda().eq(CrmWorkitemEntity::getType, (Object)crmWorkitemPagination.getType());
        }
        if (StringUtils.isNotEmpty((String)crmWorkitemPagination.getPriority())) {
            ++crmWorkitemNum;
            crmWorkitemQueryWrapper.lambda().eq(CrmWorkitemEntity::getPriority, (Object)crmWorkitemPagination.getPriority());
        }
        if (StringUtils.isNotEmpty((String)crmWorkitemPagination.getEnabledMark())) {
            ++crmWorkitemNum;
            crmWorkitemQueryWrapper.lambda().in(CrmWorkitemEntity::getEnabledMark, (Object[])crmWorkitemPagination.getEnabledMark().split(","));
        }
        if (crmWorkitemPagination.getOnlyParent().booleanValue()) {
            ++crmWorkitemNum;
            crmWorkitemQueryWrapper.lambda().eq(CrmWorkitemEntity::getParentId, (Object)"-1");
        }
        if (!StrUtil.isBlank((CharSequence)crmWorkitemPagination.getSource())) {
            ++crmWorkitemNum;
            if (!StrUtil.isBlank((CharSequence)crmWorkitemPagination.getSourceCode())) {
                crmWorkitemQueryWrapper.lambda().and(wrapper -> ((LambdaQueryWrapper)wrapper.like(CrmWorkitemEntity::getSource, (Object)crmWorkitemPagination.getSource())).or(wrapper1 -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wrapper1.eq(CrmWorkitemEntity::getSourceCode, (Object)crmWorkitemPagination.getSourceCode());
                }));
            } else {
                crmWorkitemQueryWrapper.lambda().like(CrmWorkitemEntity::getSource, (Object)crmWorkitemPagination.getSource());
            }
        }
        if (StringUtils.isNotEmpty(crmWorkitemPagination.getActualWorkDateList())) {
            ++crmWorkitemNum;
            EndDateList = crmWorkitemPagination.getActualWorkDateList();
            Long fir = Long.valueOf(EndDateList.get(0));
            sec = Long.valueOf(EndDateList.get(1));
            crmWorkitemQueryWrapper.lambda().and(queryWrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.between(CrmWorkitemEntity::getActualStartDate, (Object)new Date(fir), (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")))).or(queryWrapper1 -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)queryWrapper1.between(CrmWorkitemEntity::getActualEndDate, (Object)new Date(fir), (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
                })).or(queryWrapper2 -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper2.le(CrmWorkitemEntity::getActualStartDate, (Object)new Date(fir))).ge(CrmWorkitemEntity::getActualEndDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
                });
            });
        }
        if (StringUtils.isNotEmpty(crmWorkitemPagination.getPlanWorkDateList())) {
            ++crmWorkitemNum;
            EndDateList = crmWorkitemPagination.getPlanWorkDateList();
            Long fir = Long.valueOf(EndDateList.get(0));
            sec = Long.valueOf(EndDateList.get(1));
            crmWorkitemQueryWrapper.lambda().and(queryWrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.between(CrmWorkitemEntity::getStartDate, (Object)new Date(fir), (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")))).or(queryWrapper1 -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)queryWrapper1.between(CrmWorkitemEntity::getEndDate, (Object)new Date(fir), (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
                })).or(queryWrapper2 -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper2.le(CrmWorkitemEntity::getStartDate, (Object)new Date(fir))).ge(CrmWorkitemEntity::getEndDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
                });
            });
        }
        return crmWorkitemQueryWrapper;
    }

    @Override
    public CrmWorkitemEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CrmWorkitemEntity::getId, (Object)id);
        return (CrmWorkitemEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(CrmWorkitemEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, CrmWorkitemEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(CrmWorkitemEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public void setMessage(List<String> userId, String woekItemId, String remindTitle, String content) throws DataException {
        List collect = userId.stream().distinct().collect(Collectors.toList());
        UserInfo userInfo = this.userProvider.get();
        SentMessageForm sentMessageForm = new SentMessageForm();
        sentMessageForm.setType(MessageTypeConst.WORKITEM);
        sentMessageForm.setToUserIds(collect);
        sentMessageForm.setTemplateId("431369151336966725");
        sentMessageForm.setTitle(ObjectUtil.isEmpty((Object)remindTitle) ? "\u60a8\u6709\u4e00\u4e2a\u5de5\u4f5c\u9879\u5f85\u67e5\u770b\uff01" : remindTitle);
        sentMessageForm.setContent(ObjectUtil.isEmpty((Object)content) ? "\u60a8\u6709\u4e00\u4e2a\u5de5\u4f5c\u9879\u5f85\u67e5\u770b\uff01" : "\u6807\u9898\uff1a" + content);
        HashMap<String, String> map = new HashMap<String, String>();
        CrmWorkitemEntity info = this.getInfo(woekItemId);
        map.put("id", woekItemId);
        map.put("name", userInfo.getUserName());
        map.put("title", sentMessageForm.getTitle());
        map.put("CreatorUser", userInfo.getRealName());
        String MessageTime = DateUtil.dateFormat((Date)new Date());
        map.put("MessageTime", MessageTime);
        String contentWechat = null;
        ArrayList<String> tempUserIds = new ArrayList<String>();
        tempUserIds.add(userInfo.getUserId());
        contentWechat = sentMessageForm.getContent() + "\n\u65f6\u95f4:" + MessageTime + "\n\u53d1\u8d77\u4eba:" + userInfo.getRealName();
        map.put("content", contentWechat);
        map.put("AppUrl", "http://gl.bringspring.com/jsbos-web/#/crm/crmworkitem?id=" + woekItemId);
        sentMessageForm.setParameterMap(map);
        sentMessageForm.setBodyText(map);
        ArrayList<SentMessageForm> messageListAll = new ArrayList<SentMessageForm>();
        messageListAll.add(sentMessageForm);
    }

    @Override
    public List<CrmWorkitemEntity> getWorkItemList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ArrayList<String> list = new ArrayList<String>();
        list.add("todo");
        list.add("inprogress");
        queryWrapper.lambda().in(CrmWorkitemEntity::getEnabledMark, list);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<CrmWorkitemEntity> workItemSchdule() {
        Date frontDay = DateUtil.getFrontDay((Date)DateUtil.getNowDate(), (int)7);
        List accepted = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(CrmWorkitemEntity::getEnabledMark, (Object)"accepted")).isNull(CrmWorkitemEntity::getEvaluateGrade)).isNull(CrmWorkitemEntity::getEvaluateDescription)).le(CrmWorkitemEntity::getCreatorTime, (Object)frontDay));
        if (!ObjectUtil.isEmpty((Object)accepted)) {
            for (CrmWorkitemEntity crmWorkitemEntity : accepted) {
                crmWorkitemEntity.setEvaluateGrade("3");
                crmWorkitemEntity.setEvaluateDescription("\u81ea\u52a8\u8bc4\u4ef7");
            }
            this.updateBatchById(accepted);
        }
        return accepted;
    }

    @Override
    public List<CrmProductEntity> getListByAllWorkItem() {
        List list = this.list();
        List<String> collect = list.stream().map(CrmWorkitemEntity::getProductId).collect(Collectors.toList());
        List<CrmProductEntity> listByProductIds = this.crmProductService.getListByProductIds(collect);
        return listByProductIds;
    }

    @Override
    public DownloadVO exportData(CrmWorkitemPaginationExportModel crmWorkitemPaginationExportModel) {
        CrmWorkitemPagination crmWorkitemPagination = (CrmWorkitemPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)crmWorkitemPaginationExportModel), CrmWorkitemPagination.class));
        List<CrmWorkitemEntity> list = this.getTypeList(crmWorkitemPagination, crmWorkitemPaginationExportModel.getDataType());
        for (CrmWorkitemEntity entity : list) {
            RkContractProjectEntity projectServiceInfo;
            CrmProductEntity productServiceInfo;
            entity.setCreatorUserId(this.baseDataUtil.userSelectValues(entity.getCreatorUserId()));
            entity.setProposeUserId(this.baseDataUtil.userSelectValues(entity.getProposeUserId()));
            entity.setProposeUserDepartment(this.baseDataUtil.comSelectValues(entity.getProposeUserDepartment()));
            entity.setPersonInCharge(this.baseDataUtil.userSelectValues(entity.getPersonInCharge()));
            entity.setCoordinateUserId(this.baseDataUtil.userSelectValues(entity.getCoordinateUserId()));
            entity.setBugCategory(this.baseDataUtil.getDictName(entity.getBugCategory(), "bugCategory"));
            entity.setPriority(this.baseDataUtil.getDictName(entity.getPriority(), "demandPriority"));
            entity.setEnabledMark(this.baseDataUtil.getDictName(String.valueOf(entity.getEnabledMark()), "demandMark"));
            entity.setType(this.baseDataUtil.getDictName(entity.getType(), "demandType"));
            if (!StrUtil.equals((CharSequence)entity.getParentId(), (CharSequence)"-1")) {
                CrmWorkitemEntity info = this.getInfo(entity.getParentId());
                entity.setParentId(ObjectUtil.isNotEmpty((Object)info) ? info.getName() : "\u2014");
            } else {
                entity.setParentId("\u2014");
            }
            if (!ObjectUtil.isEmpty((Object)entity.getProductId()) && ObjectUtil.isNotEmpty((Object)(productServiceInfo = this.crmProductService.getInfo(entity.getProductId())))) {
                entity.setProductId(productServiceInfo.getProductName());
            }
            if (ObjectUtil.isEmpty((Object)entity.getProjectId()) || !ObjectUtil.isNotEmpty((Object)(projectServiceInfo = this.rkContractProjectService.getInfo(entity.getProjectId())))) continue;
            entity.setProjectId(projectServiceInfo.getProjectName());
        }
        List listVO = JsonUtil.getJsonToList(list, CrmWorkitemListVO.class);
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtil.isEmpty((String)crmWorkitemPaginationExportModel.getSelectKey()) ? crmWorkitemPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return vo;
    }

    @Override
    public List<CrmWorkitemEntity> executeJumpQueue(CrmWorkitemEntity entity) {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)entity.getStartDate()) || ObjectUtil.isEmpty((Object)entity.getEndDate())) {
            return new ArrayList<CrmWorkitemEntity>();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(CrmConstants.WORK_TODO);
        list.add(CrmConstants.WORK_INPROGRESS);
        List<CrmWorkitemEntity> listByUserIdAndEnabledMark = this.getListByUserIdAndEnabledMark(entity.getPersonInCharge(), list);
        List<Object> listByUserIdAndEnabledMarkRemoveSelf = new ArrayList();
        if (ObjectUtil.isNotEmpty(listByUserIdAndEnabledMark)) {
            listByUserIdAndEnabledMarkRemoveSelf = listByUserIdAndEnabledMark.stream().filter(i -> !i.getId().equals(entity.getId())).collect(Collectors.toList());
        }
        if (ObjectUtil.isEmpty(listByUserIdAndEnabledMarkRemoveSelf)) {
            return new ArrayList<CrmWorkitemEntity>();
        }
        Date jumpStartDate = entity.getStartDate();
        Date jumpEndDate = entity.getEndDate();
        ArrayList<CrmWorkitemEntity> overlap = new ArrayList<CrmWorkitemEntity>();
        ArrayList<CrmWorkitemEntity> noOverlap = new ArrayList<CrmWorkitemEntity>();
        for (CrmWorkitemEntity crmWorkitemEntity : listByUserIdAndEnabledMarkRemoveSelf) {
            if (ObjectUtil.isEmpty((Object)crmWorkitemEntity.getStartDate()) || ObjectUtil.isEmpty((Object)crmWorkitemEntity.getEndDate())) continue;
            boolean hasOverlap = DateUtils.hasOverlap(crmWorkitemEntity.getStartDate(), crmWorkitemEntity.getEndDate(), jumpStartDate, jumpEndDate);
            if (hasOverlap) {
                overlap.add(crmWorkitemEntity);
            }
            if (!jumpStartDate.before(crmWorkitemEntity.getStartDate()) && !jumpEndDate.equals(crmWorkitemEntity.getStartDate())) continue;
            noOverlap.add(crmWorkitemEntity);
        }
        Long day = new Long(1L);
        if (jumpEndDate.getTime() != jumpStartDate.getTime()) {
            day = (jumpEndDate.getTime() - jumpStartDate.getTime()) / 86400000L + 1L;
        }
        ArrayList<CrmWorkitemLogsEntity> arrayList = new ArrayList<CrmWorkitemLogsEntity>();
        for (CrmWorkitemEntity crmWorkitemEntity : overlap) {
            Date frontEndDate = crmWorkitemEntity.getEndDate();
            Calendar c = Calendar.getInstance();
            c.setTime(crmWorkitemEntity.getEndDate());
            c.add(5, Math.toIntExact(day));
            crmWorkitemEntity.setEndDate(c.getTime());
            CrmWorkitemLogsEntity crmWorkitemLogsEntity = new CrmWorkitemLogsEntity();
            crmWorkitemLogsEntity.setId(RandomUtil.uuId());
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(userInfo.getUserName() + "\u521b\u5efa\u63d2\u961f\u4efb\u52a1\u3010" + entity.getName() + "\u3011\uff0c\u8be5\u63d2\u961f\u4efb\u52a1\u5171\u8ba1\u8017\u65f6" + day + "\u5929;");
            stringBuffer.append("\u5f53\u524d\u4efb\u52a1\u539f\u8ba1\u5212\u65f6\u95f4\uff1a" + DateUtil.daFormat((Date)crmWorkitemEntity.getStartDate()) + "\u81f3" + DateUtil.daFormat((Date)frontEndDate) + ";");
            stringBuffer.append("\u63a8\u8fdf\u540e\u65f6\u95f4\u89c4\u5212\u4e3a\uff1a" + DateUtil.daFormat((Date)crmWorkitemEntity.getStartDate()) + "\u81f3" + DateUtil.daFormat((Date)crmWorkitemEntity.getEndDate()) + "\u3002");
            crmWorkitemLogsEntity.setDescription(stringBuffer.toString());
            crmWorkitemLogsEntity.setCreatorUserId(userInfo.getUserId());
            crmWorkitemLogsEntity.setCreatorTime(DateUtil.getNowDate());
            crmWorkitemLogsEntity.setWorkitemId(crmWorkitemEntity.getId());
            arrayList.add(crmWorkitemLogsEntity);
        }
        for (CrmWorkitemEntity crmWorkitemEntity : noOverlap) {
            Date frontStartDate = crmWorkitemEntity.getStartDate();
            Date frontEndDate = crmWorkitemEntity.getEndDate();
            Calendar c2 = Calendar.getInstance();
            c2.setTime(crmWorkitemEntity.getStartDate());
            c2.add(5, Math.toIntExact(day));
            crmWorkitemEntity.setStartDate(c2.getTime());
            Calendar c = Calendar.getInstance();
            c.setTime(crmWorkitemEntity.getEndDate());
            c.add(5, Math.toIntExact(day));
            crmWorkitemEntity.setEndDate(c.getTime());
            CrmWorkitemLogsEntity crmWorkitemLogsEntity = new CrmWorkitemLogsEntity();
            crmWorkitemLogsEntity.setId(RandomUtil.uuId());
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(userInfo.getUserName() + "\u521b\u5efa\u63d2\u961f\u4efb\u52a1\u3010" + entity.getName() + "\u3011\uff0c\u8be5\u63d2\u961f\u4efb\u52a1\u5171\u8ba1\u8017\u65f6" + day + "\u5929;");
            stringBuffer.append("\u5f53\u524d\u4efb\u52a1\u539f\u8ba1\u5212\u65f6\u95f4\uff1a" + DateUtil.daFormat((Date)frontStartDate) + "\u81f3" + DateUtil.daFormat((Date)frontEndDate) + ";");
            stringBuffer.append("\u63a8\u8fdf\u540e\u65f6\u95f4\u89c4\u5212\u4e3a\uff1a" + DateUtil.daFormat((Date)crmWorkitemEntity.getStartDate()) + "\u81f3" + DateUtil.daFormat((Date)crmWorkitemEntity.getEndDate()) + "\u3002");
            crmWorkitemLogsEntity.setDescription(stringBuffer.toString());
            crmWorkitemLogsEntity.setCreatorUserId(userInfo.getUserId());
            crmWorkitemLogsEntity.setCreatorTime(DateUtil.getNowDate());
            crmWorkitemLogsEntity.setWorkitemId(crmWorkitemEntity.getId());
            arrayList.add(crmWorkitemLogsEntity);
        }
        ArrayList<CrmWorkitemEntity> allEntity = new ArrayList<CrmWorkitemEntity>();
        allEntity.addAll(overlap);
        allEntity.addAll(noOverlap);
        this.updateBatchById(allEntity);
        this.crmWorkitemLogsService.saveBatch(arrayList);
        return listByUserIdAndEnabledMarkRemoveSelf;
    }

    @Override
    public List<CrmWorkitemEntity> getListByUserIdAndEnabledMark(String userId, List<String> enabledMark) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!StrUtil.isBlank((CharSequence)userId)) {
            queryWrapper.lambda().eq(CrmWorkitemEntity::getPersonInCharge, (Object)userId);
        }
        if (ObjectUtil.isNotEmpty(enabledMark)) {
            queryWrapper.lambda().in(CrmWorkitemEntity::getEnabledMark, enabledMark);
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void recordUpdateLog(CrmWorkitemEntity entity, CrmWorkitemEntity subentity, String autoSave) {
        UserInfo userInfo = this.userProvider.get();
        Map<String, String> compare = ObjectComparator.compare(entity, subentity);
        ArrayList keyList = new ArrayList();
        if (ObjectUtil.isNotEmpty(compare)) {
            compare.keySet().stream().forEach(key -> keyList.add(key));
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = keyList.iterator();
        while (iterator.hasNext()) {
            String s;
            switch (s = (String)iterator.next()) {
                case "name": {
                    stringBuffer.append(userInfo.getUserName() + "\u4fee\u6539\u5de5\u4f5c\u9879\u6807\u9898\uff0c\u4fee\u6539\u524d\uff1a" + entity.getName() + "\uff0c\u4fee\u6539\u540e\uff1a" + subentity.getName() + ";");
                    break;
                }
                case "productId": {
                    String frontName = "-";
                    String nextName = "-";
                    if (!StrUtil.isBlank((CharSequence)entity.getProductId())) {
                        frontName = this.crmProductService.getInfo(entity.getProductId()).getProductName();
                    }
                    if (!StrUtil.isBlank((CharSequence)subentity.getProductId())) {
                        nextName = this.crmProductService.getInfo(subentity.getProductId()).getProductName();
                    }
                    stringBuffer.append(userInfo.getUserName() + "\u4fee\u6539\u4e86\u5173\u8054\u4ea7\u54c1\uff0c\u4fee\u6539\u524d\uff1a" + frontName + "\uff0c\u4fee\u6539\u540e\uff1a" + nextName + ";");
                    break;
                }
                case "type": {
                    stringBuffer.append(userInfo.getUserName() + "\u4fee\u6539\u4e86\u4efb\u52a1\u7c7b\u578b\uff0c\u4fee\u6539\u524d\uff1a" + this.baseDataUtil.getDictName(entity.getType(), "demandType") + "\uff0c\u4fee\u6539\u540e\uff1a" + this.baseDataUtil.getDictName(subentity.getType(), "demandType") + ";");
                    break;
                }
                case "bugCategory": {
                    stringBuffer.append(userInfo.getUserName() + "\u4fee\u6539\u4e86\u7f3a\u9677\u7c7b\u578b\uff0c\u4fee\u6539\u524d\uff1a" + this.baseDataUtil.getDictName(entity.getBugCategory(), "bugCategory") + "\uff0c\u4fee\u6539\u540e\uff1a" + this.baseDataUtil.getDictName(subentity.getBugCategory(), "bugCategory") + ";");
                    break;
                }
                case "priority": {
                    stringBuffer.append(userInfo.getUserName() + "\u4fee\u6539\u4e86\u4efb\u52a1\u4f18\u5148\u7ea7\uff0c\u4fee\u6539\u524d\uff1a" + this.baseDataUtil.getDictName(entity.getPriority(), "demandPriority") + "\uff0c\u4fee\u6539\u540e\uff1a" + this.baseDataUtil.getDictName(subentity.getPriority(), "demandPriority") + ";");
                    break;
                }
                case "personInCharge": {
                    stringBuffer.append(userInfo.getUserName() + "\u4fee\u6539\u4e86\u8d1f\u8d23\u4eba\uff0c\u4fee\u6539\u524d\uff1a" + this.baseDataUtil.userSelectValues(entity.getPersonInCharge()) + "\uff0c\u4fee\u6539\u540e\uff1a" + this.baseDataUtil.userSelectValues(subentity.getPersonInCharge()) + ";");
                    break;
                }
                case "coordinateUserId": {
                    stringBuffer.append(userInfo.getUserName() + "\u4fee\u6539\u4e86\u914d\u5408\u4eba\uff0c\u4fee\u6539\u524d\uff1a" + this.baseDataUtil.userSelectValues(entity.getCoordinateUserId()) + "\uff0c\u4fee\u6539\u540e\uff1a" + this.baseDataUtil.userSelectValues(subentity.getCoordinateUserId()) + ";");
                    break;
                }
                case "proposeUserId": {
                    stringBuffer.append(userInfo.getUserName() + "\u4fee\u6539\u4e86\u63d0\u51fa\u4eba\uff0c\u4fee\u6539\u524d\uff1a" + this.baseDataUtil.userSelectValues(entity.getProposeUserId()) + "\uff0c\u4fee\u6539\u540e\uff1a" + this.baseDataUtil.userSelectValues(subentity.getProposeUserId()) + ";");
                    break;
                }
                case "filePath": {
                    stringBuffer.append(userInfo.getUserName() + "\u4fee\u6539\u4e86\u9644\u4ef6;");
                    break;
                }
                case "source": {
                    stringBuffer.append(userInfo.getUserName() + "\u4fee\u6539\u4e86\u6765\u6e90\uff0c\u4fee\u6539\u524d\uff1a" + entity.getSource() + "\uff0c\u4fee\u6539\u540e\uff1a" + subentity.getSource() + ";");
                    break;
                }
                case "workHours": {
                    stringBuffer.append(userInfo.getUserName() + "\u4fee\u6539\u4e86\u5de5\u65f6\uff0c\u4fee\u6539\u524d\uff1a" + entity.getWorkHours() + "\uff0c\u4fee\u6539\u540e\uff1a" + subentity.getWorkHours() + ";");
                    break;
                }
                case "startDate": {
                    String frontStartDate = "-";
                    String nextStartDate = "-";
                    if (ObjectUtil.isNotEmpty((Object)entity.getStartDate())) {
                        frontStartDate = DateUtil.daFormat((Date)entity.getStartDate());
                    }
                    if (ObjectUtil.isNotEmpty((Object)subentity.getStartDate())) {
                        nextStartDate = DateUtil.daFormat((Date)subentity.getStartDate());
                    }
                    stringBuffer.append(userInfo.getUserName() + "\u4fee\u6539\u4e86\u5f00\u59cb\u65f6\u95f4\uff0c\u4fee\u6539\u524d\uff1a" + frontStartDate + "\uff0c\u4fee\u6539\u540e\uff1a" + nextStartDate + ";");
                    break;
                }
                case "endDate": {
                    String frontEndDate = "-";
                    String nextEndDate = "-";
                    if (ObjectUtil.isNotEmpty((Object)entity.getEndDate())) {
                        frontEndDate = DateUtil.daFormat((Date)entity.getEndDate());
                    }
                    if (ObjectUtil.isNotEmpty((Object)subentity.getEndDate())) {
                        nextEndDate = DateUtil.daFormat((Date)subentity.getEndDate());
                    }
                    stringBuffer.append(userInfo.getUserName() + "\u4fee\u6539\u4e86\u7ed3\u675f\u65f6\u95f4\uff0c\u4fee\u6539\u524d\uff1a" + frontEndDate + "\uff0c\u4fee\u6539\u540e\uff1a" + nextEndDate + ";");
                    break;
                }
                case "enabledMark": {
                    stringBuffer.append(userInfo.getUserName() + "\u4fee\u6539\u4e86\u4efb\u52a1\u72b6\u6001\uff0c\u4fee\u6539\u524d\uff1a" + this.baseDataUtil.getDictName(entity.getEnabledMark(), "demandMark") + "\uff0c\u4fee\u6539\u540e\uff1a" + this.baseDataUtil.getDictName(subentity.getEnabledMark(), "demandMark") + ";");
                    break;
                }
                case "description": {
                    stringBuffer.append(userInfo.getUserName() + "\u4fee\u6539\u4e86\u4efb\u52a1\u63cf\u8ff0;");
                    break;
                }
                case "jumpQueue": {
                    if (!subentity.getJumpQueue().equals("1")) break;
                    stringBuffer.append(userInfo.getUserName() + "\u5c06\u8be5\u4efb\u52a1\u4fee\u6539\u4e3a\u63d2\u961f\u4efb\u52a1;");
                    break;
                }
                case "acceptanceUserId": {
                    stringBuffer.append(userInfo.getUserName() + "\u4fee\u6539\u4e86\u9a8c\u6536\u4eba\uff0c\u4fee\u6539\u524d\uff1a" + this.baseDataUtil.userSelectValues(entity.getAcceptanceUserId()) + "\uff0c\u4fee\u6539\u540e\uff1a" + this.baseDataUtil.userSelectValues(subentity.getAcceptanceUserId()) + ";");
                }
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        String title = null;
        String content = "\u6807\u9898\uff1a" + entity.getName();
        String pcUrl = CrmConstants.PC_DEMAND_DETAIL + entity.getId();
        String type = TermTypeEnum.TERM_PC.getCode();
        String typeDesc = "\u8bf7\u7528pc\u7aef\u6253\u5f00\u94fe\u63a5\uff0c\u8fdb\u884c\u4fe1\u606f\u786e\u8ba4";
        if ("accepted".equals(subentity.getEnabledMark()) && !ObjectUtil.isEmpty((Object)subentity.getPersonInCharge())) {
            list.add(subentity.getPersonInCharge());
        } else if ("completed".equals(subentity.getEnabledMark()) && !ObjectUtil.isEmpty((Object)subentity.getPersonInCharge()) && !"true".equals(autoSave)) {
            if (!StrUtil.isBlank((CharSequence)subentity.getAcceptanceUserId())) {
                list.add(subentity.getAcceptanceUserId());
            } else {
                list.add(subentity.getCreatorUserId());
            }
            title = "\u6709\u60a8\u5f85\u9a8c\u6536\u7684\u5de5\u4f5c\u9879\uff01";
            this.newSendMessage("\u9700\u6c42\u7ba1\u7406", CrmConstants.DEMAND_SENDMESSAGE, title, content, CrmConstants.APP_DEMAND_DETAIL, pcUrl, list, type, typeDesc);
        } else if ("closed".equals(subentity.getEnabledMark()) && !ObjectUtil.isEmpty((Object)subentity.getPersonInCharge()) && !"true".equals(autoSave)) {
            if (!StrUtil.isBlank((CharSequence)subentity.getAcceptanceUserId())) {
                list.add(subentity.getAcceptanceUserId());
            }
            title = "\u6709" + entity.getName() + "\u5df2\u5173\u95ed";
            this.newSendMessage("\u9700\u6c42\u7ba1\u7406", CrmConstants.DEMAND_SENDMESSAGE, title, content, CrmConstants.APP_DEMAND_DETAIL, pcUrl, list, type, typeDesc);
        } else if ("testFail".equals(subentity.getEnabledMark()) && !ObjectUtil.isEmpty((Object)subentity.getPersonInCharge()) && !"true".equals(autoSave)) {
            list.add(subentity.getCreatorUserId());
            title = "\u6709" + entity.getName() + "\u6d4b\u8bd5\u5931\u8d25";
            this.newSendMessage("\u9700\u6c42\u7ba1\u7406", CrmConstants.DEMAND_SENDMESSAGE, title, content, CrmConstants.APP_DEMAND_DETAIL, pcUrl, list, type, typeDesc);
        } else if ("reject".equals(subentity.getEnabledMark()) && !ObjectUtil.isEmpty((Object)subentity.getPersonInCharge()) && !"true".equals(autoSave)) {
            list.add(subentity.getCreatorUserId());
            title = "\u6709" + entity.getName() + "\u62d2\u7edd\u9a8c\u6536";
            this.newSendMessage("\u9700\u6c42\u7ba1\u7406", CrmConstants.DEMAND_SENDMESSAGE, title, content, CrmConstants.APP_DEMAND_DETAIL, pcUrl, list, type, typeDesc);
        } else if (!(keyList.isEmpty() || ObjectUtil.isEmpty((Object)subentity.getPersonInCharge()) || "completed".equals(subentity.getEnabledMark()) || "true".equals(autoSave))) {
            list.add(subentity.getPersonInCharge());
            list.add(subentity.getCoordinateUserId());
            title = "\u6709" + entity.getName() + "\u5f85\u60a8\u5b8c\u6210";
            this.newSendMessage("\u9700\u6c42\u7ba1\u7406", CrmConstants.DEMAND_SENDMESSAGE, title, content, CrmConstants.APP_DEMAND_DETAIL, pcUrl, list, type, typeDesc);
        }
        if (!keyList.isEmpty()) {
            if (stringBuffer.length() > 1) {
                stringBuffer = stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            String mainId = RandomUtil.uuId();
            CrmWorkitemLogsEntity crmWorkitemLogsEntity = new CrmWorkitemLogsEntity();
            crmWorkitemLogsEntity.setId(mainId);
            crmWorkitemLogsEntity.setDescription(stringBuffer.toString());
            crmWorkitemLogsEntity.setCreatorUserId(userInfo.getUserId());
            crmWorkitemLogsEntity.setCreatorTime(DateUtil.getNowDate());
            crmWorkitemLogsEntity.setWorkitemId(entity.getId());
            crmWorkitemLogsEntity.setDeleteMark(0);
            crmWorkitemLogsEntity.setOpraterType(WorkItemTypeEnum.RECORD_LOG_TYPE.getType());
            if (!StrUtil.isBlank((CharSequence)stringBuffer.toString())) {
                this.crmWorkitemLogsService.save(crmWorkitemLogsEntity);
            }
        }
        if (!keyList.isEmpty() && keyList.contains("jumpQueue") && subentity.getJumpQueue().equals("1")) {
            this.executeJumpQueue(subentity);
        }
    }

    @Override
    public List<CrmWorkitemEntity> getJumpList(String userId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ArrayList<String> list = new ArrayList<String>();
        list.add(CrmConstants.WORK_INPROGRESS);
        list.add(CrmConstants.WORK_TODO);
        queryWrapper.lambda().eq(CrmWorkitemEntity::getPersonInCharge, (Object)userId);
        queryWrapper.lambda().in(CrmWorkitemEntity::getEnabledMark, list);
        queryWrapper.lambda().eq(CrmWorkitemEntity::getJumpQueue, (Object)"1");
        return this.list((Wrapper)queryWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block64: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "personInCharge": {
                        entitys.add(new ExcelExportEntity("\u8d1f\u8d23\u4eba", (Object)"personInCharge"));
                        continue block64;
                    }
                    case "coordinateUserId": {
                        entitys.add(new ExcelExportEntity("\u914d\u5408\u4eba", (Object)"coordinateUserId"));
                        continue block64;
                    }
                    case "name": {
                        entitys.add(new ExcelExportEntity("\u4efb\u52a1\u540d\u79f0", (Object)"name"));
                        continue block64;
                    }
                    case "parentId": {
                        entitys.add(new ExcelExportEntity("\u5173\u8054\u4e0a\u7ea7\u5de5\u4f5c\u9879", (Object)"parentId"));
                        continue block64;
                    }
                    case "productId": {
                        entitys.add(new ExcelExportEntity("\u5173\u8054\u4ea7\u54c1", (Object)"productId"));
                        continue block64;
                    }
                    case "projectId": {
                        entitys.add(new ExcelExportEntity("\u5173\u8054\u9879\u76ee", (Object)"projectId"));
                        continue block64;
                    }
                    case "questionCode": {
                        entitys.add(new ExcelExportEntity("\u95ee\u9898\u7f16\u7801", (Object)"questionCode"));
                        continue block64;
                    }
                    case "type": {
                        entitys.add(new ExcelExportEntity("\u9700\u6c42\u7c7b\u578b", (Object)"type"));
                        continue block64;
                    }
                    case "bugCategory": {
                        entitys.add(new ExcelExportEntity("\u7f3a\u9677\u5206\u7c7b", (Object)"bugCategory"));
                        continue block64;
                    }
                    case "source": {
                        entitys.add(new ExcelExportEntity("\u6765\u6e90", (Object)"source"));
                        continue block64;
                    }
                    case "priority": {
                        entitys.add(new ExcelExportEntity("\u4f18\u5148\u7ea7", (Object)"priority"));
                        continue block64;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u4efb\u52a1\u72b6\u6001", (Object)"enabledMark"));
                        continue block64;
                    }
                    case "currentProductVersionName": {
                        entitys.add(new ExcelExportEntity("\u53d1\u5e03\u7248\u672c", (Object)"currentProductVersionName"));
                        continue block64;
                    }
                    case "proposeUserId": {
                        entitys.add(new ExcelExportEntity("\u63d0\u51fa\u4eba", (Object)"proposeUserId"));
                        continue block64;
                    }
                    case "proposeUserDepartment": {
                        entitys.add(new ExcelExportEntity("\u63d0\u51fa\u4eba\u90e8\u95e8", (Object)"proposeUserDepartment"));
                        continue block64;
                    }
                    case "startDate": {
                        entitys.add(new ExcelExportEntity("\u8ba1\u5212\u5f00\u59cb", (Object)"startDate"));
                        continue block64;
                    }
                    case "endDate": {
                        entitys.add(new ExcelExportEntity("\u8ba1\u5212\u5b8c\u6210", (Object)"endDate"));
                        continue block64;
                    }
                    case "workHours": {
                        entitys.add(new ExcelExportEntity("\u9884\u4f30\u5de5\u65f6", (Object)"workHours"));
                        continue block64;
                    }
                    case "actualStartDate": {
                        entitys.add(new ExcelExportEntity("\u5b9e\u9645\u5f00\u59cb\u65f6\u95f4", (Object)"actualStartDate"));
                        continue block64;
                    }
                    case "actualEndDate": {
                        entitys.add(new ExcelExportEntity("\u5b9e\u9645\u5b8c\u6210\u65f6\u95f4", (Object)"actualEndDate"));
                        continue block64;
                    }
                    case "overdueTime": {
                        entitys.add(new ExcelExportEntity("\u903e\u671f\u5929\u6570", (Object)"overdueTime"));
                        continue block64;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u4efb\u52a1\u63cf\u8ff0", (Object)"description"));
                        continue block64;
                    }
                    case "evaluateGrade": {
                        entitys.add(new ExcelExportEntity("\u8bc4\u4ef7\u7b49\u7ea7", (Object)"evaluateGrade"));
                        continue block64;
                    }
                    case "evaluateDescription": {
                        entitys.add(new ExcelExportEntity("\u8bc4\u4ef7\u63cf\u8ff0", (Object)"evaluateDescription"));
                        continue block64;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u4eba", (Object)"creatorUserId"));
                        continue block64;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block64;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u5de5\u4f5c\u9879" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Throwable)e);
            e.printStackTrace();
        }
        return vo;
    }

    @Override
    public void newSendMessage(String tsakCode, String sendCode, String title, String content, String url, String PCurl, List<String> toUserIds, String termType, String typeDesc) {
        try {
            TaskMsg taskMsg = new TaskMsg();
            taskMsg.setTaskCode(tsakCode);
            taskMsg.setSendCode(sendCode);
            String messageTime = DateUtil.dateFormat((Date)new Date());
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            parameterMap.put("title", title);
            parameterMap.put("content", content);
            parameterMap.put("MessageTime", messageTime);
            LinkMsgKeys linkMsgKeys = new LinkMsgKeys();
            linkMsgKeys.setLinkUrl("");
            linkMsgKeys.setKeys(parameterMap);
            taskMsg.setBusinessKey((BusinessKeys)linkMsgKeys);
            CustomKeysLink customKeysLink = new CustomKeysLink();
            customKeysLink.setTermType(termType);
            customKeysLink.setTermTypeDesc(typeDesc);
            customKeysLink.setPcUrl(PCurl);
            customKeysLink.setAppUrl(url);
            taskMsg.setCustomKey(customKeysLink);
            taskMsg.setToUserIds(String.join((CharSequence)",", toUserIds));
            this.sendTaskMsgUtils.sendTaskMsg(taskMsg);
        }
        catch (Exception e) {
            this.log.error("\u53d1\u6d88\u606f\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    @Override
    public CrmWorkitemEntity insert(CrmWorkitemCrForm crmWorkitemCrForm) {
        CrmProductCategoryEntity categoryEntity;
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        CrmWorkitemEntity entity = (CrmWorkitemEntity)JsonUtil.getJsonToBean((Object)crmWorkitemCrForm, CrmWorkitemEntity.class);
        entity.setId(mainId);
        entity.setParentId(StrUtil.isBlank((CharSequence)entity.getParentId()) ? "-1" : entity.getParentId());
        entity.setUserCompanyId(userInfo.getOrganizeId());
        CrmProductEntity info = this.crmProductService.getInfo(entity.getProductId());
        if (ObjectUtil.isNotEmpty((Object)info) && ObjectUtil.isNotEmpty((Object)(categoryEntity = this.crmProductCategoryService.getInfo(info.getCategoryId())))) {
            entity.setProductCompanyId(categoryEntity.getParentId());
        }
        entity.setCreatorUserId(userInfo.getUserId());
        entity.setCreatorTime(DateUtil.getNowDate());
        if ("inprogress".equals(entity.getEnabledMark())) {
            entity.setActualStartDate(DateUtil.getNowDate());
        }
        if (!ObjectUtil.isEmpty((Object)entity.getPersonInCharge())) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(entity.getPersonInCharge());
            list.add(entity.getCoordinateUserId());
            if (!"true".equals(crmWorkitemCrForm.getAutoSave())) {
                String title = "\u6709" + entity.getName() + "\u5f85\u60a8\u5b8c\u6210";
                String content = "\u6807\u9898\uff1a" + entity.getName();
                String pcUrl = CrmConstants.PC_DEMAND_DETAIL + entity.getId();
                String type = TermTypeEnum.TERM_PC.getCode();
                String typeDesc = "\u8bf7\u7528pc\u7aef\u6253\u5f00\u94fe\u63a5\uff0c\u8fdb\u884c\u4fe1\u606f\u786e\u8ba4";
                this.crmWorkitemService.newSendMessage("\u9700\u6c42\u7ba1\u7406", CrmConstants.DEMAND_SENDMESSAGE, title, content, CrmConstants.APP_DEMAND_DETAIL, pcUrl, list, type, typeDesc);
            }
        }
        CrmWorkitemLogsEntity crmWorkitemLogsEntity = new CrmWorkitemLogsEntity();
        crmWorkitemLogsEntity.setId(mainId);
        crmWorkitemLogsEntity.setDescription(userInfo.getUserName() + "\u521b\u5efa\u4efb\u52a1");
        crmWorkitemLogsEntity.setCreatorUserId(userInfo.getUserId());
        crmWorkitemLogsEntity.setCreatorTime(DateUtil.getNowDate());
        crmWorkitemLogsEntity.setWorkitemId(entity.getId());
        crmWorkitemLogsEntity.setDeleteMark(0);
        this.crmWorkitemLogsService.save(crmWorkitemLogsEntity);
        this.crmWorkitemService.save(entity);
        return entity;
    }

    @Override
    public String updateHandle(String id, CrmWorkitemUpForm crmWorkitemUpForm) throws Exception {
        CrmWorkitemEntity entity = this.crmWorkitemService.getInfo(id);
        if (entity != null) {
            RkProjectQuestionEntity questionEntity;
            CrmProductUserEntity productUserEntity;
            CrmWorkitemEntity subentity = (CrmWorkitemEntity)JsonUtil.getJsonToBean((Object)crmWorkitemUpForm, CrmWorkitemEntity.class);
            Map<String, String> compare = ObjectComparator.compare(entity, subentity);
            ArrayList keyList = new ArrayList();
            if (ObjectUtil.isNotEmpty(compare)) {
                compare.keySet().stream().forEach(key -> keyList.add(key));
            }
            if (keyList.contains("jumpQueue") && !entity.getJumpQueue().equals("1") && !StrUtil.isBlank((CharSequence)subentity.getJumpQueue()) && subentity.getJumpQueue().equals("1")) {
                List<CrmWorkitemEntity> jumpList = this.crmWorkitemService.getJumpList(entity.getPersonInCharge());
                jumpList.remove(entity);
                if (jumpList.size() > 0) {
                    return "duplication";
                }
            }
            if (keyList.contains("enabledMark")) {
                if (StrUtil.equals((CharSequence)WorkItemTypeEnum.TASK_MANAGEMENT_TYPE_TODO.getType(), (CharSequence)entity.getEnabledMark()) && StrUtil.equals((CharSequence)WorkItemTypeEnum.TASK_MANAGEMENT_TYPE_INPROGRESS.getType(), (CharSequence)subentity.getEnabledMark())) {
                    subentity.setActualStartDate(DateUtil.getNowDate());
                }
                if (StrUtil.equals((CharSequence)WorkItemTypeEnum.TASK_MANAGEMENT_TYPE_INPROGRESS.getType(), (CharSequence)entity.getEnabledMark()) && (StrUtil.equals((CharSequence)WorkItemTypeEnum.TASK_MANAGEMENT_TYPE_COMPLETED.getType(), (CharSequence)subentity.getEnabledMark()) || StrUtil.equals((CharSequence)WorkItemTypeEnum.TASK_MANAGEMENT_TYPE_WAITINGCHECK.getType(), (CharSequence)subentity.getEnabledMark()))) {
                    subentity.setActualEndDate(DateUtil.getNowDate());
                    this.setEntityOverdueTime(entity, subentity);
                }
                if (StrUtil.equals((CharSequence)WorkItemTypeEnum.TASK_MANAGEMENT_TYPE_TODO.getType(), (CharSequence)entity.getEnabledMark()) && StrUtil.equals((CharSequence)WorkItemTypeEnum.TASK_MANAGEMENT_TYPE_COMPLETED.getType(), (CharSequence)subentity.getEnabledMark())) {
                    subentity.setActualStartDate(DateUtil.getNowDate());
                    subentity.setActualEndDate(DateUtil.getNowDate());
                    this.setEntityOverdueTime(entity, subentity);
                }
                if (!StrUtil.equals((CharSequence)"accepted", (CharSequence)entity.getEnabledMark()) && StrUtil.equals((CharSequence)"accepted", (CharSequence)subentity.getEnabledMark())) {
                    subentity.setActualStartDate(ObjectUtil.isNotEmpty((Object)subentity.getActualStartDate()) ? subentity.getActualStartDate() : DateUtil.getNowDate());
                    subentity.setActualEndDate(ObjectUtil.isNotEmpty((Object)subentity.getActualEndDate()) ? subentity.getActualEndDate() : DateUtil.getNowDate());
                }
                if (!StrUtil.equals((CharSequence)"reject", (CharSequence)entity.getEnabledMark()) && StrUtil.equals((CharSequence)"reject", (CharSequence)subentity.getEnabledMark())) {
                    subentity.setActualStartDate(ObjectUtil.isNotEmpty((Object)subentity.getActualStartDate()) ? subentity.getActualStartDate() : DateUtil.getNowDate());
                    subentity.setActualEndDate(ObjectUtil.isNotEmpty((Object)subentity.getActualEndDate()) ? subentity.getActualEndDate() : DateUtil.getNowDate());
                }
                if (!StrUtil.equals((CharSequence)"closed", (CharSequence)entity.getEnabledMark()) && StrUtil.equals((CharSequence)"closed", (CharSequence)subentity.getEnabledMark())) {
                    subentity.setActualStartDate(ObjectUtil.isNotEmpty((Object)subentity.getActualStartDate()) ? subentity.getActualStartDate() : DateUtil.getNowDate());
                    subentity.setActualEndDate(ObjectUtil.isNotEmpty((Object)subentity.getActualEndDate()) ? subentity.getActualEndDate() : DateUtil.getNowDate());
                }
            } else if ((keyList.contains("startDate") || keyList.contains("endDate")) && ObjectUtil.isNotEmpty((Object)subentity.getActualEndDate())) {
                int workDays = DateUtil.getWorkDays((Date)subentity.getEndDate(), (Date)subentity.getActualEndDate());
                subentity.setOverdueTime(workDays > 0 ? String.valueOf(workDays - 1) : "0");
            }
            if (keyList.contains("productId") && ObjectUtil.isNotEmpty((Object)(productUserEntity = this.crmProductUserService.getByProductId(subentity.getProductId())))) {
                subentity.setExploitHead(productUserEntity.getExploitHead());
                subentity.setTestHead(productUserEntity.getTestHead());
                subentity.setProductHead(productUserEntity.getProductManager());
            }
            this.crmWorkitemService.recordUpdateLog(entity, subentity, crmWorkitemUpForm.getAutoSave());
            this.crmWorkitemService.update(id, subentity);
            AfterSalesQuestionEntity afterSalesQuestion = this.afterSalesQuestionService.getInfo(entity.getAfterSalesQuestionId());
            if (ObjectUtil.isNotEmpty((Object)afterSalesQuestion)) {
                if (subentity.getEnabledMark().equals("accepted")) {
                    afterSalesQuestion.setEnabledMark("resolved");
                    afterSalesQuestion.setDevelopState(subentity.getEnabledMark());
                    afterSalesQuestion.setDealUser(subentity.getPersonInCharge());
                    afterSalesQuestion.setDealTime(com.bringspring.contract.utils.DateUtils.getNowDate());
                } else {
                    afterSalesQuestion.setDevelopState(subentity.getEnabledMark());
                }
                this.afterSalesQuestionService.updateById(afterSalesQuestion);
            }
            if (ObjectUtil.isNotEmpty((Object)(questionEntity = this.rkProjectQuestionService.getInfo(entity.getProjectQuestionId())))) {
                questionEntity.setProductVersionId(!StrUtil.isBlank((CharSequence)subentity.getEffectProductVersionId()) ? subentity.getEffectProductVersionId() : "");
                questionEntity.setProductVersionName(!StrUtil.isBlank((CharSequence)subentity.getEffectProductVersionName()) ? subentity.getEffectProductVersionName() : "");
                questionEntity.setReleaseVersion(!StrUtil.isBlank((CharSequence)subentity.getCurrentProductVersionName()) ? subentity.getCurrentProductVersionName() : "");
                if (subentity.getEnabledMark().equals("accepted")) {
                    questionEntity.setState("beenAccepted");
                    questionEntity.setDevelopState(subentity.getEnabledMark());
                    questionEntity.setDealTime(com.bringspring.contract.utils.DateUtils.getNowDate());
                } else {
                    questionEntity.setDevelopState(subentity.getEnabledMark());
                }
                questionEntity.setProcessedUser(subentity.getPersonInCharge());
                questionEntity.setDealUser(subentity.getAcceptanceUserId());
                this.rkProjectQuestionService.updateById(questionEntity);
                CreateChatInfo chatInfo = new CreateChatInfo();
                RkContractProjectEntity info = this.rkContractProjectService.getInfo(questionEntity.getProjectId());
                if (ObjectUtil.isNotEmpty((Object)info) && StrUtil.isNotEmpty((CharSequence)info.getProjectCreateChatId())) {
                    chatInfo.setChatid(info.getProjectCreateChatId());
                    ArrayList<String> addUserList = new ArrayList<String>();
                    if (!entity.getPersonInCharge().equals(subentity.getPersonInCharge())) {
                        addUserList.add(subentity.getPersonInCharge());
                    }
                    if (!entity.getAcceptanceUserId().equals(subentity.getAcceptanceUserId())) {
                        addUserList.add(subentity.getAcceptanceUserId());
                    }
                    chatInfo.setAddUserList(addUserList);
                    if (CollectionUtil.isNotEmpty(addUserList)) {
                        QuestionTimeUtil.updateCreateChat(chatInfo);
                    }
                    if (!entity.getEnabledMark().equals(subentity.getEnabledMark())) {
                        String title = "";
                        title = subentity.getName().length() > 18 ? subentity.getName().substring(0, 16) : subentity.getName();
                        chatInfo.setTitle(title);
                        chatInfo.setDescription("\u8d1f\u8d23\u4eba\uff1a" + this.baseDataUtil.userSelectValue(subentity.getPersonInCharge()) + "\n\u9a8c\u6536\u4eba\uff1a" + this.baseDataUtil.userSelectValue(subentity.getAcceptanceUserId()) + "\n\u66f4\u6539\u72b6\u6001\u4e3a\uff1a" + this.baseDataUtil.getDictName(subentity.getEnabledMark(), "demandMark") + "\n\u521b\u5efa\u65f6\u95f4\uff1a" + com.bringspring.contract.utils.DateUtils.dateFormat(subentity.getCreatorTime()));
                        String url = this.sysConfigService.getSystemAddress("pc") + CrmConstants.PC_DEMAND_DETAIL + id;
                        chatInfo.setUrl(url);
                        chatInfo.setBtnTxt("\u66f4\u591a");
                        QuestionTimeUtil.sendMessage(chatInfo);
                    }
                }
            }
            return "true";
        }
        return "false";
    }

    @Override
    public List<CrmWorkitemEntity> getRelationWorkItemList(String workId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        CrmWorkitemEntity info = this.getInfo(workId);
        if (StrUtil.isBlank((CharSequence)info.getParentId()) || StrUtil.equals((CharSequence)info.getParentId(), (CharSequence)"-1")) {
            queryWrapper.lambda().eq(CrmWorkitemEntity::getParentId, (Object)workId);
        } else {
            queryWrapper.lambda().eq(CrmWorkitemEntity::getId, (Object)info.getParentId());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<CrmWorkitemListVO> getAllRelationWorkItemList(String workId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        CrmWorkitemEntity info = this.getInfo(workId);
        List<CrmWorkitemListVO> planListByParentId = this.getPlanListByParentId(workId, 1);
        if (StrUtil.isBlank((CharSequence)info.getParentId()) && StrUtil.equals((CharSequence)info.getParentId(), (CharSequence)"-1")) {
            queryWrapper.lambda().eq(CrmWorkitemEntity::getParentId, (Object)workId);
        }
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty(planListByParentId)) {
            List crmWorkitemEntities = JsonUtil.getJsonToList(planListByParentId, CrmWorkitemEntity.class);
            list.addAll(crmWorkitemEntities);
        }
        return planListByParentId;
    }

    @Override
    public void updateMasterFile(String workId, String filePath) {
        QueryWrapper crmWorkitemLogsQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)crmWorkitemLogsQueryWrapper.lambda().eq(CrmWorkitemLogsEntity::getWorkitemId, (Object)workId)).eq(CrmWorkitemLogsEntity::getOpraterType, (Object)WorkItemTypeEnum.FILE_WORK_TYPE.getType());
        CrmWorkitemLogsEntity crmWorkitemLogs = (CrmWorkitemLogsEntity)this.crmWorkitemLogsService.getOne((Wrapper)crmWorkitemLogsQueryWrapper);
        crmWorkitemLogs.setFilePath(filePath);
        crmWorkitemLogs.setCreatorUserId(this.userProvider.get().getUserId());
        crmWorkitemLogs.setCreatorTime(new Date());
        this.crmWorkitemLogsService.updateById(crmWorkitemLogs);
    }

    @Override
    public void deleteMasterFile(String workId) {
        QueryWrapper crmWorkitemLogsQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)crmWorkitemLogsQueryWrapper.lambda().eq(CrmWorkitemLogsEntity::getWorkitemId, (Object)workId)).eq(CrmWorkitemLogsEntity::getOpraterType, (Object)WorkItemTypeEnum.FILE_WORK_TYPE.getType());
        this.crmWorkitemLogsService.remove((Wrapper)crmWorkitemLogsQueryWrapper);
    }

    @Override
    public List<Object> getWorkItemUserList(String workId) {
        CrmWorkitemEntity info = this.getInfo(workId);
        ArrayList<Object> userList = new ArrayList();
        if (!StrUtil.isBlank((CharSequence)info.getPersonInCharge())) {
            HashMap<String, String> personInChargeMap = new HashMap<String, String>();
            personInChargeMap.put("id", info.getPersonInCharge());
            personInChargeMap.put("name", this.baseDataUtil.userSelectValue(info.getPersonInCharge()));
            personInChargeMap.put("role", "\u8d1f\u8d23\u4eba");
            userList.add(personInChargeMap);
        }
        if (!StrUtil.isBlank((CharSequence)info.getAcceptanceUserId())) {
            HashMap<String, String> acceptanceUserIdMap = new HashMap<String, String>();
            acceptanceUserIdMap.put("id", info.getAcceptanceUserId());
            acceptanceUserIdMap.put("name", this.baseDataUtil.userSelectValue(info.getAcceptanceUserId()));
            acceptanceUserIdMap.put("role", "\u9a8c\u6536\u4eba");
            userList.add(acceptanceUserIdMap);
        }
        if (!StrUtil.isBlank((CharSequence)info.getCoordinateUserId())) {
            HashMap<String, String> coordinateUserIdMap = new HashMap<String, String>();
            coordinateUserIdMap.put("id", info.getCoordinateUserId());
            coordinateUserIdMap.put("name", this.baseDataUtil.userSelectValue(info.getCoordinateUserId()));
            coordinateUserIdMap.put("role", "\u914d\u5408\u4eba");
            userList.add(coordinateUserIdMap);
        }
        if (!StrUtil.isBlank((CharSequence)info.getProposeUserId())) {
            HashMap<String, String> proposeUserIdIdMap = new HashMap<String, String>();
            proposeUserIdIdMap.put("id", info.getProposeUserId());
            proposeUserIdIdMap.put("name", this.baseDataUtil.userSelectValue(info.getProposeUserId()));
            proposeUserIdIdMap.put("role", "\u63d0\u51fa\u4eba");
            userList.add(proposeUserIdIdMap);
        }
        if (!StrUtil.isBlank((CharSequence)info.getExploitHead())) {
            HashMap<String, String> exploitHeadMap = new HashMap<String, String>();
            exploitHeadMap.put("id", info.getExploitHead());
            exploitHeadMap.put("name", this.baseDataUtil.userSelectValue(info.getExploitHead()));
            exploitHeadMap.put("role", "\u7814\u53d1\u8d1f\u8d23\u4eba");
            userList.add(exploitHeadMap);
        }
        if (!StrUtil.isBlank((CharSequence)info.getTestHead())) {
            HashMap<String, String> testHeadMap = new HashMap<String, String>();
            testHeadMap.put("id", info.getTestHead());
            testHeadMap.put("name", this.baseDataUtil.userSelectValue(info.getTestHead()));
            testHeadMap.put("role", "\u6d4b\u8bd5\u8d1f\u8d23\u4eba");
            userList.add(testHeadMap);
        }
        if (!StrUtil.isBlank((CharSequence)info.getProductHead())) {
            HashMap<String, String> productHeadMap = new HashMap<String, String>();
            productHeadMap.put("id", info.getProductHead());
            productHeadMap.put("name", this.baseDataUtil.userSelectValue(info.getProductHead()));
            productHeadMap.put("role", "\u4ea7\u54c1\u8d1f\u8d23\u4eba");
            userList.add(productHeadMap);
        }
        userList = userList.stream().distinct().collect(Collectors.toList());
        return userList;
    }

    @Override
    public CrmWorkitemEntity getAfterSalesQuestionId(String id) {
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        objectQueryWrapper.lambda().eq(CrmWorkitemEntity::getAfterSalesQuestionId, (Object)id);
        CrmWorkitemEntity crmWorkitemEntity = (CrmWorkitemEntity)this.getOne((Wrapper)objectQueryWrapper);
        if (ObjectUtil.isNotEmpty((Object)crmWorkitemEntity)) {
            return crmWorkitemEntity;
        }
        return null;
    }

    @Override
    public CrmWorkitemEntity getProjectQuestionId(String id) {
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        objectQueryWrapper.lambda().eq(CrmWorkitemEntity::getProjectQuestionId, (Object)id);
        CrmWorkitemEntity crmWorkitemEntity = (CrmWorkitemEntity)this.getOne((Wrapper)objectQueryWrapper);
        if (ObjectUtil.isNotEmpty((Object)crmWorkitemEntity)) {
            return crmWorkitemEntity;
        }
        return null;
    }

    private void setEntityOverdueTime(CrmWorkitemEntity entity, CrmWorkitemEntity subentity) {
        if (ObjectUtil.isEmpty((Object)entity.getEndDate())) {
            return;
        }
        int workDays = DateUtil.getWorkDays((Date)entity.getEndDate(), (Date)DateUtil.getNowDate());
        if (workDays > 0) {
            subentity.setOverdueTime(String.valueOf(workDays - 1));
        }
    }

    private Consumer<QueryWrapper<CrmWorkitemEntity>> defaultWrapper() {
        final String userId = this.userProvider.get().getUserId();
        return new Consumer<QueryWrapper<CrmWorkitemEntity>>(){

            @Override
            public void accept(QueryWrapper<CrmWorkitemEntity> crmWorkitemEntityQueryWrapper) {
                crmWorkitemEntityQueryWrapper.lambda().and(x -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)x.eq(CrmWorkitemEntity::getPersonInCharge, (Object)userId)).or()).eq(CrmWorkitemEntity::getCoordinateUserId, (Object)userId)).or()).eq(CrmWorkitemEntity::getAcceptanceUserId, (Object)userId)).or()).eq(CrmWorkitemEntity::getCreatorUserId, (Object)userId)).or()).eq(CrmWorkitemEntity::getExploitHead, (Object)userId)).or()).eq(CrmWorkitemEntity::getTestHead, (Object)userId)).or()).eq(CrmWorkitemEntity::getProductHead, (Object)userId));
            }
        };
    }

    @Override
    public List<CrmWorkitemListVO> getParentChildList(CrmWorkitemPagination crmWorkitemPagination) {
        List<CrmWorkitemEntity> list = this.getList(crmWorkitemPagination);
        List listVO = JsonUtil.getJsonToList(list, CrmWorkitemListVO.class);
        for (CrmWorkitemListVO otMeetingGroupListVO : listVO) {
            otMeetingGroupListVO.setDataLevel(1);
            this.setDataAttributes(otMeetingGroupListVO);
            List<CrmWorkitemListVO> planListByParentId = this.getPlanListByParentId(otMeetingGroupListVO.getId(), 1);
            List childList = JsonUtil.getJsonToList(planListByParentId, CrmWorkitemListVO.class);
            if (!ObjectUtil.isNotEmpty((Object)childList)) continue;
            for (CrmWorkitemListVO infoVO : childList) {
                this.setDataAttributes(infoVO);
                infoVO.setDataLevel(2);
                if (CollectionUtil.isNotEmpty(infoVO.getChildren())) {
                    infoVO.getChildren().stream().forEach(i -> {
                        this.setDataAttributes((CrmWorkitemListVO)i);
                        i.setIsChild(true);
                        i.setDataLevel(3);
                    });
                    continue;
                }
                infoVO.setIsChild(true);
            }
            otMeetingGroupListVO.setChildren(childList);
        }
        return listVO;
    }

    public void setDataAttributes(CrmWorkitemListVO infoVO) {
        infoVO.setPersonInChargeName(this.baseDataUtil.userSelectValue(infoVO.getPersonInCharge()));
        infoVO.setCreatorUserName(this.baseDataUtil.userSelectValue(infoVO.getCreatorUserId()));
        infoVO.setPersonInChargeDepartmentName(this.baseDataUtil.comSelectValues(infoVO.getPersonInChargeDepartment()));
    }

    @Override
    public List<CrmWorkitemListVO> getPlanListByParentId(String parentId, Integer index) {
        QueryWrapper otMeetingGroupQueryWrapper = new QueryWrapper();
        otMeetingGroupQueryWrapper.lambda().eq(CrmWorkitemEntity::getParentId, (Object)parentId);
        otMeetingGroupQueryWrapper.lambda().orderByDesc(CrmWorkitemEntity::getCreatorTime);
        List list = this.list((Wrapper)otMeetingGroupQueryWrapper);
        List listVOS = JsonUtil.getJsonToList((Object)list, CrmWorkitemListVO.class);
        Integer n = index;
        Integer n2 = index = Integer.valueOf(index + 1);
        for (CrmWorkitemListVO plan : listVOS) {
            List<CrmWorkitemListVO> children = this.getPlanListByParentId(plan.getId(), index);
            if (!children.isEmpty()) {
                plan.setChildren(children);
                continue;
            }
            plan.setIsChild(true);
        }
        return listVOS;
    }
}

