/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web;

import com.fasterxml.classmate.ResolvedType;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.ConsumesRequestCondition;
import org.springframework.web.servlet.mvc.condition.HeadersRequestCondition;
import org.springframework.web.servlet.mvc.condition.ParamsRequestCondition;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.ProducesRequestCondition;
import springfox.documentation.RequestHandler;
import springfox.documentation.RequestHandlerKey;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spring.web.ControllerNamingUtils;
import springfox.documentation.spring.web.WebMvcNameValueExpressionWrapper;
import springfox.documentation.spring.web.WebMvcPatternsRequestConditionWrapper;
import springfox.documentation.spring.web.WebMvcRequestMappingInfoWrapper;
import springfox.documentation.spring.web.readers.operation.HandlerMethodResolver;
import springfox.documentation.spring.wrapper.NameValueExpression;
import springfox.documentation.spring.wrapper.RequestMappingInfo;

public class WebMvcRequestHandler
implements RequestHandler {
    private final String contextPath;
    private final HandlerMethodResolver methodResolver;
    private final org.springframework.web.servlet.mvc.method.RequestMappingInfo requestMapping;
    private final HandlerMethod handlerMethod;
    private static final PatternsRequestCondition EMPTY_PATTERNS = new PatternsRequestCondition(new String[0]);
    private static final ParamsRequestCondition EMPTY_PARAMS = new ParamsRequestCondition(new String[0]);
    private static final HeadersRequestCondition EMPTY_HEADERS = new HeadersRequestCondition(new String[0]);
    private static final ConsumesRequestCondition EMPTY_CONSUMES = new ConsumesRequestCondition(new String[0]);
    private static final ProducesRequestCondition EMPTY_PRODUCES = new ProducesRequestCondition(new String[0]);

    public WebMvcRequestHandler(String contextPath, HandlerMethodResolver methodResolver, org.springframework.web.servlet.mvc.method.RequestMappingInfo requestMapping, HandlerMethod handlerMethod) {
        this.contextPath = contextPath;
        this.methodResolver = methodResolver;
        this.requestMapping = requestMapping;
        this.handlerMethod = handlerMethod;
    }

    @Override
    public HandlerMethod getHandlerMethod() {
        return this.handlerMethod;
    }

    @Override
    public RequestHandler combine(RequestHandler other) {
        return this;
    }

    @Override
    public Class<?> declaringClass() {
        return this.handlerMethod.getBeanType();
    }

    @Override
    public boolean isAnnotatedWith(Class<? extends Annotation> annotation) {
        return null != AnnotationUtils.findAnnotation(this.handlerMethod.getMethod(), annotation);
    }

    @Override
    public springfox.documentation.spring.wrapper.PatternsRequestCondition getPatternsCondition() {
        PatternsRequestCondition contition = this.requestMapping.getPatternsCondition();
        if (contition == null) {
            contition = new PatternsRequestCondition(this.requestMapping.getPathPatternsCondition().getPatterns().stream().map(p -> p.getPatternString()).collect(Collectors.toList()).toArray(new String[0]));
        }
        return new WebMvcPatternsRequestConditionWrapper(this.contextPath, contition);
    }

    @Override
    public String groupName() {
        return ControllerNamingUtils.controllerNameAsGroup(this.handlerMethod);
    }

    @Override
    public String getName() {
        return this.handlerMethod.getMethod().getName();
    }

    @Override
    public Set<RequestMethod> supportedMethods() {
        return this.requestMapping.getMethodsCondition().getMethods();
    }

    public Set<MediaType> produces() {
        return Optional.ofNullable(this.requestMapping.getProducesCondition()).orElseGet(() -> EMPTY_PRODUCES).getProducibleMediaTypes();
    }

    public Set<MediaType> consumes() {
        return Optional.ofNullable(this.requestMapping.getConsumesCondition()).orElseGet(() -> EMPTY_CONSUMES).getConsumableMediaTypes();
    }

    @Override
    public Set<NameValueExpression<String>> headers() {
        return WebMvcNameValueExpressionWrapper.from(Optional.ofNullable(this.requestMapping.getHeadersCondition()).orElseGet(() -> EMPTY_HEADERS).getExpressions());
    }

    @Override
    public Set<NameValueExpression<String>> params() {
        return WebMvcNameValueExpressionWrapper.from(Optional.ofNullable(this.requestMapping.getParamsCondition()).orElseGet(() -> EMPTY_PARAMS).getExpressions());
    }

    @Override
    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotation) {
        return Optional.ofNullable(AnnotationUtils.findAnnotation(this.handlerMethod.getMethod(), annotation));
    }

    @Override
    public RequestHandlerKey key() {
        return new RequestHandlerKey(Optional.ofNullable(this.requestMapping.getPatternsCondition()).orElseGet(() -> EMPTY_PATTERNS).getPatterns(), this.requestMapping.getMethodsCondition().getMethods(), Optional.ofNullable(this.requestMapping.getConsumesCondition()).orElseGet(() -> EMPTY_CONSUMES).getConsumableMediaTypes(), Optional.ofNullable(this.requestMapping.getProducesCondition()).orElseGet(() -> EMPTY_PRODUCES).getProducibleMediaTypes());
    }

    @Override
    public RequestMappingInfo<?> getRequestMapping() {
        return new WebMvcRequestMappingInfoWrapper(this.requestMapping);
    }

    @Override
    public List<ResolvedMethodParameter> getParameters() {
        return this.methodResolver.methodParameters(this.handlerMethod);
    }

    @Override
    public ResolvedType getReturnType() {
        return this.methodResolver.methodReturnType(this.handlerMethod);
    }

    @Override
    public <T extends Annotation> Optional<T> findControllerAnnotation(Class<T> annotation) {
        return Optional.ofNullable(AnnotationUtils.findAnnotation(this.handlerMethod.getBeanType(), annotation));
    }

    public String toString() {
        return new StringJoiner(", ", WebMvcRequestHandler.class.getSimpleName() + "{", "}").add("requestMapping=" + this.requestMapping).add("handlerMethod=" + this.handlerMethod).add("key=" + this.key()).toString();
    }
}

