# jsbos-boot
测试
> 特别说明：源码、JDK、MySQL、Redis等存放路径禁止包含中文、空格、特殊字符等

## 环境要求

> 官方建议：   JDK版本不低于 `1.8.0_281`版本，可使用`OpenJDK 8`、`Alibaba Dragonwell 8`、`BiShengJDK 8`

项目  | 推荐版本                              | 说明
-----|-----------------------------------| -------------
JDK  | 1.8.0_281            | JAVA环境依赖(需配置环境变量)
Maven  | 3.6.3                             | 项目构建(需配置环境变量)
Redis  | 3.2.100(Windows)/6.0.x(Linux,Mac) |
MySQL  | 5.7.x+                            | 数据库任选一(默认)
SQLServer  | 2012+                             | 数据库任选一
Oracle  | 11g+                              | 数据库任选一
PostgreSQL  | 12+                               | 数据库任选一
达梦数据库 | DM8                               | 数据库任选一
人大金库 | KingbaseES V8 R6                  | 数据库任选一

## 工具推荐
> 为防止无法正常下载Maven以来，请使用以下IDE版本

IDEA版本  | Maven版本
-----|-------- | 
IDEA2020及以上版本  | Maven 3.6.3及以上版本 |

## IDEA插件

- `Lombok`
- `Alibaba Java Coding Guidelines`
- `MybatisX`

## Maven私服配置

> 通过私服下载依赖完成后，由于IDEA的缓存可能会出现部分报红，重启IDEA即可

#### Maven私服与阿里云Maven私服、Maven官方的包区别

- com.sqlserver:sqljdbc4:4.0
- com.oracle:ojdbc6:11.2.0
- com.dm:DmJdbcDriver18:1.8.0
- com.kingbase8:kingbase8-jdbc:1.0
- dingtalk-sdk-java:taobao-sdk-java-source:1.0
- dingtalk-sdk-java:taobao-sdk-java:1.0
- yozo:signclient:3.0.1

#### 目录介绍

  后端工程
- jsbos-common 工具包模块
- jsobs-system 系统基础功能模块
- jsobs-oauth 登陆授权模块
- jsobs-visualdev 可视化开发模块
- jsobs-workflow 工作流模块
- jsobs-file 文件上传下载模块
- jsobs-app app相关数据模块
- jsobs-daap 聚合分析模块
- jsobs-extend 扩展应用模块
- jsobs-example 样例工程模块
- jsobs-datareport 数据报表项目
- jsobs-admin web应用
  前端工程
- jsobs-web 样例工程
- jsobs-web-app 样例工程

## 环境配置
- 打开`jsbos-admin/src/main/resources/application.yml`

> 环境变量
> - dev  开发环境
> - test  测试环境
> - preview 预发布环境
> - pro 生产环境
