#!/bin/bash
#这里可替换为你自己的执行程序，其他代码无需更改
PROJECT_NAME=jsbos-logistics-1.0.0-RELEASE
APP_NAME=$PROJECT_NAME.jar
#这里默认获取的是脚本的上级目录
APP_PATH=$(cd $(dirname $(readlink -f $0));cd ..; pwd)

echo "项目根目录：${APP_PATH}"

APP_LOG_PATH=$APP_PATH/logs
APP_LOG_NAME=$PROJECT_NAME.log
 #JVM参数
JVM_OPTS="-Dname=$PROJECT_NAME 
-Dspring.profiles.active=pro
-Dspring.config.additional-location=$APP_PATH/config/application.yml
-Dspring.config.additional-location=$APP_PATH/config/application-pro.yml
-Duser.timezone=Asia/Shanghai -Xms256M -Xmx512M -XX:PermSize=256M -XX:MaxPermSize=512M"

echo "项目根目录：${JVM_OPTS}"
#使用说明，用来提示输入参数
usage() {
    echo "Usage: sh server.sh [start|stop|restart|status]"
    exit 1
}
 
#检查程序是否在运行
is_exist(){
  pid=`ps -ef|grep $APP_NAME|grep -v grep|awk '{print $2}' `
  #如果不存在返回1，存在返回0     
  if [ -z "${pid}" ]; then
   return 1
  else
    return 0
  fi
}
 
#启动方法
start(){
  is_exist
  if [ $? -eq "0" ]; then
    echo "${APP_NAME} is already running. pid=${pid} ."
  else
    rm -rf nohup.out
    nohup java -jar $JVM_OPTS $APP_PATH/$APP_NAME > ${APP_LOG_PATH}/nohup.out 2>&1  &
    echo "${APP_NAME} start success"
    #tail -f nohup.out
    #rm -rf nohup.out
    #echo "delete nohup.out"
  fi
}
 
#停止方法
stop(){
  is_exist
  if [ $? -eq "0" ]; then
    kill -9 $pid
    echo "${APP_NAME} is stop"
  else
    echo "${APP_NAME} is not running"
  fi  
}
 
#输出运行状态
status(){
  is_exist
  if [ $? -eq "0" ]; then
    echo "${APP_NAME} is running. Pid is ${pid}"
  else
    echo "${APP_NAME} is NOT running."
  fi
}
 
#重启
restart(){
  stop
  start
}
 
#根据输入参数，选择执行对应方法，不输入则执行使用说明
case "$1" in
  "start")
    start
    ;;
  "stop")
    stop
    ;;
  "status")
    status
    ;;
  "restart")
    restart
    ;;
  *)
    usage
    ;;
esac