#!/bin/bash
## 根目录
BASE_DIR=$(cd "$(dirname "$0")/.."; pwd -P)

## java env 这里的java环境配置很重要，后面开机启动需要这些，不然开机启动会报错。
export JAVA_HOME=${BASE_DIR}/jdk1.8.0_391
export JRE_HOME=$JAVA_HOME/jre
export PATH=$JAVA_HOME/bin:$PATH


echo "working dir ${BASE_DIR}"

cd "${BASE_DIR}"

CLASS_PATH="${BASE_DIR}/lib/*"

START_CLASS="com.bringspring.JsbosAdminApplication"

#java -server -Xms2G -Xmx2G  -Dspring.profiles.active=config -Dfile.encoding=UTF-8 -cp "${CLASS_PATH}" com.bringspring.JsbosAdminApplication

jsbos_logistics_status(){
    #result=`ps -ef | awk '/JsbosAdminApplication/ && !/awk/{print $2}' | wc -l`
    result=`ps -ef | grep -v grep | grep "${BASE_DIR}/lib" | grep 'JsbosAdminApplication' | awk {'print $2'} | wc -l`

    if [[ $result -eq 0 ]]; then
        return 0
    else
        return 1
    fi
    }

jsbos_logistics_start(){
    source ~/.bashrc
    jsbos_logistics_status >/dev/null 2>&1
    if [[ $? -eq 0 ]]; then

        #nohup  java -server -Xms2G -Xmx2G -Dspring.profiles.active=pro -Dfile.encoding=UTF-8 -cp "${CLASS_PATH}" "${START_CLASS}" &
        nohup  java -server -Xms2G -Xmx2G -Dspring.profiles.active=pro -Dfile.encoding=UTF-8 -cp "${CLASS_PATH}" "${START_CLASS}" > ${BASE_DIR}/logs/nohup.out 2>&1  &

    else
        echo ""
        #PID=`ps -ef | awk '/JsbosAdminApplication/ && !/awk/{print $2}'`
        PID=`ps -ef | grep -v grep | grep "${BASE_DIR}/lib" | grep 'JsbosAdminApplication' | awk {'print $2'}`
        echo "jsbos_logistics is Running Now..... PID is ${PID} "
    fi
}


jsbos_logistics_stop(){
    jsbos_logistics_status >/dev/null 2>&1
    if [[ $? -eq 0 ]]; then
        echo ""
        echo "jsbos_logistics is not Running....."
        echo ""
    else
         #ps -ef | awk '/JsbosAdminApplication/ && !/awk/{print $2}'| xargs kill -9
         ps -ef | grep -v grep | grep "$BASE_DIR/lib" | grep 'JsbosAdminApplication' | awk {'print $2'} | xargs kill -9

    fi
}


case $1 in
    start )
        echo ""
        echo "jsbos_logistics Starting........... "
        echo ""
        jsbos_logistics_start
    ;;

    stop )
        echo ""

        echo "jsbos_logistics Stopping.......... "

        echo ""
        jsbos_logistics_stop
    ;;

    restart )
        echo "jsbos_logistics is Restarting.......... "
        jsbos_logistics_stop
        echo ""
        jsbos_logistics_start
        echo "jsbos_logistics is Starting.......... "

    ;;

    status )
        jsbos_logistics_status>/dev/null 2>&1
        if [[ $? -eq 0 ]]; then
            echo ""
            echo "jsbos_logistics is not Running......"
            echo ""
        else
            echo ""
            #PID=`ps -ef | awk '/JsbosAdminApplication/ && !/awk/{print $2}'`
            PID=`ps -ef | grep -v grep | grep "${BASE_DIR}/lib" | grep 'JsbosAdminApplication' | awk {'print $2'}`
            echo "jsbos_logistics is Running..... PID is ${PID}"
            echo ""
        fi
     ;;

    * )
        echo "Usage: jsbos_logistics-server.sh (start|stop|status|restart)"

esac
