/*
 Navicat Premium Data Transfer

 Source Server         : 10.70.10.63
 Source Server Type    : MySQL
 Source Server Version : 50741 (5.7.41-log)
 Source Host           : 10.70.10.63:3307
 Source Schema         : jsbos_logistics_standard

 Target Server Type    : MySQL
 Target Server Version : 50741 (5.7.41-log)
 File Encoding         : 65001

 Date: 20/08/2024 10:44:47
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for of_fixed_assets_order
-- ----------------------------
DROP TABLE IF EXISTS `of_fixed_assets_order`;
CREATE TABLE `of_fixed_assets_order`  (
  `id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `order_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '盘点单编码',
  `order_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产盘点名称',
  `order_date` datetime NULL DEFAULT NULL COMMENT '计划盘点日期',
  `order_end_date` datetime NULL DEFAULT NULL COMMENT '计划结束日期',
  `assets_sorts` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '台账分类s',
  `fixed_assets_type_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '资产类型IDs',
  `bas_space_ids` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '计划盘点空间ids',
  `assets_names` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产名称（多选）',
  `order_sdate_act` datetime NULL DEFAULT NULL COMMENT '实际盘点开始时间',
  `order_edate_act` datetime NULL DEFAULT NULL COMMENT '实际盘点结束日期',
  `base_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '盘点人',
  `order_state` int(10) NULL DEFAULT NULL COMMENT '盘点状态 0：未开始  1：进行中 9：已完成',
  `description` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `company_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属公司',
  `creator_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建用户',
  `creator_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `last_modify_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改用户',
  `last_modify_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  `delete_time` datetime NULL DEFAULT NULL COMMENT '删除时间',
  `delete_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '删除用户',
  `delete_mark` int(10) NULL DEFAULT 0 COMMENT '有效标志',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '固定资产盘点表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for of_fixed_assets_order_item
-- ----------------------------
DROP TABLE IF EXISTS `of_fixed_assets_order_item`;
CREATE TABLE `of_fixed_assets_order_item`  (
  `id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
  `fixed_assets_order_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '盘点表ID',
  `fixed_assets_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '固定资产ID',
  `fixed_assets_state` int(50) NULL DEFAULT NULL COMMENT '盘点状态：-1:待盘 0:正常 1:位置不符 8:盘盈 9:盘亏',
  `code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产编码-二维码编码（冗余）',
  `rfid_code` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'rfid编码（冗余）',
  `rfid_decode` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'rfid解码',
  `fixed_assets_type_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产类型ID',
  `base_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产使用负责人(领用人)',
  `base_user_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产领用/借用人名称',
  `base_organize_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产领用/借用部门名称',
  `is_custom_user` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '资产领用/借用人是否系统用户,Y:是;N:否;',
  `bas_space_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属空间ID（台账登记空间）',
  `bas_space_id_act` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '盘库所属空间ID（实际盘库空间）',
  `specification` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '规格型号',
  `report_state` char(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '自主盘点状态，RS01:未开始; RS02:进行中; RS03:已完成。',
  `report_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '上报人ID',
  `report_time` datetime NULL DEFAULT NULL COMMENT '上报时间',
  `report_json` json NULL COMMENT '上报确认信息',
  `files` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '附件集合json',
  `action_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '处置方式：0:无需处置 1:变更所属空间  8:录入库存  9:下库',
  `description` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `company_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属公司',
  `creator_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建用户',
  `creator_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  `last_modify_user_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '修改用户',
  `last_modify_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '固定资产盘点记录表' ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Table structure for of_fixed_assets_logs_inventory
-- ----------------------------
DROP TABLE IF EXISTS `of_fixed_assets_logs_inventory`;
CREATE TABLE `of_fixed_assets_logs_inventory`  (
  `id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键ID',
  `order_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '盘点计划ID',
  `item_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '待盘资产明细ID',
  `way` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '盘点方式(W01:PC端;W02:手机端;W03:RFID手持机;W04:自主盘点.)',
  `inventory_by_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '盘点人ID',
  `inventory_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '盘点人姓名',
  `inventory_time` datetime NULL DEFAULT NULL COMMENT '盘点时间',
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `company_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '所属公司',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '固定资产盘点日志' ROW_FORMAT = DYNAMIC;

SET FOREIGN_KEY_CHECKS = 1;
