package com.bringspring;

import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.common.listerner.JsbosListener;
import com.bringspring.common.model.task.LocalTaskModel;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.scheduletask.utils.TaskUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;


/**
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/15 17:12
 */
@Slf4j
@SpringBootApplication(scanBasePackages = "com.bringspring",exclude={DataSourceAutoConfiguration.class})
public class JsbosAdminApplication extends SpringBootServletInitializer implements CommandLineRunner {

    public static void main(String[] args) {
        SpringApplication springApplication = new SpringApplication(JsbosAdminApplication.class);
        //添加监听器
        springApplication.addListeners(new JsbosListener());
        springApplication.run(args);
        log.info("jsbosAdmin启动完成");
        TaskUtil.task();
    }
    @Autowired
    private ApplicationContext applicationContext;



    @Override
    public void run(String... args) throws Exception {
        ConcurrentHashMap concurrentHashMap = SpringContext.getBean(ConcurrentHashMap.class);
        // 获取所有加了@JsbosTask的方法
        // 获取所有的Bean
        String[] beanNames = applicationContext.getBeanDefinitionNames();
        for (String beanName : beanNames) {
            // 得到Bean信息
            Object obj = applicationContext.getBean(beanName);
            Class clz = obj.getClass();
            // 得到类中的所有方法
            Method[] methods = clz.getDeclaredMethods();
            for (Method method : methods) {
                JsbosTask annotation = method.getAnnotation(JsbosTask.class);
                if (annotation != null) {
                    // 默认id生成规则
                    String ids = clz.getName() + "." + method.getName();
                    String id = StringUtils.isNotEmpty(annotation.id()) ? annotation.id() : ids;
                    String name = annotation.fullName();
                    String description = annotation.description();
                    String cron = annotation.cron();
                    String startDate = annotation.startDate();
                    String endDate = annotation.endDate();
                    // 封装调用对象
                    LocalTaskModel model = new LocalTaskModel();
                    model.setFullName(name);
                    model.setClz(obj);
                    model.setMethodName(method.getName());
                    model.setDescription(description);
                    model.setId(id);
                    model.setJobGroupName("jsbos");
                    model.setCron(cron);
                    model.setStartDate(startDate);
                    model.setEndDate(endDate);
                    if (!concurrentHashMap.containsKey(id)) {
                        concurrentHashMap.put(id, model);
                    } else {
                        // 自定义id如果重复则使用系统默认id生成规则
                        concurrentHashMap.put(ids, model);
                    }
                }
            }
        }
    }

    @Bean
    public ConcurrentHashMap<String, LocalTaskModel> concurrentHashMap(){
        ConcurrentHashMap<String, LocalTaskModel> concurrentHashMap = new ConcurrentHashMap<>(16);
        return concurrentHashMap;
    }
}
