/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.filter;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.filter.SaFilterAuthStrategy;
import cn.dev33.satoken.filter.SaServletFilter;
import cn.dev33.satoken.router.SaRouter;
import cn.dev33.satoken.stp.StpUtil;
import cn.dev33.satoken.util.SaResult;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResultCode;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.properties.GatewayWhite;
import com.bringspring.common.properties.NotCheckLoginPathScanner;
import com.bringspring.common.util.IpUtil;
import com.bringspring.util.GatewayUtil;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
public class AuthFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthFilter.class);
    @Autowired
    private NotCheckLoginPathScanner pathScanner;
    @Autowired
    private GatewayWhite gatewayWhite;
    @Autowired
    private SaFilterAuthStrategy defaultBeforeAuthStrategy;

    @Bean
    public SaServletFilter getSaReactorFilter() {
        return new SaServletFilter().addInclude(new String[]{"/**"}).setExcludeList(this.gatewayWhite.excludeUrl).setAuth(obj -> {
            if (log.isInfoEnabled()) {
                log.info("\u8bf7\u6c42\u8def\u5f84: {}", (Object)SaHolder.getRequest().getRequestPath());
            }
            SaRouter.match((List)this.gatewayWhite.blockUrl).match(o -> {
                String ip = AuthFilter.getIpAddr();
                for (String o1 : this.gatewayWhite.whiteIp) {
                    if (!ip.startsWith(o1)) continue;
                    return false;
                }
                log.info("\u975e\u767d\u540d\u5355IP\u8bbf\u95ee\u9650\u5236\u63a5\u53e3\uff1a{}, {}", (Object)SaHolder.getRequest().getRequestPath(), (Object)ip);
                return true;
            }).back((Object)MsgCode.AD101.get());
            SaRouter.match((List)this.gatewayWhite.whiteUrl).stop();
            SaRouter.match((List)this.pathScanner.getPathPatterns()).stop();
            SaRouter.match(t -> {
                String innerToken = SaHolder.getRequest().getHeader("SA-SAME-TOKEN");
                return UserProvider.isValidInnerToken((String)innerToken);
            }).stop();
            SaRouter.match((String)"/**", r -> {
                StpUtil.checkLogin();
                GatewayUtil.renewToken((String)StpUtil.getTokenValue());
            }).stop();
        }).setError(e -> {
            SaHolder.getResponse().addHeader("Content-Type", "application/json; charset=utf-8");
            if (e instanceof NotLoginException) {
                return SaResult.error((String)ActionResultCode.SessionOverdue.getMessage()).setCode(ActionResultCode.SessionOverdue.getCode().intValue());
            }
            log.error(e.getMessage(), e);
            return SaResult.error((String)MsgCode.AD102.get()).setCode(ActionResultCode.Exception.getCode().intValue());
        }).setBeforeAuth(this.defaultBeforeAuthStrategy);
    }

    public static String getIpAddr() {
        return IpUtil.getIpAddr();
    }
}

