/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring;

import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.common.model.task.LocalTaskModel;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.scheduletask.utils.TaskUtil;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

@SpringBootApplication(scanBasePackages={"com.bringspring"}, exclude={DataSourceAutoConfiguration.class})
public class JsbosAdminApplication
extends SpringBootServletInitializer
implements CommandLineRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsbosAdminApplication.class);
    @Autowired
    private ApplicationContext applicationContext;

    public static void main(String[] args) {
        SpringApplication springApplication = new SpringApplication(new Class[]{JsbosAdminApplication.class});
        springApplication.run(args);
        log.info("jsbosAdmin\u542f\u52a8\u5b8c\u6210");
        TaskUtil.task();
    }

    public void run(String ... args) throws Exception {
        String[] beanNames;
        ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)SpringContext.getBean(ConcurrentHashMap.class);
        for (String beanName : beanNames = this.applicationContext.getBeanDefinitionNames()) {
            Method[] methods;
            Object obj = this.applicationContext.getBean(beanName);
            Class<?> clz = obj.getClass();
            for (Method method : methods = clz.getDeclaredMethods()) {
                JsbosTask annotation = method.getAnnotation(JsbosTask.class);
                if (annotation == null) continue;
                String ids = clz.getName() + "." + method.getName();
                Object id = StringUtils.isNotEmpty((String)annotation.id()) ? annotation.id() : ids;
                String name = annotation.fullName();
                String description = annotation.description();
                String cron = annotation.cron();
                String startDate = annotation.startDate();
                String endDate = annotation.endDate();
                LocalTaskModel model = new LocalTaskModel();
                model.setFullName(name);
                model.setClz(obj);
                model.setMethodName(method.getName());
                model.setDescription(description);
                model.setId((String)id);
                model.setJobGroupName("jsbos");
                model.setCron(cron);
                model.setStartDate(startDate);
                model.setEndDate(endDate);
                if (!concurrentHashMap.containsKey(id)) {
                    concurrentHashMap.put(id, model);
                    continue;
                }
                concurrentHashMap.put(ids, model);
            }
        }
    }

    @Bean
    public ConcurrentHashMap<String, LocalTaskModel> concurrentHashMap() {
        ConcurrentHashMap<String, LocalTaskModel> concurrentHashMap = new ConcurrentHashMap<String, LocalTaskModel>(16);
        return concurrentHashMap;
    }
}

