package com.bringspring.ai.demo.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.ai.demo.entity.AiDemoEntity;
import com.bringspring.ai.demo.mapper.AiDemoMapper;
import com.bringspring.ai.demo.model.aiDemo.AiDemoCrForm;
import com.bringspring.ai.demo.model.aiDemo.AiDemoPagination;
import com.bringspring.ai.demo.model.aiDemo.AiDemoUpForm;
import com.bringspring.ai.demo.service.AiDemoService;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.permission.util.BaseDataUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/**
 * AI案例
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2025-10-14
 */
@Service
public class AiDemoServiceImpl extends ServiceImpl<AiDemoMapper, AiDemoEntity> implements AiDemoService {


    @Autowired
    private UserProvider userProvider;

    @Autowired
    private BaseDataUtil baseDataUtil;

    /**
     * AI案例列表分页查询
     *
     * @param aiDemoPagination 查询参数
     * @return List<AiDemoEntity>
     */
    @Override
    public List<AiDemoEntity> getList(AiDemoPagination aiDemoPagination) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int aiDemoNum = 0;
        QueryWrapper<AiDemoEntity> aiDemoQueryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(aiDemoPagination.getName())) {
            aiDemoNum++;
            aiDemoQueryWrapper.lambda().like(AiDemoEntity::getName, aiDemoPagination.getName());
        }

        if (StringUtils.isNotEmpty(aiDemoPagination.getEnCode())) {
            aiDemoNum++;
            aiDemoQueryWrapper.lambda().like(AiDemoEntity::getEnCode, aiDemoPagination.getEnCode());
        }

        if (AllIdList.size() > 0) {
            aiDemoQueryWrapper.lambda().in(AiDemoEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(aiDemoPagination.getSidx())) {
            aiDemoQueryWrapper.lambda().orderByDesc(AiDemoEntity::getId);
        } else {
            try {
                String sidx = aiDemoPagination.getSidx();
                AiDemoEntity aiDemoEntity = new AiDemoEntity();
                Field declaredField = aiDemoEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                aiDemoQueryWrapper = "asc".equals(aiDemoPagination.getSort().toLowerCase()) ? aiDemoQueryWrapper.orderByAsc(value) : aiDemoQueryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ((total > 0 && AllIdList.size() > 0) || total == 0) {
            Page<AiDemoEntity> page = new Page<>(aiDemoPagination.getCurrentPage(), aiDemoPagination.getPageSize());
            IPage<AiDemoEntity> userIPage = this.page(page, aiDemoQueryWrapper);
            return aiDemoPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        } else {
            List<AiDemoEntity> list = new ArrayList();
            return aiDemoPagination.setData(list, list.size());
        }
    }

    /**
     * AI案例列表分页查询（导出使用）
     *
     * @param aiDemoPagination 查询参数
     * @param dataType         0-当前页；非0-当前查询条件所有数据
     * @return List<AiDemoEntity>
     */
    @Override
    public List<AiDemoEntity> getTypeList(AiDemoPagination aiDemoPagination, String dataType) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int aiDemoNum = 0;
        QueryWrapper<AiDemoEntity> aiDemoQueryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(aiDemoPagination.getName())) {
            aiDemoNum++;
            aiDemoQueryWrapper.lambda().like(AiDemoEntity::getName, aiDemoPagination.getName());
        }

        if (StringUtils.isNotEmpty(aiDemoPagination.getEnCode())) {
            aiDemoNum++;
            aiDemoQueryWrapper.lambda().like(AiDemoEntity::getEnCode, aiDemoPagination.getEnCode());
        }

        if (AllIdList.size() > 0) {
            aiDemoQueryWrapper.lambda().in(AiDemoEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(aiDemoPagination.getSidx())) {
            aiDemoQueryWrapper.lambda().orderByDesc(AiDemoEntity::getId);
        } else {
            try {
                String sidx = aiDemoPagination.getSidx();
                AiDemoEntity aiDemoEntity = new AiDemoEntity();
                Field declaredField = aiDemoEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                aiDemoQueryWrapper = "asc".equals(aiDemoPagination.getSort().toLowerCase()) ? aiDemoQueryWrapper.orderByAsc(value) : aiDemoQueryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if ((total > 0 && AllIdList.size() > 0) || total == 0) {
                Page<AiDemoEntity> page = new Page<>(aiDemoPagination.getCurrentPage(), aiDemoPagination.getPageSize());
                IPage<AiDemoEntity> userIPage = this.page(page, aiDemoQueryWrapper);
                return aiDemoPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            } else {
                List<AiDemoEntity> list = new ArrayList();
                return aiDemoPagination.setData(list, list.size());
            }
        } else {
            return this.list(aiDemoQueryWrapper);
        }
    }

    /**
     * 获取AI案例详细信息
     *
     * @param id 主键
     * @return AiDemoEntity
     */
    @Override
    public AiDemoEntity getInfo(String id) {
        QueryWrapper<AiDemoEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(AiDemoEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    /**
     * 创建AI案例操作
     *
     * @param aiDemoCrForm 主键
     * @return boolean 是否成功
     */
    @Override
    @DSTransactional
    public void create(AiDemoCrForm aiDemoCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        aiDemoCrForm.setEnCode(baseDataUtil.getBillNumber("AiDemoNumber", false));
        AiDemoEntity entity = JsonUtil.getJsonToBean(aiDemoCrForm, AiDemoEntity.class);
        entity.setId(mainId);
        this.save(entity);

    }

    /**
     * 更新AI案例操作
     *
     * @param id           主键
     * @param aiDemoUpForm 主键
     * @return boolean 是否成功
     */
    @Override
    @DSTransactional
    public void update(String id, AiDemoUpForm aiDemoUpForm) {
        UserInfo userInfo = userProvider.get();
        AiDemoEntity entity = this.getInfo(id);
        if (entity != null) {
            aiDemoUpForm.setLastModifyUserId(userInfo.getUserId());
            aiDemoUpForm.setLastModifyTime(DateUtil.getNow());
            AiDemoEntity subentity = JsonUtil.getJsonToBean(aiDemoUpForm, AiDemoEntity.class);
            this.updateById(subentity);
        }
    }

    /**
     * AI案例点赞
     *
     * @param id 主键
     */
    @Override
    @DSTransactional
    public void like(String id) {
        AiDemoEntity entity = this.getInfo(id);
        if (entity != null) {
            // 假设点赞逻辑为更新点赞数
            entity.setUpNum(entity.getUpNum() + 1);
            this.updateById(entity);
        }
    }

    /**
     * AI案例吐槽
     *
     * @param id 主键
     */
    @Override
    @DSTransactional
    public void down(String id) {
        AiDemoEntity entity = this.getInfo(id);
        if (entity != null) {
            // 吐槽逻辑为更新吐槽数
            entity.setDownNum(entity.getDownNum() + 1);
            this.updateById(entity);
        }
    }

    /**
     * AI案例置顶
     *
     * @param id 主键
     */
    @Override
    @DSTransactional
    public void top(String id) {
        AiDemoEntity entity = this.getInfo(id);
        if (entity != null) {
            // 置顶逻辑为设置 toping 为 1
            entity.setToping(1);
            this.updateById(entity);
        }
    }

    /**
     * AI案例取消置顶
     *
     * @param id 主键
     */
    @Override
    @DSTransactional
    public void cancelTop(String id) {
        AiDemoEntity entity = this.getInfo(id);
        if (entity != null) {
            // 取消置顶逻辑为设置 toping 为 0
            entity.setToping(0);
            this.updateById(entity);
        }
    }

    /**
     * 删除AI案例操作
     *
     * @param entity
     * @return
     */
    @Override
    @DSTransactional
    public void delete(AiDemoEntity entity) {
        if (entity != null) {
            this.removeById(entity.getId());
        }
    }
    //子表方法


}