package com.bringspring.ai.demo.controller;

import com.bringspring.ai.demo.entity.AiDemoEntity;
import com.bringspring.ai.demo.model.aiDemo.*;
import com.bringspring.ai.demo.service.AiDemoService;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.util.List;

/**
 * AI案例
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2025-10-14
 */
@Slf4j
@RestController
@Tag(name = "AI案例", description = "example")
@RequestMapping("/api/example/AiDemo")
public class AiDemoController {

    @Autowired
    private BaseDataUtil baseDataUtil;


    @Autowired
    private AiDemoService aiDemoService;


    /**
     * AI案例列表
     *
     * @param aiDemoPagination
     * @return
     */
    @PostMapping("/getList")
    @Operation(summary="AI案例列表")
    public ActionResult list(@RequestBody AiDemoPagination aiDemoPagination) throws IOException {
        List<AiDemoEntity> list = aiDemoService.getList(aiDemoPagination);
        //处理id字段转名称，若无需转或者为空可删除
        for (AiDemoEntity entity : list) {
            entity.setDemoVideo(baseDataUtil.getFileNameInJson(entity.getDemoVideo()));
            entity.setLastModifyUserId(baseDataUtil.userSelectValue(entity.getLastModifyUserId()));
        }
        List<AiDemoListVO> listVO = JsonUtil.getJsonToList(list, AiDemoListVO.class);
        for (AiDemoListVO aiDemoVO : listVO) {
        }

        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = JsonUtil.getJsonToBean(aiDemoPagination, PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success(vo);
    }


    /**
     * AI案例创建
     *
     * @param aiDemoCrForm
     * @return
     */
    @Operation(summary="AI案例创建")
    @PostMapping
    public ActionResult create(@RequestBody AiDemoCrForm aiDemoCrForm) throws DataException {
        aiDemoService.create(aiDemoCrForm);
        return ActionResult.success("创建成功");
    }


    /**
     * AI案例信息
     *
     * @param id
     * @return
     */
    @Operation(summary="AI案例信息")
    @GetMapping("/{id}")
    public ActionResult<AiDemoInfoVO> info(@PathVariable("id") String id) {
        AiDemoEntity entity = aiDemoService.getInfo(id);
        AiDemoInfoVO vo = JsonUtil.getJsonToBean(entity, AiDemoInfoVO.class);
        vo.setLastModifyUserId(baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }

        //子表
        //副表
        return ActionResult.success(vo);
    }

    /**
     * AI案例表单信息(详情页)
     *
     * @param id
     * @return
     */
    @Operation(summary="AI案例表单信息(详情页)")
    @GetMapping("/detail/{id}")
    public ActionResult<AiDemoInfoVO> detailInfo(@PathVariable("id") String id) {
        AiDemoEntity entity = aiDemoService.getInfo(id);
        AiDemoInfoVO vo = JsonUtil.getJsonToBean(entity, AiDemoInfoVO.class);

        //子表数据转换

        //附表数据转换

//添加到详情表单对象中
        vo.setDemoVideo(baseDataUtil.getFileNameInJson(vo.getDemoVideo()));
        vo.setEnabledMark(baseDataUtil.switchSelectValue(vo.getEnabledMark(), "开", "关"));
        vo.setLastModifyUserId(baseDataUtil.userSelectValue(vo.getLastModifyUserId()));

        return ActionResult.success(vo);
    }


    /**
     * AI案例更新
     *
     * @param id
     * @return
     */
    @Operation(summary="AI案例更新")
    @PutMapping("/{id}")
    public ActionResult update(@PathVariable("id") String id, @RequestBody AiDemoUpForm aiDemoUpForm) throws DataException {
        aiDemoService.update(id, aiDemoUpForm);
        return ActionResult.success("更新成功");
    }


    /**
     * AI案例删除
     *
     * @param id
     * @return
     */
    @Operation(summary="AI案例删除")
    @DeleteMapping("/{id}")
    public ActionResult delete(@PathVariable("id") String id) {
        AiDemoEntity entity = aiDemoService.getInfo(id);
        if (entity != null) {
            aiDemoService.delete(entity);

        }
        return ActionResult.success("删除成功");
    }

    /**
     * AI案例点赞
     *
     * @param id
     * @return
     */
    @Operation(summary="AI案例点赞")
    @PostMapping("/like/{id}")
    public ActionResult like(@PathVariable("id") String id) {
        aiDemoService.like(id);
        return ActionResult.success("点赞成功");
    }

    /**
     * AI案例吐槽
     *
     * @param id
     * @return
     */
    @Operation(summary="AI案例吐槽")
    @PostMapping("/down/{id}")
    public ActionResult down(@PathVariable("id") String id) {
        aiDemoService.down(id);
        return ActionResult.success("吐槽成功");
    }

    /**
     * AI案例置顶
     *
     * @param id
     * @return
     */
    @Operation(summary="AI案例置顶")
    @PostMapping("/top/{id}")
    public ActionResult top(@PathVariable("id") String id) {
        aiDemoService.top(id);
        return ActionResult.success("置顶成功");
    }

    /**
     * AI案例取消置顶
     *
     * @param id
     * @return
     */
    @Operation(summary="AI案例取消置顶")
    @PostMapping("/cancelTop/{id}")
    public ActionResult cancelTop(@PathVariable("id") String id) {
        aiDemoService.cancelTop(id);
        return ActionResult.success("取消置顶成功");
    }
}
