package com.bringspring.ai.demo.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * AI案例
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2025-10-14
 */
@Data
@TableName("AI_DEMO")
public class AiDemoEntity {
    /**
     * 主键
     **/
    @TableId("ID")
    private String id;

    /**
     * 封面
     **/
    @TableField("COVER")
    private String cover;

    /**
     * 名称
     **/
    @TableField("NAME")
    private String name;

    /**
     * 编码
     **/
    @TableField("EN_CODE")
    private String enCode;

    /**
     * 场景描述
     **/
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 基座
     **/
    @TableField("BASE")
    private String base;

    /**
     * 技术点（逗号分隔Tags）
     **/
    @TableField("TAGS")
    private String tags;

    /**
     * 点赞数
     **/
    @TableField("UP_NUM")
    private String upNum;

    /**
     * 吐槽数
     **/
    @TableField("DOWN_NUM")
    private String downNum;

    /**
     * 演示视频
     **/
    @TableField("DEMO_VIDEO")
    private String demoVideo;

    /**
     * demo体验表单url
     **/
    @TableField("DEMO_URL")
    private String demoUrl;

    /**
     * 有效标志
     **/
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 置顶标识
     **/
    @TableField("TOPING")
    private Integer toping;
    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME", fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID", fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME", fill = FieldFill.INSERT_UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID", fill = FieldFill.INSERT_UPDATE)
    private String lastModifyUserId;


}
