package com.bringspring.ai.demo.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.ai.demo.entity.AiDemoEntity;
import com.bringspring.ai.demo.model.aiDemo.AiDemoCrForm;
import com.bringspring.ai.demo.model.aiDemo.AiDemoPagination;
import com.bringspring.ai.demo.model.aiDemo.AiDemoUpForm;
import com.bringspring.common.exception.DataException;

import java.util.List;

/**
 * AI案例
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2025-10-14
 */
public interface AiDemoService extends IService<AiDemoEntity> {

    /**
     * AI案例列表分页查询
     *
     * @param aiDemoPagination 查询参数
     * @return List<AiDemoEntity>
     */
    List<AiDemoEntity> getList(AiDemoPagination aiDemoPagination);

    /**
     * AI案例列表分页查询（导出使用）
     *
     * @param aiDemoPagination 查询参数
     * @param dataType         0-当前页；非0-当前查询条件所有数据
     * @return List<AiDemoEntity>
     */
    List<AiDemoEntity> getTypeList(AiDemoPagination aiDemoPagination, String dataType);


    /**
     * 获取AI案例详细信息
     *
     * @param id 主键
     * @return AiDemoEntity
     */
    AiDemoEntity getInfo(String id);

    /**
     * 删除AI案例操作
     *
     * @param entity
     * @return
     */
    void delete(AiDemoEntity entity);

    /**
     * 创建AI案例操作
     *
     * @param aiDemoCrForm 主键
     * @return boolean 是否成功
     */
    void create(AiDemoCrForm aiDemoCrForm) throws DataException;

    /**
     * 更新AI案例操作
     *
     * @param id           主键
     * @param aiDemoUpForm 主键
     * @return boolean 是否成功
     */
    void update(String id, AiDemoUpForm aiDemoUpForm);

    /**
     * AI案例点赞
     *
     * @param id 主键
     */
    void like(String id);

    /**
     * AI案例吐槽
     *
     * @param id 主键
     */
    void down(String id);

    /**
     * AI案例置顶
     *
     * @param id 主键
     */
    void top(String id);

    /**
     * AI案例取消置顶
     *
     * @param id 主键
     */
    void cancelTop(String id);

}
