package com.bringspring.ai.service;

public interface DifyDatasetService {

    /**
     * 知识库数据同步
     * @param datasetId 知识库ID
     * @param documentId 文档ID
     * @param data 上传内容
     */
    void invokeDatasetSynchronous(String datasetId,String documentId,String data);

    /**
     * 知识库数据同步
     * @param difyBaseConfig 重载配置
     * @param datasetId 知识库ID
     * @param documentId 文档ID
     * @param data 上传内容
     */
    void invokeDatasetSynchronous(DifyBaseConfig difyBaseConfig,String datasetId,String documentId,String data);

    /**
     * 创建知识库
     * @param name 知识库名称
     * @param description 知识库注释
     * @return
     */
    String createDataset(String name,String description);

    /**
     * 创建知识库
     * @param difyBaseConfig 重载Dify配置
     * @param name 知识库名称
     * @param description 知识库注释
     * @return
     */
    String createDataset(DifyBaseConfig difyBaseConfig,String name,String description);

    /**
     * 创建文档
     * @param datasetId 知识库ID
     * @param documentName 文档名称
     * @return
     */
    String createDocument(String datasetId,String documentName);

    /**
     * 创建文档
     * @param difyBaseConfig 重载Dify配置
     * @param datasetId 知识库ID
     * @param documentName 文档名称
     * @return
     */
    String createDocument(DifyBaseConfig difyBaseConfig,String datasetId,String documentName);
    /**
     * Dify配置（覆盖默认）
     * @param difyBaseConfig
     * @param apiKey
     */
    record DifyBaseConfig(String difyBaseConfig,String apiKey){}
}
