package com.bringspring.ai.service.impl;

import com.bringspring.ai.configuration.DifyConfig;
import com.bringspring.ai.service.DifyDatasetService;
import com.bringspring.common.util.JsonUtil;
import io.github.imfangs.dify.client.DifyClientFactory;
import io.github.imfangs.dify.client.DifyDatasetsClient;
import io.github.imfangs.dify.client.model.datasets.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Slf4j
@Service
public class DifyServiceImpl implements DifyDatasetService {

    @Autowired
    private DifyConfig difyConfig;

    @Override
    public void invokeDatasetSynchronous(String datasetId, String documentId, String data) {
        DifyBaseConfig difyBaseConfig = new DifyBaseConfig(difyConfig.getDifyBaseUrl(),difyConfig.getApiKey());
        invokeDatasetSynchronous(difyBaseConfig,datasetId,documentId,data);
    }

    @Override
    public void invokeDatasetSynchronous(DifyBaseConfig difyBaseConfig, String datasetId, String documentId, String data) {
                String jsonData = JsonUtil.getObjectToString(data);
        DifyDatasetsClient datasetsClient = DifyClientFactory.createDatasetsClient(difyBaseConfig.difyBaseConfig(), difyBaseConfig.apiKey());
        CreateSegmentsRequest.SegmentInfo segmentInfo = CreateSegmentsRequest.SegmentInfo.builder()
                .content(jsonData)
                .build();
        try {
            datasetsClient.createSegments(
                    datasetId,
                    documentId,
                    CreateSegmentsRequest.builder()
                            .segments(List.of(segmentInfo))
                            .build()
            );
        } catch (Exception e) {
            log.error("知识库同步出现错误！错误信息：{}", e.getMessage());
        }
    }

    @Override
    public String createDataset(String name, String description) {
        DifyBaseConfig difyBaseConfig = new DifyBaseConfig(difyConfig.getDifyBaseUrl(),difyConfig.getApiKey());
        return createDataset(difyBaseConfig,name,description);
    }

    @Override
    public String createDataset(DifyBaseConfig difyBaseConfig, String name, String description) {
        String id = "";
        DifyDatasetsClient datasetsClient = DifyClientFactory.createDatasetsClient(difyBaseConfig.difyBaseConfig(), difyBaseConfig.apiKey());
        CreateDatasetRequest datasetRequest = CreateDatasetRequest.builder()
                .name(name)
                .description(description)
                .build();
        try {
            DatasetResponse clientDataset = datasetsClient.createDataset(datasetRequest);
            id = clientDataset.getId();
        } catch (Exception e) {
            log.error("知识库创建出现错误！错误信息：{}", e.getMessage());
        }
        return id;
    }

    @Override
    public String createDocument(String datasetId, String documentName) {
        DifyBaseConfig difyBaseConfig = new DifyBaseConfig(difyConfig.getDifyBaseUrl(),difyConfig.getApiKey());
        return createDocument(difyBaseConfig,datasetId,documentName);
    }

    @Override
    public String createDocument(DifyBaseConfig difyBaseConfig, String datasetId, String documentName) {
        String docuemntId = "";
        try {
            DifyDatasetsClient datasetsClient = DifyClientFactory.createDatasetsClient(difyBaseConfig.difyBaseConfig(), difyBaseConfig.apiKey());

            CreateDocumentByTextRequest byTextRequest = CreateDocumentByTextRequest.builder()
                    .name(documentName)
                    .indexingTechnique("high_quality")
                    .docForm("text_model")
                    .docLanguage("中文")
                    .processRule(
                            ProcessRule.builder()
                                    .mode("automatic")
                                    .rules(
                                            ProcessRule.Rules.builder()
                                                    .parentMode("full-doc")
                                                    .build()
                                    )
                                    .build()
                    )
                    .docType(".txt")
                    .text(".")
                    .build();

            DocumentResponse documentResponse = datasetsClient.createDocumentByText(
                    datasetId,
                    byTextRequest
            );
            docuemntId = documentResponse.getDocument().getId();
        } catch (Exception e) {
            log.error("知识库创建出现错误！错误信息：{}", e.getMessage());
        }
        return docuemntId;
    }

}
