/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ai.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bringspring.ai.configuration.DifyConfig;
import com.bringspring.ai.enmu.DifyCategoryEnum;
import com.bringspring.ai.vo.DifyBaseConfigVO;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.service.SysConfigService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ai/difyconfig/base"})
public class DifyBaseConfigController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DifyBaseConfigController.class);
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private DifyConfig difyConfig;

    @NotCheckLogin
    @GetMapping(value={"/list"})
    public ActionResult list() {
        List list = this.sysConfigService.list((Wrapper)Wrappers.lambdaQuery(SysConfigEntity.class).eq(SysConfigEntity::getCategory, (Object)DifyCategoryEnum.BASE_CONFIG.getCode()));
        ArrayList<DifyBaseConfigVO> result = new ArrayList<DifyBaseConfigVO>();
        for (SysConfigEntity sys : list) {
            DifyBaseConfigVO vo = (DifyBaseConfigVO)JsonUtil.getJsonToBean((String)sys.getKeyValue(), DifyBaseConfigVO.class);
            result.add(vo);
        }
        return ActionResult.success(result);
    }

    @NotCheckLogin
    @GetMapping(value={"/{keyName}"})
    public ActionResult<DifyBaseConfigVO> get(@PathVariable(value="keyName") String keyName) {
        DifyBaseConfigVO result = null;
        List list = this.sysConfigService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysConfigEntity.class).eq(SysConfigEntity::getCategory, (Object)DifyCategoryEnum.BASE_CONFIG.getCode())).eq(SysConfigEntity::getKeyName, (Object)keyName));
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            SysConfigEntity entity = (SysConfigEntity)list.get(0);
            result = (DifyBaseConfigVO)JsonUtil.getJsonToBean((String)entity.getKeyValue(), DifyBaseConfigVO.class);
        }
        return ActionResult.success(result);
    }

    @NotCheckLogin
    @PostMapping
    public ActionResult create(@RequestBody DifyBaseConfigVO baseConfigVO) {
        List list = this.sysConfigService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysConfigEntity.class).eq(SysConfigEntity::getCategory, (Object)DifyCategoryEnum.BASE_CONFIG.getCode())).eq(SysConfigEntity::getKeyName, (Object)baseConfigVO.getKeyName()));
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            return ActionResult.fail((String)MsgCode.EXIST002.get());
        }
        String jsonObj = JsonUtil.getObjectToString((Object)baseConfigVO);
        SysConfigEntity saveEntity = new SysConfigEntity();
        saveEntity.setCategory(DifyCategoryEnum.BASE_CONFIG.getCode());
        saveEntity.setName(baseConfigVO.getName());
        saveEntity.setKeyName(baseConfigVO.getKeyName());
        saveEntity.setKeyValue(jsonObj);
        this.sysConfigService.create(saveEntity);
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @NotCheckLogin
    @PutMapping
    public ActionResult update(@RequestBody DifyBaseConfigVO baseConfigVO) {
        List list = this.sysConfigService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysConfigEntity.class).eq(SysConfigEntity::getCategory, (Object)DifyCategoryEnum.BASE_CONFIG.getCode())).eq(SysConfigEntity::getKeyName, (Object)baseConfigVO.getKeyName()));
        if (CollectionUtil.isEmpty((Collection)list)) {
            return ActionResult.fail((String)MsgCode.FA001.get());
        }
        SysConfigEntity saveEntity = (SysConfigEntity)list.get(0);
        String jsonObj = JsonUtil.getObjectToString((Object)baseConfigVO);
        saveEntity.setName(baseConfigVO.getName());
        saveEntity.setKeyName(baseConfigVO.getKeyName());
        saveEntity.setKeyValue(jsonObj);
        this.sysConfigService.saveOrUpdate((Object)saveEntity);
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @DeleteMapping(value={"{keyName}"})
    public ActionResult delete(@PathVariable(value="keyName") String keyName) {
        List list = this.sysConfigService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysConfigEntity.class).eq(SysConfigEntity::getCategory, (Object)DifyCategoryEnum.BASE_CONFIG.getCode())).eq(SysConfigEntity::getKeyName, (Object)keyName));
        if (CollectionUtil.isEmpty((Collection)list)) {
            return ActionResult.success((String)MsgCode.SU005.get());
        }
        this.sysConfigService.removeById((Serializable)((Object)((SysConfigEntity)list.get(0)).getId()));
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @NotCheckLogin
    @GetMapping(value={"/getDefaultConfig"})
    public ActionResult getDefaultConfig() {
        DefaultConfig defaultConfig = new DefaultConfig(this.difyConfig.getDifyBaseUrl(), this.difyConfig.getApiKey());
        return ActionResult.success((Object)defaultConfig);
    }

    record DefaultConfig(String difyBaseUrl, String apiKey) {
    }
}

