/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ai.service.impl;

import com.bringspring.ai.configuration.DifyConfig;
import com.bringspring.ai.service.DifyDatasetService;
import com.bringspring.common.util.JsonUtil;
import io.github.imfangs.dify.client.DifyClientFactory;
import io.github.imfangs.dify.client.DifyDatasetsClient;
import io.github.imfangs.dify.client.model.datasets.CreateDatasetRequest;
import io.github.imfangs.dify.client.model.datasets.CreateDocumentByTextRequest;
import io.github.imfangs.dify.client.model.datasets.CreateSegmentsRequest;
import io.github.imfangs.dify.client.model.datasets.DatasetResponse;
import io.github.imfangs.dify.client.model.datasets.DocumentResponse;
import io.github.imfangs.dify.client.model.datasets.ProcessRule;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DifyServiceImpl
implements DifyDatasetService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DifyServiceImpl.class);
    @Autowired
    private DifyConfig difyConfig;

    @Override
    public void invokeDatasetSynchronous(String datasetId, String documentId, String data) {
        DifyDatasetService.DifyBaseConfig difyBaseConfig = new DifyDatasetService.DifyBaseConfig(this.difyConfig.getDifyBaseUrl(), this.difyConfig.getApiKey());
        this.invokeDatasetSynchronous(difyBaseConfig, datasetId, documentId, data);
    }

    @Override
    public void invokeDatasetSynchronous(DifyDatasetService.DifyBaseConfig difyBaseConfig, String datasetId, String documentId, String data) {
        String jsonData = JsonUtil.getObjectToString((Object)data);
        DifyDatasetsClient datasetsClient = DifyClientFactory.createDatasetsClient((String)difyBaseConfig.difyBaseConfig(), (String)difyBaseConfig.apiKey());
        CreateSegmentsRequest.SegmentInfo segmentInfo = CreateSegmentsRequest.SegmentInfo.builder().content(jsonData).build();
        try {
            datasetsClient.createSegments(datasetId, documentId, CreateSegmentsRequest.builder().segments(List.of(segmentInfo)).build());
        }
        catch (Exception e) {
            log.error("\u77e5\u8bc6\u5e93\u540c\u6b65\u51fa\u73b0\u9519\u8bef\uff01\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        }
    }

    @Override
    public String createDataset(String name, String description) {
        DifyDatasetService.DifyBaseConfig difyBaseConfig = new DifyDatasetService.DifyBaseConfig(this.difyConfig.getDifyBaseUrl(), this.difyConfig.getApiKey());
        return this.createDataset(difyBaseConfig, name, description);
    }

    @Override
    public String createDataset(DifyDatasetService.DifyBaseConfig difyBaseConfig, String name, String description) {
        String id = "";
        DifyDatasetsClient datasetsClient = DifyClientFactory.createDatasetsClient((String)difyBaseConfig.difyBaseConfig(), (String)difyBaseConfig.apiKey());
        CreateDatasetRequest datasetRequest = CreateDatasetRequest.builder().name(name).description(description).build();
        try {
            DatasetResponse clientDataset = datasetsClient.createDataset(datasetRequest);
            id = clientDataset.getId();
        }
        catch (Exception e) {
            log.error("\u77e5\u8bc6\u5e93\u521b\u5efa\u51fa\u73b0\u9519\u8bef\uff01\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        }
        return id;
    }

    @Override
    public String createDocument(String datasetId, String documentName) {
        DifyDatasetService.DifyBaseConfig difyBaseConfig = new DifyDatasetService.DifyBaseConfig(this.difyConfig.getDifyBaseUrl(), this.difyConfig.getApiKey());
        return this.createDocument(difyBaseConfig, datasetId, documentName);
    }

    @Override
    public String createDocument(DifyDatasetService.DifyBaseConfig difyBaseConfig, String datasetId, String documentName) {
        String docuemntId = "";
        try {
            DifyDatasetsClient datasetsClient = DifyClientFactory.createDatasetsClient((String)difyBaseConfig.difyBaseConfig(), (String)difyBaseConfig.apiKey());
            CreateDocumentByTextRequest byTextRequest = CreateDocumentByTextRequest.builder().name(documentName).indexingTechnique("high_quality").docForm("text_model").docLanguage("\u4e2d\u6587").processRule(ProcessRule.builder().mode("automatic").rules(ProcessRule.Rules.builder().parentMode("full-doc").build()).build()).docType(".txt").text(".").build();
            DocumentResponse documentResponse = datasetsClient.createDocumentByText(datasetId, byTextRequest);
            docuemntId = documentResponse.getDocument().getId();
        }
        catch (Exception e) {
            log.error("\u77e5\u8bc6\u5e93\u521b\u5efa\u51fa\u73b0\u9519\u8bef\uff01\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
        }
        return docuemntId;
    }
}

