/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.ai.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bringspring.ai.enmu.DifyCategoryEnum;
import com.bringspring.ai.service.DifyDatasetService;
import com.bringspring.ai.vo.DifyDataSetConfigVO;
import com.bringspring.ai.vo.DifyDataSetSynchronousVO;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.service.SysConfigService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ai/difyconfig/dataset"})
public class DifyDataSetConfigController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DifyDataSetConfigController.class);
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private DifyDatasetService difyDatasetService;

    @NotCheckLogin
    @GetMapping(value={"/list"})
    public ActionResult list() {
        List list = this.sysConfigService.list((Wrapper)Wrappers.lambdaQuery(SysConfigEntity.class).eq(SysConfigEntity::getCategory, (Object)DifyCategoryEnum.KNOWLEDGE_BASE.getCode()));
        ArrayList<DifyDataSetConfigVO> result = new ArrayList<DifyDataSetConfigVO>();
        for (SysConfigEntity sys : list) {
            DifyDataSetConfigVO vo = (DifyDataSetConfigVO)JsonUtil.getJsonToBean((String)sys.getKeyValue(), DifyDataSetConfigVO.class);
            result.add(vo);
        }
        return ActionResult.success(result);
    }

    @NotCheckLogin
    @GetMapping(value={"/{keyName}"})
    public ActionResult<DifyDataSetConfigVO> get(@PathVariable(value="keyName") String keyName) {
        DifyDataSetConfigVO rs = null;
        List list = this.sysConfigService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysConfigEntity.class).eq(SysConfigEntity::getCategory, (Object)DifyCategoryEnum.KNOWLEDGE_BASE.getCode())).eq(SysConfigEntity::getKeyName, (Object)keyName));
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            SysConfigEntity entity = (SysConfigEntity)list.get(0);
            rs = (DifyDataSetConfigVO)JsonUtil.getJsonToBean((String)entity.getKeyValue(), DifyDataSetConfigVO.class);
        }
        return ActionResult.success(rs);
    }

    @NotCheckLogin
    @PostMapping
    public ActionResult create(@RequestBody DifyDataSetConfigVO difyDataSetConfigVO) {
        List list = this.sysConfigService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysConfigEntity.class).eq(SysConfigEntity::getCategory, (Object)DifyCategoryEnum.KNOWLEDGE_BASE.getCode())).eq(SysConfigEntity::getKeyName, (Object)difyDataSetConfigVO.getKeyName()));
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            return ActionResult.fail((String)MsgCode.EXIST002.get());
        }
        String datasetId = this.difyDatasetService.createDataset(difyDataSetConfigVO.getDataSetName(), difyDataSetConfigVO.getDescription());
        String documentId = this.difyDatasetService.createDocument(datasetId, difyDataSetConfigVO.getDocumentName());
        difyDataSetConfigVO.setDataSetId(datasetId);
        difyDataSetConfigVO.setDocumentId(documentId);
        String jsonObj = JsonUtil.getObjectToString((Object)difyDataSetConfigVO);
        SysConfigEntity saveEntity = new SysConfigEntity();
        saveEntity.setCategory(DifyCategoryEnum.KNOWLEDGE_BASE.getCode());
        saveEntity.setName(difyDataSetConfigVO.getName());
        saveEntity.setKeyName(difyDataSetConfigVO.getKeyName());
        saveEntity.setKeyValue(jsonObj);
        this.sysConfigService.create(saveEntity);
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @NotCheckLogin
    @PutMapping
    public ActionResult update(@RequestBody DifyDataSetConfigVO difyDataSetConfigVO) {
        List list = this.sysConfigService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysConfigEntity.class).eq(SysConfigEntity::getCategory, (Object)DifyCategoryEnum.KNOWLEDGE_BASE.getCode())).eq(SysConfigEntity::getKeyName, (Object)difyDataSetConfigVO.getKeyName()));
        if (CollectionUtil.isEmpty((Collection)list)) {
            return ActionResult.fail((String)MsgCode.FA001.get());
        }
        SysConfigEntity saveEntity = (SysConfigEntity)list.get(0);
        String jsonObj = JsonUtil.getObjectToString((Object)difyDataSetConfigVO);
        saveEntity.setName(difyDataSetConfigVO.getName());
        saveEntity.setKeyName(difyDataSetConfigVO.getKeyName());
        saveEntity.setKeyValue(jsonObj);
        this.sysConfigService.create(saveEntity);
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @DeleteMapping(value={"{keyName}"})
    public ActionResult delete(@PathVariable(value="keyName") String keyName) {
        List list = this.sysConfigService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysConfigEntity.class).eq(SysConfigEntity::getCategory, (Object)DifyCategoryEnum.KNOWLEDGE_BASE.getCode())).eq(SysConfigEntity::getKeyName, (Object)keyName));
        if (CollectionUtil.isEmpty((Collection)list)) {
            return ActionResult.success((String)MsgCode.SU005.get());
        }
        this.sysConfigService.removeById((Serializable)((Object)((SysConfigEntity)list.get(0)).getId()));
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @NotCheckLogin
    @PostMapping(value={"/synchronous"})
    public ActionResult synchronous(@RequestBody DifyDataSetSynchronousVO data) {
        String jsonData = JsonUtil.getObjectToString(data.getData());
        this.difyDatasetService.invokeDatasetSynchronous(data.getDataSetId(), data.getDocumentId(), jsonData);
        return ActionResult.success((String)MsgCode.SU005.get());
    }
}

