package com.bringspring.ai.mcp.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.bringspring.common.base.ActionResult;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Optional;

@RestController
@RequestMapping("/monitor/mcp/tools")
public class McpServerToolsMonitorController {

    @Autowired
    private Optional<List<McpSyncClient>> mcpSyncClientList;

    @GetMapping
    public ActionResult list(){
        List<McpSchema.Tool> list = null;
        if(mcpSyncClientList.isPresent()){
            list = mcpSyncClientList.get().stream().flatMap(item -> item.listTools().tools().stream()).toList();
        }
        return ActionResult.success(list);
    }
}
