package com.bringspring.ai.mcp.config;

import java.lang.annotation.*;

/**
 * MCP 工具分组注解（类级别）
 * 仅用于分组，不参与 Spring AI MCP 的 @McpTool 扫描
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface McpToolGroup {
    // 分组的组名 用英文表示
    String value() default "DEFAULT";
    // 标题
    String name() default "";

    // 图标
    String icon() default "";

    // 更新时间
    String updateTime() default "";
}

